/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionEntity;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionVoteEntity;
import com.bringspring.meeting.mapper.OtMeetingGroupSuggestionVoteMapper;
import com.bringspring.meeting.model.otmeetinggroupsuggestionvote.OtMeetingGroupSuggestionVoteCrForm;
import com.bringspring.meeting.model.otmeetinggroupsuggestionvote.OtMeetingGroupSuggestionVotePagination;
import com.bringspring.meeting.model.otmeetinggroupsuggestionvote.OtMeetingGroupSuggestionVoteUpForm;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionService;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionVoteService;
import com.bringspring.meeting.utils.BussinessMeetingEnum;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingGroupSuggestionVoteServiceImpl
extends ServiceImpl<OtMeetingGroupSuggestionVoteMapper, OtMeetingGroupSuggestionVoteEntity>
implements OtMeetingGroupSuggestionVoteService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OtMeetingGroupSuggestionService otMeetingGroupSuggestionService;

    @Override
    public List<OtMeetingGroupSuggestionVoteEntity> getList(OtMeetingGroupSuggestionVotePagination otMeetingGroupSuggestionVotePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingGroupSuggestionVoteNum = 0;
        QueryWrapper otMeetingGroupSuggestionVoteQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionVotePagination.getCompanyId())) {
            ++otMeetingGroupSuggestionVoteNum;
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().like(OtMeetingGroupSuggestionVoteEntity::getCompanyId, (Object)otMeetingGroupSuggestionVotePagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty(otMeetingGroupSuggestionVotePagination.getVoteTime())) {
            ++otMeetingGroupSuggestionVoteNum;
            List<String> VoteTimeList = otMeetingGroupSuggestionVotePagination.getVoteTime();
            Long fir = Long.valueOf(VoteTimeList.get(0));
            Long sec = Long.valueOf(VoteTimeList.get(1));
            ((LambdaQueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.lambda().ge(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)new Date(fir))).le(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().in(OtMeetingGroupSuggestionVoteEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)otMeetingGroupSuggestionVotePagination.getSidx())) {
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().orderByDesc(OtMeetingGroupSuggestionVoteEntity::getId);
        } else {
            try {
                String sidx = otMeetingGroupSuggestionVotePagination.getSidx();
                OtMeetingGroupSuggestionVoteEntity otMeetingGroupSuggestionVoteEntity = new OtMeetingGroupSuggestionVoteEntity();
                Field declaredField = otMeetingGroupSuggestionVoteEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingGroupSuggestionVoteQueryWrapper = "asc".equals(otMeetingGroupSuggestionVotePagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(otMeetingGroupSuggestionVotePagination.getCurrentPage(), otMeetingGroupSuggestionVotePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupSuggestionVoteQueryWrapper);
            return otMeetingGroupSuggestionVotePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return otMeetingGroupSuggestionVotePagination.setData(list, list.size());
    }

    @Override
    public List<OtMeetingGroupSuggestionVoteEntity> getTypeList(OtMeetingGroupSuggestionVotePagination otMeetingGroupSuggestionVotePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingGroupSuggestionVoteNum = 0;
        QueryWrapper otMeetingGroupSuggestionVoteQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionVotePagination.getCompanyId())) {
            ++otMeetingGroupSuggestionVoteNum;
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().like(OtMeetingGroupSuggestionVoteEntity::getCompanyId, (Object)otMeetingGroupSuggestionVotePagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty(otMeetingGroupSuggestionVotePagination.getVoteTime())) {
            ++otMeetingGroupSuggestionVoteNum;
            List<String> VoteTimeList = otMeetingGroupSuggestionVotePagination.getVoteTime();
            Long fir = Long.valueOf(VoteTimeList.get(0));
            Long sec = Long.valueOf(VoteTimeList.get(1));
            ((LambdaQueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.lambda().ge(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)new Date(fir))).le(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().in(OtMeetingGroupSuggestionVoteEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)otMeetingGroupSuggestionVotePagination.getSidx())) {
            otMeetingGroupSuggestionVoteQueryWrapper.lambda().orderByDesc(OtMeetingGroupSuggestionVoteEntity::getId);
        } else {
            try {
                String sidx = otMeetingGroupSuggestionVotePagination.getSidx();
                OtMeetingGroupSuggestionVoteEntity otMeetingGroupSuggestionVoteEntity = new OtMeetingGroupSuggestionVoteEntity();
                Field declaredField = otMeetingGroupSuggestionVoteEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingGroupSuggestionVoteQueryWrapper = "asc".equals(otMeetingGroupSuggestionVotePagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingGroupSuggestionVoteQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(otMeetingGroupSuggestionVotePagination.getCurrentPage(), otMeetingGroupSuggestionVotePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupSuggestionVoteQueryWrapper);
                return otMeetingGroupSuggestionVotePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return otMeetingGroupSuggestionVotePagination.setData(list, list.size());
        }
        return this.list((Wrapper)otMeetingGroupSuggestionVoteQueryWrapper);
    }

    @Override
    public OtMeetingGroupSuggestionVoteEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingGroupSuggestionVoteEntity::getId, (Object)id);
        return (OtMeetingGroupSuggestionVoteEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OtMeetingGroupSuggestionVoteCrForm otMeetingGroupSuggestionVoteCrForm) {
        String mainId = RandomUtil.uuId();
        OtMeetingGroupSuggestionVoteEntity entity = (OtMeetingGroupSuggestionVoteEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupSuggestionVoteCrForm, OtMeetingGroupSuggestionVoteEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, OtMeetingGroupSuggestionVoteUpForm otMeetingGroupSuggestionVoteUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingGroupSuggestionVoteEntity entity = this.getInfo(id);
        if (entity != null) {
            OtMeetingGroupSuggestionVoteEntity subentity = (OtMeetingGroupSuggestionVoteEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupSuggestionVoteUpForm, OtMeetingGroupSuggestionVoteEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public Boolean handleVoteRule(String suggestionId, String voteType) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingGroupSuggestionEntity suggestionEntity = this.otMeetingGroupSuggestionService.getInfo(suggestionId);
        if (ObjectUtil.isEmpty((Object)suggestionEntity)) {
            return false;
        }
        if (StrUtil.equals((CharSequence)voteType, (CharSequence)BussinessMeetingEnum.VOTE_APPROVE.getType())) {
            OtMeetingGroupSuggestionVoteEntity voteEntity = new OtMeetingGroupSuggestionVoteEntity();
            voteEntity.setId(RandomUtil.uuId());
            voteEntity.setSuggestionId(suggestionId);
            voteEntity.setVoteType(BussinessMeetingEnum.VOTE_APPROVE.getType());
            voteEntity.setVoteTime(DateUtil.getNowDate());
            voteEntity.setVoterUserId(userInfo.getUserId());
            voteEntity.setDepartmentId(userInfo.getDepartmentId());
            voteEntity.setCompanyId(userInfo.getOrganizeId());
            voteEntity.setSuggestionDate(suggestionEntity.getSuggestWeek());
            voteEntity.setDeleteMark("0");
            this.save(voteEntity);
            suggestionEntity.setVoteCount(suggestionEntity.getVoteCount() + 1);
            this.otMeetingGroupSuggestionService.updateById(suggestionEntity);
        } else {
            List<OtMeetingGroupSuggestionVoteEntity> suggestVoteList = this.otMeetingGroupSuggestionService.getSuggestVoteList(suggestionId);
            if (ObjectUtil.isNotEmpty(suggestVoteList)) {
                List stringList = suggestVoteList.stream().filter(i -> StrUtil.equals((CharSequence)i.getVoterUserId(), (CharSequence)userInfo.getUserId()) && StrUtil.equals((CharSequence)i.getVoteType(), (CharSequence)BussinessMeetingEnum.VOTE_APPROVE.getType())).map(i -> i.getId()).collect(Collectors.toList());
                this.removeBatchByIds(stringList);
            }
            suggestionEntity.setVoteCount(suggestionEntity.getVoteCount() - 1);
            this.otMeetingGroupSuggestionService.updateById(suggestionEntity);
        }
        return true;
    }

    @Override
    @DSTransactional
    public void delete(OtMeetingGroupSuggestionVoteEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

