/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.entity.OtMeetingRoomEntity;
import com.bringspring.meeting.entity.OtMeetingRoomReservationEntity;
import com.bringspring.meeting.entity.OtMeetingSignEntity;
import com.bringspring.meeting.mapper.OtMeetingRoomReservationMapper;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationCrForm;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationListVO;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationPagination;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationPaginationExportModel;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationUpForm;
import com.bringspring.meeting.service.OtMeetingRoomReservationService;
import com.bringspring.meeting.service.OtMeetingRoomService;
import com.bringspring.meeting.service.OtMeetingSignService;
import com.bringspring.meeting.utils.DateUtils;
import com.bringspring.meeting.utils.Html2Text;
import com.bringspring.meeting.utils.MeetingConstants;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.meeting.utils.SendMessageUtil;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingRoomReservationServiceImpl
extends ServiceImpl<OtMeetingRoomReservationMapper, OtMeetingRoomReservationEntity>
implements OtMeetingRoomReservationService {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingRoomReservationServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OtMeetingRoomService otMeetingRoomService;
    @Autowired
    private OtMeetingSignService otMeetingSignService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<OtMeetingRoomReservationEntity> getList(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) {
        String userId = this.userProvider.get().getUserId();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped()) && ObjectUtil.isEmpty(otMeetingRoomReservationPagination.getRegularMeetingIdList())) {
            List<String> regularMeetingByTime = this.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped(), "all");
            if (ObjectUtil.isNotEmpty(regularMeetingByTime)) {
                otMeetingRoomReservationPagination.setRegularMeetingIdList(regularMeetingByTime);
            } else {
                return new ArrayList<OtMeetingRoomReservationEntity>();
            }
        }
        ArrayList roomList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getRoomAddress())) {
            QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getDeleteMark, (Object)0);
            String roomAddress = otMeetingRoomReservationPagination.getRoomAddress().replaceAll("],\\[", "];[").replaceAll("]]", "]").replaceAll("\\[\\[", "[");
            List<String> stringList = Arrays.asList(roomAddress.split(";"));
            for (int i = 0; i < stringList.size(); ++i) {
                if (i == stringList.size() - 1) {
                    otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getRoomAddress, (Object)stringList.get(i));
                    continue;
                }
                ((LambdaQueryWrapper)otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getRoomAddress, (Object)stringList.get(i))).or();
            }
            List list = this.otMeetingRoomService.list((Wrapper)otMeetingRoomQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)list)) {
                roomList.addAll(list.stream().map(OtMeetingRoomEntity::getId).collect(Collectors.toList()));
            }
        }
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomReservationNum = 0;
        QueryWrapper otMeetingRoomReservationQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == otMeetingRoomReservationPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            otMeetingRoomReservationQueryWrapper.lambda().and(w -> {
                if (ObjectUtil.isNotEmpty((Object)roomList)) {
                    for (String s : roomList) {
                        ((LambdaQueryWrapper)w.like(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)s)).or();
                    }
                    w.eq(OtMeetingRoomReservationEntity::getCompanyId, (Object)userInfo.getOrganizeId());
                } else {
                    w.eq(OtMeetingRoomReservationEntity::getCompanyId, (Object)userInfo.getOrganizeId());
                }
            });
        }
        boolean otMeetingRoomNum = false;
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getRegularMeetingIdList())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, otMeetingRoomReservationPagination.getRegularMeetingIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getEnabledMark())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)otMeetingRoomReservationPagination.getEnabledMark());
        } else {
            otMeetingRoomReservationQueryWrapper.lambda().and(query -> ((LambdaQueryWrapper)query.ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK)).or(w -> ((LambdaQueryWrapper)w.eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK)).eq(OtMeetingRoomReservationEntity::getContactsUserId, (Object)userId)));
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingTitle())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingTitle, (Object)otMeetingRoomReservationPagination.getMeetingTitle());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingRoomId())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)otMeetingRoomReservationPagination.getMeetingRoomId());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingMode())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)otMeetingRoomReservationPagination.getMeetingMode());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingType())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingType, (Object)otMeetingRoomReservationPagination.getMeetingType());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getShowMeetingType())) {
            ++otMeetingRoomReservationNum;
            if (otMeetingRoomReservationPagination.getShowMeetingType().equals("1")) {
                otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
            } else if ("2".equals(otMeetingRoomReservationPagination.getShowMeetingType())) {
                otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getCreatorUserId, (Object)userId);
            } else if ("3".equals(otMeetingRoomReservationPagination.getShowMeetingType())) {
                if (StrUtil.equals((CharSequence)otMeetingRoomReservationPagination.getActiveName(), (CharSequence)MeetingConstants.MEETING_NOTEND)) {
                    otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
                } else {
                    otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.EXPIRE_ENABLEDMARK);
                }
                otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getParticipantsUserIds, (Object)userId);
            }
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)otMeetingRoomReservationPagination.getSidx())) {
            otMeetingRoomReservationQueryWrapper.lambda().orderByDesc(OtMeetingRoomReservationEntity::getStartTime);
        } else {
            try {
                String sidx = otMeetingRoomReservationPagination.getSidx();
                OtMeetingRoomReservationEntity otMeetingRoomReservationEntity = new OtMeetingRoomReservationEntity();
                Field declaredField = otMeetingRoomReservationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomReservationQueryWrapper = "asc".equals(otMeetingRoomReservationPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(otMeetingRoomReservationPagination.getCurrentPage(), otMeetingRoomReservationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomReservationQueryWrapper);
            return otMeetingRoomReservationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return otMeetingRoomReservationPagination.setData(list, list.size());
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getTypeList(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped()) && ObjectUtil.isEmpty(otMeetingRoomReservationPagination.getRegularMeetingIdList())) {
            List<String> regularMeetingByTime = this.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped(), "all");
            if (ObjectUtil.isNotEmpty(regularMeetingByTime)) {
                otMeetingRoomReservationPagination.setRegularMeetingIdList(regularMeetingByTime);
            } else {
                return new ArrayList<OtMeetingRoomReservationEntity>();
            }
        }
        ArrayList roomList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getRoomAddress())) {
            QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getRoomAddress, (Object)otMeetingRoomReservationPagination.getRoomAddress());
            List list = this.otMeetingRoomService.list((Wrapper)otMeetingRoomQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)list)) {
                roomList.addAll(list.stream().map(OtMeetingRoomEntity::getId).collect(Collectors.toList()));
            }
        }
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomReservationNum = 0;
        QueryWrapper otMeetingRoomReservationQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == otMeetingRoomReservationPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            otMeetingRoomReservationQueryWrapper.lambda().and(w -> {
                if (ObjectUtil.isNotEmpty((Object)roomList)) {
                    for (String s : roomList) {
                        ((LambdaQueryWrapper)w.like(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)s)).or();
                    }
                    w.eq(OtMeetingRoomReservationEntity::getCompanyId, (Object)userInfo.getOrganizeId());
                } else {
                    w.eq(OtMeetingRoomReservationEntity::getCompanyId, (Object)userInfo.getOrganizeId());
                }
            });
        }
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getRegularMeetingIdList())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, otMeetingRoomReservationPagination.getRegularMeetingIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getEnabledMark())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)otMeetingRoomReservationPagination.getEnabledMark());
        } else {
            otMeetingRoomReservationQueryWrapper.lambda().and(query -> ((LambdaQueryWrapper)query.ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK)).or(w -> ((LambdaQueryWrapper)w.eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK)).eq(OtMeetingRoomReservationEntity::getContactsUserId, (Object)userId)));
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingTitle())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingTitle, (Object)otMeetingRoomReservationPagination.getMeetingTitle());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingRoomId())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)otMeetingRoomReservationPagination.getMeetingRoomId());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingMode())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)otMeetingRoomReservationPagination.getMeetingMode());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getMeetingType())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingType, (Object)otMeetingRoomReservationPagination.getMeetingType());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationPagination.getShowMeetingType())) {
            if (otMeetingRoomReservationPagination.getShowMeetingType().equals("1")) {
                otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
            } else if ("2".equals(otMeetingRoomReservationPagination.getShowMeetingType())) {
                otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getCreatorUserId, (Object)userId);
            } else if ("3".equals(otMeetingRoomReservationPagination.getShowMeetingType())) {
                ArrayList<String> markList = new ArrayList<String>();
                markList.add(MeetingConstants.WAIT_ENABLEDMARK);
                markList.add(MeetingConstants.WITHDRAW_ENABLEDMARK);
                markList.add(MeetingConstants.REJECT_ENABLEDMARK);
                markList.add(MeetingConstants.DRAFT_ENABLEDMARK);
                otMeetingRoomReservationQueryWrapper.lambda().notIn(OtMeetingRoomReservationEntity::getEnabledMark, markList);
                otMeetingRoomReservationQueryWrapper.apply("FIND_IN_SET('" + userId + "', participants_user_ids)", new Object[0]);
            }
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)otMeetingRoomReservationPagination.getSidx())) {
            otMeetingRoomReservationQueryWrapper.lambda().orderByDesc(OtMeetingRoomReservationEntity::getRepetitiveStartTime);
        } else {
            try {
                String sidx = otMeetingRoomReservationPagination.getSidx();
                OtMeetingRoomReservationEntity otMeetingRoomReservationEntity = new OtMeetingRoomReservationEntity();
                Field declaredField = otMeetingRoomReservationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomReservationQueryWrapper = "asc".equals(otMeetingRoomReservationPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(otMeetingRoomReservationPagination.getCurrentPage(), otMeetingRoomReservationPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomReservationQueryWrapper);
                return otMeetingRoomReservationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return otMeetingRoomReservationPagination.setData(list, list.size());
        }
        return this.list((Wrapper)otMeetingRoomReservationQueryWrapper);
    }

    @Override
    public OtMeetingRoomReservationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getId, (Object)id);
        return (OtMeetingRoomReservationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OtMeetingRoomReservationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OtMeetingRoomReservationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public DownloadVO exportData(OtMeetingRoomReservationPaginationExportModel otMeetingRoomReservationPaginationExportModel) {
        OtMeetingRoomReservationPagination otMeetingRoomReservationPagination = (OtMeetingRoomReservationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPaginationExportModel), OtMeetingRoomReservationPagination.class));
        List<OtMeetingRoomReservationEntity> list = this.getTypeList(otMeetingRoomReservationPagination, otMeetingRoomReservationPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        for (OtMeetingRoomReservationListVO entity : listVO) {
            List<OtMeetingRoomEntity> infoByIdList;
            entity.setMeetingType(this.baseDataUtil.getDictName(entity.getMeetingType(), "meetingType"));
            entity.setHostingUserId(this.baseDataUtil.userSelectValues(entity.getHostingUserId()));
            entity.setHostingDepartment(this.baseDataUtil.comSelectValues(entity.getHostingDepartment()));
            entity.setContactsUserId(this.baseDataUtil.userSelectValues(entity.getContactsUserId()));
            entity.setParticipantsUserIds(this.baseDataUtil.userSelectValues(entity.getParticipantsUserIds()));
            entity.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(entity.getMeetingMinutesOfficer()));
            entity.setResourcePreparation(this.baseDataUtil.getDictName(entity.getResourcePreparation(), "meetingDevice"));
            entity.setStartTime(com.bringspring.common.util.DateUtil.daFormat((Long)Long.valueOf(entity.getStartTime())));
            entity.setEndTime(com.bringspring.common.util.DateUtil.daFormat((Long)Long.valueOf(entity.getEndTime())));
            if (entity.getMeetingMode().equals(MeetingConstants.ORIGINARY_MEETING)) {
                entity.setRepetitiveStartTime("\u2014");
                entity.setRepetitiveEndTime("\u2014");
            }
            entity.setMeetingMode(this.baseDataUtil.getDictName(entity.getMeetingMode(), "conference"));
            entity.setRepetitiveMode(this.baseDataUtil.getDictName(entity.getRepetitiveMode(), "repeatModule"));
            entity.setEnabledMark(this.baseDataUtil.getDictName(String.valueOf(entity.getEnabledMark()), "meetingEnabledMark"));
            entity.setFilesPath(this.baseDataUtil.getFileNameInJson(entity.getFilesPath()));
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
            OtMeetingRoomEntity otMeetingRoomEntity = this.getOtMeetingRoom(entity.getMeetingRoomId());
            if (otMeetingRoomEntity != null) {
                entity.setMeetingRoomId(otMeetingRoomEntity.getName());
            }
            if (ObjectUtil.isNotEmpty(infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId()))) {
                String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                entity.setMeetingRoomId(meetingRoomName);
            }
            entity.setDescription(Html2Text.getContent(entity.getDescription()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)otMeetingRoomReservationPaginationExportModel.getSelectKey()) ? otMeetingRoomReservationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "meetingRoomId": {
                        entitys.add(new ExcelExportEntity("\u4f1a\u8bae\u5ba4\u540d\u79f0", (Object)"meetingRoomId"));
                        continue block54;
                    }
                    case "meetingTitle": {
                        entitys.add(new ExcelExportEntity("\u4f1a\u8bae\u4e3b\u9898", (Object)"meetingTitle"));
                        continue block54;
                    }
                    case "meetingType": {
                        entitys.add(new ExcelExportEntity("\u4f1a\u8bae\u7c7b\u578b", (Object)"meetingType"));
                        continue block54;
                    }
                    case "hostingUserId": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u6301\u4eba", (Object)"hostingUserId"));
                        continue block54;
                    }
                    case "hostingDepartment": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u529e\u90e8\u95e8", (Object)"hostingDepartment"));
                        continue block54;
                    }
                    case "contactsUserId": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contactsUserId"));
                        continue block54;
                    }
                    case "contactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"contactPhone"));
                        continue block54;
                    }
                    case "participantsUserIds": {
                        entitys.add(new ExcelExportEntity("\u53c2\u4f1a\u4eba\u5458", (Object)"participantsUserIds"));
                        continue block54;
                    }
                    case "meetingMinutesOfficer": {
                        entitys.add(new ExcelExportEntity("\u4f1a\u8bae\u7eaa\u8981\u5458", (Object)"meetingMinutesOfficer"));
                        continue block54;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startTime"));
                        continue block54;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"endTime"));
                        continue block54;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block54;
                    }
                    case "resourcePreparation": {
                        entitys.add(new ExcelExportEntity("\u8d44\u6e90\u51c6\u5907", (Object)"resourcePreparation"));
                        continue block54;
                    }
                    case "meetingMode": {
                        entitys.add(new ExcelExportEntity("\u4f1a\u8bae\u65b9\u5f0f", (Object)"meetingMode"));
                        continue block54;
                    }
                    case "repetitiveMode": {
                        entitys.add(new ExcelExportEntity("\u91cd\u590d\u6a21\u5f0f", (Object)"repetitiveMode"));
                        continue block54;
                    }
                    case "repetitiveStartTime": {
                        entitys.add(new ExcelExportEntity("\u5468\u671f\u4f1a\u8bae\u5177\u4f53\u5f00\u59cb\u65f6\u95f4", (Object)"repetitiveStartTime"));
                        continue block54;
                    }
                    case "repetitiveEndTime": {
                        entitys.add(new ExcelExportEntity("\u5468\u671f\u4f1a\u8bae\u5177\u4f53\u622a\u6b62\u65f6\u95f4", (Object)"repetitiveEndTime"));
                        continue block54;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block54;
                    }
                    case "filesPath": {
                        entitys.add(new ExcelExportEntity("\u9644\u4ef6", (Object)"filesPath"));
                        continue block54;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block54;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + com.bringspring.common.util.DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}");
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void delete(OtMeetingRoomReservationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public OtMeetingRoomEntity getOtMeetingRoom(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomEntity::getId, (Object)id);
        return (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void sendMessage(List<String> userIds, String title, String content, String url, String id, String type, String userId) throws Exception {
        List collect = userIds.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(60));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId("488609234393657413");
        sentMessageForm.setTitle("\u7ad9\u5185\u4fe1\u6807\u9898");
        sentMessageForm.setContent("\u7ad9\u5185\u4fe1\u5185\u5bb9");
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("userId", userId);
        map.put("type", type);
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue() + url);
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    @Override
    public void newSendMessage(String tsakCode, String sendCode, String title, String content, String url, String PCurl, List<String> toUserIds, String termType, String termTypeDesc) throws Exception {
        try {
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode(tsakCode);
            taskMsg.setSendCode(sendCode);
            String messageTime = com.bringspring.common.util.DateUtil.dateFormat((Date)new Date());
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("title", title);
            parameterMap.put("content", content);
            parameterMap.put("MessageTime", messageTime);
            LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
            linkMsgKeys.setLinkUrl("");
            linkMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
            CustomKeysLink customKeysLink = new CustomKeysLink();
            customKeysLink.setTermType(termType);
            customKeysLink.setTermTypeDesc(termTypeDesc);
            customKeysLink.setPcUrl(PCurl);
            taskMsg.setCustomKey(customKeysLink);
            taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u6d88\u606f\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireListByMeetingRoomId(String meetingRoomId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("30");
        arrayList.add("20");
        if (meetingRoomId.contains(",")) {
            String[] split = meetingRoomId.split(",");
            List<String> idList = Arrays.asList(split);
            queryWrapper.and(wrapper -> {
                for (int i = 0; i < idList.size(); ++i) {
                    if (i == idList.size() - 1) {
                        wrapper.apply("FIND_IN_SET('" + (String)idList.get(i) + "', meeting_room_id)", new Object[0]);
                        continue;
                    }
                    ((QueryWrapper)wrapper.apply("FIND_IN_SET('" + (String)idList.get(i) + "', meeting_room_id)", new Object[0])).or();
                }
            });
        } else {
            queryWrapper.apply("FIND_IN_SET('" + meetingRoomId + "', meeting_room_id)", new Object[0]);
        }
        queryWrapper.lambda().in(OtMeetingRoomReservationEntity::getEnabledMark, arrayList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireList(List<String> allDateScoped) {
        Date fir = new Date();
        Date sec = new Date();
        if (allDateScoped.get(0).contains("-")) {
            fir = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(0));
            sec = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(1));
        } else {
            fir = new Date(Long.valueOf(allDateScoped.get(0)));
            sec = new Date(Long.valueOf(allDateScoped.get(1)));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("30");
        arrayList.add("20");
        arrayList.add("50");
        queryWrapper.lambda().in(OtMeetingRoomReservationEntity::getEnabledMark, arrayList);
        Date finalFir = fir;
        Date finalSec = sec;
        queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)query.ge(OtMeetingRoomReservationEntity::getEndTime, (Object)finalFir)).le(OtMeetingRoomReservationEntity::getEndTime, (Object)finalSec)).or()).eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)MeetingConstants.MEETING_MODE)).ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.EXPIRE_ENABLEDMARK));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getListByMeetingRoomId(String meetingRoomId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)meetingRoomId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void scheduledupdateEnabledMark() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)query.eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)30)).or()).eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)20));
        queryWrapper.lambda().lt(OtMeetingRoomReservationEntity::getEndTime, (Object)com.bringspring.common.util.DateUtil.getNow());
        List list = this.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : list) {
                otMeetingRoomReservationEntity.setEnabledMark(50);
            }
            this.updateBatchById(list);
        }
    }

    @Override
    public void scheduledMeetingMessage() {
        List listByVo;
        List listByDateScope;
        Date dayBegin = com.bringspring.common.util.DateUtil.getDayBegin();
        Date dayEnd = com.bringspring.common.util.DateUtil.getDayEnd();
        ArrayList<String> dateList = new ArrayList<String>();
        dateList.add(String.valueOf(dayBegin.getTime()));
        dateList.add(String.valueOf(dayEnd.getTime()));
        List<String> regularMeetingByTime = this.getRegularMeetingByTime(dateList, "all");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
        if (ObjectUtil.isNotEmpty(regularMeetingByTime)) {
            queryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, regularMeetingByTime);
        }
        if (ObjectUtil.isNotEmpty((Object)(listByDateScope = JsonUtil.getJsonToList((Object)(listByVo = this.list((Wrapper)queryWrapper)), OtMeetingRoomReservationListVO.class)))) {
            for (OtMeetingRoomReservationListVO reservationListVO : listByDateScope) {
                String url = MeetingConstants.APP_MEETING_MY + reservationListVO.getId();
                String PCurl = MeetingConstants.PC_MEETING_MY + reservationListVO.getId();
                if (reservationListVO.getEnabledMark().equals(MeetingConstants.EXPIRE_ENABLEDMARK)) continue;
                if (new Date().getTime() > Long.valueOf(reservationListVO.getEndTime())) {
                    reservationListVO.setEnabledMark(MeetingConstants.EXPIRE_ENABLEDMARK);
                    OtMeetingRoomReservationEntity subentity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)reservationListVO, OtMeetingRoomReservationEntity.class);
                    ArrayList<String> list1 = new ArrayList<String>();
                    list1.add(reservationListVO.getMeetingMinutesOfficer());
                    String titTwo = "\u8bf7\u53ca\u65f6\u4e0a\u4f20\u672c\u6b21\u4f1a\u8bae\u7eaa\u8981\n\u8bf7\u5230PC\u7aef\u4e0a\u4f20";
                    String content = "\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationListVO.getMeetingTitle();
                    SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, titTwo, content, url, PCurl, list1, TermTypeEnum.TERM_APP_PC.getCode(), "");
                    this.update(subentity.getId(), subentity);
                }
                ArrayList<String> userIds = new ArrayList<String>();
                List<String> jsonToList = this.strToList(reservationListVO.getParticipantsUserIds());
                userIds.addAll(jsonToList);
                List<String> list = this.strToList(reservationListVO.getRemindTime().toString());
                List collect = list.stream().sorted().collect(Collectors.toList());
                Collections.reverse(collect);
                if (Integer.valueOf(reservationListVO.getCurrentRemindTimes()) > collect.size() - 1) continue;
                String s = (String)collect.get(Integer.valueOf(reservationListVO.getCurrentRemindTimes()));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationListVO.getMeetingTitle());
                Long currentDate = null;
                String meetingTime = "";
                String content = "";
                if (reservationListVO.getMeetingMode().equals(MeetingConstants.MEETING_MODE)) {
                    String date = com.bringspring.common.util.DateUtil.daFormat((Date)dayBegin) + " " + reservationListVO.getRepetitiveStartTime();
                    currentDate = com.bringspring.common.util.DateUtil.stringToDate((String)date).getTime();
                    stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + reservationListVO.getRepetitiveStartTime().substring(0, 5) + " - " + reservationListVO.getRepetitiveStartTime().substring(0, 5));
                    meetingTime = reservationListVO.getRepetitiveStartTime().substring(0, 5);
                } else {
                    currentDate = Long.valueOf(reservationListVO.getStartTime());
                    meetingTime = com.bringspring.common.util.DateUtil.daFormatHHMMSS((Long)currentDate).substring(11, 16);
                    stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + com.bringspring.common.util.DateUtil.daFormatHHMMSS((Long)currentDate).substring(5, 16) + " - " + com.bringspring.common.util.DateUtil.daFormatHHMMSS((Long)Long.valueOf(reservationListVO.getEndTime())).substring(11, 16));
                }
                if (currentDate - new Date().getTime() <= 0L || currentDate - new Date().getTime() > (long)(Integer.valueOf(s) * 60 * 1000)) continue;
                String titTwo = "\u60a8\u6709\u4f1a\u8bae\u9700\u8981\u53c2\u52a0\uff0c\u8bf7\u67e5\u770b\uff01";
                String meetSpot = "";
                List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(reservationListVO.getMeetingRoomId());
                if (ObjectUtil.isNotEmpty(infoByIdList)) {
                    meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                }
                stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
                Long minute = (currentDate - new Date().getTime()) / 1000L / 60L;
                stringBuffer.append("\n\u8ddd\u79bb\u4f1a\u8bae\u5f00\u59cb\u8fd8\u6709" + minute + "\u5206\u949f\uff0c\u5c06\u4e8e" + meetingTime + "\u6b63\u5f0f\u5f00\u59cb\u3002");
                stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(reservationListVO.getContactsUserId()));
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, titTwo, stringBuffer.toString(), url, PCurl, userIds, TermTypeEnum.TERM_APP_PC.getCode(), "");
                OtMeetingRoomReservationEntity subentity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)reservationListVO, OtMeetingRoomReservationEntity.class);
                subentity.setCurrentRemindTimes(subentity.getCurrentRemindTimes() + 1);
                this.update(subentity.getId(), subentity);
            }
        }
    }

    @Override
    public void setRegularMeetingRemindTimes() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)MeetingConstants.MEETING_MODE)).eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK)).le(OtMeetingRoomReservationEntity::getStartTime, (Object)com.bringspring.common.util.DateUtil.getNowDate())).ge(OtMeetingRoomReservationEntity::getEndTime, (Object)com.bringspring.common.util.DateUtil.getNowDate());
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            for (OtMeetingRoomReservationEntity reservationEntity : list) {
                reservationEntity.setCurrentRemindTimes(0);
            }
            this.updateBatchById(list);
        }
    }

    @Override
    public Boolean creatHandle(OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) {
        Boolean flag;
        OtMeetingRoomReservationEntity entity;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        otMeetingRoomReservationCrForm.setCreatorUserId(userInfo.getUserId());
        otMeetingRoomReservationCrForm.setCreatorTime(com.bringspring.common.util.DateUtil.getNow());
        otMeetingRoomReservationCrForm.setCompanyId(userInfo.getOrganizeId());
        if (StringUtils.isNotEmpty((String)otMeetingRoomReservationCrForm.getMeetingRoomId())) {
            otMeetingRoomReservationCrForm.setMeetingRoomId(otMeetingRoomReservationCrForm.getMeetingRoomId().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        if (MeetingConstants.MEETING_MODE.equals((entity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationCrForm, OtMeetingRoomReservationEntity.class)).getMeetingMode()) ? (flag = this.judgeRegularTimeConflict(entity)) != false : (flag = this.judgeOriginaryTimeConflict(entity)) != false) {
            return false;
        }
        boolean jinchuangFlag = StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3");
        ArrayList<String> messageList = new ArrayList<String>();
        if (jinchuangFlag) {
            messageList.addAll(this.strToList(otMeetingRoomReservationCrForm.getParticipantsUserIds()));
        } else {
            messageList.addAll(this.getNotifyUserByMeetingRoomId(otMeetingRoomReservationCrForm.getMeetingRoomIdList()));
        }
        if ("temporary".equals(otMeetingRoomReservationCrForm.getButtonFlag())) {
            entity.setEnabledMark(Integer.valueOf(MeetingConstants.DRAFT_ENABLEDMARK));
        } else {
            entity.setEnabledMark(jinchuangFlag ? Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK) : Integer.valueOf(MeetingConstants.WAIT_ENABLEDMARK));
            if (!messageList.isEmpty()) {
                String title = jinchuangFlag ? "\u60a8\u6709\u4f1a\u8bae\u9700\u8981\u53c2\u52a0\uff0c\u8bf7\u67e5\u770b\uff01" : "\u6709\u4f1a\u8bae\u7533\u8bf7\u9700\u8981\u5ba1\u6838\uff01";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + entity.getMeetingTitle());
                stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)entity.getStartTime(), (String)"MM-dd HH:mm") + "-" + DateUtil.format((Date)entity.getEndTime(), (String)"HH:mm"));
                String meetSpot = "";
                List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId());
                if (ObjectUtil.isNotEmpty(infoByIdList)) {
                    meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                }
                stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
                String appurl = (jinchuangFlag ? MeetingConstants.PC_MEETING_MY : MeetingConstants.APP_MEETING_APPROVE) + mainId;
                String pcurl = (jinchuangFlag ? MeetingConstants.APP_MEETING_MY : MeetingConstants.PC_MEETING_APPROVE) + mainId;
                try {
                    SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), appurl, pcurl, messageList, TermTypeEnum.TERM_APP_PC.getCode(), "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        entity.setCurrentRemindTimes(0);
        entity.setId(mainId);
        this.save(entity);
        return true;
    }

    @Override
    public OtMeetingRoomReservationEntity meetingCreate(OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) {
        Boolean flag;
        OtMeetingRoomReservationEntity entity;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        otMeetingRoomReservationCrForm.setCreatorUserId(userInfo.getUserId());
        otMeetingRoomReservationCrForm.setCreatorTime(com.bringspring.common.util.DateUtil.getNow());
        otMeetingRoomReservationCrForm.setCompanyId(userInfo.getOrganizeId());
        if (StringUtils.isNotEmpty((String)otMeetingRoomReservationCrForm.getMeetingRoomId())) {
            otMeetingRoomReservationCrForm.setMeetingRoomId(otMeetingRoomReservationCrForm.getMeetingRoomId().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        if (MeetingConstants.MEETING_MODE.equals((entity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationCrForm, OtMeetingRoomReservationEntity.class)).getMeetingMode()) ? (flag = this.judgeRegularTimeConflict(entity)) != false : (flag = this.judgeOriginaryTimeConflict(entity)) != false) {
            return new OtMeetingRoomReservationEntity();
        }
        List<String> messageList = this.getNotifyUserByMeetingRoomId(otMeetingRoomReservationCrForm.getMeetingRoomIdList());
        if ("temporary".equals(otMeetingRoomReservationCrForm.getButtonFlag())) {
            entity.setEnabledMark(10);
        } else {
            entity.setEnabledMark(StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3") ? Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK) : Integer.valueOf(MeetingConstants.WAIT_ENABLEDMARK));
            if (!messageList.isEmpty() && !StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3")) {
                String title = "\u6709\u4f1a\u8bae\u7533\u8bf7\u9700\u8981\u5ba1\u6838\uff01";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + entity.getMeetingTitle());
                stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)entity.getStartTime(), (String)"MM-dd HH:mm") + "-" + DateUtil.format((Date)entity.getEndTime(), (String)"HH:mm"));
                String meetSpot = "";
                List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId());
                if (ObjectUtil.isNotEmpty(infoByIdList)) {
                    meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                }
                stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
                String appurl = MeetingConstants.APP_MEETING_APPROVE + mainId;
                String pcurl = MeetingConstants.PC_MEETING_APPROVE + mainId;
                try {
                    SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), appurl, pcurl, messageList, TermTypeEnum.TERM_APP_PC.getCode(), "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        entity.setCurrentRemindTimes(0);
        entity.setId(mainId);
        this.save(entity);
        return entity;
    }

    @Override
    public Boolean updateHandle(String id, OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) {
        Boolean flag;
        UserInfo userInfo = this.userProvider.get();
        OtMeetingRoomReservationEntity entity = this.getInfo(id);
        otMeetingRoomReservationUpForm.setLastModifyUserId(userInfo.getUserId());
        otMeetingRoomReservationUpForm.setLastModifyTime(com.bringspring.common.util.DateUtil.getNow());
        if (StringUtils.isNotEmpty((String)otMeetingRoomReservationUpForm.getMeetingRoomId())) {
            otMeetingRoomReservationUpForm.setMeetingRoomId(otMeetingRoomReservationUpForm.getMeetingRoomId().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        OtMeetingRoomReservationEntity subentity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationUpForm, OtMeetingRoomReservationEntity.class);
        if (MeetingConstants.MEETING_MODE.equals(entity.getMeetingMode()) ? (flag = this.judgeRegularTimeConflict(subentity)) != false : (flag = this.judgeOriginaryTimeConflict(subentity)) != false) {
            return false;
        }
        subentity.setCreatorUserId(entity.getCreatorUserId());
        subentity.setCreatorTime(entity.getCreatorTime());
        List<String> messageList = this.getNotifyUserByMeetingRoomId(Arrays.asList(otMeetingRoomReservationUpForm.getMeetingRoomId().split(",")));
        StringBuffer stringBuffer = new StringBuffer();
        if (subentity.getEnabledMark() == Integer.valueOf(MeetingConstants.WAIT_ENABLEDMARK) && StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3")) {
            subentity.setEnabledMark(Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK));
        }
        String meetSpot = "";
        List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(subentity.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdList)) {
            meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
        }
        stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + subentity.getMeetingTitle());
        stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + com.bringspring.common.util.DateUtil.format((Date)subentity.getStartTime(), (String)"MM-dd HH:mm") + " - " + com.bringspring.common.util.DateUtil.format((Date)subentity.getEndTime(), (String)"HH:mm"));
        stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
        stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(subentity.getContactsUserId()));
        if (!messageList.isEmpty() && subentity.getEnabledMark() == Integer.valueOf(MeetingConstants.WAIT_ENABLEDMARK)) {
            String title = "\u6709\u4f1a\u8bae\u7533\u8bf7\u9700\u8981\u5ba1\u6838\uff01";
            String appurl = MeetingConstants.APP_MEETING_APPROVE + subentity.getId();
            String pcurl = MeetingConstants.PC_MEETING_APPROVE + subentity.getId();
            try {
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), appurl, pcurl, messageList, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (subentity.getEnabledMark() == Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK) && entity.getEnabledMark() == Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK)) {
            try {
                this.updatePassMeetAndSendMessage(entity, subentity);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.update(id, subentity);
        return true;
    }

    @Override
    public List<OtMeetingRoomReservationListVO> getListByDateScope(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) {
        List<String> regularMeetingByTime;
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped()) && ObjectUtil.isNotEmpty(regularMeetingByTime = this.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped(), "some"))) {
            otMeetingRoomReservationPagination.setRegularMeetingIdList(regularMeetingByTime);
        }
        List<OtMeetingRoomReservationEntity> list = this.getList(otMeetingRoomReservationPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        return listVO;
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireRegularList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)MeetingConstants.MEETING_MODE)).ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.EXPIRE_ENABLEDMARK);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean judgeOriginaryTimeConflict(OtMeetingRoomReservationEntity entity) {
        List<OtMeetingRoomReservationEntity> notExpireMeetingList = this.getNotExpireListByMeetingRoomId(entity.getMeetingRoomId());
        if (ObjectUtil.isEmpty(notExpireMeetingList)) {
            return false;
        }
        for (OtMeetingRoomReservationEntity otMeetingEntity : notExpireMeetingList) {
            if (MeetingConstants.MEETING_MODE.equals(otMeetingEntity.getMeetingMode())) {
                OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)otMeetingEntity, OtMeetingRoomReservationCrForm.class);
                List<Date> dateList = this.getRegularMeetingTimeList(otMeetingEntity);
                if (!ObjectUtil.isNotEmpty(dateList)) continue;
                for (Date date : dateList) {
                    Date startTime = com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                    Date endTime = com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveEndTime()));
                    boolean b = DateUtils.hasOverlap(entity.getStartTime(), entity.getEndTime(), startTime, endTime);
                    if (!b) continue;
                    return true;
                }
                continue;
            }
            boolean b = DateUtils.hasOverlap(otMeetingEntity.getStartTime(), otMeetingEntity.getEndTime(), entity.getStartTime(), entity.getEndTime());
            if (!b) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean judgeRegularTimeConflict(OtMeetingRoomReservationEntity entity) {
        List<OtMeetingRoomReservationEntity> notExpireMeetingList = this.getNotExpireListByMeetingRoomId(entity.getMeetingRoomId());
        if (ObjectUtil.isEmpty(notExpireMeetingList)) {
            return false;
        }
        OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationCrForm.class);
        List<Date> dateList = this.getRegularMeetingTimeList(entity);
        if (ObjectUtil.isNotEmpty(dateList)) {
            for (Date date : dateList) {
                Date startTime = com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                Date endTime = com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveEndTime()));
                OtMeetingRoomReservationEntity entityOne = new OtMeetingRoomReservationEntity();
                entityOne.setMeetingRoomId(entity.getMeetingRoomId());
                entityOne.setStartTime(startTime);
                entityOne.setEndTime(endTime);
                entityOne.setRepetitiveStartTime(entity.getRepetitiveStartTime());
                entityOne.setRepetitiveEndTime(entity.getRepetitiveEndTime());
                entityOne.setMeetingMode(MeetingConstants.ORIGINARY_MEETING);
                Boolean aBoolean = this.judgeOriginaryTimeConflict(entityOne);
                if (!aBoolean.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Date> getRegularMeetingTimeList(OtMeetingRoomReservationEntity entity) {
        OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationCrForm.class);
        List<Date> dateList = new ArrayList<Date>();
        switch (entity.getRepetitiveMode()) {
            case "W": {
                List<String> dayOfWeekWithinDateInterval = DateUtils.getDayOfWeekWithinDateInterval(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
                for (String s : dayOfWeekWithinDateInterval) {
                    dateList.add(com.bringspring.common.util.DateUtil.stringToDates((String)s));
                }
                break;
            }
            case "D": {
                dateList = DateUtils.dateAddDaysBetweenDate(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
                break;
            }
            case "M": {
                dateList = DateUtils.dateMonthBetweenDate(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
            }
        }
        return dateList;
    }

    @Override
    public List<String> getRegularMeetingByTime(List<String> allDateScoped, String type) {
        Date fir = new Date();
        Date sec = new Date();
        if (allDateScoped.get(0).contains("-")) {
            fir = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(0));
            sec = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(1));
        } else {
            fir = new Date(Long.valueOf(allDateScoped.get(0)));
            sec = new Date(Long.valueOf(allDateScoped.get(1)));
        }
        List<Object> notExpireRegularList = new ArrayList();
        notExpireRegularList = "some".equals(type) ? this.getNotExpireList(allDateScoped) : this.getMeetingListByTime(allDateScoped);
        ArrayList<String> list = new ArrayList<String>();
        for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : notExpireRegularList) {
            OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationEntity, OtMeetingRoomReservationCrForm.class);
            if (MeetingConstants.MEETING_MODE.equals(otMeetingRoomReservationEntity.getMeetingMode())) {
                List<Date> regularMeetingTimeList = this.getRegularMeetingTimeList(otMeetingRoomReservationEntity);
                for (Date date : regularMeetingTimeList) {
                    Date startTime = com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                    if (!startTime.after(fir) || !startTime.before(sec)) continue;
                    list.add(otMeetingRoomReservationEntity.getId());
                }
                continue;
            }
            list.add(otMeetingRoomReservationEntity.getId());
        }
        return list;
    }

    @Override
    public List<String> getMyselfMeetingList() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
        List list = this.list((Wrapper)queryWrapper);
        ArrayList<String> userIds = new ArrayList<String>();
        for (OtMeetingRoomReservationEntity reservationEntity : list) {
            List jsonToList;
            if (!ObjectUtil.isNotEmpty((Object)reservationEntity.getParticipantsUserIds()) || !(jsonToList = JsonUtil.getJsonToList((String)reservationEntity.getParticipantsUserIds(), String.class)).contains(userInfo.getId())) continue;
            userIds.add(reservationEntity.getId());
        }
        return userIds;
    }

    @Override
    public OtMeetingRoomReservationEntity approveMeeting(OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getId, (Object)otMeetingRoomReservationUpForm.getId());
        OtMeetingRoomReservationEntity one = (OtMeetingRoomReservationEntity)this.getOne((Wrapper)queryWrapper);
        one.setEnabledMark(Integer.valueOf(otMeetingRoomReservationUpForm.getEnabledMark()));
        return one;
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getMeetingListByTime(List<String> allDateScoped) {
        Date fir = new Date();
        Date sec = new Date();
        if (allDateScoped.get(0).contains("-")) {
            fir = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(0));
            sec = com.bringspring.common.util.DateUtil.stringToDate((String)allDateScoped.get(1));
        } else {
            fir = new Date(Long.valueOf(allDateScoped.get(0)));
            sec = new Date(Long.valueOf(allDateScoped.get(1)));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().ge(OtMeetingRoomReservationEntity::getEndTime, (Object)fir)).le(OtMeetingRoomReservationEntity::getEndTime, (Object)sec)).or()).eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)MeetingConstants.MEETING_MODE)).le(OtMeetingRoomReservationEntity::getStartTime, (Object)fir)).ge(OtMeetingRoomReservationEntity::getEndTime, (Object)sec);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> meetingDelayHandle(OtMeetingRoomReservationUpForm entity) throws Exception {
        boolean flag;
        OtMeetingRoomReservationPagination otMeetingRoomReservationPagination = new OtMeetingRoomReservationPagination();
        ArrayList<String> allDateScoped = new ArrayList<String>();
        allDateScoped.add(entity.getStartTime());
        Date dayEnd = com.bringspring.common.util.DateUtil.getDayEnd();
        allDateScoped.add(String.valueOf(dayEnd.getTime()));
        otMeetingRoomReservationPagination.setAllDateScoped(allDateScoped);
        otMeetingRoomReservationPagination.setSidx("startTime");
        otMeetingRoomReservationPagination.setSort("asc");
        otMeetingRoomReservationPagination.setMeetingRoomId(entity.getMeetingRoomId());
        List<OtMeetingRoomReservationEntity> collect = this.getList(otMeetingRoomReservationPagination);
        List list = collect.stream().filter(i -> !i.getId().equals(entity.getId()) && i.getMeetingMode().equals(MeetingConstants.ORIGINARY_MEETING) && (i.getEnabledMark() == Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK) || i.getEnabledMark() == Integer.valueOf(MeetingConstants.WAIT_ENABLEDMARK))).collect(Collectors.toList());
        OtMeetingRoomReservationEntity info = this.getInfo(entity.getId());
        info.setEndTime(com.bringspring.common.util.DateUtil.daFormatDate((Long)(Long.valueOf(entity.getEndTime()) + (long)(entity.getDelayTime() * 60 * 1000))));
        this.updateById(info);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList delayList = new ArrayList();
        boolean bl = flag = Long.valueOf(entity.getEndTime()) + (long)(entity.getDelayTime() * 60 * 1000) <= ((OtMeetingRoomReservationEntity)list.get(0)).getStartTime().getTime();
        if (!flag) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Long delayEnd;
                Long delayStart;
                if (i2 < list.size() - 1) {
                    delayStart = ((OtMeetingRoomReservationEntity)list.get(i2)).getStartTime().getTime() + (long)(entity.getDelayTime() * 60 * 1000);
                    delayEnd = ((OtMeetingRoomReservationEntity)list.get(i2)).getEndTime().getTime() + (long)(entity.getDelayTime() * 60 * 1000);
                    ((OtMeetingRoomReservationEntity)list.get(i2)).setStartTime(com.bringspring.common.util.DateUtil.daFormatDate((Long)delayStart));
                    ((OtMeetingRoomReservationEntity)list.get(i2)).setEndTime(com.bringspring.common.util.DateUtil.daFormatDate((Long)delayEnd));
                    delayList.add(list.get(i2));
                    if (((OtMeetingRoomReservationEntity)list.get(i2)).getEndTime().getTime() + (long)(entity.getDelayTime() * 60 * 1000) >= ((OtMeetingRoomReservationEntity)list.get(i2 + 1)).getStartTime().getTime()) continue;
                    break;
                }
                delayStart = ((OtMeetingRoomReservationEntity)list.get(i2)).getStartTime().getTime() + (long)(entity.getDelayTime() * 60 * 1000);
                delayEnd = ((OtMeetingRoomReservationEntity)list.get(i2)).getEndTime().getTime() + (long)(entity.getDelayTime() * 60 * 1000);
                ((OtMeetingRoomReservationEntity)list.get(i2)).setStartTime(com.bringspring.common.util.DateUtil.daFormatDate((Long)delayStart));
                ((OtMeetingRoomReservationEntity)list.get(i2)).setEndTime(com.bringspring.common.util.DateUtil.daFormatDate((Long)delayEnd));
                delayList.add(list.get(i2));
            }
            if (delayList.isEmpty()) {
                return null;
            }
            this.updateBatchById(delayList);
            for (OtMeetingRoomReservationEntity reservationEntity : delayList) {
                String url = MeetingConstants.APP_MEETING_MY + reservationEntity.getId();
                String PCurl = MeetingConstants.PC_MEETING_MY + reservationEntity.getId();
                List<String> jsonToList = this.strToList(reservationEntity.getParticipantsUserIds());
                String content = "\u4f1a\u8bae\u6807\u9898\uff1a" + reservationEntity.getMeetingTitle() + "\n\u65f6\u95f4\u8c03\u6574\uff1a" + com.bringspring.common.util.DateUtil.dateFormat((Date)reservationEntity.getStartTime()) + " \u2014 " + com.bringspring.common.util.DateUtil.dateFormat((Date)reservationEntity.getEndTime()).substring(11) + "\n\u4f1a\u8bae\u5730\u70b9\uff1a" + this.getOtMeetingRoom(reservationEntity.getMeetingRoomId()).getName();
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, "\u60a8\u7684\u4f1a\u8bae\u65f6\u95f4\u6709\u8c03\u6574", content, url, PCurl, jsonToList, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
        }
        return null;
    }

    @Override
    public List<String> strToList(String str) {
        str = str.replaceAll("\"", "").replace("[", "").replace("]", "");
        String[] split = str.split(",");
        return JsonUtil.getJsonToList((Object)split, String.class);
    }

    @Override
    public List<OtMeetingSignEntity> getSignListByMeetingId(String meetingId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingSignEntity::getMeetingId, (Object)meetingId);
        List list = this.otMeetingSignService.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public Boolean updateSignStatus(OtMeetingSignEntity entit) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingSignEntity::getMeetingId, (Object)entit.getMeetingId())).eq(OtMeetingSignEntity::getUserId, (Object)entit.getUserId());
        OtMeetingSignEntity one = (OtMeetingSignEntity)this.otMeetingSignService.getOne((Wrapper)queryWrapper);
        if (one != null) {
            one.setEnabledMark(1);
            this.otMeetingSignService.update(one.getId(), one);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getMeetingListByparticipantsUserIds(OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) {
        String participantsUserIds = otMeetingRoomReservationCrForm.getParticipantsUserIds().replace("[", "").replace("]", "").replaceAll("\"", "");
        List<String> participantsUserList = Arrays.asList(participantsUserIds.split(","));
        ArrayList<String> stringList = new ArrayList<String>();
        Date fir = DateUtils.daFormatDate(Long.valueOf(otMeetingRoomReservationCrForm.getStartTime()));
        Date sec = DateUtils.daFormatDate(Long.valueOf(otMeetingRoomReservationCrForm.getEndTime()));
        for (String s : participantsUserList) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().like(OtMeetingRoomReservationEntity::getParticipantsUserIds, (Object)s);
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().between(OtMeetingRoomReservationEntity::getStartTime, (Object)fir, (Object)sec)).or()).between(OtMeetingRoomReservationEntity::getEndTime, (Object)fir, (Object)sec));
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.WAIT_ENABLEDMARK)).or()).eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK));
            List list = this.list((Wrapper)queryWrapper);
            if (!ObjectUtil.isNotEmpty((Object)list)) continue;
            stringList.add(s);
        }
        return stringList;
    }

    @Override
    public HashMap<String, List<String>> getIntersectionByList(List<String> oldList, List<String> newList) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        List oldListclone = (List)ObjectUtils.clone(oldList);
        List newListclone = (List)ObjectUtils.clone(newList);
        if (ObjectUtil.isNotEmpty(oldList) && ObjectUtil.isNotEmpty(newList)) {
            oldList.removeAll(newList);
            if (ObjectUtil.isNotEmpty(oldList)) {
                hashMap.put("delete", oldList);
            }
            newList.removeAll(oldListclone);
            if (ObjectUtil.isNotEmpty(newList)) {
                hashMap.put("add", newList);
            }
        }
        return hashMap;
    }

    @Override
    public List<String> getNotifyUserByMeetingRoomId(List<String> meetingRoomId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty(meetingRoomId)) {
            return new ArrayList<String>();
        }
        ArrayList<String> messageList = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OtMeetingRoomEntity::getId, meetingRoomId);
        List meetingRoomEntities = this.otMeetingRoomService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)meetingRoomEntities)) {
            ArrayList<String> stringArrayList = new ArrayList<String>();
            List stringList = meetingRoomEntities.stream().map(OtMeetingRoomEntity::getResponsibleUserId).collect(Collectors.toList());
            for (String str : stringList) {
                if (str.contains(",")) {
                    List<String> strings = Arrays.asList(str.split(","));
                    stringArrayList.addAll(strings);
                    continue;
                }
                stringArrayList.add(str);
            }
            messageList.addAll(stringArrayList);
        } else if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"9")) {
            messageList.addAll(this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE_MJ).stream().map(UserEntity::getId).collect(Collectors.toList()));
        } else {
            messageList.addAll(this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE).stream().map(UserEntity::getId).collect(Collectors.toList()));
        }
        return messageList;
    }

    @Override
    public void updatePassMeetAndSendMessage(OtMeetingRoomReservationEntity oldEntity, OtMeetingRoomReservationEntity newEntity) throws Exception {
        String meetSpotOld = "";
        List<OtMeetingRoomEntity> infoByIdListOld = this.otMeetingRoomService.getInfoByIdList(oldEntity.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdListOld)) {
            meetSpotOld = infoByIdListOld.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
        }
        StringBuffer stringBufferOld = new StringBuffer();
        stringBufferOld.append("\u4f1a\u8bae\u65f6\u95f4\uff1a" + com.bringspring.common.util.DateUtil.format((Date)oldEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + com.bringspring.common.util.DateUtil.format((Date)oldEntity.getEndTime(), (String)"HH:mm"));
        stringBufferOld.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpotOld);
        String meetSpot = "";
        List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(newEntity.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdList)) {
            meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + newEntity.getMeetingTitle());
        stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + com.bringspring.common.util.DateUtil.format((Date)newEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + com.bringspring.common.util.DateUtil.format((Date)newEntity.getEndTime(), (String)"HH:mm"));
        stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
        stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(newEntity.getContactsUserId()));
        Map<String, String> compare = ObjectComparator.compare(oldEntity, newEntity);
        ArrayList keyList = new ArrayList();
        if (ObjectUtil.isNotEmpty(compare)) {
            compare.keySet().stream().forEach(key -> keyList.add(key));
        }
        List<String> newUserList = this.strToList(newEntity.getParticipantsUserIds());
        List<String> oldUserList = this.strToList(oldEntity.getParticipantsUserIds());
        List old = (List)ObjectUtils.clone(oldUserList);
        old.retainAll(newUserList);
        if (ObjectUtil.isNotEmpty(keyList)) {
            String url = MeetingConstants.APP_MEETING_MY + newEntity.getId();
            String PCurl = MeetingConstants.PC_MEETING_MY + newEntity.getId();
            String title = "\u6709\u4f1a\u8bae\u5185\u5bb9\u53d1\u751f\u8c03\u6574\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
            if (keyList.contains("meetingTitle") || keyList.contains("meetingRoomId") || keyList.contains("startTime") || keyList.contains("endTime")) {
                StringBuffer oldStringBuffer = new StringBuffer();
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), url, PCurl, old, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            if (keyList.contains("participantsUserIds")) {
                HashMap<String, List<String>> intersectionByList = this.getIntersectionByList(oldUserList, newUserList);
                for (String s : intersectionByList.keySet()) {
                    List<String> list = intersectionByList.get(s);
                    if (s.equals("delete")) {
                        title = "\u6709\u4f1a\u8bae\u6682\u65f6\u53d6\u6d88\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
                        url = MeetingConstants.APP_MEETING_ARRANGEMENT + newEntity.getId();
                        PCurl = MeetingConstants.PC_MEETING_ARRANGEMENT + newEntity.getId();
                        SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), url, PCurl, list, TermTypeEnum.TERM_APP_PC.getCode(), "");
                    }
                    if (!s.equals("add")) continue;
                    title = "\u60a8\u6709\u4f1a\u8bae\u9700\u8981\u53c2\u52a0\uff0c\u8bf7\u67e5\u770b\uff01";
                    SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7ba1\u7406", MeetingConstants.NEW_MEETMSG_CODE, title, stringBufferOld.toString(), url, PCurl, list, TermTypeEnum.TERM_APP_PC.getCode(), "");
                }
            }
        }
    }

    public static boolean isOverlapLocalTime(LocalTime start1, LocalTime end1, LocalTime start2, LocalTime end2, boolean isStrict) {
        if (start1.isAfter(end1) || start2.isAfter(end2)) {
            throw new DateTimeException("endDate\u4e0d\u80fd\u5c0f\u4e8estartDate");
        }
        if (isStrict) {
            return start1.compareTo(end2) <= 0 && end1.compareTo(start2) >= 0;
        }
        return start1.compareTo(end2) < 0 && end1.compareTo(start2) > 0;
    }

    public static void main(String[] args) {
        Date start1 = com.bringspring.common.util.DateUtil.stringToDate((String)"2024-12-03 14:01:00");
        Date end1 = com.bringspring.common.util.DateUtil.stringToDate((String)"2024-12-03 15:00:00");
        Date start2 = com.bringspring.common.util.DateUtil.stringToDate((String)"2024-12-03 14:00:00");
        Date end2 = com.bringspring.common.util.DateUtil.stringToDate((String)"2024-12-03 15:30:00");
        LocalDateTime start1new = start1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime end1new = end1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime start2new = start2.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime end2new = end2.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        Boolean isStrict = false;
        if (start1new.isAfter(end1new) || start2new.isAfter(end2new)) {
            throw new DateTimeException("endDate\u4e0d\u80fd\u5c0f\u4e8estartDate");
        }
        if (isStrict.booleanValue()) {
            if (start1new.compareTo(end2new) <= 0 && end1new.compareTo(start2new) >= 0) {
                System.out.println("true");
            } else {
                System.out.println("false");
            }
        } else if (start1new.compareTo(end2new) < 0 && end1new.compareTo(start2new) > 0) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }
}

