/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingRoomEntity;
import com.bringspring.meeting.mapper.OtMeetingRoomMapper;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomPagination;
import com.bringspring.meeting.service.OtMeetingRoomService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingRoomServiceImpl
extends ServiceImpl<OtMeetingRoomMapper, OtMeetingRoomEntity>
implements OtMeetingRoomService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<OtMeetingRoomEntity> getList(OtMeetingRoomPagination otMeetingRoomPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomNum = 0;
        QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == otMeetingRoomPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object otMeetingRoomObject = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingRoomQueryWrapper, otMeetingRoomPagination.getMenuId(), "ot_meeting_room"));
            if (ObjectUtil.isEmpty((Object)otMeetingRoomObject)) {
                otMeetingRoomQueryWrapper.and(wrapper -> wrapper.apply("FIND_IN_SET('" + userInfo.getOrganizeId() + "',company_id )", new Object[0]));
            } else {
                otMeetingRoomQueryWrapper = (QueryWrapper)otMeetingRoomObject;
            }
        }
        otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getDeleteMark, (Object)0);
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getName())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().like(OtMeetingRoomEntity::getName, (Object)otMeetingRoomPagination.getName());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getResponsibleUserId())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getResponsibleUserId, (Object)otMeetingRoomPagination.getResponsibleUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getEnabledMark())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getEnabledMark, (Object)otMeetingRoomPagination.getEnabledMark());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getRoomAddress())) {
            String roomAddress = otMeetingRoomPagination.getRoomAddress().replaceAll("],\\[", "];[").replaceAll("]]", "]").replaceAll("\\[\\[", "[");
            List<String> stringList = Arrays.asList(roomAddress.split(";"));
            for (int i = 0; i < stringList.size(); ++i) {
                Integer j = i;
                otMeetingRoomQueryWrapper.lambda().or(w -> {
                    w.eq(OtMeetingRoomEntity::getRoomAddress, stringList.get(j));
                    if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getName())) {
                        w.like(OtMeetingRoomEntity::getName, (Object)otMeetingRoomPagination.getName());
                    }
                    if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getResponsibleUserId())) {
                        w.eq(OtMeetingRoomEntity::getResponsibleUserId, (Object)otMeetingRoomPagination.getResponsibleUserId());
                    }
                    if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getEnabledMark())) {
                        w.eq(OtMeetingRoomEntity::getEnabledMark, (Object)otMeetingRoomPagination.getEnabledMark());
                    }
                });
            }
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getCompanyId())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.apply("FIND_IN_SET('" + otMeetingRoomPagination.getCompanyId() + "', company_id)", new Object[0]);
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomQueryWrapper.lambda().in(OtMeetingRoomEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)otMeetingRoomPagination.getSidx())) {
            otMeetingRoomQueryWrapper.lambda().orderByDesc(OtMeetingRoomEntity::getCreatorTime);
        } else {
            try {
                String sidx = otMeetingRoomPagination.getSidx();
                OtMeetingRoomEntity otMeetingRoomEntity = new OtMeetingRoomEntity();
                Field declaredField = otMeetingRoomEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomQueryWrapper = "asc".equals(otMeetingRoomPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(otMeetingRoomPagination.getCurrentPage(), otMeetingRoomPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomQueryWrapper);
            return otMeetingRoomPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return otMeetingRoomPagination.setData(list, list.size());
    }

    @Override
    public List<OtMeetingRoomEntity> getTypeList(OtMeetingRoomPagination otMeetingRoomPagination, String dataType) {
        Object rkContractObj;
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomNum = 0;
        QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingRoomQueryWrapper, otMeetingRoomPagination.getMenuId(), "ot_meeting_room"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            otMeetingRoomQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingRoomQueryWrapper, otMeetingRoomPagination.getMenuId(), "ot_meeting_room"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            otMeetingRoomQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getName())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().like(OtMeetingRoomEntity::getName, (Object)otMeetingRoomPagination.getName());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getCompanyId())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.apply("FIND_IN_SET('" + otMeetingRoomPagination.getCompanyId() + "', company_id)", new Object[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getResponsibleUserId())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getResponsibleUserId, (Object)otMeetingRoomPagination.getResponsibleUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomPagination.getEnabledMark())) {
            ++otMeetingRoomNum;
            otMeetingRoomQueryWrapper.lambda().eq(OtMeetingRoomEntity::getEnabledMark, (Object)otMeetingRoomPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomQueryWrapper.lambda().in(OtMeetingRoomEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)otMeetingRoomPagination.getSidx())) {
            otMeetingRoomQueryWrapper.lambda().orderByDesc(OtMeetingRoomEntity::getCreatorTime);
        } else {
            try {
                String sidx = otMeetingRoomPagination.getSidx();
                OtMeetingRoomEntity otMeetingRoomEntity = new OtMeetingRoomEntity();
                Field declaredField = otMeetingRoomEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomQueryWrapper = "asc".equals(otMeetingRoomPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(otMeetingRoomPagination.getCurrentPage(), otMeetingRoomPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomQueryWrapper);
                return otMeetingRoomPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return otMeetingRoomPagination.setData(list, list.size());
        }
        return this.list((Wrapper)otMeetingRoomQueryWrapper);
    }

    @Override
    public OtMeetingRoomEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomEntity::getId, (Object)id);
        return (OtMeetingRoomEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomEntity> getInfoByIdList(String idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List<String> list = Arrays.asList(idList.split(","));
        queryWrapper.lambda().in(OtMeetingRoomEntity::getId, list);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(OtMeetingRoomEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OtMeetingRoomEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public String deviceToString(String device) {
        String devices = device.replaceAll("[\\[\\]\"]", "");
        String[] feilds = devices.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : feilds) {
        }
        return stringBuffer.toString();
    }

    @Override
    public OtMeetingRoomEntity getInfoByDeviceId(String deviceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(OtMeetingRoomEntity::getDevices, (Object)deviceId);
        return (OtMeetingRoomEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(OtMeetingRoomEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public static void main(String[] args) {
        String s = "[[\"05\",\"44\",\"4402\"],[\"05\",\"44\",\"4403\"]]";
        String s2 = "[\"05\",\"44\",\"4402\"]";
        String replace = s.replaceAll("\\[\\[", "[").replace("]]", "]");
        boolean contains = replace.contains(s2);
        System.out.println(contains);
    }
}

