/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.utils;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.DateUtil;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class DateUtils {
    public static List<String> getDayOfWeekWithinDateInterval(String dataBegin, String dataEnd, int weekDays) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dataBegin = DateUtil.daFormatYmd((Long)Long.valueOf(dataBegin));
        dataEnd = DateUtil.daFormatYmd((Long)Long.valueOf(dataEnd));
        ArrayList<String> dateResult = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        String[] dateInterval = new String[]{dataBegin, dataEnd};
        Date[] dates = new Date[dateInterval.length];
        for (int i = 0; i < dateInterval.length; ++i) {
            String[] ymd = dateInterval[i].split("[^\\d]+");
            cal.set(Integer.parseInt(ymd[0]), Integer.parseInt(ymd[1]) - 1, Integer.parseInt(ymd[2]));
            dates[i] = cal.getTime();
        }
        Date date = dates[0];
        while (date.compareTo(dates[1]) <= 0) {
            cal.setTime(date);
            if (cal.get(7) - 1 == weekDays) {
                String format = sdf.format(date);
                dateResult.add(format);
            }
            cal.add(5, 1);
            date = cal.getTime();
        }
        return dateResult;
    }

    public static List<Date> dateAddDaysBetweenDate(String dataBegin, String dataEnd, int weekDays) {
        Date beginDate = DateUtil.stringToDates((String)DateUtil.daFormatYmd((Long)Long.valueOf(dataBegin)));
        Date endDate = DateUtil.stringToDates((String)DateUtil.daFormatYmd((Long)Long.valueOf(dataEnd)));
        ArrayList<Date> dateList = new ArrayList<Date>();
        Date date2 = new Date();
        date2 = DateUtil.dateAddDays((Date)beginDate, (int)weekDays);
        int num = 1;
        while (date2.before(endDate)) {
            dateList.add(date2);
            date2 = DateUtil.dateAddDays((Date)beginDate, (int)(++num * weekDays));
        }
        return dateList;
    }

    public static Date daFormatDate(Long date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date(date);
        return time;
    }

    public static String dateFormatToDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static List<Date> dateMonthBetweenDate(String dataBegin, String dataEnd, int weekDays) {
        String weekDaysString = "";
        weekDaysString = weekDays < 10 ? "0" + weekDays : "" + weekDays;
        Date beginDate = DateUtil.stringToDates((String)DateUtil.daFormatYmd((Long)Long.valueOf(dataBegin)));
        Date endDate = DateUtil.stringToDates((String)DateUtil.daFormatYmd((Long)Long.valueOf(dataEnd)));
        List allDays = DateUtil.getAllDays((Date)beginDate, (Date)endDate);
        ArrayList<Date> dateList = new ArrayList<Date>();
        for (Date allDay : allDays) {
            String str = DateUtil.daFormat((Date)allDay);
            String substring = str.substring(str.length() - 2);
            if (!weekDaysString.equals(substring)) continue;
            dateList.add(DateUtil.stringToDates((String)str));
        }
        return dateList;
    }

    public static boolean hasOverlap(Date start1, Date end1, Date start2, Date end2) {
        if (ObjectUtil.isNull((Object)start1) || ObjectUtil.isNull((Object)end1) || ObjectUtil.isNull((Object)start2) || ObjectUtil.isNull((Object)end2)) {
            return true;
        }
        LocalDateTime start1new = start1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime end1new = end1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime start2new = start2.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime end2new = end2.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        Boolean isStrict = false;
        if (start1new.isAfter(end1new) || start2new.isAfter(end2new)) {
            return true;
        }
        if (isStrict.booleanValue()) {
            return start1new.compareTo(end2new) <= 0 && end1new.compareTo(start2new) >= 0;
        }
        return start1new.compareTo(end2new) < 0 && end1new.compareTo(start2new) > 0;
    }

    public static int getMonthByDate(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public Date getThisMonthTime(Integer i, Time time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(df.format(new Date()));
        String format = df.format(new Date());
        String substring = format.substring(0, 8);
        if (i < 10) {
            String str = "0" + i;
            String s = substring + str + " " + time;
            Date date = DateUtil.strToDate((String)s);
            return date;
        }
        String s = substring + " " + time;
        Date date = DateUtil.strToDate((String)s);
        return date;
    }

    public static HashMap<String, Date> getWeekStartAndEnd(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate startOfWeek = localDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate endOfWeek = localDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        HashMap<String, Date> hashMap = new HashMap<String, Date>();
        hashMap.put("startOfWeek", Date.from(startOfWeek.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        hashMap.put("endOfWeek", Date.from(endOfWeek.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        return hashMap;
    }
}

