/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.utils;

import com.bringspring.common.util.DateUtil;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(SendMessageUtil.class);
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private SysConfigService sysConfigService;
    private static SendMessageUtil sendMessageUtil;

    @PostConstruct
    public void init() {
        sendMessageUtil = this;
        SendMessageUtil.sendMessageUtil.sysConfigService = this.sysConfigService;
        SendMessageUtil.sendMessageUtil.sendTaskMsgUtils = this.sendTaskMsgUtils;
    }

    public static void newSendMessage(String tsakCode, String sendCode, String title, String content, String appUrl, String PCurl, List<String> toUserIds, String termType, String termTypeDesc) throws Exception {
        try {
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode(tsakCode);
            taskMsg.setSendCode(sendCode);
            String messageTime = DateUtil.dateFormat((Date)new Date());
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("title", title);
            parameterMap.put("content", content);
            parameterMap.put("MessageTime", messageTime);
            LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
            linkMsgKeys.setLinkUrl("");
            linkMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
            CustomKeysLink customKeysLink = new CustomKeysLink();
            customKeysLink.setTermType(termType);
            customKeysLink.setTermTypeDesc(termTypeDesc);
            customKeysLink.setPcUrl(PCurl);
            customKeysLink.setAppUrl(appUrl);
            taskMsg.setCustomKey(customKeysLink);
            taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
            SendMessageUtil.sendMessageUtil.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u6d88\u606f\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
    }
}

