/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.purchase.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.ErpMaterialVo;
import com.bringspring.contract.service.CrmErpMaterialService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.model.contractPurchasePlan.RkContractPurchasePlanExcelModel;
import com.bringspring.purchase.model.contractPurchasePlan.RkContractPurchasePlanImportVO;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanCrForm;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanInfoVO;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanListVO;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanPagination;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanPaginationExportModel;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanUpForm;
import com.bringspring.purchase.model.oaPurchasePlan.RkPurchasePlanExcelModel;
import com.bringspring.purchase.model.oaPurchasePlan.RkPurchasePlanImportVO;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u8ba1\u5212\u6267\u884c\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/OaPurchasePlan"})
public class OaPurchasePlanController {
    private static final Logger log = LoggerFactory.getLogger(OaPurchasePlanController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmErpMaterialService crmErpMaterialService;
    @Autowired
    private SaleNoContractService saleNoContractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaPurchasePlanPagination oaPurchasePlanPagination) throws IOException {
        List<OaPurchasePlanEntity> list = this.oaPurchasePlanService.getList(oaPurchasePlanPagination);
        for (OaPurchasePlanEntity oaPurchasePlanEntity : list) {
            oaPurchasePlanEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaPurchasePlanEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPurchasePlanListVO.class);
        for (OaPurchasePlanListVO vo : listVO) {
            BigDecimal purchaseCount;
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "companyName"));
            RkContractEntity contract = this.rkContractService.getInfo(vo.getContractId());
            if (ObjectUtil.isNotEmpty((Object)contract)) {
                RkAgentEntity agent;
                vo.setContractCode(contract.getContractCode());
                vo.setContractName(contract.getContractName());
                vo.setSaleName(this.baseDataUtil.userSelectValue(contract.getSalerId()));
                CrmCustomerEntity customer = this.crmCustomerService.getInfo(contract.getCustomerId());
                if (ObjectUtil.isNotEmpty((Object)customer)) {
                    vo.setCustomerName(customer.getName());
                }
                if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(contract.getAgentId())))) {
                    vo.setAgentName(agent.getName());
                }
            } else if (ObjectUtil.isNotEmpty((Object)vo.getNoContractId())) {
                RkAgentEntity agent;
                SaleNoContractEntity saleNoContractEntity = this.saleNoContractService.getInfo(vo.getNoContractId());
                vo.setContractCode(saleNoContractEntity.getContractCode());
                vo.setContractName(saleNoContractEntity.getContractName());
                vo.setSaleName(this.baseDataUtil.userSelectValue(saleNoContractEntity.getSalerId()));
                CrmCustomerEntity customer = this.crmCustomerService.getInfo(saleNoContractEntity.getCustomerId());
                if (ObjectUtil.isNotEmpty((Object)customer)) {
                    vo.setCustomerName(customer.getName());
                }
                if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(saleNoContractEntity.getAgentId())))) {
                    vo.setAgentName(agent.getName());
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) && StrUtil.isNotEmpty((CharSequence)vo.getActualCount())) {
                purchaseCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) ? vo.getPurchaseCount() : "0");
                BigDecimal acturalCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getActualCount()) ? vo.getActualCount() : "0");
                if (acturalCount.compareTo(BigDecimal.ZERO) > 0) {
                    if (purchaseCount.compareTo(acturalCount) <= 0) {
                        vo.setExecutionStatus("purchaseOver");
                    } else {
                        vo.setExecutionStatus("purchaseing");
                    }
                } else {
                    vo.setExecutionStatus("unpurchase");
                }
            }
            if (!StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount())) continue;
            purchaseCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) ? vo.getPurchaseCount() : "0");
            BigDecimal appliedCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getAppliedCount()) ? vo.getAppliedCount() : "0");
            vo.setRemainingCount(purchaseCount.subtract(appliedCount).toString());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPurchasePlanPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/purchaseApplyList"})
    public ActionResult purchaseApplyList(@RequestBody OaPurchasePlanPagination oaPurchasePlanPagination) throws IOException {
        List<OaPurchasePlanEntity> list = this.oaPurchasePlanService.getList(oaPurchasePlanPagination);
        for (OaPurchasePlanEntity oaPurchasePlanEntity : list) {
            oaPurchasePlanEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaPurchasePlanEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPurchasePlanListVO.class);
        for (OaPurchasePlanListVO vo : listVO) {
            ErpMaterialVo codeInfo;
            RkContractEntity contract = this.rkContractService.getInfo(vo.getContractId());
            if (ObjectUtil.isNotEmpty((Object)contract)) {
                RkAgentEntity agent;
                vo.setContractCode(contract.getContractCode());
                vo.setContractName(contract.getContractName());
                vo.setSaleName(this.baseDataUtil.userSelectValue(contract.getSalerId()));
                CrmCustomerEntity customer = this.crmCustomerService.getInfo(contract.getCustomerId());
                if (ObjectUtil.isNotEmpty((Object)customer)) {
                    vo.setCustomerName(customer.getName());
                }
                if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(contract.getAgentId())))) {
                    vo.setAgentName(agent.getName());
                }
            }
            if (!ObjectUtil.isNotEmpty((Object)(codeInfo = this.crmErpMaterialService.getInfoByCode(vo.getMaterialCode())))) continue;
            vo.setErpMaterialId(codeInfo.getId());
            vo.setMaterialCategory(codeInfo.getMaterialTypeId());
            vo.setMaterialProperty(codeInfo.getProperties());
            vo.setMaterialType(codeInfo.getMaterialTypeName());
            vo.setPurchaseUnit(codeInfo.getMatUnit());
            vo.setMaterialProperties(this.baseDataUtil.getDictName(codeInfo.getProperties(), "materialProperties"));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPurchasePlanPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getDetailList"})
    public ActionResult getDetailList(@RequestBody OaPurchasePlanPagination oaPurchasePlanPagination) throws IOException {
        ArrayList<OaPurchasePlanEntity> listVO = new ArrayList<OaPurchasePlanEntity>();
        if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getNoContractId())) {
            List<OaPurchasePlanEntity> detailList = this.oaPurchasePlanService.getByNoContractId(oaPurchasePlanPagination.getNoContractId());
            listVO.addAll(detailList);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPurchasePlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OaPurchasePlanCrForm oaPurchasePlanCrForm) throws DataException {
        this.oaPurchasePlanService.create(oaPurchasePlanCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaPurchasePlanPaginationExportModel oaPurchasePlanPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaPurchasePlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaPurchasePlanPagination oaPurchasePlanPagination = (OaPurchasePlanPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaPurchasePlanPaginationExportModel), OaPurchasePlanPagination.class));
        List<OaPurchasePlanEntity> list = this.oaPurchasePlanService.getTypeList(oaPurchasePlanPagination, oaPurchasePlanPaginationExportModel.getDataType());
        for (OaPurchasePlanEntity oaPurchasePlanEntity : list) {
            oaPurchasePlanEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaPurchasePlanEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPurchasePlanListVO.class);
        for (OaPurchasePlanListVO vo : listVO) {
            RkAgentEntity agent;
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getContractId(), "companyName"));
            RkContractEntity contract = this.rkContractService.getInfo(vo.getContractId());
            if (!ObjectUtil.isNotEmpty((Object)contract)) continue;
            vo.setContractCode(contract.getContractCode());
            vo.setContractName(contract.getContractName());
            vo.setSaleName(this.baseDataUtil.userSelectValue(contract.getSalerId()));
            CrmCustomerEntity customer = this.crmCustomerService.getInfo(contract.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                vo.setCustomerName(customer.getName());
            }
            if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(contract.getAgentId())))) {
                vo.setAgentName(agent.getName());
            }
            vo.setIsPlan(this.baseDataUtil.getDictName(vo.getIsPlan(), "purchasePlanType"));
            vo.setExecutionStatus(this.baseDataUtil.getDictName(vo.getExecutionStatus(), "executionStatus"));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaPurchasePlanPaginationExportModel.getSelectKey()) ? oaPurchasePlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block46: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block46;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block46;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block46;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerName"));
                        continue block46;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u7ea6\u5ba2\u6237", (Object)"agentName"));
                        continue block46;
                    }
                    case "saleName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e", (Object)"saleName"));
                        continue block46;
                    }
                    case "purchaseName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u540d\u79f0", (Object)"purchaseName"));
                        continue block46;
                    }
                    case "purchaseModel": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u578b\u53f7", (Object)"purchaseModel"));
                        continue block46;
                    }
                    case "purchaseUnit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"purchaseUnit"));
                        continue block46;
                    }
                    case "purchaseCount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u6570\u91cf", (Object)"purchaseCount"));
                        continue block46;
                    }
                    case "purchasePrice": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5355\u4ef7(\u5143)", (Object)"purchasePrice"));
                        continue block46;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u6863\u6848\u7f16\u7801", (Object)"materialCode"));
                        continue block46;
                    }
                    case "materialProperties": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5c5e\u6027", (Object)"materialProperties"));
                        continue block46;
                    }
                    case "materialType": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5206\u7c7b", (Object)"materialType"));
                        continue block46;
                    }
                    case "materialBrand": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u54c1\u724c", (Object)"materialBrand"));
                        continue block46;
                    }
                    case "isPlan": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u7c7b\u578b", (Object)"isPlan"));
                        continue block46;
                    }
                    case "executionStatus": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u72b6\u6001", (Object)"executionStatus"));
                        continue block46;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaPurchasePlanInfoVO> info(@PathVariable(value="id") String id) {
        OaPurchasePlanEntity entity = this.oaPurchasePlanService.getInfo(id);
        OaPurchasePlanInfoVO vo = (OaPurchasePlanInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPurchasePlanInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaPurchasePlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleNoContractEntity saleNoContractEntity;
        OaPurchasePlanEntity entity = this.oaPurchasePlanService.getInfo(id);
        OaPurchasePlanInfoVO vo = (OaPurchasePlanInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPurchasePlanInfoVO.class);
        RkContractEntity contract = this.rkContractService.getInfo(vo.getContractId());
        if (ObjectUtil.isNotEmpty((Object)contract)) {
            RkAgentEntity agent;
            vo.setContractCode(contract.getContractCode());
            vo.setContractName(contract.getContractName());
            vo.setSaleName(this.baseDataUtil.userSelectValue(contract.getSalerId()));
            CrmCustomerEntity customer = this.crmCustomerService.getInfo(contract.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                vo.setCustomerName(customer.getName());
            }
            if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(contract.getAgentId())))) {
                vo.setAgentName(agent.getName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) && StrUtil.isNotEmpty((CharSequence)vo.getActualCount())) {
                long purchaseCount = Long.parseLong(vo.getPurchaseCount());
                long acturalCount = Long.parseLong(vo.getActualCount());
                if (acturalCount > 0L) {
                    if (purchaseCount <= acturalCount) {
                        vo.setExecutionStatus("purchaseOver");
                    } else {
                        vo.setExecutionStatus("purchaseing");
                    }
                } else {
                    vo.setExecutionStatus("unpurchase");
                }
            }
        } else if (ObjectUtil.isNotEmpty((Object)vo.getNoContractId()) && ObjectUtil.isNotEmpty((Object)(saleNoContractEntity = this.saleNoContractService.getInfo(vo.getNoContractId())))) {
            RkAgentEntity agent;
            vo.setContractCode(saleNoContractEntity.getContractCode());
            vo.setContractName(saleNoContractEntity.getContractName());
            vo.setSaleName(this.baseDataUtil.userSelectValue(saleNoContractEntity.getSalerId()));
            CrmCustomerEntity customer = this.crmCustomerService.getInfo(saleNoContractEntity.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                vo.setCustomerName(customer.getName());
            }
            if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(saleNoContractEntity.getAgentId())))) {
                vo.setAgentName(agent.getName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) && StrUtil.isNotEmpty((CharSequence)vo.getActualCount())) {
                long purchaseCount = Long.parseLong(vo.getPurchaseCount());
                long acturalCount = Long.parseLong(vo.getActualCount());
                if (acturalCount > 0L) {
                    if (purchaseCount <= acturalCount) {
                        vo.setExecutionStatus("purchaseOver");
                    } else {
                        vo.setExecutionStatus("purchaseing");
                    }
                } else {
                    vo.setExecutionStatus("unpurchase");
                }
            }
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaPurchasePlanUpForm oaPurchasePlanUpForm) throws DataException {
        this.oaPurchasePlanService.update(id, oaPurchasePlanUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaPurchasePlanEntity entity = this.oaPurchasePlanService.getInfo(id);
        if (entity != null) {
            this.oaPurchasePlanService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List pList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, RkContractPurchasePlanExcelModel.class);
        Map<String, Object> map = this.oaContractPurchasePlanService.importPreview(pList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult ImportData(@RequestBody RkContractPurchasePlanExcelModel data) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        List dataList = JsonUtil.getJsonToList(data.getList(), RkContractPurchasePlanExcelModel.class);
        RkContractPurchasePlanImportVO result = this.oaContractPurchasePlanService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/ContractPurchasePlanTemplateDownload"})
    public ActionResult<DownloadVO> ContractPurchasePlanTemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u9500\u552e\u5408\u540c\u5bfc\u5165\u91c7\u8d2d\u8ba1\u5212.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u9500\u552e\u5408\u540c\u5bfc\u5165\u91c7\u8d2d\u8ba1\u5212.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody RkContractPurchasePlanExcelModel data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.oaContractPurchasePlanService.exportExceptionData(dataList, new RkContractPurchasePlanExcelModel());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreviewHistory"})
    public ActionResult ImportPreviewHistory(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List pList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, RkPurchasePlanExcelModel.class);
        Map<String, Object> map = this.oaPurchasePlanService.importPreview(pList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportDataHistory"})
    public ActionResult ImportDataHistory(@RequestBody RkPurchasePlanExcelModel data) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        List dataList = JsonUtil.getJsonToList(data.getList(), RkPurchasePlanExcelModel.class);
        RkPurchasePlanImportVO result = this.oaPurchasePlanService.importDataHistory(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/ContractPurchasePlanTemplateDownloadHistory"})
    public ActionResult<DownloadVO> ContractPurchasePlanTemplateDownloadHistory() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5bfc\u5165\u5386\u53f2\u91c7\u8d2d\u8ba1\u5212.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5bfc\u5165\u5386\u53f2\u91c7\u8d2d\u8ba1\u5212.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionDataHistory"})
    public ActionResult<DownloadVO> exportExceptionDataHistory(@RequestBody RkPurchasePlanExcelModel data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.oaPurchasePlanService.exportExceptionData(dataList, new RkPurchasePlanExcelModel());
        return ActionResult.success((Object)vo);
    }
}

