/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.purchase.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.model.ErpMaterialVo;
import com.bringspring.contract.service.CrmErpMaterialService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.mapper.OaContractPurchasePlanMapper;
import com.bringspring.purchase.model.contractPurchasePlan.RkContractPurchasePlanExcelModel;
import com.bringspring.purchase.model.contractPurchasePlan.RkContractPurchasePlanImportVO;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.service.UserService;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.NumberUtils;

@Service
public class OaContractPurchasePlanServiceImpl
extends ServiceImpl<OaContractPurchasePlanMapper, OaContractPurchasePlanEntity>
implements OaContractPurchasePlanService {
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmErpMaterialService crmErpMaterialService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;

    @Override
    public List<OaContractPurchasePlanEntity> getPlanListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPurchasePlanEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaContractPurchasePlanEntity> getPlanListByNoContractId(String noContractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPurchasePlanEntity::getNoContractId, (Object)noContractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPurchasePlanEntity::getContractId, (Object)contractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByNoContractId(String noContractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPurchasePlanEntity::getNoContractId, (Object)noContractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, RkContractPurchasePlanExcelModel rkPurchaseApplyExcelModel) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)rkPurchaseApplyExcelModel, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public RkContractPurchasePlanImportVO importData(List<RkContractPurchasePlanExcelModel> dt) {
        List<ErpMaterialVo> codeList = this.crmErpMaterialService.getCodeAndIdList();
        int sum = 0;
        int num = 0;
        List errorList = CollectionUtil.list((boolean)false);
        List successResult = CollectionUtil.list((boolean)false);
        List errorMsgList = CollectionUtil.list((boolean)false);
        String msg = "";
        for (RkContractPurchasePlanExcelModel model : dt) {
            if (ObjectUtil.isEmpty((Object)model.getPurchaseName())) {
                ++num;
                model.setErrMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPurchaseModel())) {
                ++num;
                model.setErrMsg("\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPurchaseCount())) {
                ++num;
                model.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)model.getPurchaseCount())) {
                ++num;
                model.setErrMsg("\u6570\u91cf\u8bf7\u586b\u5199\u6570\u5b57");
                errorMsgList.add(model.getErrMsg());
            } else if ((Double)NumberUtils.parseNumber((String)model.getPurchaseCount(), Double.class) < 0.0) {
                ++num;
                model.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPurchasePrice())) {
                ++num;
                model.setErrMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)model.getPurchasePrice())) {
                ++num;
                model.setErrMsg("\u5355\u4ef7\u8bf7\u586b\u5199\u6570\u5b57");
                errorMsgList.add(model.getErrMsg());
            } else if ((Double)NumberUtils.parseNumber((String)model.getPurchasePrice(), Double.class) < 0.0) {
                ++num;
                model.setErrMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                errorMsgList.add(model.getErrMsg());
            }
            String code = StringUtils.trim((String)model.getMaterialCode());
            if (!ObjectUtil.isEmpty((Object)code)) {
                List matchCode = codeList.stream().filter(a -> a.getCode().equals(code)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(matchCode)) {
                    model.setErpMaterialId(((ErpMaterialVo)matchCode.get(0)).getId());
                    model.setMaterialProperties(((ErpMaterialVo)matchCode.get(0)).getPropertiesName());
                    model.setMaterialType(((ErpMaterialVo)matchCode.get(0)).getMaterialTypeName());
                    model.setMaterialBrand(((ErpMaterialVo)matchCode.get(0)).getBrand());
                    model.setPurchaseUnit(((ErpMaterialVo)matchCode.get(0)).getMatUnit());
                    model.setPurchaseName(((ErpMaterialVo)matchCode.get(0)).getFullName());
                    model.setPurchaseModel(((ErpMaterialVo)matchCode.get(0)).getModel());
                } else {
                    ++num;
                    model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                model.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                model.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(model);
                continue;
            }
            successResult.add(model);
            ++sum;
        }
        RkContractPurchasePlanImportVO vo = new RkContractPurchasePlanImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(errorList);
            return vo;
        }
        vo.setResultType(0);
        vo.setSuccessResult(successResult);
        return vo;
    }

    @Override
    public Map<String, Object> importPreview(List<RkContractPurchasePlanExcelModel> pList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (pList != null) {
            int i;
            String msg = "";
            for (i = 0; i < pList.size(); ++i) {
                HashMap<String, String> dataRowMap = new HashMap<String, String>();
                RkContractPurchasePlanExcelModel model = pList.get(i);
                dataRowMap.put("materialCode", model.getMaterialCode());
                dataRowMap.put("purchaseName", model.getPurchaseName());
                dataRowMap.put("purchaseModel", model.getPurchaseModel());
                dataRowMap.put("purchaseUnit", model.getPurchaseUnit());
                dataRowMap.put("purchaseCount", model.getPurchaseCount());
                dataRowMap.put("purchasePrice", model.getPurchasePrice());
                dataRowMap.put("materialBrand", model.getMaterialBrand());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 16; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", pList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u540d\u79f0");
        map.put(2, "\u578b\u53f7");
        map.put(3, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(4, "\u6570\u91cf");
        map.put(5, "\u5355\u4ef7(\u5143)");
        map.put(6, "\u54c1\u724c");
        map.put(7, "\u7269\u6599\u6863\u6848\u7f16\u7801");
        return (String)map.get(key);
    }

    @Override
    public void insertPlan(List<OaContractPurchasePlanEntity> list) {
        List planList = JsonUtil.getJsonToList(list, OaPurchasePlanEntity.class);
        planList.stream().forEach(a -> {
            if (StringUtils.isEmpty((String)a.getIsPlan())) {
                a.setIsPlan("planned");
            }
            if (StringUtils.isEmpty((String)a.getExecutionStatus())) {
                a.setExecutionStatus("unpurchase");
            }
            if (StringUtils.isEmpty((String)a.getActualCount())) {
                a.setActualCount("0");
            }
        });
        this.oaPurchasePlanService.saveOrUpdateBatch(planList);
    }
}

