/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.purchase.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.ErpMaterialVo;
import com.bringspring.contract.service.CrmErpMaterialService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.mapper.OaPurchasePlanMapper;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanCrForm;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanListVO;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanPagination;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanUpCountVO;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanUpForm;
import com.bringspring.purchase.model.oaPurchasePlan.RkPurchasePlanExcelModel;
import com.bringspring.purchase.model.oaPurchasePlan.RkPurchasePlanImportVO;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.NumberUtils;

@Service
public class OaPurchasePlanServiceImpl
extends ServiceImpl<OaPurchasePlanMapper, OaPurchasePlanEntity>
implements OaPurchasePlanService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmErpMaterialService crmErpMaterialService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;

    @Override
    public List<OaPurchasePlanEntity> getList(OaPurchasePlanPagination oaPurchasePlanPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaPurchasePlanNum = 0;
        QueryWrapper oaPurchasePlanQueryWrapper = new QueryWrapper();
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getMenuId()) && isPc && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaPurchasePlanQueryWrapper, oaPurchasePlanPagination.getMenuId(), "oa_purchase_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            oaPurchasePlanQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getCompanyId())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().like(OaPurchasePlanEntity::getCompanyId, (Object)oaPurchasePlanPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getContractCode()) || StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getContractName())) {
            ++oaPurchasePlanNum;
            List<RkContractEntity> contractList = this.getContract(oaPurchasePlanPagination, null);
            List<SaleNoContractEntity> noContractList = this.getNoContract(oaPurchasePlanPagination, null);
            boolean isBack = false;
            if (ObjectUtil.isNotEmpty(contractList)) {
                List ids = contractList.stream().map(RkContractEntity::getId).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(noContractList)) {
                    List nosaleIds = noContractList.stream().map(SaleNoContractEntity::getId).collect(Collectors.toList());
                    oaPurchasePlanQueryWrapper.lambda().and(a -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.in(OaPurchasePlanEntity::getContractId, (Collection)ids)).or()).in(OaPurchasePlanEntity::getNoContractId, (Collection)nosaleIds);
                    });
                } else {
                    oaPurchasePlanQueryWrapper.lambda().and(a -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.in(OaPurchasePlanEntity::getContractId, (Collection)ids);
                    });
                }
                isBack = true;
            } else if (ObjectUtil.isNotEmpty(noContractList)) {
                List nosaleIds = noContractList.stream().map(SaleNoContractEntity::getId).collect(Collectors.toList());
                oaPurchasePlanQueryWrapper.lambda().and(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.in(OaPurchasePlanEntity::getNoContractId, (Collection)nosaleIds);
                });
                isBack = true;
            }
            if (!isBack) {
                return new ArrayList<OaPurchasePlanEntity>();
            }
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getCustomerId())) {
            ++oaPurchasePlanNum;
            QueryWrapper customerEntityQueryWrapper = new QueryWrapper();
            customerEntityQueryWrapper.lambda().like(CrmCustomerEntity::getName, (Object)oaPurchasePlanPagination.getCustomerId());
            List customerEntities = this.crmCustomerService.list((Wrapper)customerEntityQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)customerEntities)) {
                List customerIds = customerEntities.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
                oaPurchasePlanQueryWrapper.lambda().in(OaPurchasePlanEntity::getCustomerId, customerIds);
            }
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getPurchaseName())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.like(OaPurchasePlanEntity::getPurchaseName, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getPurchaseModel, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getPurchaseUnit, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialProperties, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialType, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialBrand, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialCode, (Object)oaPurchasePlanPagination.getMaterialCode());
            });
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getIsPlan())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getIsPlan, (Object)oaPurchasePlanPagination.getIsPlan());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getContractId())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getContractId, (Object)oaPurchasePlanPagination.getContractId());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getExecutionStatus())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getExecutionStatus, (Object)oaPurchasePlanPagination.getExecutionStatus());
        }
        if (StringUtils.isNotEmpty(oaPurchasePlanPagination.getExecutionStatusList())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().in(OaPurchasePlanEntity::getExecutionStatus, oaPurchasePlanPagination.getExecutionStatusList());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getSearchType()) && StrUtil.equals((CharSequence)"unapply", (CharSequence)oaPurchasePlanPagination.getSearchType())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().apply("ifnull(purchase_count,0) - ifnull(applied_count,0) > {0}", new Object[]{0});
        }
        if (AllIdList.size() > 0) {
            oaPurchasePlanQueryWrapper.lambda().in(OaPurchasePlanEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaPurchasePlanPagination.getSidx())) {
            oaPurchasePlanQueryWrapper.lambda().orderByDesc(OaPurchasePlanEntity::getId);
        } else {
            try {
                String sidx = oaPurchasePlanPagination.getSidx();
                OaPurchasePlanEntity oaPurchasePlanEntity = new OaPurchasePlanEntity();
                Field declaredField = oaPurchasePlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaPurchasePlanQueryWrapper = "asc".equals(oaPurchasePlanPagination.getSort().toLowerCase()) ? (QueryWrapper)oaPurchasePlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaPurchasePlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaPurchasePlanPagination.getCurrentPage(), oaPurchasePlanPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaPurchasePlanQueryWrapper);
            return oaPurchasePlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaPurchasePlanPagination.setData(list, list.size());
    }

    @Override
    public List<OaPurchasePlanEntity> getTypeList(OaPurchasePlanPagination oaPurchasePlanPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaPurchasePlanNum = 0;
        QueryWrapper oaPurchasePlanQueryWrapper = new QueryWrapper();
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaPurchasePlanQueryWrapper, oaPurchasePlanPagination.getMenuId(), "oa_purchase_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return new ArrayList<OaPurchasePlanEntity>();
            }
            oaPurchasePlanQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getCompanyId())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().like(OaPurchasePlanEntity::getCompanyId, (Object)oaPurchasePlanPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getContractId())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getContractId, (Object)oaPurchasePlanPagination.getContractId());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getPurchaseName())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.like(OaPurchasePlanEntity::getPurchaseName, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getPurchaseModel, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getPurchaseUnit, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialProperties, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialType, (Object)oaPurchasePlanPagination.getPurchaseName())).or()).like(OaPurchasePlanEntity::getMaterialBrand, (Object)oaPurchasePlanPagination.getPurchaseName());
            });
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getIsPlan())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getIsPlan, (Object)oaPurchasePlanPagination.getIsPlan());
        }
        if (StringUtils.isNotEmpty((String)oaPurchasePlanPagination.getExecutionStatus())) {
            ++oaPurchasePlanNum;
            oaPurchasePlanQueryWrapper.lambda().eq(OaPurchasePlanEntity::getExecutionStatus, (Object)oaPurchasePlanPagination.getExecutionStatus());
        }
        if (AllIdList.size() > 0) {
            oaPurchasePlanQueryWrapper.lambda().in(OaPurchasePlanEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaPurchasePlanPagination.getSidx())) {
            oaPurchasePlanQueryWrapper.lambda().orderByDesc(OaPurchasePlanEntity::getId);
        } else {
            try {
                String sidx = oaPurchasePlanPagination.getSidx();
                OaPurchasePlanEntity oaPurchasePlanEntity = new OaPurchasePlanEntity();
                Field declaredField = oaPurchasePlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaPurchasePlanQueryWrapper = "asc".equals(oaPurchasePlanPagination.getSort().toLowerCase()) ? (QueryWrapper)oaPurchasePlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaPurchasePlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaPurchasePlanPagination.getCurrentPage(), oaPurchasePlanPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaPurchasePlanQueryWrapper);
                return oaPurchasePlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaPurchasePlanPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaPurchasePlanQueryWrapper);
    }

    @Override
    public OaPurchasePlanEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaPurchasePlanEntity::getId, (Object)id);
        return (OaPurchasePlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OaPurchasePlanCrForm oaPurchasePlanCrForm) {
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        oaPurchasePlanCrForm.setCreatorUserId(userInfo.getUserId());
        oaPurchasePlanCrForm.setCreatorTime(DateUtil.getNow());
        OaPurchasePlanEntity entity = (OaPurchasePlanEntity)JsonUtil.getJsonToBean((Object)oaPurchasePlanCrForm, OaPurchasePlanEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, OaPurchasePlanUpForm oaPurchasePlanUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OaPurchasePlanEntity entity = this.getInfo(id);
        if (entity != null) {
            OaPurchasePlanEntity subentity = (OaPurchasePlanEntity)JsonUtil.getJsonToBean((Object)oaPurchasePlanUpForm, OaPurchasePlanEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(OaPurchasePlanEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    private List<SaleNoContractEntity> getNoContract(OaPurchasePlanPagination oaPurchasePlanPagination, List<String> customerIds) {
        QueryWrapper contractEntityQueryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractCode()) || StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractName())) {
            if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractCode())) {
                contractEntityQueryWrapper.lambda().like(SaleNoContractEntity::getContractCode, (Object)oaPurchasePlanPagination.getContractCode());
            }
            if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractName())) {
                contractEntityQueryWrapper.lambda().like(SaleNoContractEntity::getContractName, (Object)oaPurchasePlanPagination.getContractName());
            }
            return this.saleNoContractService.list((Wrapper)contractEntityQueryWrapper);
        }
        if (ObjectUtil.isNotEmpty(customerIds)) {
            contractEntityQueryWrapper.lambda().in(SaleNoContractEntity::getCustomerId, customerIds);
            List o = this.list((Wrapper)new QueryWrapper());
            List contractIds = o.stream().map(OaPurchasePlanEntity::getContractId).distinct().collect(Collectors.toList());
            contractEntityQueryWrapper.lambda().in(SaleNoContractEntity::getId, contractIds);
            return this.saleNoContractService.list((Wrapper)contractEntityQueryWrapper);
        }
        return CollectionUtil.list((boolean)false);
    }

    private List<RkContractEntity> getContract(OaPurchasePlanPagination oaPurchasePlanPagination, List<String> customerIds) {
        QueryWrapper contractEntityQueryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractCode()) || StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractName())) {
            if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractCode())) {
                contractEntityQueryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)oaPurchasePlanPagination.getContractCode());
            }
            if (StrUtil.isNotEmpty((CharSequence)oaPurchasePlanPagination.getContractName())) {
                contractEntityQueryWrapper.lambda().like(RkContractEntity::getContractName, (Object)oaPurchasePlanPagination.getContractName());
            }
            return this.rkContractService.list((Wrapper)contractEntityQueryWrapper);
        }
        if (ObjectUtil.isNotEmpty(customerIds)) {
            contractEntityQueryWrapper.lambda().in(RkContractEntity::getCustomerId, customerIds);
            List o = this.list((Wrapper)new QueryWrapper());
            List contractIds = o.stream().map(OaPurchasePlanEntity::getContractId).distinct().collect(Collectors.toList());
            contractEntityQueryWrapper.lambda().in(RkContractEntity::getId, contractIds);
            return this.rkContractService.list((Wrapper)contractEntityQueryWrapper);
        }
        return CollectionUtil.list((boolean)false);
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u540d\u79f0");
        map.put(2, "\u578b\u53f7");
        map.put(3, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(4, "\u6570\u91cf");
        map.put(5, "\u5355\u4ef7(\u5143)");
        map.put(6, "\u54c1\u724c");
        map.put(7, "\u7269\u6599\u6863\u6848\u7f16\u7801");
        map.put(8, "\u5408\u540c\u7f16\u53f7");
        map.put(9, "\u5df2\u91c7\u8d2d\u6570\u91cf");
        map.put(10, "\u8ba1\u5212\u7c7b\u578b");
        return (String)map.get(key);
    }

    @Override
    public Map<String, Object> importPreview(List<RkPurchasePlanExcelModel> pList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (pList != null) {
            int i;
            String msg = "";
            for (i = 0; i < pList.size(); ++i) {
                HashMap<String, String> dataRowMap = new HashMap<String, String>();
                RkPurchasePlanExcelModel model = pList.get(i);
                dataRowMap.put("materialCode", model.getMaterialCode());
                dataRowMap.put("purchaseName", model.getPurchaseName());
                dataRowMap.put("purchaseModel", model.getPurchaseModel());
                dataRowMap.put("purchaseUnit", model.getPurchaseUnit());
                dataRowMap.put("purchaseCount", model.getPurchaseCount());
                dataRowMap.put("purchasePrice", model.getPurchasePrice());
                dataRowMap.put("materialBrand", model.getMaterialBrand());
                dataRowMap.put("contractCode", model.getContractCode());
                dataRowMap.put("actualCount", model.getActualCount());
                dataRowMap.put("isPlan", model.getIsPlan());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 16; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", pList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public RkPurchasePlanImportVO importData(List<RkPurchasePlanExcelModel> dataList) {
        List<ErpMaterialVo> codeList = this.crmErpMaterialService.getCodeAndIdList();
        int sum = 0;
        int num = 0;
        List errorList = CollectionUtil.list((boolean)false);
        List successResult = CollectionUtil.list((boolean)false);
        List errorMsgList = CollectionUtil.list((boolean)false);
        String msg = "";
        for (RkPurchasePlanExcelModel model : dataList) {
            String code = StringUtils.trim((String)model.getMaterialCode());
            if (!ObjectUtil.isEmpty((Object)code)) {
                List matchCode = codeList.stream().filter(a -> a.getCode().equals(code)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(matchCode)) {
                    model.setErpMaterialId(((ErpMaterialVo)matchCode.get(0)).getId());
                    model.setMaterialProperties(((ErpMaterialVo)matchCode.get(0)).getPropertiesName());
                    model.setMaterialType(((ErpMaterialVo)matchCode.get(0)).getMaterialTypeName());
                    model.setMaterialBrand(((ErpMaterialVo)matchCode.get(0)).getBrand());
                    model.setPurchaseUnit(((ErpMaterialVo)matchCode.get(0)).getMatUnit());
                    model.setPurchaseName(((ErpMaterialVo)matchCode.get(0)).getFullName());
                    model.setPurchaseModel(((ErpMaterialVo)matchCode.get(0)).getModel());
                } else {
                    ++num;
                    model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                model.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                model.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(model);
                continue;
            }
            successResult.add(model);
            ++sum;
        }
        RkPurchasePlanImportVO vo = new RkPurchasePlanImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(errorList);
            return vo;
        }
        vo.setResultType(0);
        vo.setSuccessResult(successResult);
        return vo;
    }

    @Override
    public RkPurchasePlanImportVO importDataHistory(List<RkPurchasePlanExcelModel> dataList) {
        UserInfo userInfo = this.userProvider.get();
        List<ErpMaterialVo> codeList = this.crmErpMaterialService.getCodeAndIdList();
        List dictionaryDataEntities = this.dictionaryDataService.getDicList("692015224416511749");
        int sum = 0;
        int num = 0;
        List errorList = CollectionUtil.list((boolean)false);
        List successResult = CollectionUtil.list((boolean)false);
        List errorMsgList = CollectionUtil.list((boolean)false);
        String msg = "";
        for (RkPurchasePlanExcelModel model : dataList) {
            String code = StringUtils.trim((String)model.getMaterialCode());
            if (!ObjectUtil.isEmpty((Object)code)) {
                List matchCode = codeList.stream().filter(a -> a.getCode().equals(code)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(matchCode)) {
                    model.setErpMaterialId(((ErpMaterialVo)matchCode.get(0)).getId());
                    model.setMaterialProperties(((ErpMaterialVo)matchCode.get(0)).getPropertiesName());
                    model.setMaterialType(((ErpMaterialVo)matchCode.get(0)).getMaterialTypeName());
                    model.setMaterialBrand(((ErpMaterialVo)matchCode.get(0)).getBrand());
                    model.setPurchaseUnit(((ErpMaterialVo)matchCode.get(0)).getMatUnit());
                    model.setPurchaseName(((ErpMaterialVo)matchCode.get(0)).getFullName());
                    model.setPurchaseModel(((ErpMaterialVo)matchCode.get(0)).getModel());
                } else {
                    model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (StrUtil.isEmpty((CharSequence)model.getPurchaseName())) {
                model.setErrMsg("\u91c7\u8d2d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(model.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)model.getPurchaseModel())) {
                model.setErrMsg("\u7269\u6599\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(model.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)model.getPurchaseUnit())) {
                model.setErrMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPurchaseCount())) {
                model.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)model.getPurchaseCount())) {
                model.setErrMsg("\u6570\u91cf\u8bf7\u586b\u5199\u6570\u5b57");
                errorMsgList.add(model.getErrMsg());
            } else if ((Double)NumberUtils.parseNumber((String)model.getPurchaseCount(), Double.class) < 0.0) {
                model.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getActualCount())) {
                model.setActualCount("0");
            } else if (!NumberUtil.isNumber((CharSequence)model.getActualCount())) {
                model.setErrMsg("\u5df2\u91c7\u8d2d\u6570\u91cf\u8bf7\u586b\u5199\u6570\u5b57");
                errorMsgList.add(model.getErrMsg());
            } else if ((Double)NumberUtils.parseNumber((String)model.getActualCount(), Double.class) < 0.0) {
                model.setErrMsg("\u5df2\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPurchasePrice())) {
                model.setErrMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)model.getPurchasePrice())) {
                model.setErrMsg("\u5355\u4ef7\u8bf7\u586b\u5199\u6570\u5b57");
                errorMsgList.add(model.getErrMsg());
            } else if ((Double)NumberUtils.parseNumber((String)model.getPurchasePrice(), Double.class) < 0.0) {
                model.setErrMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                errorMsgList.add(model.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)model.getIsPlan())) {
                model.setErrMsg("\u8ba1\u5212\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(model.getErrMsg());
            } else {
                List matchList = dictionaryDataEntities.stream().filter(a -> a.getFullName().equals(model.getIsPlan())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(matchList)) {
                    model.setIsPlan(((DictionaryDataEntity)matchList.get(0)).getEnCode());
                } else {
                    model.setErrMsg("\u672a\u5339\u914d\u5230\u8ba1\u5212\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (StrUtil.isEmpty((CharSequence)model.getContractCode())) {
                model.setErrMsg("\u5408\u540c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(model.getErrMsg());
            } else {
                List<RkContractEntity> rkContractEntities = this.rkContractService.getListByCode(model.getContractCode(), userInfo.getOrganizeId());
                if (CollectionUtil.isNotEmpty(rkContractEntities)) {
                    RkContractEntity contract = rkContractEntities.get(0);
                    model.setContractId(contract.getId());
                } else {
                    model.setErrMsg("\u672a\u5339\u914d\u5230\u5408\u540c\u7f16\u53f7\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                ++num;
                model.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                model.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(model);
                continue;
            }
            successResult.add(model);
            ++sum;
        }
        if (num == 0) {
            for (RkPurchasePlanExcelModel model : dataList) {
                OaPurchasePlanEntity oaPurchasePlanEntity = (OaPurchasePlanEntity)JsonUtil.getJsonToBean((Object)model, OaPurchasePlanEntity.class);
                BigDecimal purchaseCount = new BigDecimal(oaPurchasePlanEntity.getPurchaseCount());
                BigDecimal acturalCount = new BigDecimal(oaPurchasePlanEntity.getActualCount());
                if (acturalCount.compareTo(BigDecimal.ZERO) > 0) {
                    if (purchaseCount.compareTo(acturalCount) <= 0) {
                        oaPurchasePlanEntity.setExecutionStatus("purchaseOver");
                    } else {
                        oaPurchasePlanEntity.setExecutionStatus("purchaseing");
                    }
                } else {
                    oaPurchasePlanEntity.setExecutionStatus("unpurchase");
                }
                oaPurchasePlanEntity.setAppliedCount(acturalCount.toString());
                oaPurchasePlanEntity.setCreatorUserId(userInfo.getUserId());
                oaPurchasePlanEntity.setCreatorTime(new Date());
                oaPurchasePlanEntity.setCompanyId(userInfo.getOrganizeId());
                this.save(oaPurchasePlanEntity);
            }
        }
        RkPurchasePlanImportVO vo = new RkPurchasePlanImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(errorList);
            return vo;
        }
        vo.setResultType(0);
        vo.setSuccessResult(successResult);
        return vo;
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, RkPurchasePlanExcelModel rkPurchasePlanExcelModel) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)rkPurchasePlanExcelModel, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public List<OaPurchasePlanEntity> getListByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OaPurchasePlanEntity::getId, ids);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaPurchasePlanEntity> getByNoContractId(String noContractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OaPurchasePlanEntity::getNoContractId, new Object[]{noContractId});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaPurchasePlanListVO> getByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaPurchasePlanEntity::getContractId, (Object)contractId);
        queryWrapper.lambda().apply("ifnull(purchase_count,0) - ifnull(applied_count,0) > {0}", new Object[]{0});
        queryWrapper.lambda().ne(OaPurchasePlanEntity::getExecutionStatus, (Object)"purchaseOver");
        List list = this.list((Wrapper)queryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)list, OaPurchasePlanListVO.class);
        for (OaPurchasePlanListVO vo : listVO) {
            BigDecimal purchaseCount;
            RkAgentEntity agent;
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "companyName"));
            RkContractEntity contract = this.rkContractService.getInfo(vo.getContractId());
            if (!ObjectUtil.isNotEmpty((Object)contract)) continue;
            vo.setContractCode(contract.getContractCode());
            vo.setContractName(contract.getContractName());
            vo.setSaleName(this.baseDataUtil.userSelectValue(contract.getSalerId()));
            CrmCustomerEntity customer = this.crmCustomerService.getInfo(contract.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                vo.setCustomerName(customer.getName());
            }
            if (ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(contract.getAgentId())))) {
                vo.setAgentName(agent.getName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) && StrUtil.isNotEmpty((CharSequence)vo.getActualCount())) {
                purchaseCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) ? vo.getPurchaseCount() : "0");
                BigDecimal acturalCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getActualCount()) ? vo.getActualCount() : "0");
                if (acturalCount.compareTo(BigDecimal.ZERO) > 0) {
                    if (purchaseCount.compareTo(acturalCount) <= 0) {
                        vo.setExecutionStatus("purchaseOver");
                    } else {
                        vo.setExecutionStatus("purchaseing");
                    }
                } else {
                    vo.setExecutionStatus("unpurchase");
                }
            }
            if (!StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount())) continue;
            purchaseCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getPurchaseCount()) ? vo.getPurchaseCount() : "0");
            BigDecimal appliedCount = new BigDecimal(StrUtil.isNotEmpty((CharSequence)vo.getAppliedCount()) ? vo.getAppliedCount() : "0");
            vo.setRemainingCount(purchaseCount.subtract(appliedCount).toString());
        }
        return listVO;
    }

    @Override
    public void updateAppliedCount(List<OaPurchasePlanUpCountVO> planList, String type) {
        if (CollectionUtil.isNotEmpty(planList)) {
            for (OaPurchasePlanUpCountVO v : planList) {
                OaContractPurchasePlanEntity c;
                OaPurchasePlanEntity e = this.getInfo(v.getPlanId());
                if (ObjectUtil.isNotEmpty((Object)e)) {
                    BigDecimal appliedCount = new BigDecimal(StringUtils.isEmpty((String)e.getAppliedCount()) ? "0" : e.getAppliedCount());
                    BigDecimal thisApplyCount = new BigDecimal(ObjectUtil.isEmpty((Object)v.getAmount()) ? "0" : v.getAmount());
                    BigDecimal resCount = BigDecimal.ZERO;
                    resCount = StringUtils.equals((CharSequence)type, (CharSequence)"add") ? appliedCount.add(thisApplyCount) : appliedCount.subtract(thisApplyCount);
                    e.setAppliedCount(resCount.toString());
                    this.updateById(e);
                }
                if (!ObjectUtil.isNotEmpty((Object)(c = (OaContractPurchasePlanEntity)this.oaContractPurchasePlanService.getById((Serializable)((Object)v.getPlanId()))))) continue;
                c.setAppliedCount(e.getAppliedCount());
                this.oaContractPurchasePlanService.updateById(c);
            }
        }
    }

    @Override
    public void deleteByNoContractId(String noContractId) {
    }
}

