/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.model.salequotation.SaleQuotationCrForm;
import com.bringspring.quotation.model.salequotation.SaleQuotationInfoVO;
import com.bringspring.quotation.model.salequotation.SaleQuotationListVO;
import com.bringspring.quotation.model.salequotation.SaleQuotationPagination;
import com.bringspring.quotation.model.salequotation.SaleQuotationPaginationExportModel;
import com.bringspring.quotation.model.salequotation.SaleQuotationUpForm;
import com.bringspring.quotation.service.SaleQuotationModuleService;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\uff08\u5546\u673a\uff09\u62a5\u4ef7\u4e3b\u8868"}, value="quotation")
@RequestMapping(value={"/api/quotation/SaleQuotation"})
public class SaleQuotationController {
    private static final Logger log = LoggerFactory.getLogger(SaleQuotationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationModuleService salequotationmoduleService;
    @Autowired
    private SaleQuotationProfitService profitApplyService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleQuotationPagination saleQuotationPagination) throws IOException {
        List<SaleQuotationEntity> listByProductId;
        if (!StrUtil.isBlank((CharSequence)saleQuotationPagination.getProductId()) && ObjectUtil.isNotEmpty(listByProductId = this.saleQuotationService.getListByProductId(saleQuotationPagination.getProductId()))) {
            List<String> stringList = listByProductId.stream().map(SaleQuotationEntity::getId).collect(Collectors.toList());
            saleQuotationPagination.setQuotationIds(stringList);
        }
        List<SaleQuotationEntity> list = this.saleQuotationService.getList(saleQuotationPagination);
        List<SaleQuotationListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleQuotationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleQuotationListVO> appendListVo(List<SaleQuotationEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleQuotationListVO.class);
        for (SaleQuotationListVO oaSaleQuotationVO : listVO) {
            FlowTaskEntity flowTaskEntity;
            SaleQuotationProfitEntity saleQuotationProfitEntity;
            RkProjectReportingEntity rkProjectReportingEntity;
            if (StringUtils.isNotEmpty((String)oaSaleQuotationVO.getCompanyId())) {
                oaSaleQuotationVO.setCompanyName(this.organizeService.getInfo(oaSaleQuotationVO.getCompanyId()).getShortName());
            }
            if (StringUtils.isNotEmpty((String)oaSaleQuotationVO.getQuotationCompanyId())) {
                oaSaleQuotationVO.setSalerCompanyName(this.organizeService.getInfo(oaSaleQuotationVO.getQuotationCompanyId()).getShortName());
            }
            oaSaleQuotationVO.setMoneyUnit(this.baseDataUtil.getDictName(oaSaleQuotationVO.getMoneyUnit(), "moneyUnit"));
            if (!StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getOpportunityId()) && null != (rkProjectReportingEntity = this.rkProjectReportingService.getInfo(oaSaleQuotationVO.getOpportunityId()))) {
                oaSaleQuotationVO.setOpportunityName(rkProjectReportingEntity.getReportingProject());
                oaSaleQuotationVO.setCustomerId(rkProjectReportingEntity.getCustomerId());
            }
            if (!StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getCustomerId())) {
                CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(oaSaleQuotationVO.getCustomerId());
                oaSaleQuotationVO.setCustomerName(ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "");
            }
            if (!StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getQuotationProfitId()) && !StrUtil.isBlank((CharSequence)(saleQuotationProfitEntity = this.profitApplyService.getInfo(oaSaleQuotationVO.getQuotationProfitId())).getCustomerId())) {
                CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(saleQuotationProfitEntity.getCustomerId());
                String customerName = ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "";
                oaSaleQuotationVO.setQuotationProfitName(StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getSerialNumber()) ? customerName + " - " + oaSaleQuotationVO.getQuotationUserName() : oaSaleQuotationVO.getSerialNumber() + " - " + oaSaleQuotationVO.getQuotationUserName());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)oaSaleQuotationVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                oaSaleQuotationVO.setFlowState(flowTaskEntity.getStatus());
                oaSaleQuotationVO.setFlowStateName(FlowTaskStatusEnum.getMessageByCode((Integer)flowTaskEntity.getStatus()));
                continue;
            }
            oaSaleQuotationVO.setFlowState(null);
        }
        return listVO;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleQuotationCrForm saleQuotationCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        this.saleQuotationService.create(saleQuotationCrForm, mainId);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleQuotationPaginationExportModel saleQuotationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleQuotationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleQuotationPagination saleQuotationPagination = (SaleQuotationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleQuotationPaginationExportModel), SaleQuotationPagination.class));
        List<SaleQuotationEntity> list = this.saleQuotationService.getTypeList(saleQuotationPagination, saleQuotationPaginationExportModel.getDataType());
        List<SaleQuotationListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleQuotationPaginationExportModel.getSelectKey()) ? saleQuotationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block52: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "serialNumber": {
                        entitys.add(new ExcelExportEntity("\u7f16\u53f7", (Object)"serialNumber"));
                        continue block52;
                    }
                    case "opportunityName": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u62a5\u5907", (Object)"opportunityName"));
                        continue block52;
                    }
                    case "moneyUnit": {
                        entitys.add(new ExcelExportEntity("\u5355\u4f4d", (Object)"moneyUnit"));
                        continue block52;
                    }
                    case "quotationUser": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u4eba\u5458", (Object)"quotationUserName"));
                        continue block52;
                    }
                    case "quotationDate": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u65e5\u671f", (Object)"quotationDateStr"));
                        continue block52;
                    }
                    case "deliveryMethod": {
                        entitys.add(new ExcelExportEntity("\u4ea4\u8d27\u65b9\u5f0f", (Object)"deliveryMethod"));
                        continue block52;
                    }
                    case "deliveryDate": {
                        entitys.add(new ExcelExportEntity("\u4ea4\u8d27\u671f\u9650", (Object)"deliveryDate"));
                        continue block52;
                    }
                    case "paymentMethod": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentMethod"));
                        continue block52;
                    }
                    case "contactMethod": {
                        entitys.add(new ExcelExportEntity("\u8054\u7edc\u65b9\u5f0f", (Object)"contactMethod"));
                        continue block52;
                    }
                    case "warrantyPeriod": {
                        entitys.add(new ExcelExportEntity("\u4fdd\u4fee\u671f", (Object)"warrantyPeriod"));
                        continue block52;
                    }
                    case "allAmount": {
                        entitys.add(new ExcelExportEntity("\u8f6f\u786c\u4ef6\u5408\u8ba1\u91d1\u989d(\u5143)", (Object)"allAmount"));
                        continue block52;
                    }
                    case "totalDiscount": {
                        entitys.add(new ExcelExportEntity("\u603b\u6298\u6263\u4f18\u60e0(\u5143)", (Object)"totalDiscount"));
                        continue block52;
                    }
                    case "allTotalAmount": {
                        entitys.add(new ExcelExportEntity("\u91d1\u989d\u603b\u8ba1(\u5143)", (Object)"allTotalAmount"));
                        continue block52;
                    }
                    case "allAmountCapitalization": {
                        entitys.add(new ExcelExportEntity("\u91d1\u989d\u603b\u8ba1(\u5927\u5199)", (Object)"allAmountCapitalization"));
                        continue block52;
                    }
                    case "softwareTotalAmount": {
                        entitys.add(new ExcelExportEntity("\u8f6f\u4ef6\u62a5\u4ef7\u5408\u8ba1(\u5143)", (Object)"softwareTotalAmount"));
                        continue block52;
                    }
                    case "hardwareTotalAmount": {
                        entitys.add(new ExcelExportEntity("\u786c\u4ef6\u62a5\u4ef7\u5408\u8ba1(\u5143)", (Object)"hardwareTotalAmount"));
                        continue block52;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u8bc4\u5ba1\u8bf4\u660e", (Object)"description"));
                        continue block52;
                    }
                    case "flowStateName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"flowStateName"));
                        continue block52;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block52;
                    }
                    case "salerCompanyName": {
                        entitys.add(new ExcelExportEntity("\u8425\u9500\u5e73\u53f0", (Object)"salerCompanyName"));
                        continue block52;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleQuotationInfoVO> info(@PathVariable(value="id") String id) {
        SaleQuotationInfoVO vo = this.saleQuotationService.getDetailInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleQuotationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity applyServiceInfo;
        SaleQuotationInfoVO vo = this.saleQuotationService.getDetailInfo(id);
        vo.setQuotationUser(this.baseDataUtil.userSelectValue(vo.getQuotationUser()));
        if (!StrUtil.isBlank((CharSequence)vo.getQuotationProfitId()) && !StrUtil.isBlank((CharSequence)(applyServiceInfo = this.profitApplyService.getInfo(vo.getQuotationProfitId())).getCustomerId())) {
            CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(applyServiceInfo.getCustomerId());
            vo.setQuotationProfitName(ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "");
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleQuotationUpForm saleQuotationUpForm) throws DataException {
        this.saleQuotationService.update(id, saleQuotationUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SaleQuotationEntity entity = this.saleQuotationService.getInfo(id);
        List<SaleQuotationProfitEntity> listByQuotationId = this.profitApplyService.getListByQuotationId(id);
        if (!listByQuotationId.isEmpty()) {
            return ActionResult.success((String)"prohibitDelete");
        }
        if (entity != null) {
            this.saleQuotationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getQuotationProductAmount/{quotationId}"})
    public ActionResult<Map<String, BigDecimal>> getQuotationProductAmount(@PathVariable(value="quotationId") String quotationId) {
        Map<String, BigDecimal> productAmount = this.saleQuotationService.getQuotationProductAmount(quotationId);
        return ActionResult.success(productAmount);
    }
}

