/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitDetailEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitCrForm;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitInfoVO;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitListVO;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitPagination;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitPaginationExportModel;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitUpForm;
import com.bringspring.quotation.model.salequotationprofitdetail.SaleQuotationProfitDetailModel;
import com.bringspring.quotation.service.SaleQuotationProfitDetailService;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.quotation.utils.QuotationProfitEnum;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62a5\u4ef7\u6bdb\u5229"}, value="quotation")
@RequestMapping(value={"/api/quotation/SaleQuotationProfit"})
public class SaleQuotationProfitController {
    private static final Logger log = LoggerFactory.getLogger(SaleQuotationProfitController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleQuotationProfitDetailService salequotationprofitdetailService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private SaleQuotationProfitDetailService saleQuotationprofitDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleQuotationProfitPagination saleQuotationProfitPagination) throws IOException {
        List<SaleQuotationProfitEntity> list = this.saleQuotationProfitService.getList(saleQuotationProfitPagination);
        List<SaleQuotationProfitListVO> listVO = this.appendVoList(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleQuotationProfitPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleQuotationProfitListVO> appendVoList(List<SaleQuotationProfitEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleQuotationProfitListVO.class);
        SaleQuotationProfitDetailEntity profitDetail = null;
        for (SaleQuotationProfitListVO saleQuotationProfitVO : listVO) {
            FlowTaskEntity flowTaskEntity;
            CrmCustomerEntity byId;
            RkProjectReportingEntity reportingEntity;
            if (StringUtils.isNotEmpty((String)saleQuotationProfitVO.getCompanyId())) {
                saleQuotationProfitVO.setCompanyName(this.organizeService.getInfo(saleQuotationProfitVO.getCompanyId()).getShortName());
            }
            if (StringUtils.isNotEmpty((String)saleQuotationProfitVO.getSalerCompanyId())) {
                saleQuotationProfitVO.setSalerCompanyName(this.organizeService.getInfo(saleQuotationProfitVO.getSalerCompanyId()).getShortName());
            }
            saleQuotationProfitVO.setDistributionMethodName(this.baseDataUtil.getDictName(saleQuotationProfitVO.getDistributionMethod(), "distributionMethod"));
            saleQuotationProfitVO.setProductTypeName(this.baseDataUtil.getDictName(saleQuotationProfitVO.getProductType(), "profitClassification"));
            saleQuotationProfitVO.setStatusDesc(this.baseDataUtil.getDictName(saleQuotationProfitVO.getStatus(), "quotationProfitStatus"));
            saleQuotationProfitVO.setAddressName(this.baseDataUtil.provinceData(saleQuotationProfitVO.getAddress()));
            SaleQuotationEntity quotationEntity = (SaleQuotationEntity)this.saleQuotationService.getById((Serializable)((Object)saleQuotationProfitVO.getQuotationId()));
            if (ObjectUtil.isNotNull((Object)quotationEntity) && ObjectUtil.isNotNull((Object)(reportingEntity = (RkProjectReportingEntity)this.rkProjectReportingService.getById((Serializable)((Object)quotationEntity.getOpportunityId()))))) {
                saleQuotationProfitVO.setOppName(reportingEntity.getReportingProject());
                saleQuotationProfitVO.setCustomerId(reportingEntity.getCustomerId());
            }
            saleQuotationProfitVO.setCustomerName(ObjectUtil.isNull((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)saleQuotationProfitVO.getCustomerId())))) ? "" : byId.getName());
            if (StrUtil.isNotBlank((CharSequence)saleQuotationProfitVO.getProductCategoryId())) {
                saleQuotationProfitVO.setProductCategoryName(this.crmProductCategoryService.getNameByIds(saleQuotationProfitVO.getProductCategoryId()));
            }
            if (isExport) continue;
            profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(saleQuotationProfitVO.getId(), "softProfit");
            if (null != profitDetail) {
                saleQuotationProfitVO.setSoftProfit(ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue()));
            }
            if (null != (profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(saleQuotationProfitVO.getId(), "hardProfit"))) {
                saleQuotationProfitVO.setSoftProfit(MathUtils.add(saleQuotationProfitVO.getSoftProfit(), ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue())));
            }
            if (null != (profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(saleQuotationProfitVO.getId(), "softProfitRate"))) {
                saleQuotationProfitVO.setSoftProfitRate(ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue()));
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)saleQuotationProfitVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                saleQuotationProfitVO.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            saleQuotationProfitVO.setFlowState(null);
        }
        return listVO;
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid SaleQuotationProfitCrForm saleQuotationProfitCrForm) throws DataException {
        this.saleQuotationProfitService.createProfit(saleQuotationProfitCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody SaleQuotationProfitPaginationExportModel saleQuotationProfitPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleQuotationProfitPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleQuotationProfitPagination saleQuotationProfitPagination = (SaleQuotationProfitPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleQuotationProfitPaginationExportModel), SaleQuotationProfitPagination.class));
        List<SaleQuotationProfitEntity> list = this.saleQuotationProfitService.getTypeList(saleQuotationProfitPagination, saleQuotationProfitPaginationExportModel.getDataType());
        List<SaleQuotationProfitListVO> listVO = this.appendVoList(list, false);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleQuotationProfitPaginationExportModel.getSelectKey()) ? saleQuotationProfitPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "serialNumber": {
                        entitys.add(new ExcelExportEntity("\u7f16\u53f7", (Object)"serialNumber"));
                        continue block44;
                    }
                    case "distributionMethod": {
                        entitys.add(new ExcelExportEntity("\u5206\u9500\u65b9\u5f0f", (Object)"distributionMethodName"));
                        continue block44;
                    }
                    case "saleId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9500\u552e", (Object)"saleName"));
                        continue block44;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u533b\u9662\u540d\u79f0", (Object)"customerName"));
                        continue block44;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"productTypeName"));
                        continue block44;
                    }
                    case "regionId": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df\u8d1f\u8d23\u4eba", (Object)"regionUserName"));
                        continue block44;
                    }
                    case "quotationId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7", (Object)"quotationId"));
                        continue block44;
                    }
                    case "oppName": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u540d\u79f0", (Object)"oppName"));
                        continue block44;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u533a", (Object)"addressName"));
                        continue block44;
                    }
                    case "productCategoryName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productCategoryName"));
                        continue block44;
                    }
                    case "amount": {
                        entitys.add(new ExcelExportEntity("\u6bdb\u5229\u91d1\u989d", (Object)"amount"));
                        continue block44;
                    }
                    case "statusDesc": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"statusDesc"));
                        continue block44;
                    }
                    case "amountCapital": {
                        entitys.add(new ExcelExportEntity("\u91d1\u989d\u5927\u5199", (Object)"amountCapital"));
                        continue block44;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8id", (Object)"companyId"));
                        continue block44;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block44;
                    }
                    case "salerCompanyName": {
                        entitys.add(new ExcelExportEntity("\u8425\u9500\u5e73\u53f0", (Object)"salerCompanyName"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u62a5\u4ef7\u6bdb\u5229");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleQuotationProfitInfoVO> info(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity entity = this.saleQuotationProfitService.getInfo(id);
        SaleQuotationProfitInfoVO vo = (SaleQuotationProfitInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleQuotationProfitInfoVO.class);
        List<SaleQuotationProfitDetailEntity> salequotationprofitdetailList = this.saleQuotationProfitService.getSalequotationprofitdetailList(id);
        List saleList = salequotationprofitdetailList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.SALE_TYPE.getType())).collect(Collectors.toList());
        List devList = salequotationprofitdetailList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.DEV_TYPE.getType())).collect(Collectors.toList());
        List executeList = salequotationprofitdetailList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.EXECUTE_TYPE.getType())).collect(Collectors.toList());
        vo.setSaleList(JsonUtil.getJsonToList(saleList, SaleQuotationProfitDetailModel.class));
        vo.setExecuteList(JsonUtil.getJsonToList(executeList, SaleQuotationProfitDetailModel.class));
        vo.setDevList(JsonUtil.getJsonToList(devList, SaleQuotationProfitDetailModel.class));
        vo.setSaleQuotationProfitDetailList(JsonUtil.getJsonToList(salequotationprofitdetailList, SaleQuotationProfitDetailModel.class));
        List<RkAttachmentEntity> listByObjId = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(listByObjId);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleQuotationProfitInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity entity = this.saleQuotationProfitService.getInfo(id);
        SaleQuotationProfitInfoVO vo = (SaleQuotationProfitInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleQuotationProfitInfoVO.class);
        List<SaleQuotationProfitDetailEntity> salequotationprofitdetailList = this.saleQuotationProfitService.getSalequotationprofitdetailList(id);
        List salequotationprofitdetailModelList = JsonUtil.getJsonToList(salequotationprofitdetailList, SaleQuotationProfitDetailModel.class);
        for (SaleQuotationProfitDetailModel saleQuotationProfitDetailModel : salequotationprofitdetailModelList) {
        }
        vo.setSaleQuotationProfitDetailList(salequotationprofitdetailModelList);
        vo.setDistributionMethod(this.baseDataUtil.getDictName(vo.getDistributionMethod(), "distributionMethod"));
        vo.setSaleId(this.baseDataUtil.userSelectValues(vo.getSaleId()));
        vo.setProductType(this.baseDataUtil.getDictName(vo.getProductType(), "profitClassification"));
        vo.setRegionId(this.baseDataUtil.userSelectValues(vo.getRegionId()));
        vo.setAddress(this.baseDataUtil.provinceData(vo.getAddress()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleQuotationProfitUpForm saleQuotationProfitUpForm) throws DataException {
        this.saleQuotationProfitService.updateProfit(id, saleQuotationProfitUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity entity = this.saleQuotationProfitService.getInfo(id);
        List<SaleQuotationEntity> listByProfitIdId = this.saleQuotationService.getListByProfitIdId(id);
        if (!listByProfitIdId.isEmpty()) {
            return ActionResult.success((String)"prohibitDelete");
        }
        if (entity != null) {
            this.saleQuotationProfitService.delete(entity);
            QueryWrapper queryWrapperSalequotationprofitdetail = new QueryWrapper();
            queryWrapperSalequotationprofitdetail.lambda().eq(SaleQuotationProfitDetailEntity::getProfitId, (Object)entity.getId());
            this.salequotationprofitdetailService.remove((Wrapper)queryWrapperSalequotationprofitdetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

