/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.quotation.constant.TemplateEnableMarkEnum;
import com.bringspring.quotation.entity.SaleQuotationTemplateEntity;
import com.bringspring.quotation.entity.SaleQuotationTemplateModuleEntity;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateCrForm;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateInfoVO;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateListVO;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplatePagination;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplatePaginationExportModel;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateUpForm;
import com.bringspring.quotation.model.salequotationtemplatemodule.SaleQuotationTemplateModuleModel;
import com.bringspring.quotation.model.salequotationtemplatemodule.SaleQuotationTemplateModulePagination;
import com.bringspring.quotation.service.SaleQuotationTemplateModuleService;
import com.bringspring.quotation.service.SaleQuotationTemplateService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62a5\u4ef7\u6a21\u677f"}, value="quotation")
@RequestMapping(value={"/api/quotation/SaleQuotationTemplate"})
public class SaleQuotationTemplateController {
    private static final Logger log = LoggerFactory.getLogger(SaleQuotationTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleQuotationTemplateService saleQuotationTemplateService;
    @Autowired
    private SaleQuotationTemplateModuleService saleQuotationTemplateModuleService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleQuotationTemplatePagination saleQuotationTemplatePagination) throws IOException {
        List<SaleQuotationTemplateEntity> list = this.saleQuotationTemplateService.getList(saleQuotationTemplatePagination);
        List listVO = JsonUtil.getJsonToList(list, SaleQuotationTemplateListVO.class);
        this.appendVo(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleQuotationTemplatePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleQuotationTemplateCrForm saleQuotationTemplateCrForm) throws DataException {
        this.saleQuotationTemplateService.create(saleQuotationTemplateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleQuotationTemplateInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity productCategory;
        SaleQuotationTemplateEntity entity = this.saleQuotationTemplateService.getInfo(id);
        SaleQuotationTemplateInfoVO vo = (SaleQuotationTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleQuotationTemplateInfoVO.class);
        if (StringUtils.isNotBlank((CharSequence)vo.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(vo.getProductCategoryId()))) {
            vo.setProductCategoryName(productCategory.getName());
        }
        vo.setHospitalLevelName(this.baseDataUtil.getDictName(vo.getHospitalLevel(), "CustomerGrade"));
        this.appendModuleList(vo);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleQuotationTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity productCategory;
        SaleQuotationTemplateEntity entity = this.saleQuotationTemplateService.getInfo(id);
        SaleQuotationTemplateInfoVO vo = (SaleQuotationTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleQuotationTemplateInfoVO.class);
        if (StringUtils.isNotBlank((CharSequence)vo.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(vo.getProductCategoryId()))) {
            vo.setProductCategoryName(productCategory.getName());
        }
        vo.setHospitalLevelName(this.baseDataUtil.getDictName(vo.getHospitalLevel(), "CustomerGrade"));
        this.appendModuleList(vo);
        return ActionResult.success((Object)vo);
    }

    private void appendModuleList(SaleQuotationTemplateInfoVO vo) {
        List<SaleQuotationTemplateModuleEntity> SaleQuotationTemplateModuleList = this.saleQuotationTemplateService.getSaleQuotationTemplateModuleList(vo.getId());
        ArrayList<SaleQuotationTemplateModuleModel> softModuleList = new ArrayList<SaleQuotationTemplateModuleModel>();
        ArrayList<SaleQuotationTemplateModuleModel> hardModuleList = new ArrayList<SaleQuotationTemplateModuleModel>();
        SaleQuotationTemplateModuleModel templateModuleModel = null;
        for (SaleQuotationTemplateModuleEntity salequotationtemplatemoduleEntity : SaleQuotationTemplateModuleList) {
            templateModuleModel = (SaleQuotationTemplateModuleModel)JsonUtil.getJsonToBean((Object)salequotationtemplatemoduleEntity, SaleQuotationTemplateModuleModel.class);
            templateModuleModel.setUnitName(this.baseDataUtil.getDictName(templateModuleModel.getUnit(), "quotationModuleUnit"));
            templateModuleModel.setTypeName(this.baseDataUtil.getDictName(templateModuleModel.getType(), "quotationModuleType"));
            if ("soft".equals(salequotationtemplatemoduleEntity.getModuleCategory())) {
                softModuleList.add(templateModuleModel);
                continue;
            }
            if (!"hard".equals(salequotationtemplatemoduleEntity.getModuleCategory())) continue;
            hardModuleList.add(templateModuleModel);
        }
        vo.setSoftModuleList(softModuleList);
        vo.setHardModuleList(hardModuleList);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleQuotationTemplateUpForm saleQuotationTemplateUpForm) throws DataException {
        this.saleQuotationTemplateService.update(id, saleQuotationTemplateUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult delete(@PathVariable(value="id") String id) {
        SaleQuotationTemplateEntity entity = this.saleQuotationTemplateService.getInfo(id);
        if (entity != null) {
            entity.setDeleteFlag(1);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.saleQuotationTemplateService.updateById(entity);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getTemplateId, (Object)id);
            updateWrapper.lambda().set(SaleQuotationTemplateModuleEntity::getDeleteFlag, (Object)entity.getDeleteFlag());
            this.saleQuotationTemplateModuleService.update((Wrapper)updateWrapper);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/pause/{id}"})
    @DSTransactional
    public ActionResult pause(@PathVariable(value="id") String id) throws DataException {
        SaleQuotationTemplateEntity entity = this.saleQuotationTemplateService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(TemplateEnableMarkEnum.PAUSE.getEnableMark());
        this.saleQuotationTemplateService.updateById(entity);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getTemplateId, (Object)id);
        updateWrapper.lambda().set(SaleQuotationTemplateModuleEntity::getEnabledMark, (Object)entity.getEnabledMark());
        this.saleQuotationTemplateModuleService.update((Wrapper)updateWrapper);
        return ActionResult.success((String)"\u6682\u505c\u6210\u529f");
    }

    @PutMapping(value={"/enable/{id}"})
    @DSTransactional
    public ActionResult enable(@PathVariable(value="id") String id) throws DataException {
        SaleQuotationTemplateEntity entity = this.saleQuotationTemplateService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(TemplateEnableMarkEnum.ENABLE.getEnableMark());
        this.saleQuotationTemplateService.updateById(entity);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getTemplateId, (Object)id);
        updateWrapper.lambda().set(SaleQuotationTemplateModuleEntity::getEnabledMark, (Object)entity.getEnabledMark());
        this.saleQuotationTemplateModuleService.update((Wrapper)updateWrapper);
        return ActionResult.success((String)"\u542f\u7528\u6210\u529f");
    }

    @PostMapping(value={"/getModuleList"})
    public ActionResult getModuleList(@RequestBody SaleQuotationTemplateModulePagination modulePagination) throws IOException {
        List<SaleQuotationTemplateModuleEntity> list = this.saleQuotationTemplateService.getModulelist(modulePagination);
        List listVO = JsonUtil.getJsonToList(list, SaleQuotationTemplateModuleModel.class);
        CrmProductCategoryEntity productCategory = null;
        SaleQuotationTemplateEntity saleQuotationTemplateEntity = null;
        for (SaleQuotationTemplateModuleModel vo : listVO) {
            if (StrUtil.isNotEmpty((CharSequence)vo.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(vo.getProductCategoryId()))) {
                vo.setProductCategoryName(productCategory.getName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getTemplateId()) && null != (saleQuotationTemplateEntity = this.saleQuotationTemplateService.getInfo(vo.getTemplateId()))) {
                vo.setTemplateName(saleQuotationTemplateEntity.getTemplateName());
            }
            vo.setUnitName(this.baseDataUtil.getDictName(vo.getUnit(), "quotationModuleUnit"));
            vo.setTypeName(this.baseDataUtil.getDictName(vo.getType(), "quotationModuleType"));
            vo.setHospitalLevelName(this.baseDataUtil.getDictName(vo.getHospitalLevel(), "CustomerGrade"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)modulePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleQuotationTemplatePaginationExportModel saleQuotationTemplatePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleQuotationTemplatePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleQuotationTemplatePagination saleQuotationTemplatePagination = (SaleQuotationTemplatePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleQuotationTemplatePaginationExportModel), SaleQuotationTemplatePagination.class));
        List<SaleQuotationTemplateEntity> list = this.saleQuotationTemplateService.getTypeList(saleQuotationTemplatePagination, saleQuotationTemplatePaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, SaleQuotationTemplateListVO.class);
        this.appendVo(listVO);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleQuotationTemplatePaginationExportModel.getSelectKey()) ? saleQuotationTemplatePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    private void appendVo(List<SaleQuotationTemplateListVO> listVO) {
        CrmProductCategoryEntity productCategory = null;
        for (SaleQuotationTemplateListVO vo : listVO) {
            if (StringUtils.isNotBlank((CharSequence)vo.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(vo.getProductCategoryId()))) {
                vo.setProductCategoryName(productCategory.getName());
            }
            vo.setHospitalLevelName(this.baseDataUtil.getDictName(vo.getHospitalLevel(), "CustomerGrade"));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
            }
            vo.setEnabledMarkName(this.baseDataUtil.getDictName(vo.getEnabledMark(), "quotationTemplateState"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "templateName": {
                        entity = new ExcelExportEntity("\u6a21\u7248\u540d\u79f0", (Object)"templateName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "productName": {
                        entity = new ExcelExportEntity("\u4ea7\u54c1", (Object)"productName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "productCategoryName": {
                        entity = new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"productCategoryName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "hospitalLevelName": {
                        entity = new ExcelExportEntity("\u533b\u9662\u7b49\u7ea7", (Object)"hospitalLevelName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "usingCompanyName": {
                        entity = new ExcelExportEntity("\u62a5\u4ef7\u4f7f\u7528\u516c\u53f8", (Object)"usingCompanyName");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "enabledMarkName": {
                        entity = new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMarkName");
                        entitys.add(entity);
                        continue block36;
                    }
                    case "creatorTime": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "creatorUserName": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserName");
                        entitys.add(entity);
                        continue block36;
                    }
                    case "activeStartTime": {
                        entity = new ExcelExportEntity("\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object)"activeStartTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "activeEndTime": {
                        entity = new ExcelExportEntity("\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object)"activeEndTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "totalAmount": {
                        entity = new ExcelExportEntity("\u6700\u4f4e\u4ef7\u683c\u603b\u8ba1\uff08\u5143\uff09", (Object)"totalAmount");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "channelTotalAmount": {
                        entity = new ExcelExportEntity("\u6e20\u9053\u4ef7\u683c\u603b\u8ba1\uff08\u5143\uff09", (Object)"channelTotalAmount");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

