/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.quotation.entity.SaleQuotationProfitDetailEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.mapper.SaleQuotationProfitMapper;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitCrForm;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitListVO;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitPagination;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitUpForm;
import com.bringspring.quotation.service.SaleQuotationProfitDetailService;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.utils.CustomizeSortWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleQuotationProfitServiceImpl
extends ServiceImpl<SaleQuotationProfitMapper, SaleQuotationProfitEntity>
implements SaleQuotationProfitService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleQuotationProfitDetailService salequotationprofitdetailService;

    @Override
    public List<SaleQuotationProfitEntity> getList(SaleQuotationProfitPagination saleQuotationProfitPagination) {
        QueryWrapper<SaleQuotationProfitEntity> saleQuotationProfitQueryWrapper = this.appendWrapper(saleQuotationProfitPagination);
        if (ObjectUtil.isNull(saleQuotationProfitQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        Page page = new Page(saleQuotationProfitPagination.getCurrentPage(), saleQuotationProfitPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationProfitQueryWrapper);
        return saleQuotationProfitPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleQuotationProfitEntity> appendWrapper(SaleQuotationProfitPagination saleQuotationProfitPagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper saleQuotationProfitQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (ObjectUtil.equals((Object)saleQuotationProfitPagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(saleQuotationProfitQueryWrapper, saleQuotationProfitPagination.getMenuId(), "sale_quotation_profit"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getCreatorUserId, (Object)userInfo.getUserId());
            } else {
                saleQuotationProfitQueryWrapper = (QueryWrapper)rkContractObj;
            }
        }
        QueryWrapper salequotationprofitdetailQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getDistributionMethod())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getDistributionMethod, (Object)saleQuotationProfitPagination.getDistributionMethod());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getSaleId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getSaleId, (Object)saleQuotationProfitPagination.getSaleId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getRegionId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getRegionId, (Object)saleQuotationProfitPagination.getRegionId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getCustomerId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getCustomerId, (Object)saleQuotationProfitPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getProductType())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getProductType, (Object)saleQuotationProfitPagination.getProductType());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getQuotationId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getQuotationId, (Object)saleQuotationProfitPagination.getQuotationId());
        } else if ("1".equals(saleQuotationProfitPagination.getOnlyThisQuotation())) {
            saleQuotationProfitQueryWrapper.lambda().and(s -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.or()).eq(SaleQuotationProfitEntity::getQuotationId, (Object)"")).or()).isNull(SaleQuotationProfitEntity::getQuotationId));
        }
        if (CollectionUtil.isNotEmpty(saleQuotationProfitPagination.getAddress())) {
            saleQuotationProfitPagination.getAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (saleQuotationProfitPagination.getAddress().size() < 2 && saleQuotationProfitPagination.getAddress().get(0).equals("10")) {
                saleQuotationProfitPagination.setAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(saleQuotationProfitPagination.getAddress())) {
            saleQuotationProfitQueryWrapper.lambda().and(x -> {
                for (List<String> ll : saleQuotationProfitPagination.getAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(SaleQuotationProfitEntity::getAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(SaleQuotationProfitEntity::getAddress, (Object)s2);
                }
            });
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getProductId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getProductId, (Object)saleQuotationProfitPagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getAmount())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getAmount, (Object)saleQuotationProfitPagination.getAmount());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getAmountCapital())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getAmountCapital, (Object)saleQuotationProfitPagination.getAmountCapital());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationProfitPagination.getCompanyId())) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getCompanyId, (Object)saleQuotationProfitPagination.getCompanyId());
        }
        if (null != saleQuotationProfitPagination.getFlowStatus()) {
            saleQuotationProfitQueryWrapper.lambda().eq(SaleQuotationProfitEntity::getFlowStatus, (Object)saleQuotationProfitPagination.getFlowStatus());
        }
        if (CollectionUtil.isNotEmpty(saleQuotationProfitPagination.getSalerCompanyIdList())) {
            saleQuotationProfitQueryWrapper.lambda().in(SaleQuotationProfitEntity::getSalerCompanyId, saleQuotationProfitPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(saleQuotationProfitPagination.getCompanyIdList())) {
            saleQuotationProfitQueryWrapper.lambda().in(SaleQuotationProfitEntity::getCompanyId, saleQuotationProfitPagination.getCompanyIdList());
        }
        if (StringUtils.isEmpty((String)saleQuotationProfitPagination.getSidx())) {
            saleQuotationProfitQueryWrapper.lambda().orderByDesc(SaleQuotationProfitEntity::getId);
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleQuotationProfitPagination, new SaleQuotationProfitListVO(), saleQuotationProfitQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = saleQuotationProfitPagination.getSidx();
                    SaleQuotationProfitEntity saleQuotationProfitEntity = new SaleQuotationProfitEntity();
                    Field declaredField = saleQuotationProfitEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    saleQuotationProfitQueryWrapper = "asc".equals(saleQuotationProfitPagination.getSort().toLowerCase()) ? (QueryWrapper)saleQuotationProfitQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleQuotationProfitQueryWrapper.orderByDesc((Object)value);
                } else {
                    saleQuotationProfitQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return saleQuotationProfitQueryWrapper;
    }

    @Override
    public List<SaleQuotationProfitEntity> getTypeList(SaleQuotationProfitPagination saleQuotationProfitPagination, String dataType) {
        QueryWrapper<SaleQuotationProfitEntity> saleQuotationProfitQueryWrapper = this.appendWrapper(saleQuotationProfitPagination);
        if (ObjectUtil.isNull(saleQuotationProfitQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if ("0".equals(dataType)) {
            Page page = new Page(saleQuotationProfitPagination.getCurrentPage(), saleQuotationProfitPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationProfitQueryWrapper);
            return saleQuotationProfitPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleQuotationProfitQueryWrapper);
    }

    @Override
    public SaleQuotationProfitEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationProfitEntity::getId, (Object)id);
        return (SaleQuotationProfitEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void createProfit(SaleQuotationProfitCrForm saleQuotationProfitCrForm) {
        String mainId = RandomUtil.uuId();
        SaleQuotationProfitEntity entity = (SaleQuotationProfitEntity)JsonUtil.getJsonToBean((Object)saleQuotationProfitCrForm, SaleQuotationProfitEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List SalequotationprofitdetailList = JsonUtil.getJsonToList(saleQuotationProfitCrForm.getSalequotationprofitdetailList(), SaleQuotationProfitDetailEntity.class);
        for (SaleQuotationProfitDetailEntity entitys : SalequotationprofitdetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setProfitId(entity.getId());
            this.salequotationprofitdetailService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public void updateProfit(String id, SaleQuotationProfitUpForm saleQuotationProfitUpForm) {
        UserInfo userInfo = this.userProvider.get();
        SaleQuotationProfitEntity entity = this.getInfo(id);
        if (entity != null) {
            SaleQuotationProfitEntity subentity = (SaleQuotationProfitEntity)JsonUtil.getJsonToBean((Object)saleQuotationProfitUpForm, SaleQuotationProfitEntity.class);
            subentity.setId(id);
            this.updateById(subentity);
            QueryWrapper SalequotationprofitdetailqueryWrapper = new QueryWrapper();
            SalequotationprofitdetailqueryWrapper.lambda().eq(SaleQuotationProfitDetailEntity::getProfitId, (Object)entity.getId());
            this.salequotationprofitdetailService.remove((Wrapper)SalequotationprofitdetailqueryWrapper);
            List SalequotationprofitdetailList = JsonUtil.getJsonToList(saleQuotationProfitUpForm.getSalequotationprofitdetailList(), SaleQuotationProfitDetailEntity.class);
            for (SaleQuotationProfitDetailEntity entitys : SalequotationprofitdetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setProfitId(entity.getId());
                this.salequotationprofitdetailService.save(entitys);
            }
            this.updateById(entity);
        }
    }

    @Override
    public void delete(SaleQuotationProfitEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<SaleQuotationProfitDetailEntity> getSalequotationprofitdetailList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationProfitDetailEntity::getProfitId, (Object)id);
        return this.salequotationprofitdetailService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleQuotationProfitEntity> getListByQuotationId(String quotationId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationProfitEntity::getQuotationId, (Object)quotationId);
        return this.list((Wrapper)queryWrapper);
    }
}

