/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationModuleEntity;
import com.bringspring.quotation.entity.SaleQuotationProductEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.entity.SaleQuotationTemplateEntity;
import com.bringspring.quotation.mapper.SaleQuotationMapper;
import com.bringspring.quotation.model.saleqQuotationModule.SaleQuotationModule;
import com.bringspring.quotation.model.saleqQuotationModule.SaleQuotationTemplateModel;
import com.bringspring.quotation.model.salequotation.SaleQuotationCrForm;
import com.bringspring.quotation.model.salequotation.SaleQuotationInfoVO;
import com.bringspring.quotation.model.salequotation.SaleQuotationListVO;
import com.bringspring.quotation.model.salequotation.SaleQuotationPagination;
import com.bringspring.quotation.model.salequotation.SaleQuotationUpForm;
import com.bringspring.quotation.service.SaleQuotationModuleService;
import com.bringspring.quotation.service.SaleQuotationProductService;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.quotation.service.SaleQuotationTemplateService;
import com.bringspring.quotation.utils.QuotationConstants;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.CustomizeSortWrapper;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleQuotationServiceImpl
extends ServiceImpl<SaleQuotationMapper, SaleQuotationEntity>
implements SaleQuotationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleQuotationModuleService saleQuotationModuleService;
    @Autowired
    private SaleQuotationProductService saleQuotationProductService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SaleQuotationProfitService profitApplyService;
    @Autowired
    private SaleQuotationTemplateService saleQuotationTemplateService;

    @Override
    public List<SaleQuotationEntity> getList(SaleQuotationPagination saleQuotationPagination) {
        QueryWrapper<SaleQuotationEntity> saleQuotationQueryWrapper = this.appendWrapper(saleQuotationPagination);
        Page page = new Page(saleQuotationPagination.getCurrentPage(), saleQuotationPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationQueryWrapper);
        return saleQuotationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleQuotationEntity> appendWrapper(SaleQuotationPagination saleQuotationPagination) {
        QueryWrapper saleQuotationQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (ObjectUtil.equals((Object)saleQuotationPagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object afterSalesQuestionObj = this.authorizeService.getCondition(new AuthorizeConditionModel(saleQuotationQueryWrapper, saleQuotationPagination.getMenuId(), "sale_quotation"));
            if (ObjectUtil.isEmpty((Object)afterSalesQuestionObj)) {
                saleQuotationQueryWrapper.and(this.defaultWrapper());
            } else {
                saleQuotationQueryWrapper = (QueryWrapper)afterSalesQuestionObj;
            }
        }
        if (StringUtils.isNotEmpty((String)saleQuotationPagination.getQuotationUser())) {
            saleQuotationQueryWrapper.lambda().eq(SaleQuotationEntity::getQuotationUser, (Object)saleQuotationPagination.getQuotationUser());
        }
        if (StringUtils.isNotEmpty(saleQuotationPagination.getQuotationDate())) {
            List<String> QuotationDateList = saleQuotationPagination.getQuotationDate();
            Long fir = Long.valueOf(QuotationDateList.get(0));
            Long sec = Long.valueOf(QuotationDateList.get(1));
            ((LambdaQueryWrapper)saleQuotationQueryWrapper.lambda().ge(SaleQuotationEntity::getQuotationDate, (Object)new Date(fir))).le(SaleQuotationEntity::getQuotationDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty(saleQuotationPagination.getQuotationIds())) {
            saleQuotationQueryWrapper.lambda().in(SaleQuotationEntity::getId, saleQuotationPagination.getQuotationIds());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationPagination.getOpportunityName())) {
            saleQuotationQueryWrapper.lambda().like(SaleQuotationEntity::getOpportunityName, (Object)saleQuotationPagination.getOpportunityName());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationPagination.getOpportunityId())) {
            saleQuotationQueryWrapper.lambda().in(SaleQuotationEntity::getOpportunityId, Arrays.asList(saleQuotationPagination.getOpportunityId().split(",")));
        }
        if (StringUtils.isNotEmpty((String)saleQuotationPagination.getFlowState())) {
            saleQuotationQueryWrapper.lambda().eq(SaleQuotationEntity::getState, (Object)saleQuotationPagination.getFlowState());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationPagination.getCompanyId())) {
            saleQuotationQueryWrapper.lambda().eq(SaleQuotationEntity::getCompanyId, (Object)saleQuotationPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleQuotationPagination.getSalerCompanyIdList())) {
            saleQuotationQueryWrapper.lambda().in(SaleQuotationEntity::getQuotationCompanyId, saleQuotationPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(saleQuotationPagination.getCompanyIdList())) {
            saleQuotationQueryWrapper.lambda().in(SaleQuotationEntity::getCompanyId, saleQuotationPagination.getCompanyIdList());
        }
        if (StringUtils.isEmpty((String)saleQuotationPagination.getSidx())) {
            saleQuotationQueryWrapper.lambda().orderByDesc(SaleQuotationEntity::getId);
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleQuotationPagination, new SaleQuotationListVO(), saleQuotationQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = saleQuotationPagination.getSidx();
                    SaleQuotationEntity saleQuotationEntity = new SaleQuotationEntity();
                    Field declaredField = saleQuotationEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    saleQuotationQueryWrapper = "asc".equals(saleQuotationPagination.getSort().toLowerCase()) ? (QueryWrapper)saleQuotationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleQuotationQueryWrapper.orderByDesc((Object)value);
                } else {
                    saleQuotationQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return saleQuotationQueryWrapper;
    }

    private Consumer<QueryWrapper<SaleQuotationEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<SaleQuotationEntity>>(){

            @Override
            public void accept(QueryWrapper<SaleQuotationEntity> saleQuotationQueryWrapper) {
                saleQuotationQueryWrapper.lambda().eq(SaleQuotationEntity::getCreatorUserId, (Object)userId);
            }
        };
    }

    @Override
    public List<SaleQuotationEntity> getTypeList(SaleQuotationPagination saleQuotationPagination, String dataType) {
        QueryWrapper<SaleQuotationEntity> saleQuotationQueryWrapper = this.appendWrapper(saleQuotationPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(saleQuotationPagination.getCurrentPage(), saleQuotationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationQueryWrapper);
            return saleQuotationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleQuotationQueryWrapper);
    }

    @Override
    public SaleQuotationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationEntity::getId, (Object)id);
        return (SaleQuotationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SaleQuotationInfoVO getDetailInfo(String id) {
        CrmCustomerEntity customer;
        SaleQuotationProfitEntity applyServiceInfo;
        SaleQuotationEntity entity = this.getInfo(id);
        SaleQuotationInfoVO vo = (SaleQuotationInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleQuotationInfoVO.class);
        vo.setMoneyUnitName(this.baseDataUtil.getDictName(vo.getMoneyUnit(), "moneyUnit"));
        if (!StrUtil.isBlank((CharSequence)vo.getQuotationProfitId()) && !StrUtil.isBlank((CharSequence)(applyServiceInfo = this.profitApplyService.getInfo(vo.getQuotationProfitId())).getCustomerId())) {
            CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(applyServiceInfo.getCustomerId());
            String customerName = ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "";
            vo.setQuotationProfitName(StrUtil.isBlank((CharSequence)vo.getSerialNumber()) ? customerName + " - " + this.baseDataUtil.userSelectValue(vo.getQuotationUser()) : vo.getSerialNumber() + " - " + this.baseDataUtil.userSelectValue(vo.getQuotationUser()));
        }
        vo.setProductName(this.crmProductService.getNameByIds(vo.getProductId()));
        vo.setProductTypeName(this.crmProductCategoryService.getNameByIds(vo.getProductType()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(vo.getCustomerId()))) {
            vo.setCustomerName(customer.getName());
        }
        vo.setGardeName(this.baseDataUtil.getDictName(vo.getGarde(), "CustomerGrade"));
        List<SaleQuotationEntity> listByOpportunity = this.getListByOpportunity(vo.getOpportunityId());
        if (ObjectUtil.isNotEmpty(listByOpportunity) && listByOpportunity.size() > 1) {
            vo.setHistoryQuotationFlag(true);
        }
        List<SaleQuotationModuleEntity> moduleEntityList = this.getSaleQuotationModuleList(id);
        List modelList = JsonUtil.getJsonToList(moduleEntityList, SaleQuotationModule.class);
        List<SaleQuotationProductEntity> productQuotationList = this.getSaleProductListById(id);
        List quotationTemplateModels1 = JsonUtil.getJsonToList(productQuotationList, SaleQuotationTemplateModel.class);
        ArrayList<SaleQuotationModule> softList = new ArrayList<SaleQuotationModule>();
        ArrayList<SaleQuotationModule> hardList = new ArrayList<SaleQuotationModule>();
        ArrayList<SaleQuotationModule> guaranteeList = new ArrayList<SaleQuotationModule>();
        ArrayList<SaleQuotationModule> customizationList = new ArrayList<SaleQuotationModule>();
        ArrayList<SaleQuotationModule> thirdList = new ArrayList<SaleQuotationModule>();
        ArrayList<SaleQuotationModule> otherList = new ArrayList<SaleQuotationModule>();
        if (ObjectUtil.isNotEmpty(moduleEntityList)) {
            SaleQuotationTemplateEntity quotationTemplateEntity = null;
            CrmProductCategoryEntity productCategory = null;
            for (SaleQuotationModule moduleEntity : modelList) {
                if (StringUtil.isNotEmpty((String)moduleEntity.getQuotationTemplateId()) && null != (quotationTemplateEntity = this.saleQuotationTemplateService.getInfo(moduleEntity.getQuotationTemplateId()))) {
                    moduleEntity.setTemplateName(quotationTemplateEntity.getTemplateName());
                }
                moduleEntity.setUnitName(this.baseDataUtil.getDictName(moduleEntity.getProductUnit(), "quotationModuleUnit"));
                if (StrUtil.isNotEmpty((CharSequence)moduleEntity.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(moduleEntity.getProductCategoryId()))) {
                    moduleEntity.setProductCategoryName(productCategory.getName());
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_SOFT)) {
                    softList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_HARD)) {
                    hardList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_GUARANTEE)) {
                    guaranteeList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_CUSTOMIZATION)) {
                    customizationList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_THIRD)) {
                    thirdList.add(moduleEntity);
                }
                if (!moduleEntity.getProductType().equals(QuotationConstants.MODULE_OTHER)) continue;
                otherList.add(moduleEntity);
            }
            List<SaleQuotationProductEntity> listByQuotationId = this.saleQuotationProductService.getListByQuotationId(entity.getId());
            List quotationTemplateModels = JsonUtil.getJsonToList(listByQuotationId, SaleQuotationTemplateModel.class);
            vo.setSaleQuotationTemplateModelList(quotationTemplateModels);
        }
        vo.setQuotationListSoft(softList);
        vo.setQuotationListHard(hardList);
        vo.setQuotationListCustomization(customizationList);
        vo.setQuotationListGuarantee(guaranteeList);
        vo.setThirdList(thirdList);
        vo.setOtherList(otherList);
        vo.setSaleQuotationTemplateModelList(quotationTemplateModels1);
        return vo;
    }

    @Override
    public List<SaleQuotationEntity> getListByOpportunity(String opportunity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationEntity::getOpportunityId, (Object)opportunity);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(SaleQuotationCrForm saleQuotationCrForm, String mainId) {
        List OaSaleQuotationModuleList;
        RkProjectReportingEntity reporting;
        UserInfo userInfo = this.userProvider.get();
        SaleQuotationEntity entity = (SaleQuotationEntity)JsonUtil.getJsonToBean((Object)saleQuotationCrForm, SaleQuotationEntity.class);
        entity.setId(mainId);
        entity.setCreatorCompanyId(userInfo.getOrganizeId());
        if (StrUtil.isNotEmpty((CharSequence)entity.getQuotationUser())) {
            UserEntity userEntity = this.userService.getInfo(entity.getQuotationUser());
            if (null != userEntity) {
                OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
                entity.setQuotationCompanyId(null != organizeEntity ? organizeEntity.getOrganizeId() : "");
            }
            entity.setQuotationUserName(this.baseDataUtil.userSelectValueNoAccount(entity.getQuotationUser()));
        }
        entity.setOriginalQuotationUser(entity.getQuotationUser());
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId()) && null != (reporting = this.rkProjectReportingService.getInfo(entity.getOpportunityId()))) {
            entity.setOpportunityName(reporting.getReportingProject());
        }
        this.save(entity);
        List saleQuotationTemplateModelList = JsonUtil.getJsonToList(saleQuotationCrForm.getSaleQuotationTemplateModelList(), SaleQuotationProductEntity.class);
        if (ObjectUtil.isNotEmpty((Object)saleQuotationTemplateModelList)) {
            for (SaleQuotationProductEntity entitys : saleQuotationTemplateModelList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuotationId(entity.getId());
                entitys.setCompanyId(entity.getCompanyId());
                entitys.setCreatorCompanyId(entity.getCreatorCompanyId());
                entitys.setQuotationCompanyId(entity.getQuotationCompanyId());
                this.saleQuotationProductService.save(entitys);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(OaSaleQuotationModuleList = JsonUtil.getJsonToList(saleQuotationCrForm.getOasalequotationList(), SaleQuotationModuleEntity.class)))) {
            for (SaleQuotationModuleEntity entitys : OaSaleQuotationModuleList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuotationId(entity.getId());
                entitys.setCompanyId(entity.getCompanyId());
                entitys.setCreatorCompanyId(entity.getCreatorCompanyId());
                entitys.setQuotationCompanyId(entity.getQuotationCompanyId());
                this.saleQuotationModuleService.save(entitys);
            }
        }
    }

    @Override
    public void update(String id, SaleQuotationUpForm saleQuotationUpForm) {
        SaleQuotationEntity entity = this.getInfo(id);
        if (entity != null) {
            RkProjectReportingEntity reporting;
            SaleQuotationEntity subentity = (SaleQuotationEntity)JsonUtil.getJsonToBean((Object)saleQuotationUpForm, SaleQuotationEntity.class);
            if (StrUtil.isNotEmpty((CharSequence)subentity.getQuotationUser())) {
                UserEntity userEntity = this.userService.getInfo(subentity.getQuotationUser());
                if (null != userEntity) {
                    OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
                    subentity.setQuotationCompanyId(null != organizeEntity ? organizeEntity.getOrganizeId() : "");
                }
                subentity.setQuotationUserName(this.baseDataUtil.userSelectValueNoAccount(subentity.getQuotationUser()));
            }
            if (StringUtils.isNotEmpty((String)entity.getOpportunityId()) && null != (reporting = this.rkProjectReportingService.getInfo(entity.getOpportunityId()))) {
                entity.setOpportunityName(reporting.getReportingProject());
            }
            this.updateById(subentity);
            QueryWrapper saleQuotationProductEntityQueryWrapper = new QueryWrapper();
            saleQuotationProductEntityQueryWrapper.lambda().eq(SaleQuotationProductEntity::getQuotationId, (Object)entity.getId());
            this.saleQuotationProductService.remove((Wrapper)saleQuotationProductEntityQueryWrapper);
            List saleQuotationTemplateModelList = JsonUtil.getJsonToList(saleQuotationUpForm.getSaleQuotationTemplateModelList(), SaleQuotationProductEntity.class);
            if (ObjectUtil.isNotEmpty((Object)saleQuotationTemplateModelList)) {
                for (SaleQuotationProductEntity entitys : saleQuotationTemplateModelList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setQuotationId(entity.getId());
                    entitys.setCompanyId(entity.getCompanyId());
                    entitys.setCreatorCompanyId(entity.getCreatorCompanyId());
                    entitys.setQuotationCompanyId(subentity.getQuotationCompanyId());
                    this.saleQuotationProductService.save(entitys);
                }
            }
            QueryWrapper OaSaleQuotationModulequeryWrapper = new QueryWrapper();
            OaSaleQuotationModulequeryWrapper.lambda().eq(SaleQuotationModuleEntity::getQuotationId, (Object)entity.getId());
            this.saleQuotationModuleService.remove((Wrapper)OaSaleQuotationModulequeryWrapper);
            List OaSaleQuotationModuleList = JsonUtil.getJsonToList(saleQuotationUpForm.getOasalequotationList(), SaleQuotationModuleEntity.class);
            for (SaleQuotationModuleEntity entitys : OaSaleQuotationModuleList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuotationId(entity.getId());
                entitys.setCompanyId(entity.getCompanyId());
                entitys.setCreatorCompanyId(entity.getCreatorCompanyId());
                entitys.setQuotationCompanyId(subentity.getQuotationCompanyId());
                this.saleQuotationModuleService.save(entitys);
            }
        }
    }

    @Override
    public void delete(SaleQuotationEntity entity) {
        if (entity != null) {
            List<SaleQuotationProductEntity> saleProductListById = this.getSaleProductListById(entity.getId());
            List<SaleQuotationModuleEntity> saleQuotationModuleList = this.getSaleQuotationModuleList(entity.getId());
            this.removeById((Serializable)((Object)entity.getId()));
            this.saleQuotationProductService.removeBatchByIds(saleProductListById);
            this.saleQuotationModuleService.removeBatchByIds(saleQuotationModuleList);
        }
    }

    @Override
    public List<SaleQuotationModuleEntity> getSaleQuotationModuleList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationModuleEntity::getQuotationId, (Object)id);
        return this.saleQuotationModuleService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleQuotationProductEntity> getSaleProductListById(String quotationId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationProductEntity::getQuotationId, (Object)quotationId);
        return this.saleQuotationProductService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleQuotationEntity> getListByProductId(String productId) {
        List<SaleQuotationProductEntity> listByProductId = this.saleQuotationProductService.getListByProductId(productId);
        if (listByProductId.isEmpty()) {
            return null;
        }
        List quotationIds = listByProductId.stream().map(SaleQuotationProductEntity::getQuotationId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(SaleQuotationEntity::getId, quotationIds);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleQuotationEntity> getListByProfitIdId(String profitId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationEntity::getQuotationProfitId, (Object)profitId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, BigDecimal> getQuotationProductAmount(String quotationId) {
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        List<SaleQuotationModuleEntity> saleQuotationModuleList = this.getSaleQuotationModuleList(quotationId);
        for (SaleQuotationModuleEntity module : saleQuotationModuleList) {
            if (!StringUtils.isNotEmpty((String)module.getProductId())) continue;
            amountMap.put(module.getProductId(), ConvertUtil.toBigDecimal(amountMap.get(module.getProductId()), (BigDecimal)BigDecimal.ZERO).add(ConvertUtil.toBigDecimal((Object)module.getPreferential(), (BigDecimal)BigDecimal.ZERO)));
        }
        return amountMap;
    }
}

