/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.quotation.constant.TemplateEnableMarkEnum;
import com.bringspring.quotation.entity.SaleQuotationTemplateEntity;
import com.bringspring.quotation.entity.SaleQuotationTemplateModuleEntity;
import com.bringspring.quotation.mapper.SaleQuotationTemplateMapper;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateCrForm;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateListVO;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplatePagination;
import com.bringspring.quotation.model.salequotationtemplate.SaleQuotationTemplateUpForm;
import com.bringspring.quotation.model.salequotationtemplatemodule.SaleQuotationTemplateModulePagination;
import com.bringspring.quotation.service.SaleQuotationTemplateModuleService;
import com.bringspring.quotation.service.SaleQuotationTemplateService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.utils.CustomizeSortWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleQuotationTemplateServiceImpl
extends ServiceImpl<SaleQuotationTemplateMapper, SaleQuotationTemplateEntity>
implements SaleQuotationTemplateService {
    Logger logger = LoggerFactory.getLogger(SaleQuotationTemplateServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleQuotationTemplateModuleService saleQuotationTemplateModuleService;

    @Override
    public List<SaleQuotationTemplateEntity> getList(SaleQuotationTemplatePagination saleQuotationTemplatePagination) {
        QueryWrapper<SaleQuotationTemplateEntity> saleQuotationTemplateQueryWrapper = this.appendWrapper(saleQuotationTemplatePagination);
        Page page = new Page(saleQuotationTemplatePagination.getCurrentPage(), saleQuotationTemplatePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationTemplateQueryWrapper);
        return saleQuotationTemplatePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleQuotationTemplateEntity> appendWrapper(SaleQuotationTemplatePagination saleQuotationTemplatePagination) {
        QueryWrapper saleQuotationTemplateQueryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleQuotationTemplatePagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object afterSalesQuestionObj = this.authorizeService.getCondition(new AuthorizeConditionModel(saleQuotationTemplateQueryWrapper, saleQuotationTemplatePagination.getMenuId(), "sale_quotation_template"));
            if (ObjectUtil.isEmpty((Object)afterSalesQuestionObj)) {
                saleQuotationTemplateQueryWrapper.and(this.defaultWrapper());
            } else {
                saleQuotationTemplateQueryWrapper = (QueryWrapper)afterSalesQuestionObj;
            }
        }
        saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getDeleteFlag, (Object)0);
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleQuotationTemplatePagination.getTemplateName()))) {
            saleQuotationTemplateQueryWrapper.lambda().like(SaleQuotationTemplateEntity::getTemplateName, (Object)StringUtils.trim((String)saleQuotationTemplatePagination.getTemplateName()));
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getProductId())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getProductId, (Object)saleQuotationTemplatePagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getProductCategoryId())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getProductCategoryId, (Object)saleQuotationTemplatePagination.getProductCategoryId());
        }
        if (CollectionUtil.isNotEmpty(saleQuotationTemplatePagination.getCreatorTime())) {
            List<String> creatorTimeList = saleQuotationTemplatePagination.getCreatorTime();
            Long fir = Long.valueOf(creatorTimeList.get(0));
            Long sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)saleQuotationTemplateQueryWrapper.lambda().ge(SaleQuotationTemplateEntity::getCreatorTime, (Object)new Date(fir))).le(SaleQuotationTemplateEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getCreatorUserId())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getCreatorUserId, (Object)saleQuotationTemplatePagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getEnabledMark())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getEnabledMark, (Object)saleQuotationTemplatePagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getCompanyId())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getCompanyId, (Object)saleQuotationTemplatePagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getUsingCompanyId())) {
            saleQuotationTemplateQueryWrapper.apply("FIND_IN_SET('" + saleQuotationTemplatePagination.getUsingCompanyId() + "', using_company_id)", new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)saleQuotationTemplatePagination.getHospitalLevel())) {
            saleQuotationTemplateQueryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.apply(" FIND_IN_SET(" + saleQuotationTemplatePagination.getHospitalLevel() + ",hospital_level)", new Object[0])).or()).apply(" hospital_level is null or hospital_level = ''", new Object[0]);
            });
        }
        if ("1".equals(saleQuotationTemplatePagination.getIsActive())) {
            saleQuotationTemplateQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(SaleQuotationTemplateEntity::getIsUnLimitUse, (Object)"1")).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(SaleQuotationTemplateEntity::getActiveStartTime, (Object)new Date())).ge(SaleQuotationTemplateEntity::getActiveEndTime, (Object)new Date());
                });
            });
        } else if ("0".equals(saleQuotationTemplatePagination.getIsActive())) {
            saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getIsUnLimitUse, (Object)"0");
            saleQuotationTemplateQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.gt(SaleQuotationTemplateEntity::getActiveStartTime, (Object)new Date())).or()).lt(SaleQuotationTemplateEntity::getActiveEndTime, (Object)new Date());
            });
        }
        if (StringUtils.isEmpty((String)saleQuotationTemplatePagination.getSidx())) {
            ((LambdaQueryWrapper)saleQuotationTemplateQueryWrapper.lambda().orderByAsc(SaleQuotationTemplateEntity::getEnabledMark)).orderByDesc(SaleQuotationTemplateEntity::getCreatorTime, (Object[])new SFunction[]{SaleQuotationTemplateEntity::getId});
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleQuotationTemplatePagination, new SaleQuotationTemplateListVO(), saleQuotationTemplateQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = saleQuotationTemplatePagination.getSidx();
                    SaleQuotationTemplateEntity saleQuotationTemplateEntity = new SaleQuotationTemplateEntity();
                    Field declaredField = saleQuotationTemplateEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    saleQuotationTemplateQueryWrapper = "asc".equals(saleQuotationTemplatePagination.getSort().toLowerCase()) ? (QueryWrapper)saleQuotationTemplateQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleQuotationTemplateQueryWrapper.orderByDesc((Object)value);
                } else {
                    saleQuotationTemplateQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return saleQuotationTemplateQueryWrapper;
    }

    private Consumer<QueryWrapper<SaleQuotationTemplateEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<SaleQuotationTemplateEntity>>(){

            @Override
            public void accept(QueryWrapper<SaleQuotationTemplateEntity> saleQuotationTemplateQueryWrapper) {
                saleQuotationTemplateQueryWrapper.lambda().eq(SaleQuotationTemplateEntity::getCreatorUserId, (Object)userId);
            }
        };
    }

    @Override
    public List<SaleQuotationTemplateEntity> getTypeList(SaleQuotationTemplatePagination saleQuotationTemplatePagination, String dataType) {
        QueryWrapper<SaleQuotationTemplateEntity> saleQuotationTemplateQueryWrapper = this.appendWrapper(saleQuotationTemplatePagination);
        if ("0".equals(dataType)) {
            Page page = new Page(saleQuotationTemplatePagination.getCurrentPage(), saleQuotationTemplatePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleQuotationTemplateQueryWrapper);
            return saleQuotationTemplatePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleQuotationTemplateQueryWrapper);
    }

    @Override
    public SaleQuotationTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationTemplateEntity::getId, (Object)id);
        return (SaleQuotationTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SaleQuotationTemplateCrForm saleQuotationTemplateCrForm) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        SaleQuotationTemplateEntity entity = (SaleQuotationTemplateEntity)JsonUtil.getJsonToBean((Object)saleQuotationTemplateCrForm, SaleQuotationTemplateEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDeleteFlag(0);
        if ("0".equals(saleQuotationTemplateCrForm.getState())) {
            entity.setEnabledMark(TemplateEnableMarkEnum.DRAFT.getEnableMark());
        } else {
            entity.setEnabledMark(TemplateEnableMarkEnum.ENABLE.getEnableMark());
        }
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorUserName(userInfo.getUserName());
        this.save(entity);
        List softModuleList = JsonUtil.getJsonToList(saleQuotationTemplateCrForm.getSoftModuleList(), SaleQuotationTemplateModuleEntity.class);
        for (SaleQuotationTemplateModuleEntity module : softModuleList) {
            module.setId(RandomUtil.uuId());
            module.setTemplateId(entity.getId());
            module.setProductId(entity.getProductId());
            module.setProductName(entity.getProductName());
            module.setHospitalLevel(entity.getHospitalLevel());
            module.setProductCategoryId(entity.getProductCategoryId());
            module.setModuleCategory("soft");
            module.setCompanyId(entity.getCompanyId());
            module.setDeleteFlag(entity.getDeleteFlag());
            module.setEnabledMark(entity.getEnabledMark());
            this.saleQuotationTemplateModuleService.save(module);
        }
        List hardModuleList = JsonUtil.getJsonToList(saleQuotationTemplateCrForm.getHardModuleList(), SaleQuotationTemplateModuleEntity.class);
        for (SaleQuotationTemplateModuleEntity module : hardModuleList) {
            module.setId(RandomUtil.uuId());
            module.setTemplateId(entity.getId());
            module.setProductId(entity.getProductId());
            module.setProductName(entity.getProductName());
            module.setHospitalLevel(entity.getHospitalLevel());
            module.setProductCategoryId(entity.getProductCategoryId());
            module.setModuleCategory("hard");
            module.setCompanyId(entity.getCompanyId());
            module.setDeleteFlag(entity.getDeleteFlag());
            module.setEnabledMark(entity.getEnabledMark());
            this.saleQuotationTemplateModuleService.save(module);
        }
    }

    @Override
    public void update(String id, SaleQuotationTemplateUpForm saleQuotationTemplateUpForm) {
        UserInfo userInfo = this.userProvider.get();
        SaleQuotationTemplateEntity entity = this.getInfo(id);
        if (entity != null) {
            SaleQuotationTemplateEntity subentity = (SaleQuotationTemplateEntity)JsonUtil.getJsonToBean((Object)saleQuotationTemplateUpForm, SaleQuotationTemplateEntity.class);
            subentity.setEnabledMark(entity.getEnabledMark());
            if ("1".equals(saleQuotationTemplateUpForm.getState()) && TemplateEnableMarkEnum.DRAFT.getEnableMark().equals(entity.getEnabledMark())) {
                subentity.setEnabledMark(TemplateEnableMarkEnum.ENABLE.getEnableMark());
            }
            this.updateById(subentity);
            this.saleQuotationTemplateModuleService.remove((Wrapper)new QueryWrapper().lambda().eq(SaleQuotationTemplateModuleEntity::getTemplateId, (Object)id));
            List softModuleList = JsonUtil.getJsonToList(saleQuotationTemplateUpForm.getSoftModuleList(), SaleQuotationTemplateModuleEntity.class);
            for (SaleQuotationTemplateModuleEntity module : softModuleList) {
                module.setTemplateId(entity.getId());
                module.setProductId(subentity.getProductId());
                module.setProductName(subentity.getProductName());
                module.setHospitalLevel(subentity.getHospitalLevel());
                module.setProductCategoryId(subentity.getProductCategoryId());
                module.setModuleCategory("soft");
                module.setCompanyId(entity.getCompanyId());
                module.setEnabledMark(subentity.getEnabledMark());
                if (StringUtils.isEmpty((String)module.getId())) {
                    module.setId(RandomUtil.uuId());
                }
                module.setDeleteFlag(entity.getDeleteFlag());
            }
            this.saleQuotationTemplateModuleService.saveBatch(softModuleList);
            List hardModuleList = JsonUtil.getJsonToList(saleQuotationTemplateUpForm.getHardModuleList(), SaleQuotationTemplateModuleEntity.class);
            for (SaleQuotationTemplateModuleEntity module : hardModuleList) {
                module.setTemplateId(entity.getId());
                module.setProductId(subentity.getProductId());
                module.setProductName(subentity.getProductName());
                module.setHospitalLevel(subentity.getHospitalLevel());
                module.setProductCategoryId(subentity.getProductCategoryId());
                module.setModuleCategory("hard");
                module.setCompanyId(entity.getCompanyId());
                module.setEnabledMark(subentity.getEnabledMark());
                if (StringUtils.isEmpty((String)module.getId())) {
                    module.setId(RandomUtil.uuId());
                }
                module.setDeleteFlag(entity.getDeleteFlag());
            }
            this.saleQuotationTemplateModuleService.saveBatch(hardModuleList);
        }
    }

    @Override
    public void delete(SaleQuotationTemplateEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<SaleQuotationTemplateModuleEntity> getSaleQuotationTemplateModuleList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getTemplateId, (Object)id);
        return this.saleQuotationTemplateModuleService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleQuotationTemplateModuleEntity> getModulelist(SaleQuotationTemplateModulePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getDeleteFlag, (Object)0);
        if (CollectionUtil.isNotEmpty(pagination.getTemplateIds())) {
            queryWrapper.lambda().in(SaleQuotationTemplateModuleEntity::getTemplateId, pagination.getTemplateIds());
        } else if (StringUtils.isNotEmpty((String)StringUtils.trim((String)pagination.getTemplateName()))) {
            List templateList;
            QueryWrapper templateWrapper = new QueryWrapper();
            templateWrapper.lambda().eq(SaleQuotationTemplateEntity::getDeleteFlag, (Object)0);
            if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
                templateWrapper.lambda().eq(SaleQuotationTemplateEntity::getEnabledMark, (Object)pagination.getEnabledMark());
            }
            templateWrapper.lambda().like(SaleQuotationTemplateEntity::getTemplateName, (Object)StringUtils.trim((String)pagination.getTemplateName()));
            if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
                templateWrapper.lambda().eq(SaleQuotationTemplateEntity::getCompanyId, (Object)pagination.getCompanyId());
            }
            if (CollectionUtil.isNotEmpty((Collection)(templateList = this.list((Wrapper)templateWrapper)))) {
                List templateIds = templateList.stream().map(SaleQuotationTemplateEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(SaleQuotationTemplateModuleEntity::getTemplateId, templateIds);
            } else {
                return new ArrayList<SaleQuotationTemplateModuleEntity>();
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)pagination.getModuleName()))) {
            queryWrapper.lambda().like(SaleQuotationTemplateModuleEntity::getModuleName, (Object)StringUtils.trim((String)pagination.getModuleName()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getProductId())) {
            queryWrapper.lambda().in(SaleQuotationTemplateModuleEntity::getProductId, Arrays.asList(pagination.getProductId().split(",")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getProductCategoryId())) {
            queryWrapper.lambda().in(SaleQuotationTemplateModuleEntity::getProductCategoryId, Arrays.asList(pagination.getProductCategoryId().split(",")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getModuleCategory())) {
            queryWrapper.lambda().eq(SaleQuotationTemplateModuleEntity::getModuleCategory, (Object)pagination.getModuleCategory());
        }
        if (StringUtils.isNotEmpty((String)pagination.getHospitalLevel())) {
            queryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.apply(" FIND_IN_SET(" + pagination.getHospitalLevel() + ",hospital_level)", new Object[0])).or()).apply(" hospital_level is null or hospital_level = ''", new Object[0]);
            });
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(SaleQuotationTemplateModuleEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                SaleQuotationTemplateModuleEntity entity = new SaleQuotationTemplateModuleEntity();
                Field declaredField = entity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.saleQuotationTemplateModuleService.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }
}

