/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.supplier.entity.SupplierChangeEntity;
import com.bringspring.supplier.entity.SupplierProductChangeEntity;
import com.bringspring.supplier.model.supplierchange.SupplierChangeCrForm;
import com.bringspring.supplier.model.supplierchange.SupplierChangeInfoVO;
import com.bringspring.supplier.model.supplierchange.SupplierChangeListVO;
import com.bringspring.supplier.model.supplierchange.SupplierChangePagination;
import com.bringspring.supplier.model.supplierchange.SupplierChangeUpForm;
import com.bringspring.supplier.model.supplierchange.SupplierProductChangeModel;
import com.bringspring.supplier.service.SupplierChangeService;
import com.bringspring.supplier.service.SupplierProductChangeService;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4"}, value="supplier")
@RequestMapping(value={"/api/supplier/SupplierChange"})
public class SupplierChangeController {
    private static final Logger log = LoggerFactory.getLogger(SupplierChangeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SupplierChangeService contractsupplierchangeService;
    @Autowired
    private SupplierProductChangeService supplierProductChangeService;
    @Autowired
    private SupplierService supplierService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SupplierChangePagination contractsupplierchangePagination) throws IOException {
        List<SupplierChangeEntity> list = this.contractsupplierchangeService.getList(contractsupplierchangePagination);
        for (SupplierChangeEntity supplierChangeEntity : list) {
            supplierChangeEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(supplierChangeEntity.getCreatorUserId()));
            supplierChangeEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(supplierChangeEntity.getLastModifyUserId()));
            supplierChangeEntity.setSupplierId(this.supplierService.getInfo(supplierChangeEntity.getSupplierId()).getSupplierName());
            supplierChangeEntity.setChangeContent(this.baseDataUtil.getDictName(supplierChangeEntity.getChangeContent(), "507474965977633029"));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierChangeListVO.class);
        for (SupplierChangeListVO supplierChangeListVO : listVO) {
        }
        for (SupplierChangeListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)contractsupplierchangePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        SupplierChangeCrForm contractsupplierchangeCrForm = (SupplierChangeCrForm)((Object)JsonUtil.getJsonToBean(crData, SupplierChangeCrForm.class));
        String flowEngineId = "507448943886471365";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        contractsupplierchangeCrForm.setCreatorUserId(userInfo.getUserId());
        contractsupplierchangeCrForm.setCreatorTime(DateUtil.getNow());
        SupplierChangeEntity entity = (SupplierChangeEntity)JsonUtil.getJsonToBean((Object)((Object)contractsupplierchangeCrForm), SupplierChangeEntity.class);
        entity.setId(mainId);
        this.contractsupplierchangeService.save(entity);
        List ContractSupplierProductChangeList = JsonUtil.getJsonToList(contractsupplierchangeCrForm.getContractsupplierproductchangeList(), SupplierProductChangeEntity.class);
        for (SupplierProductChangeEntity entitys : ContractSupplierProductChangeList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSupplierChangeId(entity.getId());
            this.supplierProductChangeService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)contractsupplierchangeCrForm.getTaskId(), (String)flowEngineId, (String)contractsupplierchangeCrForm.getTemplateId(), (String)mainId, (Object)entity, (Integer)contractsupplierchangeCrForm.getStatus(), (String)contractsupplierchangeCrForm.getSupplierName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SupplierChangeInfoVO> info(@PathVariable(value="id") String id) {
        SupplierChangeEntity entity = this.contractsupplierchangeService.getInfo(id);
        SupplierChangeInfoVO vo = (SupplierChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierChangeInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        List<SupplierProductChangeEntity> ContractSupplierProductChangeList = this.contractsupplierchangeService.GetContractSupplierProductChangeList(id);
        for (SupplierProductChangeEntity supplierProductChangeEntity : ContractSupplierProductChangeList) {
        }
        vo.setContractsupplierproductchangeList(JsonUtil.getJsonToList(ContractSupplierProductChangeList, SupplierProductChangeModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        SupplierChangeUpForm contractsupplierchangeUpForm = (SupplierChangeUpForm)((Object)JsonUtil.getJsonToBean(upData, SupplierChangeUpForm.class));
        String flowEngineId = "507448943886471365";
        UserInfo userInfo = this.userProvider.get();
        SupplierChangeEntity entity = this.contractsupplierchangeService.getInfo(id);
        if (entity != null) {
            contractsupplierchangeUpForm.setLastModifyUserId(userInfo.getUserId());
            contractsupplierchangeUpForm.setLastModifyTime(DateUtil.getNow());
            SupplierChangeEntity subentity = (SupplierChangeEntity)JsonUtil.getJsonToBean((Object)((Object)contractsupplierchangeUpForm), SupplierChangeEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.contractsupplierchangeService.update(id, subentity);
            QueryWrapper ContractSupplierProductChangequeryWrapper = new QueryWrapper();
            ContractSupplierProductChangequeryWrapper.lambda().eq(SupplierProductChangeEntity::getSupplierChangeId, (Object)entity.getId());
            this.supplierProductChangeService.remove((Wrapper)ContractSupplierProductChangequeryWrapper);
            List ContractSupplierProductChangeList = JsonUtil.getJsonToList(contractsupplierchangeUpForm.getContractsupplierproductchangeList(), SupplierProductChangeEntity.class);
            for (SupplierProductChangeEntity entitys : ContractSupplierProductChangeList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSupplierChangeId(entity.getId());
                this.supplierProductChangeService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)contractsupplierchangeUpForm.getTaskId(), (String)flowEngineId, (String)contractsupplierchangeUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)contractsupplierchangeUpForm.getStatus(), (String)contractsupplierchangeUpForm.getSupplierName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SupplierChangeEntity entity = this.contractsupplierchangeService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.contractsupplierchangeService.delete(entity);
            QueryWrapper queryWrapperContractSupplierProductChange = new QueryWrapper();
            queryWrapperContractSupplierProductChange.lambda().eq(SupplierProductChangeEntity::getSupplierChangeId, (Object)entity.getId());
            this.supplierProductChangeService.remove((Wrapper)queryWrapperContractSupplierProductChange);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

