/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.entity.SupplierProductEntity;
import com.bringspring.supplier.model.supplier.SupplierCrForm;
import com.bringspring.supplier.model.supplier.SupplierExportModel;
import com.bringspring.supplier.model.supplier.SupplierImportReturnVO;
import com.bringspring.supplier.model.supplier.SupplierImportVO;
import com.bringspring.supplier.model.supplier.SupplierInfoVO;
import com.bringspring.supplier.model.supplier.SupplierListVO;
import com.bringspring.supplier.model.supplier.SupplierPagination;
import com.bringspring.supplier.model.supplier.SupplierProductModel;
import com.bringspring.supplier.model.supplier.SupplierUpForm;
import com.bringspring.supplier.service.SupplierProductService;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u4fe1\u606f"}, value="com/bringspring/supplier/supplier")
@RequestMapping(value={"/api/supplier/supplier"})
public class SupplierController {
    private static final Logger log = LoggerFactory.getLogger(SupplierController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private SupplierProductService supplierProductService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SupplierPagination supplierPagination) throws IOException {
        List<SupplierEntity> list = this.supplierService.getList(supplierPagination);
        for (SupplierEntity supplierEntity : list) {
            supplierEntity.setSupplierUserId(this.baseDataUtil.userSelectValues(supplierEntity.getSupplierUserId()));
            supplierEntity.setAgencyQualificationUrl(this.baseDataUtil.getFileNameInJson(supplierEntity.getAgencyQualificationUrl()));
            supplierEntity.setLetterCommitmentIntegrity(this.baseDataUtil.getFileNameInJson(supplierEntity.getLetterCommitmentIntegrity()));
            supplierEntity.setSupplierQuestionary(this.baseDataUtil.getFileNameInJson(supplierEntity.getSupplierQuestionary()));
            supplierEntity.setEnvironmentalCertification(this.baseDataUtil.getFileNameInJson(supplierEntity.getEnvironmentalCertification()));
            supplierEntity.setOtherUrl(this.baseDataUtil.getFileNameInJson(supplierEntity.getOtherUrl()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierListVO.class);
        for (SupplierListVO supplierListVO : listVO) {
        }
        for (SupplierListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)supplierPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid SupplierCrForm supplierCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "489036358656984133";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        supplierCrForm.setCreatorTime(DateUtil.getNow());
        supplierCrForm.setSupplierUserId(userInfo.getUserId());
        supplierCrForm.setCode(this.baseDataUtil.getBillNumber("SupplierEvaluationForm", Boolean.valueOf(false)));
        SupplierEntity entity = (SupplierEntity)JsonUtil.getJsonToBean((Object)((Object)supplierCrForm), SupplierEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setSupplierUseState("1");
        this.supplierService.save(entity);
        List Crm_supperli_productList = JsonUtil.getJsonToList(supplierCrForm.getSupplierProductList(), SupplierProductEntity.class);
        for (SupplierProductEntity entitys : Crm_supperli_productList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSupplierId(entity.getId());
            this.supplierProductService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)supplierCrForm.getTaskId(), (String)flowEngineId, (String)supplierCrForm.getTemplateId(), (String)mainId, (Object)((Object)supplierCrForm), (Integer)supplierCrForm.getStatus(), (String)supplierCrForm.getSupplierName());
        if (supplierCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @PostMapping(value={"/createOrUpdate"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult createOrUpdate(@RequestBody @Valid SupplierUpForm supplierCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "489036358656984133";
        UserInfo userInfo = this.userProvider.get();
        supplierCrForm.setCreatorTime(DateUtil.getNow());
        supplierCrForm.setSupplierUserId(userInfo.getUserId());
        supplierCrForm.setCode(this.baseDataUtil.getBillNumber("SupplierEvaluationForm", Boolean.valueOf(false)));
        SupplierEntity entity = (SupplierEntity)JsonUtil.getJsonToBean((Object)((Object)supplierCrForm), SupplierEntity.class);
        if (StrUtil.isEmpty((CharSequence)supplierCrForm.getId())) {
            String mainId = RandomUtil.uuId();
            entity.setId(mainId);
            entity.setCompanyId(userInfo.getOrganizeId());
            entity.setSupplierUseState("1");
            entity.setEnabledMark("complete");
        } else {
            QueryWrapper Crm_supperli_productqueryWrapper = new QueryWrapper();
            Crm_supperli_productqueryWrapper.lambda().eq(SupplierProductEntity::getSupplierId, (Object)entity.getId());
            this.supplierProductService.remove((Wrapper)Crm_supperli_productqueryWrapper);
            SupplierEntity subEntity = this.supplierService.getInfo(supplierCrForm.getId());
            entity.setCompanyId(subEntity.getCompanyId());
            entity.setSupplierUseState("1");
            entity.setEnabledMark("complete");
        }
        this.supplierService.saveOrUpdate(entity);
        List Crm_supperli_productList = JsonUtil.getJsonToList(supplierCrForm.getSupplierProductList(), SupplierProductEntity.class);
        for (SupplierProductEntity entitys : Crm_supperli_productList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSupplierId(entity.getId());
            this.supplierProductService.save(entitys);
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SupplierInfoVO> info(@PathVariable(value="id") String id) {
        SupplierEntity entity = this.supplierService.getInfo(id);
        SupplierInfoVO vo = (SupplierInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
            vo.setSupplierUserName(this.baseDataUtil.userSelectValue(entity.getSupplierUserId()));
        }
        List<SupplierProductEntity> SupplierProductList = this.supplierService.GetSupplierProductList(id);
        for (SupplierProductEntity supplierProductEntity : SupplierProductList) {
        }
        vo.setSupplierProductList(JsonUtil.getJsonToList(SupplierProductList, SupplierProductModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getInfoByCodeOrId/{id}"})
    public ActionResult<SupplierInfoVO> getInfoByCodeOrId(@PathVariable(value="id") String id) {
        List<SupplierEntity> entityList = this.supplierService.getInfoByCodeOrId(id);
        if (CollectionUtil.isNotEmpty(entityList)) {
            SupplierEntity entity = entityList.get(0);
            SupplierInfoVO vo = (SupplierInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierInfoVO.class);
            if (vo.getCreatorTime() != null) {
                vo.setCreatorTime(vo.getCreatorTime());
                vo.setSupplierUserName(this.baseDataUtil.userSelectValue(entity.getSupplierUserId()));
            }
            List<SupplierProductEntity> SupplierProductList = this.supplierService.GetSupplierProductList(id);
            for (SupplierProductEntity supplierProductEntity : SupplierProductList) {
            }
            vo.setSupplierProductList(JsonUtil.getJsonToList(SupplierProductList, SupplierProductModel.class));
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success((Object)new SupplierInfoVO());
    }

    @GetMapping(value={"/getInfoByName/{name}"})
    public ActionResult getInfoByName(@PathVariable(value="name") String name) {
        List<SupplierEntity> entity = this.supplierService.getInfoByName(name);
        if (CollectionUtil.isNotEmpty(entity)) {
            return ActionResult.success(entity);
        }
        return ActionResult.success(new ArrayList());
    }

    @GetMapping(value={"/detailInfo/{id}"})
    public ActionResult<SupplierInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SupplierEntity entity = this.supplierService.getInfo(id);
        SupplierInfoVO vo = (SupplierInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
            vo.setSupplierUserName(this.baseDataUtil.userSelectValue(entity.getSupplierUserId()));
            vo.setInvoiceContent(this.baseDataUtil.getDictName(vo.getInvoiceContent(), "InvoiceContents"));
            vo.setSupplierInvoice(this.baseDataUtil.getDictName(vo.getSupplierInvoice(), "supplierInvoice"));
        }
        List<SupplierProductEntity> SupplierProductList = this.supplierService.GetSupplierProductList(id);
        for (SupplierProductEntity supplierProductEntity : SupplierProductList) {
        }
        vo.setSupplierProductList(JsonUtil.getJsonToList(SupplierProductList, SupplierProductModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SupplierUpForm crmSupplierUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "489036358656984133";
        SupplierEntity entity = this.supplierService.getInfo(id);
        if (entity != null) {
            SupplierEntity subentity = (SupplierEntity)JsonUtil.getJsonToBean((Object)((Object)crmSupplierUpForm), SupplierEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setSupplierUseState("1");
            this.supplierService.update(id, subentity);
            QueryWrapper Crm_supperli_productqueryWrapper = new QueryWrapper();
            Crm_supperli_productqueryWrapper.lambda().eq(SupplierProductEntity::getSupplierId, (Object)entity.getId());
            this.supplierProductService.remove((Wrapper)Crm_supperli_productqueryWrapper);
            List Crm_supperli_productList = JsonUtil.getJsonToList(crmSupplierUpForm.getSupplierProductList(), SupplierProductEntity.class);
            for (SupplierProductEntity entitys : Crm_supperli_productList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSupplierId(entity.getId());
                this.supplierProductService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)crmSupplierUpForm.getTaskId(), (String)flowEngineId, (String)crmSupplierUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)crmSupplierUpForm.getStatus(), (String)crmSupplierUpForm.getSupplierName());
            if (crmSupplierUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SupplierEntity entity = this.supplierService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.supplierService.delete(entity);
            QueryWrapper queryWrapperCrm_supperli_product = new QueryWrapper();
            queryWrapperCrm_supperli_product.lambda().eq(SupplierProductEntity::getSupplierId, (Object)entity.getId());
            this.supplierProductService.remove((Wrapper)queryWrapperCrm_supperli_product);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u4f9b\u5e94\u5546\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u4f9b\u5e94\u5546\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List ImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, SupplierImportVO.class);
        if (CollectionUtil.isEmpty((Collection)ImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ImportList.size() > 3000) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.supplierService.importPreview(ImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<SupplierImportReturnVO> ImportData(@RequestBody SupplierImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), SupplierImportVO.class);
        SupplierImportReturnVO result = this.supplierService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody SupplierImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.supplierService.exportExceptionData(dataList, new SupplierImportVO());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SupplierExportModel SupplierExportModel2) throws IOException {
        if (StringUtil.isEmpty((String)SupplierExportModel2.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SupplierPagination rkMaterialPagination = (SupplierPagination)((Object)JsonUtil.getJsonToBean((Object)SupplierExportModel2, SupplierPagination.class));
        List<SupplierEntity> list = this.supplierService.getTypeList(rkMaterialPagination, SupplierExportModel2.getDataType());
        List stateList = this.dictionaryDataService.getDicList("502408478342516037");
        List haveList = this.dictionaryDataService.getDicList("535107685771651461");
        List isList = this.dictionaryDataService.getDicList("535107783545072005");
        List invoiceList = this.dictionaryDataService.getDicList("502437400539041093");
        List supplierInvoiceList = this.dictionaryDataService.getDicList("502409336077684037");
        for (SupplierEntity supplierEntity : list) {
            supplierEntity.setSupplierUserId(this.baseDataUtil.userSelectValue(supplierEntity.getSupplierUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierInfoVO.class);
        for (SupplierInfoVO supplierInfoVO : listVO) {
            List invoiceDataList;
            String temp;
            int i;
            StringBuilder resInvoice;
            JSONArray jsonArray;
            List haveEnvironmentalCertificationList;
            List haveAgencyQualificationList;
            List isSpecifiedList;
            List isAffiliatedCompanyList;
            List riskOfDishonestyList;
            List taxPayerList;
            List havePaidInCapitalList;
            List haveNumberOfInsuredList;
            List stateOneList = stateList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getSupplierState())).collect(Collectors.toList());
            if (!stateOneList.isEmpty()) {
                supplierInfoVO.setSupplierState(((DictionaryDataEntity)stateOneList.get(0)).getFullName());
            }
            if (!(haveNumberOfInsuredList = haveList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getHaveNumberOfInsured())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setHaveNumberOfInsured(((DictionaryDataEntity)haveNumberOfInsuredList.get(0)).getFullName());
            }
            if (!(havePaidInCapitalList = haveList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getHavePaidInCapital())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setHavePaidInCapital(((DictionaryDataEntity)havePaidInCapitalList.get(0)).getFullName());
            }
            if (!(taxPayerList = isList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getSupplierTaxpayer())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setSupplierTaxpayer(((DictionaryDataEntity)taxPayerList.get(0)).getFullName());
            }
            if (!(riskOfDishonestyList = isList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getRiskOfDishonesty())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setRiskOfDishonesty(((DictionaryDataEntity)riskOfDishonestyList.get(0)).getFullName());
            }
            if (!(isAffiliatedCompanyList = isList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getIsAffiliatedCompany())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setIsAffiliatedCompany(((DictionaryDataEntity)isAffiliatedCompanyList.get(0)).getFullName());
            }
            if (!(isSpecifiedList = isList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getIsSpecified())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setIsSpecified(((DictionaryDataEntity)isSpecifiedList.get(0)).getFullName());
            }
            if (!(haveAgencyQualificationList = haveList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getHaveAgencyQualification())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setHaveAgencyQualification(((DictionaryDataEntity)haveAgencyQualificationList.get(0)).getFullName());
            }
            if (!(haveEnvironmentalCertificationList = haveList.stream().filter(b -> b.getEnCode().equals(supplierInfoVO.getHaveEnvironmentalCertification())).collect(Collectors.toList())).isEmpty()) {
                supplierInfoVO.setHaveEnvironmentalCertification(((DictionaryDataEntity)haveEnvironmentalCertificationList.get(0)).getFullName());
            }
            if (StringUtils.isNotEmpty((String)supplierInfoVO.getSupplierInvoice())) {
                jsonArray = JSONArray.parseArray((String)supplierInfoVO.getSupplierInvoice());
                resInvoice = new StringBuilder();
                for (i = 0; i < jsonArray.size(); ++i) {
                    temp = jsonArray.getString(i);
                    invoiceDataList = supplierInvoiceList.stream().filter(b -> b.getEnCode().equals(temp)).collect(Collectors.toList());
                    if (invoiceDataList.isEmpty()) continue;
                    resInvoice.append(((DictionaryDataEntity)invoiceDataList.get(0)).getFullName()).append(";");
                }
                supplierInfoVO.setSupplierInvoice(resInvoice.toString());
            }
            if (!StringUtils.isNotEmpty((String)supplierInfoVO.getInvoiceContent())) continue;
            jsonArray = JSONArray.parseArray((String)supplierInfoVO.getInvoiceContent());
            resInvoice = new StringBuilder();
            for (i = 0; i < jsonArray.size(); ++i) {
                temp = jsonArray.getString(i);
                invoiceDataList = invoiceList.stream().filter(b -> b.getEnCode().equals(temp)).collect(Collectors.toList());
                if (invoiceDataList.isEmpty()) continue;
                resInvoice.append(((DictionaryDataEntity)invoiceDataList.get(0)).getFullName()).append(";");
            }
            supplierInfoVO.setInvoiceContent(resInvoice.toString());
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)SupplierExportModel2.getSelectKey()) ? SupplierExportModel2.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block76: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "supplierUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u7528\u6237", (Object)"supplierUserId"));
                        continue block76;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block76;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u7f16\u53f7", (Object)"code"));
                        continue block76;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block76;
                    }
                    case "unifiedSocialCreditCode": {
                        entitys.add(new ExcelExportEntity("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (Object)"unifiedSocialCreditCode"));
                        continue block76;
                    }
                    case "corporate": {
                        entitys.add(new ExcelExportEntity("\u6cd5\u5b9a\u4ee3\u8868\u4eba", (Object)"corporate"));
                        continue block76;
                    }
                    case "registeredCapital": {
                        entitys.add(new ExcelExportEntity("\u6ce8\u518c\u8d44\u672c(\u5143)", (Object)"registeredCapital"));
                        continue block76;
                    }
                    case "dateOincorporation": {
                        entitys.add(new ExcelExportEntity("\u6210\u7acb\u65e5\u671f", (Object)"dateOincorporation"));
                        continue block76;
                    }
                    case "supplierState": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u72b6\u6001", (Object)"supplierState"));
                        continue block76;
                    }
                    case "haveNumberOfInsured": {
                        entitys.add(new ExcelExportEntity("\u6709\u65e0\u53c2\u4fdd", (Object)"haveNumberOfInsured"));
                        continue block76;
                    }
                    case "numberOfInsured": {
                        entitys.add(new ExcelExportEntity("\u53c2\u4fdd\u4eba\u6570", (Object)"numberOfInsured"));
                        continue block76;
                    }
                    case "havePaidInCapital": {
                        entitys.add(new ExcelExportEntity("\u6709\u65e0\u5b9e\u7f34\u8d44\u672c", (Object)"havePaidInCapital"));
                        continue block76;
                    }
                    case "paidInCapital": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u7f34\u8d44\u672c(\u5143)", (Object)"paidInCapital"));
                        continue block76;
                    }
                    case "businessScope": {
                        entitys.add(new ExcelExportEntity("\u8425\u4e1a\u8303\u56f4", (Object)"businessScope"));
                        continue block76;
                    }
                    case "supplierTaxpayer": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u4e00\u822c\u7eb3\u7a0e\u4eba", (Object)"supplierTaxpayer"));
                        continue block76;
                    }
                    case "supplierInvoice": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u79cd\u7c7b", (Object)"supplierInvoice"));
                        continue block76;
                    }
                    case "supplierBank": {
                        entitys.add(new ExcelExportEntity("\u57fa\u672c\u6237\u5f00\u6237\u7f51\u70b9", (Object)"supplierBank"));
                        continue block76;
                    }
                    case "supplierAccount": {
                        entitys.add(new ExcelExportEntity("\u94f6\u884c\u5361\u53f7", (Object)"supplierAccount"));
                        continue block76;
                    }
                    case "riskOfDishonesty": {
                        entitys.add(new ExcelExportEntity("\u4f01\u67e5\u67e5\u662f\u5426\u663e\u793a\u6709\u5931\u4fe1\u98ce\u9669", (Object)"riskOfDishonesty"));
                        continue block76;
                    }
                    case "invoiceContent": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u5185\u5bb9", (Object)"invoiceContent"));
                        continue block76;
                    }
                    case "supplierLevel": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u7ea7\u522b", (Object)"supplierLevel"));
                        continue block76;
                    }
                    case "supplierContacts": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"supplierContacts"));
                        continue block76;
                    }
                    case "supplierJob": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u804c\u4f4d", (Object)"supplierJob"));
                        continue block76;
                    }
                    case "telephone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"telephone"));
                        continue block76;
                    }
                    case "isAffiliatedCompany": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u8363\u79d1\u5173\u8054\u516c\u53f8", (Object)"isAffiliatedCompany"));
                        continue block76;
                    }
                    case "isSpecified": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u5ba2\u6237\u6307\u5b9a\u4f9b\u5e94\u5546", (Object)"isSpecified"));
                        continue block76;
                    }
                    case "supplierScore": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u8bc4\u4ef7\u5206\u6570", (Object)"supplierScore"));
                        continue block76;
                    }
                    case "supplierNote": {
                        entitys.add(new ExcelExportEntity("\u5176\u4ed6\u8bf4\u660e", (Object)"supplierNote"));
                        continue block76;
                    }
                    case "haveAgencyQualification": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62e5\u6709\u4ee3\u7406\u8d44\u8d28", (Object)"haveAgencyQualification"));
                        continue block76;
                    }
                    case "agencyQualificationContent": {
                        entitys.add(new ExcelExportEntity("\u4ee3\u7406\u8d44\u8d28\u5185\u5bb9", (Object)"agencyQualificationContent"));
                        continue block76;
                    }
                    case "haveEnvironmentalCertification": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62e5\u6709\u73af\u4fdd\u8bc1\u4e66", (Object)"haveEnvironmentalCertification"));
                        continue block76;
                    }
                    case "environmentalCertificationContent": {
                        entitys.add(new ExcelExportEntity("\u73af\u4fdd\u8bc1\u4e66\u5185\u5bb9", (Object)"environmentalCertificationContent"));
                        continue block76;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

