/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.supplier.entity.SupplierEvaluationEntity;
import com.bringspring.supplier.entity.SupplierEvaluationIndicatorEntity;
import com.bringspring.supplier.entity.SupplierEvaluationTemplateEntity;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationCrForm;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationIndicatorModel;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationInfoVO;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationListVO;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationPagination;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationPaginationExportModel;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationUpForm;
import com.bringspring.supplier.service.SupplierEvaluationIndicatorService;
import com.bringspring.supplier.service.SupplierEvaluationService;
import com.bringspring.supplier.service.SupplierEvaluationTemplateService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u8bc4\u4ef7\u8868"}, value="")
@RequestMapping(value={"/api/supplier/supplierevaluation"})
public class SupplierEvaluationController {
    private static final Logger log = LoggerFactory.getLogger(SupplierEvaluationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SupplierEvaluationService supplierevaluationService;
    @Autowired
    private SupplierEvaluationIndicatorService SupplierEvaluationIndicatorService;
    @Autowired
    private SupplierEvaluationTemplateService supplierEvaluationTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SupplierEvaluationPagination supplierevaluationPagination) throws IOException {
        supplierevaluationPagination.setCompanyId(this.userProvider.get().getOrganizeId());
        List<SupplierEvaluationEntity> list = this.supplierevaluationService.getList(supplierevaluationPagination);
        for (SupplierEvaluationEntity supplierEvaluationEntity : list) {
            supplierEvaluationEntity.setCgy(this.baseDataUtil.userSelectValue(supplierEvaluationEntity.getCgy()));
            supplierEvaluationEntity.setXmjl(this.baseDataUtil.userSelectValues(supplierEvaluationEntity.getXmjl()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierEvaluationListVO.class);
        for (SupplierEvaluationListVO supplierEvaluationListVO : listVO) {
        }
        for (SupplierEvaluationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)supplierevaluationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid SupplierEvaluationCrForm supplierevaluationCrForm) throws DataException, WorkFlowException {
        List SupplierEvaluationIndicatorBuyerList;
        String flowEngineId = "487575954290377221";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        supplierevaluationCrForm.setCgy(userInfo.getUserId());
        supplierevaluationCrForm.setEvaluationTime(DateUtil.getNow());
        supplierevaluationCrForm.setFormId(this.baseDataUtil.getBillNumber("SupplierEvaluationForm", Boolean.valueOf(false)));
        SupplierEvaluationEntity entity = (SupplierEvaluationEntity)JsonUtil.getJsonToBean((Object)((Object)supplierevaluationCrForm), SupplierEvaluationEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDateOfIncorporation(supplierevaluationCrForm.getDateOfIncorporation());
        this.supplierevaluationService.save(entity);
        if (StrUtil.isNotEmpty((CharSequence)supplierevaluationCrForm.getXmjl())) {
            List<String> projectManager = Arrays.asList(supplierevaluationCrForm.getXmjl().split(","));
            List<SupplierEvaluationTemplateEntity> tList = this.supplierEvaluationTemplateService.getByTypeList("manager");
            for (String manager : projectManager) {
                List SupplierEvaluationIndicatorList = JsonUtil.getJsonToList(tList, SupplierEvaluationIndicatorEntity.class);
                SupplierEvaluationIndicatorList.stream().forEach(a -> {
                    a.setId(RandomUtil.uuId());
                    a.setParentId(entity.getId());
                    a.setEvaluationType("manager");
                    a.setEvaluatorUser(this.baseDataUtil.userSelectValues(manager));
                    a.setEvaluatorUserId(manager);
                });
                this.SupplierEvaluationIndicatorService.saveBatch(SupplierEvaluationIndicatorList);
            }
        }
        if ((SupplierEvaluationIndicatorBuyerList = JsonUtil.getJsonToList(supplierevaluationCrForm.getSupplierEvaluationIndicatorBuyerList(), SupplierEvaluationIndicatorEntity.class)) != null) {
            for (SupplierEvaluationIndicatorEntity entitys : SupplierEvaluationIndicatorBuyerList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                entitys.setEvaluationType("buyer");
                entitys.setEvaluatorUser(userInfo.getRealName());
                this.SupplierEvaluationIndicatorService.save(entitys);
            }
        }
        FlowUtil.saveOrSubmit((String)supplierevaluationCrForm.getTaskId(), (String)flowEngineId, (String)supplierevaluationCrForm.getTemplateId(), (String)mainId, (Object)entity, (Integer)supplierevaluationCrForm.getStatus(), (String)supplierevaluationCrForm.getSupplierName());
        if (supplierevaluationCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u4f9b\u5e94\u5546\u8bc4\u4ef7\u8868.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u4f9b\u5e94\u5546\u8bc4\u4ef7\u8868.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SupplierEvaluationPaginationExportModel supplierevaluationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)supplierevaluationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SupplierEvaluationPagination supplierevaluationPagination = (SupplierEvaluationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)supplierevaluationPaginationExportModel), SupplierEvaluationPagination.class));
        List<SupplierEvaluationEntity> list = this.supplierevaluationService.getTypeList(supplierevaluationPagination, supplierevaluationPaginationExportModel.getDataType());
        for (SupplierEvaluationEntity supplierEvaluationEntity : list) {
            supplierEvaluationEntity.setCgy(this.baseDataUtil.userSelectValue(supplierEvaluationEntity.getCgy()));
            supplierEvaluationEntity.setXmjl(this.baseDataUtil.userSelectValues(supplierEvaluationEntity.getXmjl()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierEvaluationListVO.class);
        for (SupplierEvaluationListVO supplierEvaluationListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)supplierevaluationPaginationExportModel.getSelectKey()) ? supplierevaluationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "cgy": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"cgy"));
                        continue block44;
                    }
                    case "evaluationTime": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u65f6\u95f4", (Object)"evaluationTime"));
                        continue block44;
                    }
                    case "formId": {
                        entitys.add(new ExcelExportEntity("\u5355\u636e\u53f7", (Object)"formId"));
                        continue block44;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block44;
                    }
                    case "paidInCapital": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u7f34\u8d44\u672c(\u4e07)", (Object)"paidInCapital"));
                        continue block44;
                    }
                    case "dateOfIncorporation": {
                        entitys.add(new ExcelExportEntity("\u6210\u7acb\u65e5\u671f", (Object)"dateOfIncorporation"));
                        continue block44;
                    }
                    case "numberOcollaborations": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u5468\u671f\u5185\u5408\u4f5c\u6b21\u6570", (Object)"numberOcollaborations"));
                        continue block44;
                    }
                    case "cooperationAmount": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u5468\u671f\u5185\u5408\u4f5c\u91d1\u989d\uff08\u4e07\uff09", (Object)"cooperationAmount"));
                        continue block44;
                    }
                    case "evaluationTimeStart": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u5f00\u59cb\u65f6\u95f4", (Object)"evaluationTimeStart"));
                        continue block44;
                    }
                    case "evaluationTimeEnd": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u7ed3\u675f\u65f6\u95f4", (Object)"evaluationTimeEnd"));
                        continue block44;
                    }
                    case "isItBlacklisted": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5217\u5165\u9ed1\u540d\u5355", (Object)"isItBlacklisted"));
                        continue block44;
                    }
                    case "explanationOreasons": {
                        entitys.add(new ExcelExportEntity("\u4e8b\u7531\u8bf4\u660e", (Object)"explanationOreasons"));
                        continue block44;
                    }
                    case "totalScore": {
                        entitys.add(new ExcelExportEntity("\u5408\u8ba1\u5f97\u5206", (Object)"totalScore"));
                        continue block44;
                    }
                    case "evaluationLevel": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u7b49\u7ea7", (Object)"evaluationLevel"));
                        continue block44;
                    }
                    case "suggestionsForImprovement": {
                        entitys.add(new ExcelExportEntity("\u6539\u8fdb\u5efa\u8bae", (Object)"suggestionsForImprovement"));
                        continue block44;
                    }
                    case "xmjl": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"xmjl"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SupplierEvaluationInfoVO> info(@PathVariable(value="id") String id) {
        SupplierEvaluationEntity entity = this.supplierevaluationService.getInfo(id);
        SupplierEvaluationInfoVO vo = (SupplierEvaluationInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierEvaluationInfoVO.class);
        vo.setCgy(this.baseDataUtil.userSelectValue(vo.getCgy()));
        vo.setDateOfIncorporation(entity.getDateOfIncorporation());
        if (vo.getEvaluationTime() != null) {
            vo.setEvaluationTime(vo.getEvaluationTime());
        }
        List<SupplierEvaluationIndicatorEntity> supplierEvaluationIndicatorList = this.supplierevaluationService.GetSupplierEvaluationIndicatorList(id);
        List managerList = supplierEvaluationIndicatorList.stream().filter(a -> StrUtil.equals((CharSequence)a.getEvaluationType(), (CharSequence)"manager")).collect(Collectors.toList());
        List buyerList = supplierEvaluationIndicatorList.stream().filter(a -> StrUtil.equals((CharSequence)a.getEvaluationType(), (CharSequence)"buyer")).collect(Collectors.toList());
        vo.setSupplierEvaluationIndicatorList(JsonUtil.getJsonToList(managerList, SupplierEvaluationIndicatorModel.class));
        vo.setSupplierEvaluationIndicatorBuyerList(JsonUtil.getJsonToList(buyerList, SupplierEvaluationIndicatorModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SupplierEvaluationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SupplierEvaluationEntity entity = this.supplierevaluationService.getInfo(id);
        SupplierEvaluationInfoVO vo = (SupplierEvaluationInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierEvaluationInfoVO.class);
        List<SupplierEvaluationIndicatorEntity> supplierEvaluationIndicatorList = this.supplierevaluationService.GetSupplierEvaluationIndicatorList(id);
        List managerList = supplierEvaluationIndicatorList.stream().filter(a -> StrUtil.equals((CharSequence)a.getEvaluationType(), (CharSequence)"manager")).collect(Collectors.toList());
        List buyerList = supplierEvaluationIndicatorList.stream().filter(a -> StrUtil.equals((CharSequence)a.getEvaluationType(), (CharSequence)"buyer")).collect(Collectors.toList());
        vo.setSupplierEvaluationIndicatorList(JsonUtil.getJsonToList(managerList, SupplierEvaluationIndicatorModel.class));
        vo.setSupplierEvaluationIndicatorBuyerList(JsonUtil.getJsonToList(buyerList, SupplierEvaluationIndicatorModel.class));
        vo.setCgy(this.baseDataUtil.userSelectValue(vo.getCgy()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SupplierEvaluationUpForm supplierevaluationUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "487575954290377221";
        UserInfo userInfo = this.userProvider.get();
        SupplierEvaluationEntity entity = this.supplierevaluationService.getInfo(id);
        if (entity != null) {
            List SupplierEvaluationIndicatorBuyerList;
            SupplierEvaluationEntity subentity = (SupplierEvaluationEntity)JsonUtil.getJsonToBean((Object)((Object)supplierevaluationUpForm), SupplierEvaluationEntity.class);
            subentity.setDateOfIncorporation(supplierevaluationUpForm.getDateOfIncorporation());
            subentity.setCgy(entity.getCgy());
            subentity.setEvaluationTime(entity.getEvaluationTime());
            this.supplierevaluationService.update(id, subentity);
            QueryWrapper SupplierEvaluationIndicatorqueryWrapper = new QueryWrapper();
            SupplierEvaluationIndicatorqueryWrapper.lambda().eq(SupplierEvaluationIndicatorEntity::getParentId, (Object)entity.getId());
            this.SupplierEvaluationIndicatorService.remove((Wrapper)SupplierEvaluationIndicatorqueryWrapper);
            if (StrUtil.isNotEmpty((CharSequence)supplierevaluationUpForm.getXmjl())) {
                List<String> projectManager = Arrays.asList(supplierevaluationUpForm.getXmjl().split(","));
                List<SupplierEvaluationTemplateEntity> tList = this.supplierEvaluationTemplateService.getByTypeList("manager");
                List templateCover = JsonUtil.getJsonToList(tList, SupplierEvaluationIndicatorEntity.class);
                List SupplierEvaluationIndicatorList = JsonUtil.getJsonToList(supplierevaluationUpForm.getSupplierEvaluationIndicatorList(), SupplierEvaluationIndicatorEntity.class);
                for (String manager : projectManager) {
                    List onePerson = SupplierEvaluationIndicatorList.stream().filter(a -> a.getEvaluatorUserId().equals(manager)).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(onePerson)) {
                        for (SupplierEvaluationIndicatorEntity entitys : onePerson) {
                            entitys.setParentId(entity.getId());
                            entitys.setEvaluationType("manager");
                            entitys.setEvaluatorUser(this.baseDataUtil.userSelectValues(manager));
                            entitys.setEvaluatorUserId(manager);
                            this.SupplierEvaluationIndicatorService.saveOrUpdate(entitys);
                        }
                        continue;
                    }
                    for (SupplierEvaluationIndicatorEntity entitys : templateCover) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setParentId(entity.getId());
                        entitys.setEvaluationType("manager");
                        entitys.setEvaluatorUser(this.baseDataUtil.userSelectValues(manager));
                        entitys.setEvaluatorUserId(manager);
                        this.SupplierEvaluationIndicatorService.save(entitys);
                    }
                }
            }
            if ((SupplierEvaluationIndicatorBuyerList = JsonUtil.getJsonToList(supplierevaluationUpForm.getSupplierEvaluationIndicatorBuyerList(), SupplierEvaluationIndicatorEntity.class)) != null) {
                for (SupplierEvaluationIndicatorEntity entitys : SupplierEvaluationIndicatorBuyerList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setParentId(entity.getId());
                    entitys.setEvaluationType("buyer");
                    entitys.setEvaluatorUser(this.baseDataUtil.userSelectValue(entity.getCgy()));
                    this.SupplierEvaluationIndicatorService.save(entitys);
                }
            }
            FlowUtil.saveOrSubmit((String)supplierevaluationUpForm.getTaskId(), (String)flowEngineId, (String)supplierevaluationUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)supplierevaluationUpForm.getStatus(), (String)supplierevaluationUpForm.getSupplierName());
            if (supplierevaluationUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SupplierEvaluationEntity entity = this.supplierevaluationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.supplierevaluationService.delete(entity);
            QueryWrapper SupplierEvaluationIndicatorqueryWrapper = new QueryWrapper();
            SupplierEvaluationIndicatorqueryWrapper.lambda().eq(SupplierEvaluationIndicatorEntity::getParentId, (Object)entity.getId());
            this.SupplierEvaluationIndicatorService.remove((Wrapper)SupplierEvaluationIndicatorqueryWrapper);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

