/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.supplier.entity.SupplierEvaluationTemplateEntity;
import com.bringspring.supplier.model.supplierEvaluationTemplate.SupplierEvaluationTemplateCrForm;
import com.bringspring.supplier.model.supplierEvaluationTemplate.SupplierEvaluationTemplateInfoVO;
import com.bringspring.supplier.model.supplierEvaluationTemplate.SupplierEvaluationTemplateListVO;
import com.bringspring.supplier.model.supplierEvaluationTemplate.SupplierEvaluationTemplatePagination;
import com.bringspring.supplier.model.supplierEvaluationTemplate.SupplierEvaluationTemplateUpForm;
import com.bringspring.supplier.service.SupplierEvaluationTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u8bc4\u4ef7\u6a21\u677f"}, value="supplier")
@RequestMapping(value={"/api/supplier/SupplierEvaluationTemplate"})
public class SupplierEvaluationTemplateController {
    private static final Logger log = LoggerFactory.getLogger(SupplierEvaluationTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SupplierEvaluationTemplateService supplierEvaluationTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SupplierEvaluationTemplatePagination supplierEvaluationTemplatePagination) throws IOException {
        List<SupplierEvaluationTemplateEntity> list = this.supplierEvaluationTemplateService.getList(supplierEvaluationTemplatePagination);
        for (SupplierEvaluationTemplateEntity supplierEvaluationTemplateEntity : list) {
            supplierEvaluationTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(supplierEvaluationTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierEvaluationTemplateListVO.class);
        for (SupplierEvaluationTemplateListVO supplierEvaluationTemplateListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)supplierEvaluationTemplatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/listByType"})
    public ActionResult listByType(@RequestBody SupplierEvaluationTemplatePagination supplierEvaluationTemplatePagination) throws IOException {
        List<SupplierEvaluationTemplateEntity> list = this.supplierEvaluationTemplateService.getTypeList(supplierEvaluationTemplatePagination, "1");
        for (SupplierEvaluationTemplateEntity supplierEvaluationTemplateEntity : list) {
            supplierEvaluationTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(supplierEvaluationTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, SupplierEvaluationTemplateListVO.class);
        for (SupplierEvaluationTemplateListVO supplierEvaluationTemplateListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)supplierEvaluationTemplatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid SupplierEvaluationTemplateCrForm supplierEvaluationTemplateCrForm) throws DataException {
        this.supplierEvaluationTemplateService.create(supplierEvaluationTemplateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SupplierEvaluationTemplateInfoVO> info(@PathVariable(value="id") String id) {
        SupplierEvaluationTemplateEntity entity = this.supplierEvaluationTemplateService.getInfo(id);
        SupplierEvaluationTemplateInfoVO vo = (SupplierEvaluationTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierEvaluationTemplateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SupplierEvaluationTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SupplierEvaluationTemplateEntity entity = this.supplierEvaluationTemplateService.getInfo(id);
        SupplierEvaluationTemplateInfoVO vo = (SupplierEvaluationTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, SupplierEvaluationTemplateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SupplierEvaluationTemplateUpForm supplierEvaluationTemplateUpForm) throws DataException {
        this.supplierEvaluationTemplateService.update(id, supplierEvaluationTemplateUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        SupplierEvaluationTemplateEntity entity = this.supplierEvaluationTemplateService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(0);
            this.supplierEvaluationTemplateService.updateById(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

