/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.entity.SupplierEvaluationEntity;
import com.bringspring.supplier.entity.SupplierEvaluationIndicatorEntity;
import com.bringspring.supplier.mapper.SupplierEvaluationMapper;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationPagination;
import com.bringspring.supplier.model.supplierevaluation.SupplierEvaluationUpForm;
import com.bringspring.supplier.service.SupplierEvaluationIndicatorService;
import com.bringspring.supplier.service.SupplierEvaluationService;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierEvaluationServiceImpl
extends ServiceImpl<SupplierEvaluationMapper, SupplierEvaluationEntity>
implements SupplierEvaluationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SupplierEvaluationIndicatorService supplierEvaluationIndicatorService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SupplierService supplierService;

    @Override
    public List<SupplierEvaluationEntity> getList(SupplierEvaluationPagination supplierevaluationPagination) {
        Object supplierevaluationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int supplierevaluationNum = 0;
        QueryWrapper supplierevaluationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            supplierevaluationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(supplierevaluationQueryWrapper, supplierevaluationPagination.getMenuId(), "supplierevaluation"));
            if (ObjectUtil.isEmpty((Object)supplierevaluationObj)) {
                return new ArrayList<SupplierEvaluationEntity>();
            }
            supplierevaluationQueryWrapper = (QueryWrapper)supplierevaluationObj;
            ++supplierevaluationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            supplierevaluationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(supplierevaluationQueryWrapper, supplierevaluationPagination.getMenuId(), "supplierevaluation"));
            if (ObjectUtil.isEmpty((Object)supplierevaluationObj)) {
                return new ArrayList<SupplierEvaluationEntity>();
            }
            supplierevaluationQueryWrapper = (QueryWrapper)supplierevaluationObj;
            ++supplierevaluationNum;
        }
        if (StringUtils.isNotEmpty((String)supplierevaluationPagination.getCompanyId())) {
            ++supplierevaluationNum;
            supplierevaluationQueryWrapper.lambda().eq(SupplierEvaluationEntity::getCompanyId, (Object)supplierevaluationPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)supplierevaluationPagination.getSupplierName())) {
            ++supplierevaluationNum;
            supplierevaluationQueryWrapper.lambda().like(SupplierEvaluationEntity::getSupplierName, (Object)supplierevaluationPagination.getSupplierName());
        }
        if (AllIdList.size() > 0) {
            supplierevaluationQueryWrapper.lambda().in(SupplierEvaluationEntity::getId, AllIdList);
        }
        supplierevaluationQueryWrapper.lambda().eq(SupplierEvaluationEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (StringUtils.isEmpty((String)supplierevaluationPagination.getSidx())) {
            supplierevaluationQueryWrapper.lambda().orderByDesc(SupplierEvaluationEntity::getEvaluationTime);
        } else {
            try {
                String sidx = supplierevaluationPagination.getSidx();
                SupplierEvaluationEntity supplierevaluationEntity = new SupplierEvaluationEntity();
                Field declaredField = supplierevaluationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                supplierevaluationQueryWrapper = "asc".equals(supplierevaluationPagination.getSort().toLowerCase()) ? (QueryWrapper)supplierevaluationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)supplierevaluationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(supplierevaluationPagination.getCurrentPage(), supplierevaluationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)supplierevaluationQueryWrapper);
            return supplierevaluationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return supplierevaluationPagination.setData(list, list.size());
    }

    @Override
    public List<SupplierEvaluationEntity> getTypeList(SupplierEvaluationPagination supplierevaluationPagination, String dataType) {
        Object supplierevaluationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int supplierevaluationNum = 0;
        QueryWrapper supplierevaluationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            supplierevaluationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(supplierevaluationQueryWrapper, supplierevaluationPagination.getMenuId(), "supplierevaluation"));
            if (ObjectUtil.isEmpty((Object)supplierevaluationObj)) {
                return new ArrayList<SupplierEvaluationEntity>();
            }
            supplierevaluationQueryWrapper = (QueryWrapper)supplierevaluationObj;
            ++supplierevaluationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            supplierevaluationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(supplierevaluationQueryWrapper, supplierevaluationPagination.getMenuId(), "supplierevaluation"));
            if (ObjectUtil.isEmpty((Object)supplierevaluationObj)) {
                return new ArrayList<SupplierEvaluationEntity>();
            }
            supplierevaluationQueryWrapper = (QueryWrapper)supplierevaluationObj;
            ++supplierevaluationNum;
        }
        if (StringUtils.isNotEmpty((String)supplierevaluationPagination.getSupplierName())) {
            ++supplierevaluationNum;
            supplierevaluationQueryWrapper.lambda().like(SupplierEvaluationEntity::getSupplierName, (Object)supplierevaluationPagination.getSupplierName());
        }
        supplierevaluationQueryWrapper.lambda().eq(SupplierEvaluationEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (AllIdList.size() > 0) {
            supplierevaluationQueryWrapper.lambda().in(SupplierEvaluationEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)supplierevaluationPagination.getSidx())) {
            supplierevaluationQueryWrapper.lambda().orderByDesc(SupplierEvaluationEntity::getEvaluationTime);
        } else {
            try {
                String sidx = supplierevaluationPagination.getSidx();
                SupplierEvaluationEntity supplierevaluationEntity = new SupplierEvaluationEntity();
                Field declaredField = supplierevaluationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                supplierevaluationQueryWrapper = "asc".equals(supplierevaluationPagination.getSort().toLowerCase()) ? (QueryWrapper)supplierevaluationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)supplierevaluationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(supplierevaluationPagination.getCurrentPage(), supplierevaluationPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)supplierevaluationQueryWrapper);
                return supplierevaluationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return supplierevaluationPagination.setData(list, list.size());
        }
        return this.list((Wrapper)supplierevaluationQueryWrapper);
    }

    @Override
    public SupplierEvaluationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SupplierEvaluationEntity::getId, (Object)id);
        return (SupplierEvaluationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SupplierEvaluationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, SupplierEvaluationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(SupplierEvaluationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<SupplierEvaluationIndicatorEntity> GetSupplierEvaluationIndicatorList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SupplierEvaluationIndicatorEntity::getParentId, (Object)id);
        return this.supplierEvaluationIndicatorService.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) throws NoSuchFieldException, IllegalAccessException {
        UserInfo userInfo = this.userProvider.get();
        SupplierEvaluationEntity entity = this.getInfo(id);
        if (entity != null) {
            List SupplierEvaluationIndicatorBuyerList;
            SupplierEvaluationUpForm supplierevaluationUpForm = (SupplierEvaluationUpForm)((Object)JsonUtil.getJsonToBean((Object)model.getFormData(), SupplierEvaluationUpForm.class));
            SupplierEvaluationEntity subentity = (SupplierEvaluationEntity)JsonUtil.getJsonToBean((Object)((Object)supplierevaluationUpForm), SupplierEvaluationEntity.class);
            subentity.setDateOfIncorporation(supplierevaluationUpForm.getDateOfIncorporation());
            subentity.setCgy(entity.getCgy());
            subentity.setXmjl(entity.getXmjl());
            subentity.setEvaluationTime(entity.getEvaluationTime());
            QueryWrapper SupplierEvaluationIndicatorqueryWrapper = new QueryWrapper();
            SupplierEvaluationIndicatorqueryWrapper.lambda().eq(SupplierEvaluationIndicatorEntity::getParentId, (Object)entity.getId());
            this.supplierEvaluationIndicatorService.remove((Wrapper)SupplierEvaluationIndicatorqueryWrapper);
            BigDecimal totalScore = new BigDecimal("0.00");
            List SupplierEvaluationIndicatorList = JsonUtil.getJsonToList(supplierevaluationUpForm.getSupplierEvaluationIndicatorList(), SupplierEvaluationIndicatorEntity.class);
            if (SupplierEvaluationIndicatorList != null) {
                for (Object entitys : SupplierEvaluationIndicatorList) {
                    ((SupplierEvaluationIndicatorEntity)entitys).setId(RandomUtil.uuId());
                    ((SupplierEvaluationIndicatorEntity)entitys).setParentId(entity.getId());
                    ((SupplierEvaluationIndicatorEntity)entitys).setEvaluationType("manager");
                    ((SupplierEvaluationIndicatorEntity)entitys).setEvaluatorUser(this.baseDataUtil.userSelectValues(((SupplierEvaluationIndicatorEntity)entitys).getEvaluatorUserId()));
                    this.supplierEvaluationIndicatorService.save(entitys);
                    if (!ObjectUtil.isNotEmpty((Object)((SupplierEvaluationIndicatorEntity)entitys).getIndicatorScore())) continue;
                    totalScore.add(BigDecimal.valueOf(((SupplierEvaluationIndicatorEntity)entitys).getIndicatorScore()));
                }
            }
            if ((SupplierEvaluationIndicatorBuyerList = JsonUtil.getJsonToList(supplierevaluationUpForm.getSupplierEvaluationIndicatorBuyerList(), SupplierEvaluationIndicatorEntity.class)) != null) {
                for (SupplierEvaluationIndicatorEntity entitys : SupplierEvaluationIndicatorBuyerList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setParentId(entity.getId());
                    entitys.setEvaluationType("buyer");
                    entitys.setEvaluatorUser(this.baseDataUtil.userSelectValue(entity.getCgy()));
                    this.supplierEvaluationIndicatorService.save(entitys);
                    if (!ObjectUtil.isNotEmpty((Object)entitys.getIndicatorScore())) continue;
                    totalScore.add(BigDecimal.valueOf(entitys.getIndicatorScore()));
                }
            }
            subentity.setTotalScore(totalScore);
            if (totalScore.compareTo(new BigDecimal("90")) > 0) {
                subentity.setEvaluationLevel("\u4f18\u79c0");
            } else if (totalScore.compareTo(new BigDecimal("70")) > 0) {
                subentity.setEvaluationLevel("\u6ee1\u610f");
            } else if (totalScore.compareTo(new BigDecimal("60")) > 0) {
                subentity.setEvaluationLevel("\u5408\u683c\u4f46\u9700\u6539\u8fdb");
            } else {
                subentity.setEvaluationLevel("\u4e0d\u5408\u683c");
            }
            this.update(id, subentity);
            SupplierEntity supplier = this.supplierService.getInfo(entity.getSupplierId());
            if (ObjectUtil.isNotEmpty((Object)supplier)) {
                supplier.setSupplierScore(totalScore.toString());
                this.supplierService.updateById(supplier);
            }
        }
        return true;
    }
}

