/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.supplier.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.entity.SupplierProductEntity;
import com.bringspring.supplier.mapper.SupplierMapper;
import com.bringspring.supplier.model.supplier.SupplierImportReturnVO;
import com.bringspring.supplier.model.supplier.SupplierImportVO;
import com.bringspring.supplier.model.supplier.SupplierPagination;
import com.bringspring.supplier.service.SupplierProductService;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.supplier.utils.SupplierEncodeEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierServiceImpl
extends ServiceImpl<SupplierMapper, SupplierEntity>
implements SupplierService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SupplierProductService supplierProductService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<SupplierEntity> getList(SupplierPagination crmSupplierPagination) {
        Object crmSupplierObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmSupplierNum = 0;
        QueryWrapper crmSupplierQueryWrapper = new QueryWrapper();
        boolean crmSupperliProductNum = false;
        QueryWrapper crmSupperliProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmSupplierObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupplierQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supplier"));
            if (ObjectUtil.isEmpty((Object)crmSupplierObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupplierQueryWrapper = (QueryWrapper)crmSupplierObj;
            ++crmSupplierNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmSupplierObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupplierQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supplier"));
            if (ObjectUtil.isEmpty((Object)crmSupplierObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupplierQueryWrapper = (QueryWrapper)crmSupplierObj;
            ++crmSupplierNum;
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierLevel())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierLevel, (Object)crmSupplierPagination.getSupplierLevel());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierName())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().like(SupplierEntity::getSupplierName, (Object)crmSupplierPagination.getSupplierName());
        }
        if (CollectionUtil.isNotEmpty(crmSupplierPagination.getEnabledMark())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().in(SupplierEntity::getEnabledMark, crmSupplierPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierState())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierState, (Object)crmSupplierPagination.getSupplierState());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierUseState())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierUseState, (Object)crmSupplierPagination.getSupplierUseState());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmSupplierPagination.getIsEnvironmental())) {
            ++crmSupplierNum;
            if (StrUtil.equals((CharSequence)crmSupplierPagination.getIsEnvironmental(), (CharSequence)"S")) {
                crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getHaveEnvironmentalCertification, (Object)crmSupplierPagination.getIsEnvironmental());
            } else {
                crmSupplierQueryWrapper.lambda().ne(SupplierEntity::getHaveEnvironmentalCertification, (Object)"S");
            }
        }
        if (StringUtils.isNotEmpty(crmSupplierPagination.getCreatorTime())) {
            List<String> CreatorTimeList = crmSupplierPagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)crmSupplierQueryWrapper.lambda().ge(SupplierEntity::getCreatorTime, (Object)new Date(fir))).le(SupplierEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StrUtil.isNotEmpty((CharSequence)crmSupplierPagination.getCompanyId())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getCompanyId, (Object)crmSupplierPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(crmSupplierPagination.getCompanyIdList())) {
            crmSupplierQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w1 -> {
                w1.apply("find_in_set('" + crmSupplierPagination.getCompanyIdList().get(0) + "',company_id)", new Object[0]);
                for (int i = 1; i < crmSupplierPagination.getCompanyIdList().size(); ++i) {
                    ((LambdaQueryWrapper)w1.or()).apply("find_in_set('" + crmSupplierPagination.getCompanyIdList().get(i) + "',company_id)", new Object[0]);
                }
            })).or(w2 -> w2.in(SupplierEntity::getCompanyId, crmSupplierPagination.getCompanyIdList())));
        }
        if (AllIdList.size() > 0) {
            crmSupplierQueryWrapper.lambda().in(SupplierEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmSupplierPagination.getSidx())) {
            crmSupplierQueryWrapper.lambda().orderByDesc(SupplierEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmSupplierPagination.getSidx();
                SupplierEntity crmSupplierEntity = new SupplierEntity();
                Field declaredField = crmSupplierEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmSupplierQueryWrapper = "asc".equals(crmSupplierPagination.getSort().toLowerCase()) ? (QueryWrapper)crmSupplierQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmSupplierQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmSupplierPagination.getCurrentPage(), crmSupplierPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmSupplierQueryWrapper);
            return crmSupplierPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmSupplierPagination.setData(list, list.size());
    }

    @Override
    public List<SupplierEntity> getTypeList(SupplierPagination crmSupplierPagination, String dataType) {
        Object crmSupperliProductObj;
        Object crmSupplierObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmSupplierNum = 0;
        QueryWrapper crmSupplierQueryWrapper = new QueryWrapper();
        int crmSupperliProductNum = 0;
        QueryWrapper crmSupperliProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmSupplierObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupplierQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supplier"));
            if (ObjectUtil.isEmpty((Object)crmSupplierObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupplierQueryWrapper = (QueryWrapper)crmSupplierObj;
            ++crmSupplierNum;
            crmSupperliProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupperliProductQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supperli_product"));
            if (ObjectUtil.isEmpty((Object)crmSupperliProductObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupperliProductQueryWrapper = (QueryWrapper)crmSupperliProductObj;
            ++crmSupperliProductNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmSupplierObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupplierQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supplier"));
            if (ObjectUtil.isEmpty((Object)crmSupplierObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupplierQueryWrapper = (QueryWrapper)crmSupplierObj;
            ++crmSupplierNum;
            crmSupperliProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmSupperliProductQueryWrapper, crmSupplierPagination.getMenuId(), "crm_supperli_product"));
            if (ObjectUtil.isEmpty((Object)crmSupperliProductObj)) {
                return new ArrayList<SupplierEntity>();
            }
            crmSupperliProductQueryWrapper = (QueryWrapper)crmSupperliProductObj;
            ++crmSupperliProductNum;
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierLevel())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierLevel, (Object)crmSupplierPagination.getSupplierLevel());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierName())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().like(SupplierEntity::getSupplierName, (Object)crmSupplierPagination.getSupplierName());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierState())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierState, (Object)crmSupplierPagination.getSupplierState());
        }
        if (StringUtils.isNotEmpty((String)crmSupplierPagination.getSupplierUseState())) {
            ++crmSupplierNum;
            crmSupplierQueryWrapper.lambda().eq(SupplierEntity::getSupplierUseState, (Object)crmSupplierPagination.getSupplierUseState());
        }
        if (AllIdList.size() > 0) {
            crmSupplierQueryWrapper.lambda().in(SupplierEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmSupplierPagination.getSidx())) {
            crmSupplierQueryWrapper.lambda().orderByDesc(SupplierEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmSupplierPagination.getSidx();
                SupplierEntity crmSupplierEntity = new SupplierEntity();
                Field declaredField = crmSupplierEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmSupplierQueryWrapper = "asc".equals(crmSupplierPagination.getSort().toLowerCase()) ? (QueryWrapper)crmSupplierQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmSupplierQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmSupplierPagination.getCurrentPage(), crmSupplierPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmSupplierQueryWrapper);
                return crmSupplierPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmSupplierPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmSupplierQueryWrapper);
    }

    @Override
    public SupplierEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SupplierEntity::getId, (Object)id);
        return (SupplierEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SupplierEntity> getInfoByName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(SupplierEntity::getSupplierName, (Object)name);
        queryWrapper.lambda().eq(SupplierEntity::getEnabledMark, (Object)"complete");
        queryWrapper.last("limit 20");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SupplierEntity> getInfoByCodeOrId(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(SupplierEntity::getId, (Object)name)).or()).eq(SupplierEntity::getCode, (Object)name)).or()).eq(SupplierEntity::getUnifiedSocialCreditCode, (Object)name);
        });
        queryWrapper.lambda().eq(SupplierEntity::getEnabledMark, (Object)"complete");
        queryWrapper.last("limit 20");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(SupplierEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, SupplierEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        SupplierEntity entity = this.getInfo(id);
        entity.setEnabledMark(String.valueOf(enableMark));
        entity.setEnabledMark("complete");
        return this.updateById(entity);
    }

    @Override
    public void delete(SupplierEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<SupplierProductEntity> GetSupplierProductList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SupplierProductEntity::getSupplierId, (Object)id);
        return this.supplierProductService.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> importPreview(List<SupplierImportVO> ImportList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < ImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            SupplierImportVO ImportVO = ImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)ImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= ImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", ImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u4f9b\u5e94\u5546\u7f16\u7801");
        map.put(2, "\u4f9b\u5e94\u5546\u540d\u79f0");
        map.put(3, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
        map.put(4, "\u6cd5\u4eba\u4ee3\u8868");
        map.put(5, "\u6ce8\u518c\u8d44\u672c");
        map.put(6, "\u6210\u7acb\u65e5\u671f");
        map.put(7, "\u7ecf\u8425\u72b6\u6001");
        map.put(8, "\u6709\u65e0\u53c2\u4fdd");
        map.put(9, "\u53c2\u4fdd\u4eba\u6570");
        map.put(10, "\u6709\u65e0\u5b9e\u7f34\u8d44\u672c");
        map.put(11, "\u5b9e\u7f34\u8d44\u672c");
        map.put(12, "\u8425\u4e1a\u8303\u56f4");
        map.put(13, "\u662f\u5426\u4e3a\u4e00\u822c\u7eb3\u7a0e\u4eba");
        map.put(14, "\u53d1\u7968\u79cd\u7c7b");
        map.put(15, "\u57fa\u672c\u6237\u5f00\u6237\u7f51\u70b9");
        map.put(16, "\u94f6\u884c\u5361\u53f7");
        map.put(17, "\u4f01\u67e5\u67e5\u662f\u5426\u663e\u793a\u6709\u5931\u4fe1\u98ce\u9669");
        map.put(18, "\u53d1\u7968\u5185\u5bb9");
        map.put(19, "\u4f9b\u5e94\u5546\u7ea7\u522b");
        map.put(20, "\u8054\u7cfb\u4eba");
        map.put(21, "\u8054\u7cfb\u4eba\u804c\u4f4d");
        map.put(22, "\u8054\u7cfb\u4eba\u7535\u8bdd");
        map.put(23, "\u662f\u5426\u4e3a\u8363\u79d1\u5173\u8054\u516c\u53f8");
        map.put(24, "\u662f\u5426\u4e3a\u5ba2\u6237\u6307\u5b9a\u4f9b\u5e94\u5546");
        map.put(25, "\u662f\u5426\u62e5\u6709\u4ee3\u7406\u8d44\u8d28");
        map.put(26, "\u662f\u5426\u62e5\u6709\u73af\u4fdd\u8bc1\u4e66");
        map.put(27, "\u5176\u5b83\u8bf4\u660e");
        return (String)map.get(key);
    }

    @Override
    public SupplierImportReturnVO importData(List<SupplierImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List<SupplierEncodeEnum> allToList = SupplierEncodeEnum.getAllToList();
        allToList.stream().forEach(fileEncodeEnum -> {
            String encode = fileEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
            dictMap.put(encode, collect);
        });
        List supplierList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (SupplierImportVO ImportVO : dataList) {
            String s;
            String s2;
            Map stringStringMap;
            if (StringUtil.isNotEmpty((String)ImportVO.getSupplierName())) {
                ImportVO.setSupplierName(StrUtil.trim((CharSequence)ImportVO.getSupplierName()));
                if (CollectionUtil.isNotEmpty(this.getListByName(ImportVO.getSupplierName()))) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u4f9b\u5e94\u5546\u540d\u79f0\u91cd\u590d");
                    errorMsgList.add(ImportVO.getErrMsg());
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u8bf7\u586b\u5199\u4f9b\u5e94\u5546\u540d\u79f0");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            String supplierState = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getSupplierState())) {
                Map stringStringMap2 = (Map)dictMap.get(SupplierEncodeEnum.SUPPLIER_STATE_DICT.getEncode());
                String s3 = (String)stringStringMap2.get(ImportVO.getSupplierState());
                if (StrUtil.isEmpty((CharSequence)s3)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u7ecf\u8425\u72b6\u6001\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    supplierState = s3;
                }
            }
            String haveNumberOfInsured = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getHaveNumberOfInsured())) {
                Map stringStringMap3 = (Map)dictMap.get(SupplierEncodeEnum.NUMBER_INSURED_DICT.getEncode());
                String s4 = (String)stringStringMap3.get(ImportVO.getHaveNumberOfInsured());
                if (StrUtil.isEmpty((CharSequence)s4)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u6709\u65e0\u53c2\u4fdd\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    haveNumberOfInsured = s4;
                }
            }
            String havePaidInCapital = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getHavePaidInCapital())) {
                Map stringStringMap4 = (Map)dictMap.get(SupplierEncodeEnum.PAID_CAPITAL_DICT.getEncode());
                String s5 = (String)stringStringMap4.get(ImportVO.getHaveNumberOfInsured());
                if (StrUtil.isEmpty((CharSequence)s5)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u6709\u65e0\u5b9e\u7f34\u8d44\u672c\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    havePaidInCapital = s5;
                }
            }
            String supplierTaxpayer = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getSupplierTaxpayer())) {
                Map stringStringMap5 = (Map)dictMap.get(SupplierEncodeEnum.SUPPLIER_TAXPAYER_DICT.getEncode());
                String s6 = (String)stringStringMap5.get(ImportVO.getSupplierTaxpayer());
                if (StrUtil.isEmpty((CharSequence)s6)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u662f\u5426\u4e3a\u4e00\u822c\u7eb3\u7a0e\u4eba\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    supplierTaxpayer = s6;
                }
            }
            String supplierInvoice = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getSupplierInvoice())) {
                String[] invoice_att = ImportVO.getSupplierInvoice().split(";");
                stringStringMap = (Map)dictMap.get(SupplierEncodeEnum.SUPPLIER_INVOICE_DICT.getEncode());
                ArrayList<String> invoiceList = new ArrayList<String>();
                for (int i = 0; i < invoice_att.length; ++i) {
                    if (!ObjectUtil.isNotEmpty((Object)invoice_att[i])) continue;
                    s2 = (String)stringStringMap.get(invoice_att[i]);
                    if (StrUtil.isEmpty((CharSequence)s2)) {
                        ++errorNum;
                        ImportVO.setErrMsg("\u53d1\u7968\u79cd\u7c7b\u4e0d\u5b58\u5728");
                        errorMsgList.add(ImportVO.getErrMsg());
                        break;
                    }
                    invoiceList.add(s2);
                }
                if (!invoiceList.isEmpty()) {
                    supplierInvoice = JsonUtil.getListToJsonArray(invoiceList).toString();
                }
            }
            String riskOfDishonesty = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getRiskOfDishonesty())) {
                stringStringMap = (Map)dictMap.get(SupplierEncodeEnum.RISK_DISHONESTY_DICT.getEncode());
                String s7 = (String)stringStringMap.get(ImportVO.getRiskOfDishonesty());
                if (StrUtil.isEmpty((CharSequence)s7)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u4f01\u67e5\u67e5\u662f\u5426\u663e\u793a\u6709\u5931\u4fe1\u98ce\u9669\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    riskOfDishonesty = s7;
                }
            }
            String invoiceContent = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getInvoiceContent())) {
                Map stringStringMap6 = (Map)dictMap.get(SupplierEncodeEnum.INVOICE_CONTENTS_DICT.getEncode());
                String[] invoice_att = ImportVO.getInvoiceContent().split(";");
                ArrayList<String> invoiceList = new ArrayList<String>();
                for (int i = 0; i < invoice_att.length; ++i) {
                    if (!ObjectUtil.isNotEmpty((Object)invoice_att[i])) continue;
                    s = (String)stringStringMap6.get(invoice_att[i]);
                    if (StrUtil.isEmpty((CharSequence)s)) {
                        ++errorNum;
                        ImportVO.setErrMsg("\u53d1\u7968\u5185\u5bb9\u4e0d\u5b58\u5728");
                        errorMsgList.add(ImportVO.getErrMsg());
                        break;
                    }
                    invoiceList.add(s);
                }
                if (!invoiceList.isEmpty()) {
                    invoiceContent = JsonUtil.getListToJsonArray(invoiceList).toString();
                }
            }
            String supplierLevel = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getSupplierLevel())) {
                Map stringStringMap7 = (Map)dictMap.get(SupplierEncodeEnum.SUPPLIER_LEVEL_DICT.getEncode());
                s2 = (String)stringStringMap7.get(ImportVO.getSupplierLevel());
                if (StrUtil.isEmpty((CharSequence)s2)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u4f9b\u5e94\u5546\u7ea7\u522b\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    supplierLevel = s2;
                }
            }
            String isAffiliatedCompany = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getIsAffiliatedCompany())) {
                Map stringStringMap8 = (Map)dictMap.get(SupplierEncodeEnum.AFFILIATED_COMPANY_DICT.getEncode());
                String s8 = (String)stringStringMap8.get(ImportVO.getIsAffiliatedCompany());
                if (StrUtil.isEmpty((CharSequence)s8)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u662f\u5426\u4e3a\u8363\u79d1\u5173\u8054\u516c\u53f8\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    isAffiliatedCompany = s8;
                }
            }
            String isSpecified = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getIsSpecified())) {
                Map stringStringMap9 = (Map)dictMap.get(SupplierEncodeEnum.IS_SPECIFIED_DICT.getEncode());
                s = (String)stringStringMap9.get(ImportVO.getIsSpecified());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u662f\u5426\u4e3a\u5ba2\u6237\u6307\u5b9a\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    isSpecified = s;
                }
            }
            String haveAgencyQualification = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getHaveAgencyQualification())) {
                Map stringStringMap10 = (Map)dictMap.get(SupplierEncodeEnum.AGENCY_QUALIFICATION_DICT.getEncode());
                String s9 = (String)stringStringMap10.get(ImportVO.getHaveAgencyQualification());
                if (StrUtil.isEmpty((CharSequence)s9)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u662f\u5426\u62e5\u6709\u4ee3\u7406\u8d44\u8d28\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    haveAgencyQualification = s9;
                }
            }
            String haveEnvironmentalCertification = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getHaveEnvironmentalCertification())) {
                Map stringStringMap11 = (Map)dictMap.get(SupplierEncodeEnum.ENVIRONMENTAL_CERTIFICATION_DICT.getEncode());
                String s10 = (String)stringStringMap11.get(ImportVO.getHaveEnvironmentalCertification());
                if (StrUtil.isEmpty((CharSequence)s10)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u662f\u5426\u62e5\u6709\u73af\u4fdd\u8bc1\u4e66\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    haveEnvironmentalCertification = s10;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                ImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                ImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(ImportVO);
                continue;
            }
            ImportVO.setSupplierState(supplierState);
            ImportVO.setHaveNumberOfInsured(haveNumberOfInsured);
            ImportVO.setHavePaidInCapital(havePaidInCapital);
            ImportVO.setSupplierTaxpayer(supplierTaxpayer);
            ImportVO.setSupplierInvoice(supplierInvoice);
            ImportVO.setRiskOfDishonesty(riskOfDishonesty);
            ImportVO.setSupplierLevel(supplierLevel);
            ImportVO.setIsSpecified(isSpecified);
            ImportVO.setIsAffiliatedCompany(isAffiliatedCompany);
            ImportVO.setHaveEnvironmentalCertification(haveEnvironmentalCertification);
            ImportVO.setHaveAgencyQualification(haveAgencyQualification);
            ImportVO.setInvoiceContent(invoiceContent);
            ImportVO.setCreatorTime(DateUtil.getNow());
            SupplierEntity jsonToBean = (SupplierEntity)JsonUtil.getJsonToBean((Object)ImportVO, SupplierEntity.class);
            supplierList.add(jsonToBean);
            supplierList.stream().forEach(supplier -> {
                supplier.setSupplierUserId(userInfo.getUserId());
                supplier.setSupplierInvoice(StringUtil.isEmpty((String)supplier.getSupplierInvoice()) ? "[]" : supplier.getSupplierInvoice());
                supplier.setInvoiceContent(StringUtil.isEmpty((String)supplier.getInvoiceContent()) ? "[]" : supplier.getInvoiceContent());
                supplier.setBusinessLicenseUrl(StringUtil.isEmpty((String)supplier.getBusinessLicenseUrl()) ? "[]" : supplier.getBusinessLicenseUrl());
                supplier.setAgencyQualificationUrl(StringUtil.isEmpty((String)supplier.getAgencyQualificationUrl()) ? "[]" : supplier.getAgencyQualificationUrl());
                supplier.setLetterCommitmentIntegrity(StringUtil.isEmpty((String)supplier.getLetterCommitmentIntegrity()) ? "[]" : supplier.getLetterCommitmentIntegrity());
                supplier.setSupplierQuestionary(StringUtil.isEmpty((String)supplier.getSupplierQuestionary()) ? "[]" : supplier.getSupplierQuestionary());
                supplier.setOtherUrl(StringUtil.isEmpty((String)supplier.getOtherUrl()) ? "[]" : supplier.getOtherUrl());
                supplier.setEnvironmentalCertification(StringUtil.isEmpty((String)supplier.getEnvironmentalCertification()) ? "[]" : supplier.getEnvironmentalCertification());
                supplier.setBusinessIncomeUrl(StringUtil.isEmpty((String)supplier.getBusinessIncomeUrl()) ? "[]" : supplier.getBusinessLicenseUrl());
                supplier.setSocialSecurityCertificateUrl(StringUtil.isEmpty((String)supplier.getSocialSecurityCertificateUrl()) ? "[]" : supplier.getSocialSecurityCertificateUrl());
                supplier.setEnabledMark("complete");
                supplier.setCompanyId(userInfo.getOrganizeId());
            });
        }
        this.saveBatch(supplierList);
        SupplierImportReturnVO vo = new SupplierImportReturnVO();
        vo.setSnum(supplierList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, SupplierImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    private List<SupplierEntity> getListByName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SupplierEntity::getSupplierName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, SupplierImportVO o) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }
}

