/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.utils;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.RedisUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AMapUtils {
    private static final Logger log = LoggerFactory.getLogger(AMapUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    public static final String amapKey = "23c52fb7694705ab99ec346fec3c463a";
    private static final String API_URL = "https://restapi.amap.com/v3/geocode/geo";
    private static final String REVERSE_GEO_API = "https://restapi.amap.com/v3/geocode/regeo?key=%s&location=%s";

    public String getGeocode(String address) {
        String url = "https://restapi.amap.com/v3/geocode/geo?key=23c52fb7694705ab99ec346fec3c463a&address=" + address;
        String location = null;
        try {
            URL apiUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JSONObject json = JSONObject.parseObject((String)response.toString());
                String status = json.getString("status");
                if (status.equals("1")) {
                    JSONObject geocode = json.getJSONArray("geocodes").getJSONObject(0);
                    location = geocode.getString("location");
                } else {
                    log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)json.getString("info"));
                }
            } else {
                System.out.println();
                log.error("HTTP\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)responseCode);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5f02\u5e38");
        }
        return location;
    }

    public String getAddressFromCoordinates(double longitude, double latitude) {
        String address = "";
        try {
            String inputLine;
            String urlString = String.format(REVERSE_GEO_API, amapKey, longitude + "," + latitude);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JSONObject jsonResponse = JSONObject.parseObject((String)response.toString());
            address = jsonResponse.getJSONObject("regeocode").getString("formatted_address");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u5740\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return address;
    }
}

