/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.service.strategy.FieldContentStringStrategy;
import com.bringspring.utils.AuthorizeBussConditionEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentStringOrgUser
extends FieldContentStringStrategy {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;

    public ContentStringOrgUser() {
        this.conditionOptions = new ArrayList();
        this.conditionOptions.add(new HashMap<String, Object>(){
            {
                this.put("value", AuthorizeBussConditionEnum.ORG_USER_AUTH.getCode());
                this.put("label", AuthorizeBussConditionEnum.ORG_USER_AUTH.getDesc());
            }
        });
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBatch();
    }

    public Object convertFieldContent(String fieldContent, String symbol) {
        List listByOrganizeId;
        UserInfo userInfo = this.userProvider.get();
        String orgId = userInfo.getOrganizeId();
        if (StringUtils.isNotEmpty((String)userInfo.getDepartmentId())) {
            orgId = userInfo.getDepartmentId();
        }
        if (CollectionUtil.isEmpty((Collection)(listByOrganizeId = this.userService.getListByOraganizetionId(orgId)))) {
            return CollectionUtil.list((boolean)false, (Object[])new String[]{userInfo.getUserId()});
        }
        return listByOrganizeId.stream().map(UserEntity::getId).collect(Collectors.toList());
    }
}

