/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.utils.SentMessageSelfForm;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageUtils.class);
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    public void messagePush(SentMessageSelfForm sentMessageForm) {
        if (ObjectUtil.isNull((Object)((Object)sentMessageForm))) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getContent());
        map.put("AppUrl", sentMessageForm.getUrl());
        map.put("MessageTime", sentMessageForm.getMessageTime());
        map.put("objId", sentMessageForm.getObjId());
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageSelfForm> messageListAll = new ArrayList<SentMessageSelfForm>();
        messageListAll.add(sentMessageForm);
    }

    public SentMessageSelfForm getMessageForm(Integer type, String templateCode) {
        MessageTemplateEntity one = this.messageTemplateService.getMessageTemplateByEncode(templateCode);
        if (ObjectUtil.isNull((Object)one)) {
            log.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageSelfForm sentMessageForm = new SentMessageSelfForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        String app = null;
        try {
            app = this.sysConfigService.getSystemAddress("app");
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        sentMessageForm.setUrl(app);
        sentMessageForm.setMessageTime(DateUtil.dateFormat((Date)new Date()));
        return sentMessageForm;
    }

    public void sendMessageNew(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc) {
        log.info("code:{},\u63a5\u6536\u4eba:{}", (Object)sendCode, (Object)userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        if (StrUtil.isEmpty((CharSequence)linkUrl)) {
            try {
                linkUrl = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        linkMsgKeys.setLinkUrl("");
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(termType);
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

