/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.UserRelationObjectTypeEnum;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.AfterInspectEnum;
import com.bringspring.visit.entity.AfterInspectTaskEntity;
import com.bringspring.visit.entity.AfterSalesTaskInspectionTopicEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTemplateEntity;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskCrForm;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskForm;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskInfoVO;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskListVO;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskPagination;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskPaginationExportModel;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskUpForm;
import com.bringspring.visit.service.AfterInspectTaskService;
import com.bringspring.visit.service.AfterInspectTaskTrendsService;
import com.bringspring.visit.service.AfterSalesTaskInspectionTopicService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de1\u68c0\u4efb\u52a1-\u89c6\u7ff0\u6682\u7528"}, value="afterInspect")
@RequestMapping(value={"/api/afterInspect/AfterInspectTask"})
public class AfterInspectTaskController {
    private static final Logger log = LoggerFactory.getLogger(AfterInspectTaskController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterInspectTaskService afterInspectTaskService;
    @Autowired
    private AfterInspectTaskTrendsService afterInspectTaskTrendsService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private AfterSalesTaskInspectionTopicService afterSalesTaskInspectionTopicService;
    @Autowired
    private RkContractService rkContractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterInspectTaskPagination afterInspectTaskPagination) throws IOException {
        List<AfterInspectTaskEntity> list = this.afterInspectTaskService.getList(afterInspectTaskPagination);
        List listVO = JsonUtil.getJsonToList(list, AfterInspectTaskListVO.class);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (AfterInspectTaskListVO task : listVO) {
            for (OrganizeEntity company : allCompanyList) {
                CrmCustomerEntity info;
                if (StringUtils.isNotEmpty((String)task.getCompanyId()) && company.getId().equals(task.getCompanyId())) {
                    task.setCompanyName(company.getFullName());
                    continue block0;
                }
                if (!StrUtil.isNotBlank((CharSequence)task.getCustomerId()) || !ObjectUtil.isNotEmpty((Object)(info = this.crmCustomerService.getInfo(task.getCustomerId())))) continue;
                task.setCustomerName(info.getName());
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterInspectTaskPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getTaskInspectionTopicPrint/{id}"})
    @NotCheckLogin
    public ActionResult<AfterInspectTaskInfoVO> getTaskInspectionTopicPrint(@PathVariable(value="id") String id) {
        RkContractEntity contractEntity;
        AfterInspectTaskEntity info = this.afterInspectTaskService.getInfo(id);
        AfterInspectTaskInfoVO jsonToBean = (AfterInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)info, AfterInspectTaskInfoVO.class);
        AfterSalesTelephoneTemplateEntity byId = this.afterSalesTaskInspectionTopicService.getTemplateId(id);
        jsonToBean.setTemplateId(byId.getId());
        jsonToBean.setTemplateName(byId.getName());
        LinkedHashMap<String, List<AfterSalesTaskInspectionTopicEntity>> stringListHashMap = this.afterSalesTaskInspectionTopicService.getByInspectionId(id);
        jsonToBean.setAnswerList(stringListHashMap);
        List<RkAttachmentEntity> rkAttachmentEntityList = this.rkAttachmentService.getListByObjId(id);
        jsonToBean.setAttachmentList(rkAttachmentEntityList);
        AfterSalesProjectsEntity projectsEntity = this.afterSalesProjectsService.byProjectId(info.getProjectId());
        if (ObjectUtil.isNotEmpty((Object)projectsEntity)) {
            List list = CollectionUtil.list((boolean)false, (Object[])new Long[]{projectsEntity.getWarrantyStartDate().getTime(), projectsEntity.getWarrantyEndDate().getTime()});
            jsonToBean.setWarrantyDate(list);
            jsonToBean.setStartEndDate(DateUtil.daFormatYmd((Long)projectsEntity.getWarrantyStartDate().getTime()) + "\u81f3" + DateUtil.daFormatYmd((Long)projectsEntity.getWarrantyEndDate().getTime()));
        }
        if (ObjectUtil.isNotEmpty((Object)(contractEntity = this.rkContractService.getInfo(info.getContractId())))) {
            jsonToBean.setUserAddress(contractEntity.getCustomerAddressName());
        }
        return ActionResult.success((Object)jsonToBean);
    }

    @PostMapping(value={"/telephoneCreate"})
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AfterInspectTaskForm form) throws DataException {
        this.afterSalesTaskInspectionTopicService.create(form);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping(value={"/telephoneUpdate/{id}"})
    @DSTransactional
    public ActionResult telephoneUpdate(@PathVariable(value="id") String id, @RequestBody @Valid AfterInspectTaskForm afterInspectTaskForm) throws DataException {
        Boolean state = this.afterSalesTaskInspectionTopicService.telephoneUpdate(id, afterInspectTaskForm);
        if (state.booleanValue()) {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/getListByProjectId/{projectId}"})
    public ActionResult getListByProjectId(@PathVariable(value="projectId") String projectId) throws IOException {
        List<AfterInspectTaskListVO> listVO = this.afterInspectTaskService.getListByProjectId(projectId);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (AfterInspectTaskListVO task : listVO) {
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)task.getCompanyId()) || !company.getId().equals(task.getCompanyId())) continue;
                task.setCompanyName(company.getFullName());
                continue block0;
            }
        }
        return ActionResult.success(listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AfterInspectTaskCrForm afterInspectTaskCrForm) throws DataException {
        List result;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        AfterInspectTaskEntity entity = (AfterInspectTaskEntity)JsonUtil.getJsonToBean((Object)afterInspectTaskCrForm, AfterInspectTaskEntity.class);
        entity.setId(mainId);
        List<RkContractProjectEntity> projectList = this.rkContractProjectService.getListByProjectCode(afterInspectTaskCrForm.getProjectCode());
        if (ObjectUtil.isNotEmpty(projectList)) {
            for (RkContractProjectEntity po : projectList) {
                entity.setContractId(po.getContractId());
                entity.setCustomerId(po.getCustomerId());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(result = this.userRelationService.getListByUserIdAndObjType(userInfo.getUserId(), UserRelationObjectTypeEnum.AFTER_AREA_MANAGER.getObjectType())))) {
            entity.setRegionUserId(userInfo.getUserId());
            entity.setRegionUserName(userInfo.getUserName());
        }
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setInspectUserName(userInfo.getUserName());
        entity.setInspectUserId(userInfo.getUserId());
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setEnabledMark(AfterInspectEnum.AFTER_INSPECT_CREATE.getType());
        entity.setCreatorTime(new Date());
        entity.setUserDept(userInfo.getDepartmentId());
        entity.setUserDeptName(this.baseDataUtil.comSelectValues(userInfo.getDepartmentId()));
        this.afterInspectTaskService.save(entity);
        entity.setDescription(null);
        this.afterInspectTaskTrendsService.createInspectTaskTrends(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u552e\u540e\u5de1\u68c0\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u552e\u540e\u5de1\u68c0\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(AfterInspectTaskPaginationExportModel afterInspectTaskPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)afterInspectTaskPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        AfterInspectTaskPagination afterInspectTaskPagination = (AfterInspectTaskPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)afterInspectTaskPaginationExportModel), AfterInspectTaskPagination.class));
        List<AfterInspectTaskEntity> list = this.afterInspectTaskService.getTypeList(afterInspectTaskPagination, afterInspectTaskPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, AfterInspectTaskListVO.class);
        for (AfterInspectTaskListVO afterInspectTaskVO : listVO) {
            afterInspectTaskVO.setEnabledMark(AfterInspectEnum.getByCode(afterInspectTaskVO.getEnabledMark()));
            afterInspectTaskVO.setInspectUserId(this.baseDataUtil.userSelectValue(afterInspectTaskVO.getInspectUserId()));
            afterInspectTaskVO.setUserDeptName(this.baseDataUtil.comSelectValues(afterInspectTaskVO.getUserDept()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)afterInspectTaskPaginationExportModel.getSelectKey()) ? afterInspectTaskPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block32: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block32;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCode"));
                        continue block32;
                    }
                    case "inspectionContent": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u5185\u5bb9", (Object)"inspectionContent"));
                        continue block32;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u72b6\u6001", (Object)"enabledMark"));
                        continue block32;
                    }
                    case "inspectUserId": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u4eba", (Object)"inspectUserId"));
                        continue block32;
                    }
                    case "userDeptName": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u90e8\u95e8", (Object)"userDeptName"));
                        continue block32;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block32;
                    }
                    case "executionStartTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"executionStartTime"));
                        continue block32;
                    }
                    case "executionEndTime": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"executionEndTime"));
                        continue block32;
                    }
                    case "attachmentList": {
                        entitys.add(new ExcelExportEntity("\u9644\u4ef6", (Object)"attachmentList"));
                        continue block32;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u552e\u540e\u5de1\u68c0\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u552e\u540e\u5de1\u68c0\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u552e\u540e\u5de1\u68c0\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterInspectTaskInfoVO> info(@PathVariable(value="id") String id) {
        AfterInspectTaskEntity entity = this.afterInspectTaskService.getInfo(id);
        AfterInspectTaskInfoVO vo = (AfterInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterInspectTaskInfoVO.class);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId())) {
            CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()));
            vo.setCustomerName(byId.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        vo.setInspectTaskTrendsEntityList(this.afterInspectTaskTrendsService.getInspectTrendsListByInspectId(id));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterInspectTaskInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesProjectsEntity projectsEntity;
        AfterInspectTaskEntity entity = this.afterInspectTaskService.getInfo(id);
        AfterInspectTaskInfoVO vo = (AfterInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterInspectTaskInfoVO.class);
        vo.setInspectTaskTrendsEntityList(this.afterInspectTaskTrendsService.getInspectTrendsListByInspectId(id));
        RkContractEntity info = this.rkContractService.getInfo(entity.getContractId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            vo.setUserAddress(info.getCustomerAddressName());
        }
        List<RkAttachmentEntity> rkAttachmentEntityList = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(rkAttachmentEntityList);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        if (ObjectUtil.isNotEmpty((Object)(projectsEntity = this.afterSalesProjectsService.byProjectId(entity.getProjectId())))) {
            if (ObjectUtil.isNotEmpty((Object)projectsEntity.getWarrantyStartDate()) && ObjectUtil.isNotEmpty((Object)projectsEntity.getWarrantyEndDate())) {
                List list = CollectionUtil.list((boolean)false, (Object[])new Long[]{projectsEntity.getWarrantyStartDate().getTime(), projectsEntity.getWarrantyEndDate().getTime()});
                vo.setWarrantyDate(list);
            }
            vo.setServerIp(projectsEntity.getServerIp());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterInspectTaskUpForm afterInspectTaskUpForm) throws DataException {
        AfterInspectTaskEntity entity = this.afterInspectTaskService.getInfo(id);
        if (entity != null) {
            afterInspectTaskUpForm.setId(id);
            this.afterInspectTaskService.updateInspectTask(afterInspectTaskUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterInspectTaskEntity entity = this.afterInspectTaskService.getInfo(id);
        if (entity != null) {
            this.afterInspectTaskService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

