/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesCommunicationRecordEntity;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordCrForm;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordInfoVO;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordListVO;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordPagination;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordUpForm;
import com.bringspring.visit.service.AfterSalesCommunicationRecordService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6c9f\u901a\u8bb0\u5f55"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesCommunicationRecord"})
public class AfterSalesCommunicationRecordController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesCommunicationRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesCommunicationRecordService afterSalesCommunicationRecordService;
    @Autowired
    private CrmProductService crmProductService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesCommunicationRecordPagination afterSalesCommunicationRecordPagination) throws IOException {
        List<AfterSalesCommunicationRecordEntity> list = this.afterSalesCommunicationRecordService.getList(afterSalesCommunicationRecordPagination);
        for (AfterSalesCommunicationRecordEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesCommunicationRecordListVO.class);
        for (AfterSalesCommunicationRecordListVO vo : listVO) {
            List<CrmProductEntity> productEntities;
            List<String> ids;
            vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            if (!StringUtils.isNotEmpty((String)vo.getProductId()) || !CollectionUtil.isNotEmpty(ids = Arrays.asList(vo.getProductId().split(","))) || !CollectionUtil.isNotEmpty(productEntities = this.crmProductService.getInfoByListId(StringUtils.join(ids, (String)",")))) continue;
            vo.setProductName(productEntities.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesCommunicationRecordPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid AfterSalesCommunicationRecordCrForm afterSalesCommunicationRecordCrForm) throws DataException, ParseException {
        this.afterSalesCommunicationRecordService.create(afterSalesCommunicationRecordCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesCommunicationRecordInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesCommunicationRecordEntity entity = this.afterSalesCommunicationRecordService.getInfo(id);
        AfterSalesCommunicationRecordInfoVO vo = (AfterSalesCommunicationRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesCommunicationRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesCommunicationRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesCommunicationRecordEntity entity = this.afterSalesCommunicationRecordService.getInfo(id);
        AfterSalesCommunicationRecordInfoVO vo = (AfterSalesCommunicationRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesCommunicationRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesCommunicationRecordUpForm afterSalesCommunicationRecordUpForm) throws DataException {
        this.afterSalesCommunicationRecordService.update(id, afterSalesCommunicationRecordUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesCommunicationRecordEntity entity = this.afterSalesCommunicationRecordService.getInfo(id);
        if (entity != null) {
            this.afterSalesCommunicationRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

