/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerRemarkEntity;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsPagination;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerRemarkService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.address.AdInfo;
import com.bringspring.visit.entity.AfterSalesAttachmentEntity;
import com.bringspring.visit.entity.AfterSalesInspectExpectedResultEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskBatchEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskExpectedResultEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskProductEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskTargetEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskTrendsEntity;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.entity.VisitFollowEvaluateEntity;
import com.bringspring.visit.model.after_sales_inspect_task_batch.AfterSalesInspectTaskModel;
import com.bringspring.visit.model.after_sales_inspect_task_batch.AfterSalesInspectTaskProductModel;
import com.bringspring.visit.model.after_sales_inspect_template.AfterSalesInspectTargetModel;
import com.bringspring.visit.model.after_sales_telephone_template.AfterSalesInspectTaskTargetModelVo;
import com.bringspring.visit.model.aftersalesattachment.AfterSalesAttachmentModel;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectListVO;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskAssginForm;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskExportModel;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskInfoVO;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskListVO;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskTargetModel;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskUpForm;
import com.bringspring.visit.model.aftersalesinspecttask.AfterSalesInspectTaskWithdrawForm;
import com.bringspring.visit.model.aftersalesinspecttask.InspectCustomerDTO;
import com.bringspring.visit.model.aftersalesinspecttask.InspectCustomerExportModel;
import com.bringspring.visit.model.aftersalesinspecttask.InspectCustomerQuery;
import com.bringspring.visit.model.aftersalesinspecttask.InspectResultSummaryExportModel;
import com.bringspring.visit.model.aftersalesinspecttask.InspectResultSummaryQuery;
import com.bringspring.visit.model.aftersalesinspecttask.InspectResultSummaryVO;
import com.bringspring.visit.model.aftersalesinspecttask.InspectStatisticsSummaryExportModel;
import com.bringspring.visit.model.aftersalesinspecttask.InspectStatisticsSummaryQuery;
import com.bringspring.visit.model.aftersalesinspecttask.InspectStatisticsSummaryVO;
import com.bringspring.visit.model.aftersalesinspecttaskbatch.AfterSalesInspectTaskBatchPagination;
import com.bringspring.visit.service.AfterSalesAttachmentService;
import com.bringspring.visit.service.AfterSalesInspectTaskBatchService;
import com.bringspring.visit.service.AfterSalesInspectTaskExpectedResultsService;
import com.bringspring.visit.service.AfterSalesInspectTaskProductService;
import com.bringspring.visit.service.AfterSalesInspectTaskService;
import com.bringspring.visit.service.AfterSalesInspectTaskTargetService;
import com.bringspring.visit.service.AfterSalesInspectTaskTrendsService;
import com.bringspring.visit.service.AfterSalesInspectTemplateService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.VisitFollowEvaluateService;
import com.bringspring.visit.utils.AfterSalesAttachmentTypeEnum;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.visit.utils.CustomerRemarkTypeEnum;
import com.bringspring.visit.utils.InspectTaskEnableMarkEnum;
import com.bringspring.visit.utils.InspectTaskTrendsEnum;
import com.bringspring.visit.utils.JingWeiUtil;
import com.bringspring.visit.utils.QuestionEnableMarkEnum;
import com.bringspring.visit.utils.UserRelationUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de1\u68c0\u4efb\u52a1"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesInspectTask"})
public class AfterSalesInspectTaskController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesInspectTaskController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesInspectTaskBatchService afterSalesInspectTaskBatchService;
    @Autowired
    private AfterSalesInspectTaskService afterSalesInspectTaskService;
    @Autowired
    private AfterSalesInspectTaskProductService afterSalesInspectTaskProductService;
    @Autowired
    private AfterSalesInspectTaskTargetService afterSalesInspectTaskTargetService;
    @Autowired
    private AfterSalesInspectTaskExpectedResultsService afterSalesInspectTaskExpectedResultsService;
    @Autowired
    private AfterSalesAttachmentService afterSalesAttachmentService;
    @Autowired
    private AfterSalesInspectTemplateService afterSalesInspectTemplateService;
    @Autowired
    private UserService userService;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private CrmCustomerRemarkService crmCustomerRemarkService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private AfterSalesInspectTaskTrendsService afterSalesInspectTaskTrendsService;
    @Autowired
    private VisitFollowEvaluateService visitFollowEvaluateService;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesInspectTaskBatchPagination afterSalesInspectTaskBatchPagination) throws IOException {
        List listUser = this.crmCustomerContactsService.list();
        List<AfterSalesInspectTaskEntity> list = this.afterSalesInspectTaskService.getList(afterSalesInspectTaskBatchPagination);
        List listVO = JsonUtil.getJsonToList(list, AfterSalesInspectTaskListVO.class);
        for (AfterSalesInspectTaskListVO taskVo : listVO) {
            AfterSalesInspectTaskBatchEntity byId = (AfterSalesInspectTaskBatchEntity)this.afterSalesInspectTaskBatchService.getById((Serializable)((Object)taskVo.getTaskBatchId()));
            taskVo.setName(byId.getName());
            taskVo.setExecutionStartBatchTime(byId.getExecutionStartTime());
            taskVo.setExecutionEndBatchTime(byId.getExecutionEndTime());
            taskVo.setCreatorTime(byId.getCreatorTime());
            List<AfterSalesInspectTaskProductEntity> listByTaskBatchId = this.afterSalesInspectTaskProductService.getListByTaskBatchIdAndTaskId(taskVo.getTaskBatchId(), taskVo.getId());
            String collect = listByTaskBatchId.stream().map(AfterSalesInspectTaskProductEntity::getProductName).collect(Collectors.joining(","));
            String projectName = listByTaskBatchId.stream().map(AfterSalesInspectTaskProductEntity::getProjectName).collect(Collectors.joining(","));
            List collect1 = listByTaskBatchId.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getProjectIncomeType())).collect(Collectors.toList());
            String projectIncomeType = collect1.stream().map(AfterSalesInspectTaskProductEntity::getProjectIncomeType).collect(Collectors.joining(","));
            if (CollectionUtil.isNotEmpty(listByTaskBatchId)) {
                taskVo.setInspectType(listByTaskBatchId.get(0).getInspectType());
            }
            taskVo.setProductName(ObjectUtil.equals((Object)taskVo.getInspectType(), (Object)1) ? collect : "");
            taskVo.setProjectName(ObjectUtil.equals((Object)taskVo.getInspectType(), (Object)2) ? projectName : "");
            taskVo.setProjectInComeType(ObjectUtil.equals((Object)taskVo.getInspectType(), (Object)2) ? projectIncomeType : "");
            taskVo.setInspectUserId(this.baseDataUtil.userSelectValueNoAccount(taskVo.getInspectUserId()));
            taskVo.setEnabledMarkCode(taskVo.getEnabledMark());
            taskVo.setEnabledMark(this.baseDataUtil.getDictName(taskVo.getEnabledMark(), "inspectTaskStatus"));
            if (StrUtil.isNotEmpty((CharSequence)taskVo.getContactId())) {
                for (CrmCustomerContactsEntity user : listUser) {
                    if (!ObjectUtil.isNotEmpty((Object)user) || !user.getId().equals(taskVo.getContactId())) continue;
                    taskVo.setContactDeptName(user.getDepartment());
                    taskVo.setPost(user.getPost());
                }
            }
            CrmCustomerContactsPagination contactsPagination = new CrmCustomerContactsPagination();
            contactsPagination.setCustomerId(taskVo.getCustomerId());
            contactsPagination.setClassification("488760535479749253");
            List<CrmCustomerContactsEntity> listByCustomerId = this.crmCustomerContactsService.getListByCustomerId(contactsPagination);
            if (!CollectionUtil.isNotEmpty(listByCustomerId)) continue;
            String afterName = listByCustomerId.stream().map(CrmCustomerContactsEntity::getName).collect(Collectors.joining(","));
            String afterPhone = listByCustomerId.stream().map(CrmCustomerContactsEntity::getPhone).collect(Collectors.joining(","));
            taskVo.setAfterContactName(afterName);
            taskVo.setAfterContactPhone(afterPhone);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesInspectTaskBatchPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"listByEnableMark"})
    public ActionResult listByEnableMark() {
        List list = CollectionUtil.list((boolean)false, (Object[])new String[]{InspectTaskEnableMarkEnum.ENABLE_EVALUATED.getEnableMark(), InspectTaskEnableMarkEnum.ENABLE_TOBEEVALUATED.getEnableMark()});
        return ActionResult.success(this.afterSalesInspectTaskService.listByEnableMark(list));
    }

    @PostMapping(value={"countTabs"})
    public ActionResult countTabs(@RequestBody AfterSalesInspectTaskBatchPagination afterSalesInspectTaskBatchPagination) {
        if (StrUtil.isNotEmpty((CharSequence)afterSalesInspectTaskBatchPagination.getEnabledMark())) {
            afterSalesInspectTaskBatchPagination.setEnabledMark("");
        }
        List<Map<String, Object>> maps = this.afterSalesInspectTaskService.countTabs(afterSalesInspectTaskBatchPagination);
        return ActionResult.success(maps);
    }

    @GetMapping(value={"taskList/{customerId}"})
    public ActionResult taskList(@PathVariable(value="customerId") String customerId) {
        List list = CollectionUtil.list((boolean)false);
        List<AfterSalesInspectTaskEntity> afterSalesInspectTaskEntities = this.afterSalesInspectTaskService.listByCustomerIdAndEnabledMark(customerId, list);
        List jsonToList = JsonUtil.getJsonToList(afterSalesInspectTaskEntities, AfterSalesInspectTaskModel.class);
        for (AfterSalesInspectTaskModel model : jsonToList) {
            model.setActInspectUser(this.baseDataUtil.userSelectValueNoAccount(model.getActInspectUser()));
            model.setEnabledMarkDesc(this.baseDataUtil.getDictName(model.getEnabledMark(), "inspectTaskStatus"));
            AfterSalesInspectTaskBatchEntity byId = (AfterSalesInspectTaskBatchEntity)this.afterSalesInspectTaskBatchService.getById((Serializable)((Object)model.getTaskBatchId()));
            model.setName(byId.getName());
            model.setExecutionStartTime(byId.getExecutionStartTime());
            model.setExecutionEndTime(byId.getExecutionEndTime());
            List<AfterSalesInspectTaskProductEntity> listByTaskBatchId = this.afterSalesInspectTaskProductService.getListByTaskBatchIdAndTaskId(model.getTaskBatchId(), model.getId());
            String collect = listByTaskBatchId.stream().map(AfterSalesInspectTaskProductEntity::getProductName).collect(Collectors.joining(","));
            model.setProductName(collect);
            model.setInspectUserId(this.baseDataUtil.userSelectValueNoAccount(model.getInspectUserId()));
        }
        return ActionResult.success((Object)jsonToList);
    }

    @GetMapping(value={"taskTrends/{taskId}"})
    public ActionResult taskTrends(@PathVariable(value="taskId") String taskId) {
        List<AfterSalesInspectTaskModel> jsonToList = this.afterSalesInspectTaskService.getAfterSalesInspectTaskTrendsList(taskId);
        return ActionResult.success(jsonToList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"assign"})
    public ActionResult assign(@RequestBody AfterSalesInspectTaskAssginForm afterSalesInspectTaskAssginForm) throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            HashMap assign = this.afterSalesInspectTaskService.assign(afterSalesInspectTaskAssginForm);
            if (Objects.isNull(assign.get("error"))) {
                return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
            }
            return ActionResult.fail((String)assign.get("error").toString());
        }
    }

    @RepeatSubmit
    @PostMapping(value={"withdraw"})
    public synchronized ActionResult withdraw(@RequestBody AfterSalesInspectTaskWithdrawForm withdrawForm) {
        HashMap withdraw = this.afterSalesInspectTaskService.withdraw(withdrawForm);
        if (Objects.isNull(withdraw.get("error"))) {
            return ActionResult.success((String)"\u64a4\u56de\u6210\u529f");
        }
        return ActionResult.fail((String)withdraw.get("error").toString());
    }

    @GetMapping(value={"getListByCustomerId/{customerId}"})
    public ActionResult getListByCustomerId(@PathVariable(value="customerId") String customerId) {
        List<AfterSalesInspectTaskEntity> list = this.afterSalesInspectTaskService.getInspectByCustomerId(customerId);
        List infoVOList = CollectionUtil.list((boolean)false);
        for (AfterSalesInspectTaskEntity taskEntity : list) {
            String id = taskEntity.getId();
            AfterSalesInspectTaskEntity entity = this.afterSalesInspectTaskService.getInfo(taskEntity.getId());
            AfterSalesInspectTaskInfoVO vo = (AfterSalesInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesInspectTaskInfoVO.class);
            vo.setInspectUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getInspectUserId()));
            vo.setAssistUser(this.userRelationUtil.userSelectValuesNoAccount(vo.getAssistUser()));
            AfterSalesInspectTaskBatchEntity byId = (AfterSalesInspectTaskBatchEntity)this.afterSalesInspectTaskBatchService.getById((Serializable)((Object)entity.getTaskBatchId()));
            vo.setName(byId.getName());
            vo.setExecutionEndTime(byId.getExecutionEndTime());
            vo.setExecutionStartTime(byId.getExecutionStartTime());
            vo.setEnabledMarkCode(vo.getEnabledMark());
            vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "inspectTaskStatus"));
            List<AfterSalesInspectTaskTargetEntity> afterSalesInspectTargetList = this.afterSalesInspectTaskTargetService.getListByTaskId(id);
            List afterSalesInspectTargetModelList = JsonUtil.getJsonToList(afterSalesInspectTargetList, AfterSalesInspectTargetModel.class);
            for (AfterSalesInspectTargetModel afterSalesInspectTargetModel : afterSalesInspectTargetModelList) {
                List<AfterSalesInspectTaskExpectedResultEntity> byTargetId = this.afterSalesInspectTaskExpectedResultsService.getByTargetId(afterSalesInspectTargetModel.getId());
                afterSalesInspectTargetModel.setResultList(JsonUtil.getJsonToList(byTargetId, AfterSalesInspectExpectedResultEntity.class));
                String collect = byTargetId.stream().map(AfterSalesInspectTaskExpectedResultEntity::getResult).collect(Collectors.joining(","));
                afterSalesInspectTargetModel.setResultsStr(collect);
                List<AfterSalesAttachmentEntity> listByObjId = this.afterSalesAttachmentService.listByInspectTargetId(afterSalesInspectTargetModel.getId());
                afterSalesInspectTargetModel.setAttachmentList(JsonUtil.getJsonToList(listByObjId, AfterSalesAttachmentModel.class));
            }
            vo.setTargetList(afterSalesInspectTargetModelList);
            vo.setTemplateName(byId.getTemplateName());
            vo.setTaskType(this.baseDataUtil.getDictName(byId.getType(), "AfterSalesInspectTaskType"));
            vo.setActInspectUser(this.baseDataUtil.userSelectValueNoAccount(vo.getActInspectUser()));
            List<AfterSalesAttachmentEntity> attachmentEntities = this.afterSalesAttachmentService.listByInspectTaskIdSingle(id);
            List jsonToList = JsonUtil.getJsonToList(attachmentEntities, AfterSalesAttachmentModel.class);
            vo.setAttachmentList(jsonToList);
            vo.setAllAttachmentList(JsonUtil.getJsonToList(this.afterSalesAttachmentService.listByInspectTaskId(taskEntity.getId()), AfterSalesAttachmentModel.class));
            VisitFollowEvaluateEntity evaluateEntity = this.visitFollowEvaluateService.getListByInspectId(id);
            vo.setEvaluateEntity(evaluateEntity);
            infoVOList.add(vo);
        }
        return ActionResult.success((Object)infoVOList);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesInspectTaskInfoVO> get(@PathVariable(value="id") String id) {
        AfterSalesInspectTaskEntity entity = this.afterSalesInspectTaskService.getInfo(id);
        AfterSalesInspectTaskInfoVO vo = (AfterSalesInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesInspectTaskInfoVO.class);
        ArrayList<Date> timeList = new ArrayList<Date>();
        timeList.add(entity.getExecutionStartTime());
        timeList.add(entity.getExecutionEndTime());
        vo.setExecutionTime(timeList);
        return ActionResult.success((Object)vo);
    }

    @DSTransactional
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesInspectTaskInfoVO afterSalesInspectTaskUpForm) throws DataException {
        AfterSalesInspectTaskEntity entity = (AfterSalesInspectTaskEntity)this.afterSalesInspectTaskService.getById((Serializable)((Object)id));
        if (entity == null) {
            return ActionResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (entity.getEnabledMark().equals(InspectTaskEnableMarkEnum.ENABLE_TOBEEVALUATED.getEnableMark())) {
            return ActionResult.fail((String)"\u8be5\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        AfterSalesInspectTaskEntity jsonToBean = (AfterSalesInspectTaskEntity)JsonUtil.getJsonToBean((Object)afterSalesInspectTaskUpForm, AfterSalesInspectTaskEntity.class);
        jsonToBean.setExecutionStartTime(afterSalesInspectTaskUpForm.getExecutionTime().get(0));
        jsonToBean.setExecutionEndTime(afterSalesInspectTaskUpForm.getExecutionTime().get(1));
        jsonToBean.setInspectTemplateId(entity.getInspectTemplateId());
        this.afterSalesInspectTaskService.update(id, jsonToBean);
        AfterSalesInspectTaskTrendsEntity trendsEntity = new AfterSalesInspectTaskTrendsEntity();
        trendsEntity.setTaskId(entity.getId());
        trendsEntity.setInspectTemplateId(entity.getInspectTemplateId());
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setNodeType(InspectTaskTrendsEnum.ENABLE_POSTPONE.getEnableMark());
        trendsEntity.setDescription(DateUtil.daFormat((Date)jsonToBean.getExecutionStartTime()) + " \u81f3 " + DateUtil.daFormat((Date)jsonToBean.getExecutionEndTime()));
        this.afterSalesInspectTaskTrendsService.save(trendsEntity);
        return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesInspectTaskInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesInspectTaskEntity entity = this.afterSalesInspectTaskService.getInfo(id);
        AfterSalesInspectTaskInfoVO vo = (AfterSalesInspectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesInspectTaskInfoVO.class);
        vo.setInspectUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getInspectUserId()));
        vo.setAssistUser(this.userRelationUtil.userSelectValuesNoAccount(vo.getAssistUser()));
        AfterSalesInspectTaskBatchEntity byId = (AfterSalesInspectTaskBatchEntity)this.afterSalesInspectTaskBatchService.getById((Serializable)((Object)entity.getTaskBatchId()));
        vo.setName(byId.getName());
        vo.setEnabledMarkCode(vo.getEnabledMark());
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "inspectTaskStatus"));
        List<AfterSalesInspectTaskTargetEntity> afterSalesInspectTargetList = this.afterSalesInspectTaskTargetService.getListByTaskId(id);
        List afterSalesInspectTargetModelList = JsonUtil.getJsonToList(afterSalesInspectTargetList, AfterSalesInspectTargetModel.class);
        for (AfterSalesInspectTargetModel afterSalesInspectTargetModel : afterSalesInspectTargetModelList) {
            List<AfterSalesInspectTaskExpectedResultEntity> byTargetId = this.afterSalesInspectTaskExpectedResultsService.getByTargetId(afterSalesInspectTargetModel.getId());
            afterSalesInspectTargetModel.setResultList(JsonUtil.getJsonToList(byTargetId, AfterSalesInspectExpectedResultEntity.class));
            String collect = byTargetId.stream().map(AfterSalesInspectTaskExpectedResultEntity::getResult).collect(Collectors.joining(","));
            afterSalesInspectTargetModel.setResultsStr(collect);
            List<AfterSalesAttachmentEntity> listByObjId = this.afterSalesAttachmentService.listByInspectTargetId(afterSalesInspectTargetModel.getId());
            afterSalesInspectTargetModel.setAttachmentList(JsonUtil.getJsonToList(listByObjId, AfterSalesAttachmentModel.class));
            afterSalesInspectTargetModel.setOptionNameList(JsonUtil.getJsonToList((String)afterSalesInspectTargetModel.getOptionName(), AfterSalesInspectTaskTargetModelVo.class));
        }
        vo.setTargetList(afterSalesInspectTargetModelList);
        vo.setTemplateName(byId.getTemplateName());
        vo.setTaskType(this.baseDataUtil.getDictName(byId.getType(), "AfterSalesInspectTaskType"));
        vo.setActInspectUser(this.baseDataUtil.userSelectValueNoAccount(vo.getActInspectUser()));
        List<AfterSalesAttachmentEntity> attachmentEntities = this.afterSalesAttachmentService.listByInspectTaskIdSingle(id);
        List jsonToList = JsonUtil.getJsonToList(attachmentEntities, AfterSalesAttachmentModel.class);
        vo.setAttachmentList(jsonToList);
        vo.setAllAttachmentList(JsonUtil.getJsonToList(this.afterSalesAttachmentService.listByInspectTaskId(id), AfterSalesAttachmentModel.class));
        List<AfterSalesInspectTaskProductEntity> productList = this.afterSalesInspectTaskProductService.getListByTaskBatchIdAndTaskId(entity.getTaskBatchId(), entity.getId());
        List jsonToList1 = JsonUtil.getJsonToList(productList, AfterSalesInspectTaskProductModel.class);
        vo.setProductList(jsonToList1);
        VisitFollowEvaluateEntity evaluateEntity = this.visitFollowEvaluateService.getListByInspectId(id);
        vo.setEvaluateEntity(evaluateEntity);
        return ActionResult.success((Object)vo);
    }

    @DSTransactional
    @PutMapping(value={"/execute/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesInspectTaskUpForm afterSalesInspectTaskUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesInspectTaskEntity byId = (AfterSalesInspectTaskEntity)this.afterSalesInspectTaskService.getById((Serializable)((Object)id));
        if (Objects.isNull(byId)) {
            return ActionResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        byId.setExecutionResults(afterSalesInspectTaskUpForm.getExecutionResults());
        byId.setEnabledMark(InspectTaskEnableMarkEnum.ENABLE_TOBEEVALUATED.getEnableMark());
        byId.setActInspectUser(userInfo.getUserId());
        byId.setActInspectTime(DateUtil.getNowDate());
        byId.setAddressLat(afterSalesInspectTaskUpForm.getAddressLat());
        byId.setAddressLng(afterSalesInspectTaskUpForm.getAddressLng());
        byId.setContactId(afterSalesInspectTaskUpForm.getContactId());
        byId.setContactName(afterSalesInspectTaskUpForm.getContactName());
        byId.setContactPhone(afterSalesInspectTaskUpForm.getContactPhone());
        byId.setInspectRemark(afterSalesInspectTaskUpForm.getInspectRemark());
        byId.setQuestionId(afterSalesInspectTaskUpForm.getQuestionId());
        if (StrUtil.isNotEmpty((CharSequence)byId.getAddressLat()) && StrUtil.isNotEmpty((CharSequence)byId.getAddressLng())) {
            AdInfo adInfo = JingWeiUtil.getAddress(byId.getAddressLat(), byId.getAddressLng());
            if (StrUtil.isEmpty((CharSequence)byId.getLocationAddress())) {
                byId.setLocationAddress(adInfo.getAddress());
            }
        }
        List attachmentEntities = JsonUtil.getJsonToList(afterSalesInspectTaskUpForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
        for (AfterSalesAttachmentEntity att : attachmentEntities) {
            att.setId(RandomUtil.uuId());
            att.setInspectTaskId(id);
            att.setFileType(AfterSalesAttachmentTypeEnum.INSPECT_TYPE.getType());
            this.afterSalesAttachmentService.save(att);
        }
        this.afterSalesInspectTaskService.update(id, byId);
        List<AfterSalesInspectTaskTargetModel> targetList = afterSalesInspectTaskUpForm.getTargetList();
        Map<String, List<AfterSalesInspectTaskTargetModel>> collect = targetList.stream().collect(Collectors.groupingBy(AfterSalesInspectTaskTargetModel::getId));
        List jsonToList = JsonUtil.getJsonToList(targetList, AfterSalesInspectTaskTargetEntity.class);
        jsonToList.stream().forEach(target -> {
            if (StringUtils.isNotEmpty((String)target.getOptionNameList())) {
                List jsonToList1 = JsonUtil.getJsonToList((String)target.getOptionNameList(), AfterSalesInspectTaskTargetModelVo.class);
                List collect1 = jsonToList1.stream().filter(x -> StrUtil.equals((CharSequence)x.getId(), (CharSequence)target.getExecutionId())).collect(Collectors.toList());
                target.setExecutionResults(((AfterSalesInspectTaskTargetModelVo)collect1.get(0)).getOptionName());
            }
            target.setActInspectUser(userInfo.getUserId());
            target.setActInspectTime(DateUtil.getNowDate());
            target.setOptionName(target.getOptionNameList());
        });
        this.afterSalesInspectTaskTargetService.saveOrUpdateBatch(jsonToList);
        targetList.stream().forEach(target -> {
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(target.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity att : AfterSalesAttachmentList) {
                att.setId(RandomUtil.uuId());
                att.setInspectTaskId(id);
                att.setInspectTargetId(target.getId());
                att.setFileType(AfterSalesAttachmentTypeEnum.INSPECT_TYPE.getType());
                this.afterSalesAttachmentService.save(att);
            }
        });
        if (StrUtil.isNotEmpty((CharSequence)afterSalesInspectTaskUpForm.getInspectRemark())) {
            CrmCustomerRemarkEntity remarkCrForm = new CrmCustomerRemarkEntity();
            remarkCrForm.setId(RandomUtil.uuId());
            remarkCrForm.setInspectId(id);
            remarkCrForm.setRemarkType(CustomerRemarkTypeEnum.AFTERSALE_TYPE.getType());
            remarkCrForm.setCustomerId(byId.getCustomerId());
            remarkCrForm.setDescription(afterSalesInspectTaskUpForm.getInspectRemark());
            this.crmCustomerRemarkService.save(remarkCrForm);
        }
        AfterSalesInspectTaskTrendsEntity trendsEntity = new AfterSalesInspectTaskTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setTaskId(byId.getId());
        trendsEntity.setInspectTemplateId(byId.getInspectTemplateId());
        trendsEntity.setNodeType(InspectTaskTrendsEnum.ENABLE_EXECUTE.getEnableMark());
        trendsEntity.setDescription(afterSalesInspectTaskUpForm.getExecutionResults());
        this.afterSalesInspectTaskTrendsService.save(trendsEntity);
        return ActionResult.success((String)"\u6267\u884c\u6210\u529f");
    }

    @PostMapping(value={"getCustomerByInspectIdList"})
    public ActionResult getCustomerByInspectIdList(@RequestBody List<AfterSalesInspectListVO> list) {
        List collect = list.stream().map(AfterSalesInspectListVO::getInspectId).collect(Collectors.toList());
        List afterSalesInspectTaskEntities = this.afterSalesInspectTaskService.listByIds(collect);
        List collect1 = afterSalesInspectTaskEntities.stream().map(AfterSalesInspectTaskEntity::getCustomerId).collect(Collectors.toList());
        return ActionResult.success(collect1);
    }

    @PostMapping(value={"/statistics/summary"})
    public ActionResult statisticsSummary(@RequestBody InspectStatisticsSummaryQuery inspectStatisticsSummaryQuery) {
        if (CollectionUtil.isNotEmpty(inspectStatisticsSummaryQuery.getCreatorTime())) {
            inspectStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(0)));
            inspectStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(1)));
        }
        List<InspectStatisticsSummaryVO> list = this.afterSalesInspectTaskService.statisticsSummary(inspectStatisticsSummaryQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)inspectStatisticsSummaryQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/statistics/summary/Export"})
    public ActionResult exportStatisticsSummary(InspectStatisticsSummaryExportModel exportModel) {
        InspectStatisticsSummaryQuery inspectStatisticsSummaryQuery = new InspectStatisticsSummaryQuery();
        if (StringUtils.isNotEmpty(exportModel.getCreatorTime())) {
            ArrayList<Date> creatorTime = new ArrayList<Date>();
            creatorTime.add(new Date(exportModel.getCreatorTime().get(0)));
            creatorTime.add(new Date(exportModel.getCreatorTime().get(1)));
            inspectStatisticsSummaryQuery.setCreatorTime(creatorTime);
        }
        String str = "\u5de1\u68c0\u4efb\u52a1\u6c47\u603b";
        if (CollectionUtil.isNotEmpty(exportModel.getCreatorTime())) {
            inspectStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(0)));
            inspectStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(1)));
            str = str + inspectStatisticsSummaryQuery.getStartTime() + "-" + inspectStatisticsSummaryQuery.getEndTime();
        }
        inspectStatisticsSummaryQuery.setDataType(exportModel.getDataType());
        inspectStatisticsSummaryQuery.setExport(true);
        List<InspectStatisticsSummaryVO> list = this.afterSalesInspectTaskService.statisticsSummary(inspectStatisticsSummaryQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str, null);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/statistics/user/summary"})
    public ActionResult statisticsUserSummary(@RequestBody InspectStatisticsSummaryQuery inspectStatisticsSummaryQuery) {
        if (CollectionUtil.isNotEmpty(inspectStatisticsSummaryQuery.getCreatorTime())) {
            inspectStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(0)));
            inspectStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(1)));
        }
        List<InspectStatisticsSummaryVO> list = this.afterSalesInspectTaskService.statisticsUserSummary(inspectStatisticsSummaryQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)inspectStatisticsSummaryQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/statistics/user/Export"})
    public ActionResult exportStatisticsUserSummary(InspectStatisticsSummaryExportModel exportModel) {
        InspectStatisticsSummaryQuery inspectStatisticsSummaryQuery = new InspectStatisticsSummaryQuery();
        if (StringUtils.isNotEmpty(exportModel.getCreatorTime())) {
            ArrayList<Date> creatorTime = new ArrayList<Date>();
            creatorTime.add(new Date(exportModel.getCreatorTime().get(0)));
            creatorTime.add(new Date(exportModel.getCreatorTime().get(1)));
            inspectStatisticsSummaryQuery.setCreatorTime(creatorTime);
        }
        String str = "\u5de1\u68c0\u4efb\u52a1\u4e2a\u4eba";
        if (CollectionUtil.isNotEmpty(exportModel.getCreatorTime())) {
            inspectStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(0)));
            inspectStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)inspectStatisticsSummaryQuery.getCreatorTime().get(1)));
            str = str + inspectStatisticsSummaryQuery.getStartTime() + "-" + inspectStatisticsSummaryQuery.getEndTime();
        }
        inspectStatisticsSummaryQuery.setDataType(exportModel.getDataType());
        inspectStatisticsSummaryQuery.setExport(true);
        List<InspectStatisticsSummaryVO> list = this.afterSalesInspectTaskService.statisticsUserSummary(inspectStatisticsSummaryQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str, null);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult exportTask(@RequestBody AfterSalesInspectTaskExportModel exportModel) {
        Long sec;
        Long fir;
        AfterSalesInspectTaskBatchPagination afterSalesInspectTaskBatchPagination = (AfterSalesInspectTaskBatchPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), AfterSalesInspectTaskBatchPagination.class));
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        if (Objects.isNull(afterSalesInspectTaskBatchPagination.getActInspectUser())) {
            HashMap iCanWho = this.afterSalesRoleUtils.getICanWho(userInfo, "inspect");
            boolean isAll = (Boolean)iCanWho.get("isAll");
            if (!isAll) {
                userIdList.add(userInfo.getUserId());
                List list = (List)iCanWho.get("idList");
                userIdList.addAll(list);
            }
        } else {
            userIdList.add(afterSalesInspectTaskBatchPagination.getActInspectUser());
        }
        afterSalesInspectTaskBatchPagination.setUserIdList(userIdList);
        List<AfterSalesInspectTaskEntity> list = this.afterSalesInspectTaskService.getList(afterSalesInspectTaskBatchPagination);
        List listUser = this.crmCustomerContactsService.list();
        List listVO = JsonUtil.getJsonToList(list, AfterSalesInspectTaskListVO.class);
        for (AfterSalesInspectTaskListVO taskVo : listVO) {
            AfterSalesQuestionEntity questionEntity;
            AfterSalesInspectTaskBatchEntity byId = (AfterSalesInspectTaskBatchEntity)this.afterSalesInspectTaskBatchService.getById((Serializable)((Object)taskVo.getTaskBatchId()));
            taskVo.setName(byId.getName());
            taskVo.setExecutionStartTime(byId.getExecutionStartTime());
            taskVo.setExecutionEndTime(byId.getExecutionEndTime());
            taskVo.setCreatorTime(byId.getCreatorTime());
            List<AfterSalesInspectTaskProductEntity> listByTaskBatchId = this.afterSalesInspectTaskProductService.getListByTaskBatchIdAndTaskId(taskVo.getTaskBatchId(), taskVo.getId());
            String collect = listByTaskBatchId.stream().map(AfterSalesInspectTaskProductEntity::getProductName).collect(Collectors.joining(","));
            String projectName = listByTaskBatchId.stream().map(AfterSalesInspectTaskProductEntity::getProjectName).collect(Collectors.joining(","));
            taskVo.setProductName(collect);
            taskVo.setProjectName(projectName);
            if (StrUtil.isNotBlank((CharSequence)taskVo.getQuestionId()) && ObjectUtil.isNotNull((Object)(questionEntity = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)taskVo.getQuestionId()))))) {
                taskVo.setQuestionDesc(questionEntity.getDescription());
                taskVo.setQuestionCreator(this.baseDataUtil.userSelectValue(questionEntity.getCreatorUserId()));
                if (ObjectUtil.equals((Object)questionEntity.getIsResolved(), (Object)1)) {
                    taskVo.setQuestionDealTime(questionEntity.getDealTime());
                    taskVo.setQuestionDealUser(this.baseDataUtil.userSelectValue(questionEntity.getDealUser()));
                }
                if (ObjectUtil.equals((Object)questionEntity.getIsResolved(), (Object)2)) {
                    taskVo.setQuestionEstimatedTime(questionEntity.getEstimatedTime());
                }
                taskVo.setQuestionEnabledMark(QuestionEnableMarkEnum.getAllToMap().get(questionEntity.getEnabledMark()).getDesc());
            }
            List<AfterSalesInspectTaskTargetEntity> afterSalesInspectTargetList = this.afterSalesInspectTaskTargetService.getListByTaskId(taskVo.getId());
            List afterSalesInspectTargetModelList = JsonUtil.getJsonToList(afterSalesInspectTargetList, AfterSalesInspectTargetModel.class);
            for (AfterSalesInspectTargetModel afterSalesInspectTargetModel : afterSalesInspectTargetModelList) {
                List<AfterSalesInspectTaskExpectedResultEntity> byTargetId = this.afterSalesInspectTaskExpectedResultsService.getByTargetId(afterSalesInspectTargetModel.getId());
                afterSalesInspectTargetModel.setResultList(JsonUtil.getJsonToList(byTargetId, AfterSalesInspectExpectedResultEntity.class));
                String collect2 = byTargetId.stream().map(AfterSalesInspectTaskExpectedResultEntity::getResult).collect(Collectors.joining(","));
                afterSalesInspectTargetModel.setResultsStr(StrUtil.isBlank((CharSequence)collect2) ? "" : collect2);
                afterSalesInspectTargetModel.setExecutionResults(StrUtil.isBlank((CharSequence)afterSalesInspectTargetModel.getExecutionResults()) ? "" : afterSalesInspectTargetModel.getExecutionResults());
            }
            Map<String, String> collect1 = afterSalesInspectTargetModelList.stream().collect(Collectors.toMap(AfterSalesInspectTargetModel::getTarget, AfterSalesInspectTargetModel::getExecutionResults));
            taskVo.setResultMap(collect1);
            UserEntity info = (UserEntity)this.userService.getById((Serializable)((Object)taskVo.getInspectUserId()));
            if (!Objects.isNull(info)) {
                taskVo.setInspectUserId(info.getRealName());
                if (!Objects.isNull(info.getOrganizeId())) {
                    OrganizeEntity organizeEntity = this.organizeService.getDirectlyUnderCompanyById(info.getOrganizeId());
                    taskVo.setDepartmentName(organizeEntity.getFullName());
                }
            }
            taskVo.setEnabledMarkCode(taskVo.getEnabledMark());
            taskVo.setEnabledMark(this.baseDataUtil.getDictName(taskVo.getEnabledMark(), "inspectTaskStatus"));
            taskVo.setExecutionTime(DateUtil.daFormat((Date)taskVo.getExecutionStartTime()) + "\u81f3" + DateUtil.daFormat((Date)taskVo.getExecutionEndTime()));
            if (!StrUtil.isNotEmpty((CharSequence)taskVo.getContactId())) continue;
            for (CrmCustomerContactsEntity user : listUser) {
                if (!ObjectUtil.isNotEmpty((Object)user) || !user.getId().equals(taskVo.getContactId())) continue;
                taskVo.setContactDeptName(user.getDepartment());
                taskVo.setPost(user.getPost());
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        HashSet set = CollectionUtil.set((boolean)false, (Object[])new String[0]);
        HashMap keyMap = MapUtil.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                Map map = JsonUtil.stringToMap((String)JsonUtil.getObjectToString(m.get("resultMap")));
                Set strings = map.keySet();
                for (String s : strings) {
                    m.put(s, map.get(s));
                    set.add(s);
                    keyMap.put(s, s);
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                for (Object key : keyMap.keySet()) {
                    Set strings = m.keySet();
                    if (strings.contains(key)) continue;
                    m.put(key.toString(), "");
                }
            });
        }
        List collect = set.stream().collect(Collectors.toList());
        Collections.sort(collect, Collections.reverseOrder());
        exportModel.setSelectKey(exportModel.getSelectKey() + "," + CollectionUtil.join(collect, (CharSequence)","));
        String name = "\u5de1\u68c0\u4efb\u52a1";
        if (StrUtil.isNotEmpty((CharSequence)exportModel.getSource()) && StrUtil.equals((CharSequence)exportModel.getSource(), (CharSequence)"userDetail")) {
            name = "\u5de1\u68c0\u4e2a\u4eba\u4efb\u52a1\u5b8c\u6210\u660e\u7ec6";
            if (CollectionUtil.isNotEmpty(exportModel.getExecutionTime())) {
                fir = Long.valueOf(exportModel.getExecutionTime().get(0));
                sec = Long.valueOf(exportModel.getExecutionTime().get(1));
                name = name + DateUtil.stringToDate((String)DateUtil.daFormatYmd((Long)fir)) + "-" + DateUtil.stringToDate((String)DateUtil.daFormatYmd((Long)sec));
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)exportModel.getSource()) && StrUtil.equals((CharSequence)exportModel.getSource(), (CharSequence)"taskDetail")) {
            name = "\u5de1\u68c0\u4efb\u52a1\u660e\u7ec6";
            if (CollectionUtil.isNotEmpty(exportModel.getCreatorTime())) {
                fir = Long.valueOf(exportModel.getCreatorTime().get(0));
                sec = Long.valueOf(exportModel.getCreatorTime().get(1));
                name = name + DateUtil.stringToDate((String)DateUtil.daFormatYmd((Long)fir)) + "-" + DateUtil.stringToDate((String)DateUtil.daFormatYmd((Long)sec));
            }
            String selectKey = exportModel.getSelectKey();
            selectKey = selectKey + ",questionDesc,questionCreator,questionEnabledMark,questionEstimatedTime,questionDealUser,questionDealTime";
            exportModel.setSelectKey(selectKey);
        }
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, name, keyMap);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String appendStr, HashMap keyMap) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            block96: for (String key : keys) {
                if (ObjectUtil.isNotNull((Object)keyMap) && ObjectUtil.isNotNull(keyMap.get(key)) && StrUtil.isNotBlank((CharSequence)keyMap.get(key).toString())) {
                    entitys.add(new ExcelExportEntity(keyMap.get(key).toString(), (Object)key));
                    continue;
                }
                switch (key) {
                    case "questionDesc": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"questionDesc"));
                        continue block96;
                    }
                    case "questionCreator": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u63d0\u4ea4\u4eba", (Object)"questionCreator"));
                        continue block96;
                    }
                    case "questionEnabledMark": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u72b6\u6001", (Object)"questionEnabledMark"));
                        continue block96;
                    }
                    case "questionEstimatedTime": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u89e3\u51b3\u65f6\u95f4", (Object)"questionEstimatedTime"));
                        continue block96;
                    }
                    case "questionDealUser": {
                        entitys.add(new ExcelExportEntity("\u5904\u7406\u4eba", (Object)"questionDealUser"));
                        continue block96;
                    }
                    case "questionDealTime": {
                        entitys.add(new ExcelExportEntity("\u5904\u7406\u65f6\u95f4", (Object)"questionDealTime"));
                        continue block96;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block96;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u540d\u79f0", (Object)"name"));
                        continue block96;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u5ba2\u6237", (Object)"customerName"));
                        continue block96;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u4ea7\u54c1", (Object)"productName"));
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u9879\u76ee", (Object)"projectName"));
                        continue block96;
                    }
                    case "contactName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contactName"));
                        continue block96;
                    }
                    case "contactDeptName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u79d1\u5ba4", (Object)"contactDeptName"));
                        continue block96;
                    }
                    case "post": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u804c\u52a1", (Object)"post"));
                        continue block96;
                    }
                    case "contactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"contactPhone"));
                        continue block96;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block96;
                    }
                    case "inspectUserId": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u4eba", (Object)"inspectUserId"));
                        continue block96;
                    }
                    case "executionTime": {
                        entitys.add(new ExcelExportEntity("(\u9884\u8ba1)\u6267\u884c\u65f6\u95f4", (Object)"executionTime"));
                        continue block96;
                    }
                    case "actInspectTime": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u5b8c\u6210\u65f6\u95f4", (Object)"actInspectTime"));
                        continue block96;
                    }
                    case "evaluateTime": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u65f6\u95f4", (Object)"evaluateTime"));
                        continue block96;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u53d1\u5e03\u65f6\u95f4", (Object)"creatorTime"));
                        continue block96;
                    }
                    case "templateName": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u6a21\u677f", (Object)"templateName"));
                        continue block96;
                    }
                    case "target": {
                        entitys.add(new ExcelExportEntity("\u5de1\u68c0\u76ee\u6807", (Object)"target"));
                        continue block96;
                    }
                    case "executionResults": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u679c", (Object)"executionResults"));
                        continue block96;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df", (Object)"address"));
                        continue block96;
                    }
                    case "gradeName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7b49\u7ea7", (Object)"gradeName"));
                        continue block96;
                    }
                    case "grade": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7b49\u7ea7", (Object)"grade"));
                        continue block96;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"departmentName"));
                        continue block96;
                    }
                    case "contactsName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contactsName"));
                        continue block96;
                    }
                    case "contactsPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"contactsPhone"));
                        continue block96;
                    }
                    case "contactsDepartment": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"contactsDepartment"));
                        continue block96;
                    }
                    case "contactsPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u52a1", (Object)"contactsPost"));
                        continue block96;
                    }
                    case "inspectUserName": {
                        entitys.add(new ExcelExportEntity("\u4eba\u5458", (Object)"inspectUserName"));
                        continue block96;
                    }
                    case "taskNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u4efb\u52a1\u603b\u6570\u91cf", (Object)"taskNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "inspectCount": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5de1\u68c0\u4efb\u52a1\u4e2a\u6570", (Object)"inspectCount");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "publishedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u53d1\u5e03", (Object)"publishedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "claimedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u8ba4\u9886", (Object)"claimedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "assignedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u5206\u6d3e", (Object)"assignedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "toBeEvaluatedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u6267\u884c", (Object)"toBeEvaluatedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "evaluatedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u8bc4\u4ef7", (Object)"evaluatedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "completeNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5b8c\u6210\u6570\u91cf", (Object)"completeNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                    case "notCompleteNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5f85\u5b8c\u6570\u91cf", (Object)"notCompleteNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block96;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = appendStr + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public synchronized ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesInspectTaskEntity byId = (AfterSalesInspectTaskEntity)this.afterSalesInspectTaskService.getById((Serializable)((Object)id));
        if (!Objects.isNull(byId)) {
            if (!StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)InspectTaskEnableMarkEnum.ENABLE_PUBLISHED.getEnableMark())) {
                return ActionResult.fail((String)"\u5de1\u68c0\u4efb\u52a1\u4e0d\u662f\u5df2\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            return ActionResult.fail((String)"\u5de1\u68c0\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        byId.setDeleteFlag(1);
        byId.setDeleteTime(DateUtil.getNowDate());
        byId.setDeleteUserId(userInfo.getUserId());
        this.afterSalesInspectTaskService.updateById(byId);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        UserInfo userInfo = this.userProvider.get();
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        for (String allId : allIdList) {
            AfterSalesInspectTaskEntity byId = (AfterSalesInspectTaskEntity)this.afterSalesInspectTaskService.getById((Serializable)((Object)allId));
            if (Objects.isNull(byId) || !StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)InspectTaskEnableMarkEnum.ENABLE_PUBLISHED.getEnableMark())) continue;
            byId.setDeleteFlag(1);
            byId.setDeleteTime(DateUtil.getNowDate());
            byId.setDeleteUserId(userInfo.getUserId());
            this.afterSalesInspectTaskService.updateById(byId);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"resultSummary"})
    public ActionResult resultSummary(@RequestBody InspectResultSummaryQuery summaryQuery) {
        if (CollectionUtil.isNotEmpty(summaryQuery.getMonth())) {
            summaryQuery.setStartTime(DateUtil.daFormat((Long)Long.valueOf(summaryQuery.getMonth().get(0))));
            summaryQuery.setEndTime(DateUtil.daFormat((Long)Long.valueOf(summaryQuery.getMonth().get(1))));
        }
        if (CollectionUtil.isNotEmpty(summaryQuery.getActInspectTime())) {
            summaryQuery.setInspectStartTime(DateUtil.daFormat((Long)Long.valueOf(summaryQuery.getActInspectTime().get(0))));
            summaryQuery.setInspectEndTime(DateUtil.daFormat((Long)Long.valueOf(summaryQuery.getActInspectTime().get(1))));
        }
        List<InspectResultSummaryVO> list = this.afterSalesInspectTaskService.resultSummary(summaryQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)summaryQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/resultSummary/Export"})
    public ActionResult exportResultSummary(InspectResultSummaryExportModel exportModel) {
        InspectResultSummaryQuery resultSummaryQuery = (InspectResultSummaryQuery)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), InspectResultSummaryQuery.class));
        String str = "\u5de1\u68c0\u7ed3\u679c\u6c47\u603b";
        resultSummaryQuery.setDataType(exportModel.getDataType());
        resultSummaryQuery.setExport(true);
        if (CollectionUtil.isNotEmpty(resultSummaryQuery.getMonth())) {
            resultSummaryQuery.setStartTime(DateUtil.daFormat((Long)Long.valueOf(resultSummaryQuery.getMonth().get(0))));
            resultSummaryQuery.setEndTime(DateUtil.daFormat((Long)Long.valueOf(resultSummaryQuery.getMonth().get(1))));
        }
        if (CollectionUtil.isNotEmpty(resultSummaryQuery.getActInspectTime())) {
            resultSummaryQuery.setInspectStartTime(DateUtil.daFormat((Long)Long.valueOf(resultSummaryQuery.getActInspectTime().get(0))));
            resultSummaryQuery.setInspectEndTime(DateUtil.daFormat((Long)Long.valueOf(resultSummaryQuery.getActInspectTime().get(1))));
        }
        List<InspectResultSummaryVO> list = this.afterSalesInspectTaskService.resultSummary(resultSummaryQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str, null);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"customer"})
    public ActionResult customer(@RequestBody InspectCustomerQuery inspectCustomerQuery) throws Exception {
        if (CollectionUtil.isNotEmpty(inspectCustomerQuery.getPublishTime())) {
            inspectCustomerQuery.setStartTime(inspectCustomerQuery.getPublishTime().get(0));
            inspectCustomerQuery.setEndTime(inspectCustomerQuery.getPublishTime().get(1));
        }
        List<InspectCustomerDTO> list = this.afterSalesInspectTaskService.selectCustomerInspect(inspectCustomerQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)inspectCustomerQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/customer/Export"})
    public ActionResult exportcustomerTask(@RequestBody InspectCustomerExportModel exportModel) throws Exception {
        InspectCustomerQuery inspectCustomerQuery = (InspectCustomerQuery)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), InspectCustomerQuery.class));
        String str = "\u5ba2\u6237\u5de1\u68c0\u7ed3\u679c\u6c47\u603b";
        List<InspectCustomerDTO> list = this.afterSalesInspectTaskService.selectCustomerInspect(inspectCustomerQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str, null);
        return ActionResult.success((Object)vo);
    }
}

