/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesInspectExpectedResultEntity;
import com.bringspring.visit.entity.AfterSalesInspectTargetEntity;
import com.bringspring.visit.entity.AfterSalesInspectTemplateEntity;
import com.bringspring.visit.model.after_sales_inspect_template.AfterSalesInspectTargetModel;
import com.bringspring.visit.model.aftersalesinspecttemplate.AfterSalesInspectTemplateCrForm;
import com.bringspring.visit.model.aftersalesinspecttemplate.AfterSalesInspectTemplateInfoVO;
import com.bringspring.visit.model.aftersalesinspecttemplate.AfterSalesInspectTemplateListVO;
import com.bringspring.visit.model.aftersalesinspecttemplate.AfterSalesInspectTemplatePagination;
import com.bringspring.visit.model.aftersalesinspecttemplate.AfterSalesInspectTemplateUpForm;
import com.bringspring.visit.service.AfterSalesInspectExpectedResultsService;
import com.bringspring.visit.service.AfterSalesInspectTargetService;
import com.bringspring.visit.service.AfterSalesInspectTemplateService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de1\u68c0\u6a21\u677f"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesInspectTemplate"})
public class AfterSalesInspectTemplateController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesInspectTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesInspectTemplateService afterSalesInspectTemplateService;
    @Autowired
    private AfterSalesInspectTargetService afterSalesInspectTargetService;
    @Autowired
    private AfterSalesInspectExpectedResultsService afterSalesInspectExpectedResultsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesInspectTemplatePagination afterSalesInspectTemplatePagination) throws IOException {
        List<AfterSalesInspectTemplateEntity> list = this.afterSalesInspectTemplateService.getList(afterSalesInspectTemplatePagination);
        for (AfterSalesInspectTemplateEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesInspectTemplateListVO.class);
        for (AfterSalesInspectTemplateListVO afterSalesInspectTemplateVO : listVO) {
            afterSalesInspectTemplateVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(afterSalesInspectTemplateVO.getCreatorUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesInspectTemplatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"getListByEnableMark"})
    public ActionResult getListByEnableMark(Integer enableMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (enableMark != null) {
            queryWrapper.lambda().eq(AfterSalesInspectTemplateEntity::getEnabledMark, (Object)enableMark);
        }
        return ActionResult.success((Object)this.afterSalesInspectTemplateService.list((Wrapper)queryWrapper));
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AfterSalesInspectTemplateCrForm afterSalesInspectTemplateCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        AfterSalesInspectTemplateEntity entity = (AfterSalesInspectTemplateEntity)JsonUtil.getJsonToBean((Object)afterSalesInspectTemplateCrForm, AfterSalesInspectTemplateEntity.class);
        entity.setId(mainId);
        this.afterSalesInspectTemplateService.save(entity);
        List AfterSalesInspectTargetList = JsonUtil.getJsonToList(afterSalesInspectTemplateCrForm.getTargetList(), AfterSalesInspectTargetEntity.class);
        for (AfterSalesInspectTargetEntity entitys : AfterSalesInspectTargetList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setInspectTemplateId(entity.getId());
            this.afterSalesInspectTargetService.save(entitys);
            List<AfterSalesInspectExpectedResultEntity> resultsList = entitys.getResultList();
            for (AfterSalesInspectExpectedResultEntity resultsEntity : resultsList) {
                resultsEntity.setTargetId(entitys.getId());
                resultsEntity.setInspectTemplateId(entity.getId());
            }
            this.afterSalesInspectExpectedResultsService.saveBatch(resultsList);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesInspectTemplateInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesInspectTemplateEntity entity = this.afterSalesInspectTemplateService.getInfo(id);
        AfterSalesInspectTemplateInfoVO vo = (AfterSalesInspectTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesInspectTemplateInfoVO.class);
        List<AfterSalesInspectTargetEntity> AfterSalesInspectTargetList = this.afterSalesInspectTemplateService.GetAfterSalesInspectTargetList(id);
        for (AfterSalesInspectTargetEntity aftersalesinspecttargetEntity : AfterSalesInspectTargetList) {
            List<AfterSalesInspectExpectedResultEntity> byTargetId = this.afterSalesInspectExpectedResultsService.getByTargetId(aftersalesinspecttargetEntity.getId());
            aftersalesinspecttargetEntity.setResultList(byTargetId);
        }
        vo.setTargetList(JsonUtil.getJsonToList(AfterSalesInspectTargetList, AfterSalesInspectTargetModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesInspectTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesInspectTemplateEntity entity = this.afterSalesInspectTemplateService.getInfo(id);
        AfterSalesInspectTemplateInfoVO vo = (AfterSalesInspectTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesInspectTemplateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List<AfterSalesInspectTargetEntity> afterSalesInspectTargetList = this.afterSalesInspectTemplateService.GetAfterSalesInspectTargetList(id);
        List afterSalesInspectTargetModelList = JsonUtil.getJsonToList(afterSalesInspectTargetList, AfterSalesInspectTargetModel.class);
        for (AfterSalesInspectTargetModel afterSalesInspectTargetModel : afterSalesInspectTargetModelList) {
            List<AfterSalesInspectExpectedResultEntity> byTargetId = this.afterSalesInspectExpectedResultsService.getByTargetId(afterSalesInspectTargetModel.getId());
            afterSalesInspectTargetModel.setResultList(byTargetId);
            String collect = byTargetId.stream().map(AfterSalesInspectExpectedResultEntity::getResult).collect(Collectors.joining(","));
            afterSalesInspectTargetModel.setResultsStr(collect);
        }
        vo.setTargetList(afterSalesInspectTargetModelList);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesInspectTemplateUpForm afterSalesInspectTemplateUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesInspectTemplateEntity entity = this.afterSalesInspectTemplateService.getInfo(id);
        if (entity != null) {
            AfterSalesInspectTemplateEntity subentity = (AfterSalesInspectTemplateEntity)JsonUtil.getJsonToBean((Object)afterSalesInspectTemplateUpForm, AfterSalesInspectTemplateEntity.class);
            this.afterSalesInspectTemplateService.update(id, subentity);
            QueryWrapper AfterSalesInspectTargetqueryWrapper = new QueryWrapper();
            AfterSalesInspectTargetqueryWrapper.lambda().eq(AfterSalesInspectTargetEntity::getInspectTemplateId, (Object)entity.getId());
            this.afterSalesInspectTargetService.remove((Wrapper)AfterSalesInspectTargetqueryWrapper);
            QueryWrapper expectedResultEntityQueryWrapper = new QueryWrapper();
            expectedResultEntityQueryWrapper.lambda().eq(AfterSalesInspectExpectedResultEntity::getInspectTemplateId, (Object)entity.getId());
            this.afterSalesInspectExpectedResultsService.remove((Wrapper)expectedResultEntityQueryWrapper);
            List AfterSalesInspectTargetList = JsonUtil.getJsonToList(afterSalesInspectTemplateUpForm.getTargetList(), AfterSalesInspectTargetEntity.class);
            for (AfterSalesInspectTargetEntity entitys : AfterSalesInspectTargetList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setInspectTemplateId(entity.getId());
                this.afterSalesInspectTargetService.save(entitys);
                List<AfterSalesInspectExpectedResultEntity> resultsList = entitys.getResultList();
                for (AfterSalesInspectExpectedResultEntity resultsEntity : resultsList) {
                    resultsEntity.setTargetId(entitys.getId());
                    resultsEntity.setInspectTemplateId(entity.getId());
                }
                this.afterSalesInspectExpectedResultsService.saveBatch(resultsList);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesInspectTemplateEntity entity = this.afterSalesInspectTemplateService.getInfo(id);
        if (entity != null) {
            this.afterSalesInspectTemplateService.delete(entity);
            QueryWrapper queryWrapperAfterSalesInspectTarget = new QueryWrapper();
            queryWrapperAfterSalesInspectTarget.lambda().eq(AfterSalesInspectTargetEntity::getInspectTemplateId, (Object)entity.getId());
            this.afterSalesInspectTargetService.remove((Wrapper)queryWrapperAfterSalesInspectTarget);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/stop/{id}"})
    public ActionResult stop(@PathVariable(value="id") String id) {
        AfterSalesInspectTemplateEntity entity = this.afterSalesInspectTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u5de1\u68c0\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(0);
        this.afterSalesInspectTemplateService.update(id, entity);
        return ActionResult.success((String)"\u505c\u7528\u6210\u529f");
    }
}

