/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.AllMaintenanceTypeEnum;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.entity.AfterSalesMaintenanceEntity;
import com.bringspring.visit.model.aftersalesmaintenance.AfterSalesMaintenanceCrForm;
import com.bringspring.visit.model.aftersalesmaintenance.AfterSalesMaintenanceInfoVO;
import com.bringspring.visit.model.aftersalesmaintenance.AfterSalesMaintenanceListVO;
import com.bringspring.visit.model.aftersalesmaintenance.AfterSalesMaintenancePagination;
import com.bringspring.visit.model.aftersalesmaintenance.AfterSalesMaintenanceUpForm;
import com.bringspring.visit.service.AfterSalesCommunicationRecordService;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ef4\u4fdd\u8ddf\u8fdb"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesMaintenance"})
public class AfterSalesMaintenanceController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesMaintenanceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private AfterSalesCommunicationRecordService afterSalesCommunicationRecordService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress") @RequestBody AfterSalesMaintenancePagination afterSalesMaintenancePagination) throws IOException {
        afterSalesMaintenancePagination.setMaintenanceType(AllMaintenanceTypeEnum.MAINTENANCEFOLLOW.getType());
        List<AfterSalesMaintenanceEntity> list = this.afterSalesMaintenanceService.getList(afterSalesMaintenancePagination);
        List<AfterSalesMaintenanceListVO> listVO = JsonUtil.getJsonToList(list, AfterSalesMaintenanceListVO.class);
        listVO = this.getInfoList(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesMaintenancePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<AfterSalesMaintenanceListVO> getInfoList(List<AfterSalesMaintenanceListVO> listVO) {
        for (AfterSalesMaintenanceListVO vo : listVO) {
            CrmProductEntity productEntity;
            long between;
            LocalDate endDate;
            LocalDate now;
            if (ObjectUtil.isNotEmpty((Object)vo.getState()) && ObjectUtil.isNotEmpty((Object)vo.getExpirationDate()) && !StrUtil.equals((CharSequence)vo.getState(), (CharSequence)"derelivery")) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(vo.getExpirationDate() / 86400000L);
                between = ChronoUnit.DAYS.between(now, endDate);
                vo.setMaturityDays((int)between);
            }
            if (StrUtil.equals((CharSequence)vo.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)vo.getExpirationDate())) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(vo.getExpirationDate() / 86400000L);
                between = ChronoUnit.DAYS.between(endDate, now);
                vo.setOutDays((int)between);
            }
            vo.setState(this.baseDataUtil.getDictName(vo.getState(), "afterSalesProjectWarrantyState"));
            vo.setFollowStatus(this.baseDataUtil.getDictName(vo.getFollowStatus(), "FollowStatus"));
            vo.setWarrantyState(this.baseDataUtil.getDictName(vo.getWarrantyState(), "MaintainStatus"));
            vo.setAfterSalesRegional(this.baseDataUtil.userSelectValue(vo.getAfterSalesRegional()));
            vo.setAfterSalesPerson(this.baseDataUtil.userSelectValue(vo.getAfterSalesPerson()));
            vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
            if (StrUtil.isNotEmpty((CharSequence)vo.getIncomeType())) {
                vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getReplacementProduct())) {
                vo.setReplacementProductName(this.crmProductCategoryService.getNameByIds(vo.getReplacementProduct()));
            }
            if (ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(vo.getProductId())))) {
                vo.setProductId(productEntity.getProductName());
            }
            vo.setLatestCommunicator(this.baseDataUtil.userSelectValue(vo.getLatestCommunicator()));
            vo.setProcessedByName(this.baseDataUtil.userSelectValue(vo.getProcessedBy()));
            vo.setDepartmentId(this.baseDataUtil.comSelectValues(vo.getDepartmentId()));
            if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerAddress()) && vo.getCustomerAddress().contains("[")) {
                vo.setCustomerAddress(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
            }
            vo.setStopReasonTypeName(this.baseDataUtil.getDictName(vo.getStopReasonType(), "productStopReasonType"));
        }
        return listVO;
    }

    @PostMapping(value={"/getProductLineList"})
    public ActionResult productLineList(@RequestBody AfterSalesMaintenancePagination afterSalesMaintenancePagination) throws IOException {
        afterSalesMaintenancePagination.setMaintenanceType(AllMaintenanceTypeEnum.PRODUCTLINE.getType());
        List<AfterSalesMaintenanceEntity> list = this.afterSalesMaintenanceService.getList(afterSalesMaintenancePagination);
        List<AfterSalesMaintenanceListVO> listVO = JsonUtil.getJsonToList(list, AfterSalesMaintenanceListVO.class);
        listVO = this.getInfoList(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesMaintenancePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid AfterSalesMaintenanceCrForm afterSalesMaintenanceCrForm) throws DataException {
        this.afterSalesMaintenanceService.create(afterSalesMaintenanceCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesMaintenanceInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesMaintenanceEntity entity = this.afterSalesMaintenanceService.getInfo(id);
        AfterSalesMaintenanceInfoVO vo = (AfterSalesMaintenanceInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesMaintenanceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesMaintenanceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductEntity productEntity;
        long between;
        LocalDate endDate;
        LocalDate now;
        AfterSalesMaintenanceEntity entity = this.afterSalesMaintenanceService.getInfo(id);
        AfterSalesMaintenanceInfoVO vo = (AfterSalesMaintenanceInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesMaintenanceInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)vo.getState()) && ObjectUtil.isNotEmpty((Object)vo.getExpirationDate()) && !StrUtil.equals((CharSequence)vo.getState(), (CharSequence)"derelivery")) {
            now = LocalDate.now();
            endDate = LocalDate.ofEpochDay(vo.getExpirationDate() / 86400000L);
            between = ChronoUnit.DAYS.between(now, endDate);
            vo.setMaturityDays((int)between);
        }
        if (StrUtil.equals((CharSequence)vo.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)vo.getExpirationDate())) {
            now = LocalDate.now();
            endDate = LocalDate.ofEpochDay(vo.getExpirationDate() / 86400000L);
            between = ChronoUnit.DAYS.between(endDate, now);
            vo.setOutDays((int)between);
        }
        vo.setState(this.baseDataUtil.getDictName(vo.getState(), "afterSalesProjectWarrantyState"));
        vo.setFollowStatus(this.baseDataUtil.getDictName(vo.getFollowStatus(), "FollowStatus"));
        vo.setWarrantyState(this.baseDataUtil.getDictName(vo.getWarrantyState(), "MaintainStatus"));
        vo.setAfterSalesRegional(this.baseDataUtil.userSelectValue(vo.getAfterSalesRegional()));
        vo.setAfterSalesPerson(this.baseDataUtil.userSelectValue(vo.getAfterSalesPerson()));
        vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getIncomeType())) {
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        }
        if (ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(vo.getProductId())))) {
            vo.setProductId(productEntity.getProductName());
        }
        vo.setLatestCommunicator(this.baseDataUtil.userSelectValue(vo.getLatestCommunicator()));
        vo.setProcessedByName(this.baseDataUtil.userSelectValue(vo.getProcessedBy()));
        vo.setDepartmentId(this.baseDataUtil.comSelectValues(vo.getDepartmentId()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerAddress()) && vo.getCustomerAddress().contains("[")) {
            vo.setCustomerAddress(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getReplacementProduct())) {
            vo.setReplacementProductName(this.crmProductCategoryService.getNameByIds(vo.getReplacementProduct()));
        }
        vo.setStopReasonTypeName(this.baseDataUtil.getDictName(vo.getStopReasonType(), "productStopReasonType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesMaintenanceUpForm afterSalesMaintenanceUpForm) throws DataException {
        this.afterSalesMaintenanceService.update(id, afterSalesMaintenanceUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/state/{id}"})
    public ActionResult updateStateBy(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesMaintenanceUpForm afterSalesMaintenanceUpForm) throws DataException {
        this.afterSalesMaintenanceService.update(id, afterSalesMaintenanceUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/countTab/{id}"})
    public ActionResult countTab(@PathVariable(value="id") String id, String menuId) {
        HashMap map = MapUtil.newHashMap();
        long contractCount = 0L;
        long projectCount = 0L;
        long communicationrecordCount = 0L;
        AfterSalesMaintenanceEntity info = this.afterSalesMaintenanceService.getInfo(id);
        if (ObjectUtil.isNull((Object)info)) {
            return null;
        }
        communicationrecordCount = this.afterSalesCommunicationRecordService.getMainCount(id);
        if (StrUtil.isNotEmpty((CharSequence)menuId)) {
            contractCount = this.contractService.countByCustomerId(info.getCustomerId(), menuId);
            projectCount = this.rkContractProjectService.countByCustomerId(info.getCustomerId(), menuId);
        }
        map.put("contractCount", contractCount);
        map.put("projectCount", projectCount);
        map.put("communicationrecordCount", communicationrecordCount);
        return ActionResult.success((Object)map);
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesMaintenanceEntity entity = this.afterSalesMaintenanceService.getInfo(id);
        if (entity != null) {
            this.afterSalesMaintenanceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

