/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesPerformerDetailEntity;
import com.bringspring.visit.entity.AfterSalesPerformerEntity;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerCrForm;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerInfoVO;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerListVO;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerPagination;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerPaginationExportModel;
import com.bringspring.visit.model.aftersalesperformer.AfterSalesPerformerUpForm;
import com.bringspring.visit.service.AfterSalesPerformerDetailService;
import com.bringspring.visit.service.AfterSalesPerformerService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u540e\u8868\u626c\u4fe1"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesPerformer"})
public class AfterSalesPerformerController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesPerformerController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private AfterSalesPerformerService afterSalesPerformerService;
    @Autowired
    private AfterSalesPerformerDetailService afterSalesPerformerDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesPerformerPagination afterSalesPerformerPagination) throws IOException {
        List<AfterSalesPerformerEntity> list = this.afterSalesPerformerService.getList(afterSalesPerformerPagination);
        for (AfterSalesPerformerEntity afterSalesPerformerEntity : list) {
            afterSalesPerformerEntity.setAttachment(this.baseDataUtil.getFileNameInJson(afterSalesPerformerEntity.getAttachment()));
            afterSalesPerformerEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(afterSalesPerformerEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesPerformerListVO.class);
        for (AfterSalesPerformerListVO listVo : listVO) {
            List<AfterSalesPerformerDetailEntity> listByPerformerId = this.afterSalesPerformerDetailService.getListByPerformerId(listVo.getId());
            String performerName = listByPerformerId.stream().map(AfterSalesPerformerDetailEntity::getPerformerName).collect(Collectors.joining(","));
            String departmentName = listByPerformerId.stream().map(AfterSalesPerformerDetailEntity::getPerformerDepartmentName).collect(Collectors.joining(","));
            listVo.setPerformerUserName(performerName);
            listVo.setPerformerDepartmentName(departmentName);
            listVo.setCompanyName(this.serviceAllUtil.getOrganizeInfo(listVo.getCompanyId()).getShortName());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesPerformerPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid AfterSalesPerformerCrForm afterSalesPerformerCrForm) throws DataException {
        this.afterSalesPerformerService.create(afterSalesPerformerCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(AfterSalesPerformerPaginationExportModel afterSalesPerformerPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)afterSalesPerformerPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        AfterSalesPerformerPagination afterSalesPerformerPagination = (AfterSalesPerformerPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)afterSalesPerformerPaginationExportModel), AfterSalesPerformerPagination.class));
        List<AfterSalesPerformerEntity> list = this.afterSalesPerformerService.getTypeList(afterSalesPerformerPagination, afterSalesPerformerPaginationExportModel.getDataType());
        for (AfterSalesPerformerEntity afterSalesPerformerEntity : list) {
            afterSalesPerformerEntity.setAttachment(this.baseDataUtil.getFileNameInJson(afterSalesPerformerEntity.getAttachment()));
            afterSalesPerformerEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(afterSalesPerformerEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesPerformerListVO.class);
        for (AfterSalesPerformerListVO afterSalesPerformerVO : listVO) {
            List<AfterSalesPerformerDetailEntity> listByPerformerId = this.afterSalesPerformerDetailService.getListByPerformerId(afterSalesPerformerVO.getId());
            String performerName = listByPerformerId.stream().map(AfterSalesPerformerDetailEntity::getPerformerName).collect(Collectors.joining(","));
            String departmentName = listByPerformerId.stream().map(AfterSalesPerformerDetailEntity::getPerformerDepartmentName).collect(Collectors.joining(","));
            afterSalesPerformerVO.setPerformerUserName(performerName);
            afterSalesPerformerVO.setPerformerDepartmentName(departmentName);
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)afterSalesPerformerPaginationExportModel.getSelectKey()) ? afterSalesPerformerPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerName"));
                        continue block28;
                    }
                    case "performerUserName": {
                        entitys.add(new ExcelExportEntity("\u88ab\u8868\u626c\u4eba", (Object)"performerUserName"));
                        continue block28;
                    }
                    case "performerDepartmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"performerDepartmentName"));
                        continue block28;
                    }
                    case "performerDate": {
                        entitys.add(new ExcelExportEntity("\u8868\u626c\u65e5\u671f", (Object)"performerDate"));
                        continue block28;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block28;
                    }
                    case "attachment": {
                        entitys.add(new ExcelExportEntity("\u9644\u4ef6", (Object)"attachment"));
                        continue block28;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserId"));
                        continue block28;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u626c\u4fe1\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesPerformerInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesPerformerEntity entity = this.afterSalesPerformerService.getInfo(id);
        AfterSalesPerformerInfoVO vo = (AfterSalesPerformerInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesPerformerInfoVO.class);
        List<AfterSalesPerformerDetailEntity> listByPerformerId = this.afterSalesPerformerDetailService.getListByPerformerId(id);
        vo.setPerformerList(listByPerformerId);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesPerformerInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesPerformerEntity entity = this.afterSalesPerformerService.getInfo(id);
        AfterSalesPerformerInfoVO vo = (AfterSalesPerformerInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesPerformerInfoVO.class);
        vo.setAttachment(this.baseDataUtil.getFileNameInJson(vo.getAttachment()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesPerformerUpForm afterSalesPerformerUpForm) throws DataException {
        this.afterSalesPerformerService.update(id, afterSalesPerformerUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesPerformerEntity entity = this.afterSalesPerformerService.getInfo(id);
        if (entity != null) {
            this.afterSalesPerformerService.delete(entity);
            this.afterSalesPerformerDetailService.deleteByPerformerId(entity.getId());
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

