/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.utils.DateUtils;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerUserPointsEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.model.crmproduct.CrmProductInfoVO;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmCustomerUserPointsService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesAttachmentEntity;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.entity.AfterSalesQuestionTrendsEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskDetailEntity;
import com.bringspring.visit.model.aftersalesattachment.AfterSalesAttachmentModel;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuesitonStatisticsSummaryExportModel;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuesitonStatisticsSummaryQuery;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionAssignCrForm;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionAuditCrForm;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionBackCrForm;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionCrForm;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionDealCrForm;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionInfoVO;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionListVO;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionPagination;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionPaginationExportModel;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionTrendsPagination;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionUpForm;
import com.bringspring.visit.model.aftersalesquestion.QuestionSstatisticsSummaryVO;
import com.bringspring.visit.model.aftersalesquestionmessagecount.AfterSalesQuestionMessageCountCrForm;
import com.bringspring.visit.service.AfterSalesAttachmentService;
import com.bringspring.visit.service.AfterSalesQuestionMessageCountService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.AfterSalesQuestionTrendsService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskDetailService;
import com.bringspring.visit.service.RkMarketLogService;
import com.bringspring.visit.utils.AfterSalesAttachmentTypeEnum;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.visit.utils.QuestionEnableMarkEnum;
import com.bringspring.visit.utils.QuestionTrendsTypeEnum;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workitem.entity.CrmWorkitemEntity;
import com.bringspring.workitem.service.CrmWorkitemService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u540e\u95ee\u9898"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesQuestion"})
public class AfterSalesQuestionController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesQuestionController.class);
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkMarketLogService rkMarketLogService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private AfterSalesAttachmentService afterSalesAttachmentService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private AfterSalesQuestionTrendsService afterSalesQuestionTrendsService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerUserPointsService crmCustomerUserPointsService;
    @Autowired
    private AfterSalesTelephoneTaskDetailService afterSalesTelephoneTaskDetailService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private AfterSalesQuestionMessageCountService afterSalesQuestionMessageCountService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesQuestionPagination afterSalesQuestionPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getList(afterSalesQuestionPagination);
        PageListVO vo = new PageListVO();
        vo.setList(this.appendVo(list));
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getQuestionTrendsList"})
    @NotCheckLogin
    public ActionResult getQuestionTrendsList(@RequestBody AfterSalesQuestionTrendsPagination afterSalesQuestionTrendsPagination) {
        UserInfo userInfo = this.userProvider.get();
        List<AfterSalesQuestionEntity> questionTrendsList = this.afterSalesQuestionService.getQuestionTrendsList(afterSalesQuestionTrendsPagination);
        List listVO = JsonUtil.getJsonToList(questionTrendsList, AfterSalesQuestionListVO.class);
        if (CollectionUtil.isEmpty((Collection)listVO)) {
            return ActionResult.success((Object)listVO);
        }
        for (AfterSalesQuestionListVO vo : listVO) {
            vo.setPriorityName(this.baseDataUtil.getDictName(vo.getPriority(), "problemPriority"));
            vo.setEnabledMarkName(this.baseDataUtil.getDictName(vo.getEnabledMark(), "problemStatus"));
            CrmCustomerEntity customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()));
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                vo.setAddressLng(customer.getAddressLongitude());
                vo.setAddressLat(customer.getAddressLatitude());
                vo.setCustomerAddress(customer.getDetailAddress());
                vo.setClassificationCode(customer.getClassificationCode());
            }
            if (!StrUtil.isNotEmpty((CharSequence)vo.getProductId())) continue;
            List<String> productIdList = Arrays.asList(vo.getProductId().split(","));
            List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
            String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/getByAfterProjectId/{projectId}"})
    public ActionResult list(@PathVariable(value="projectId") String projectId) throws IOException {
        AfterSalesQuestionPagination afterSalesQuestionPagination = new AfterSalesQuestionPagination();
        afterSalesQuestionPagination.setProjectId(projectId);
        afterSalesQuestionPagination.setIsAudit(0);
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getList(afterSalesQuestionPagination);
        List<AfterSalesQuestionListVO> afterSalesQuestionListVOS = this.appendVo(list);
        return ActionResult.success(afterSalesQuestionListVOS);
    }

    private HashMap canSee() {
        List role;
        List roleIds;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isManage", false);
        List companyIdList = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        if (!StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"2")) {
            companyIdList.add(userInfo.getOrganizeId());
        }
        if (userInfo.getUserId().equals("admin")) {
            map.put("isManage", true);
        }
        if (CollectionUtil.isEmpty(roleIds = (role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role")).stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList()))) {
            List listByObjectId = this.userRelationService.getListByUserId(userInfo.getUserId(), "Role");
            roleIds = listByObjectId.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            log.info("\u91cd\u65b0\u67e5\u8be2roleId\uff1a", (Object)JsonUtil.getObjectToString(roleIds));
        }
        List listByIds = this.roleService.getListByIds(roleIds);
        List collect = listByIds.stream().map(PermissionEntityBase::getEnCode).collect(Collectors.toList());
        for (String str : collect) {
            if (!str.endsWith("AfterSalesManage")) continue;
            map.put("isManage", true);
            break;
        }
        map.put("companyIdList", companyIdList);
        return map;
    }

    @PostMapping(value={"countTabs"})
    public ActionResult countTabs(@RequestBody AfterSalesQuestionPagination afterSalesQuestionPagination) {
        List<Map<String, Object>> maps = this.afterSalesQuestionService.countTabs(afterSalesQuestionPagination);
        return ActionResult.success(maps);
    }

    @PostMapping(value={"countTabs400"})
    public ActionResult countTabs400(@RequestBody AfterSalesQuestionPagination afterSalesQuestionPagination) {
        afterSalesQuestionPagination.setEnabledMark("");
        afterSalesQuestionPagination.setEnabledMarkList(CollectionUtil.list((boolean)false));
        afterSalesQuestionPagination.setFourState("");
        afterSalesQuestionPagination.setFourStateList(CollectionUtil.list((boolean)false));
        List<Map<String, Object>> maps = this.afterSalesQuestionService.countTabs(afterSalesQuestionPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("-1", "0");
        map.put("pendingOrders", "0");
        map.put("receivedOrder", "0");
        map.put("resolved", "0");
        maps.stream().forEach(m -> {
            Integer receivedOrder;
            Object enabledMark = m.get("enabledMark");
            Integer newCout = Integer.valueOf(m.get("count").toString());
            if (ObjectUtil.equals(enabledMark, (Object)"pendingOrders")) {
                receivedOrder = Integer.valueOf(map.get("pendingOrders").toString());
                map.put("pendingOrders", newCout + receivedOrder);
            }
            if (ObjectUtil.equals(enabledMark, (Object)"receivedOrder") || ObjectUtil.equals(enabledMark, (Object)"pending")) {
                receivedOrder = Integer.valueOf(map.get("receivedOrder").toString());
                map.put("receivedOrder", newCout + receivedOrder);
            }
            if (ObjectUtil.equals(enabledMark, (Object)"close") || ObjectUtil.equals(enabledMark, (Object)"resolved")) {
                receivedOrder = Integer.valueOf(map.get("resolved").toString());
                map.put("resolved", newCout + receivedOrder);
            }
            Integer total = Integer.valueOf(map.get("-1").toString());
            map.put("-1", total + newCout);
        });
        HashMap map0 = MapUtil.newHashMap();
        map0.put("enabledMark", "-1");
        map0.put("count", map.get("-1"));
        HashMap map1 = MapUtil.newHashMap();
        map1.put("enabledMark", "pendingOrders");
        map1.put("count", map.get("pendingOrders"));
        HashMap map2 = MapUtil.newHashMap();
        map2.put("enabledMark", "receivedOrder");
        map2.put("count", map.get("receivedOrder"));
        HashMap map3 = MapUtil.newHashMap();
        map3.put("enabledMark", "resolved");
        map3.put("count", map.get("resolved"));
        List list = CollectionUtil.list((boolean)false, (Object[])new HashMap[]{map0, map1, map2, map3});
        return ActionResult.success((Object)list);
    }

    @PostMapping
    @DSTransactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid AfterSalesQuestionCrForm afterSalesQuestionCrForm) throws Exception {
        HashMap map;
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNull((Object)afterSalesQuestionCrForm.getFeedbackSource())) {
            afterSalesQuestionCrForm.setFeedbackSource(1);
        }
        if (!StrUtil.equals((CharSequence)afterSalesQuestionCrForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            if (ObjectUtil.equals((Object)afterSalesQuestionCrForm.getFeedbackSource(), (Object)1) || ObjectUtil.equals((Object)afterSalesQuestionCrForm.getFeedbackSource(), (Object)3)) {
                afterSalesQuestionCrForm.setIsAudit(0);
                afterSalesQuestionCrForm.setEnabledMark(QuestionEnableMarkEnum.ENABLE_AUDIT.getEnableMark());
            } else {
                afterSalesQuestionCrForm.setIsAudit(1);
                afterSalesQuestionCrForm.setEnabledMark(QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark());
                if (ObjectUtil.equals((Object)afterSalesQuestionCrForm.getIsAssign(), (Object)0)) {
                    afterSalesQuestionCrForm.setProcessedBy(this.userProvider.get().getUserId());
                }
            }
        }
        if (!Objects.isNull(map = this.afterSalesQuestionService.saveQuestion(afterSalesQuestionCrForm)) && !Objects.isNull(map.get("error"))) {
            return ActionResult.fail((String)map.get("error").toString());
        }
        if (!Objects.isNull(map) && !Objects.isNull(map.get("success"))) {
            String questionId = map.get("success").toString();
            HashMap returnMap = MapUtil.newHashMap();
            returnMap.put("questionId", questionId);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)returnMap);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @NotCheckLogin
    @PostMapping(value={"customer"})
    @RepeatSubmit
    public ActionResult customerCreate(@RequestBody @Valid AfterSalesQuestionCrForm afterSalesQuestionCrForm) throws Exception {
        HashMap map;
        afterSalesQuestionCrForm.setFeedbackSource(3);
        afterSalesQuestionCrForm.setIsAudit(0);
        afterSalesQuestionCrForm.setEnabledMark(QuestionEnableMarkEnum.ENABLE_AUDIT.getEnableMark());
        afterSalesQuestionCrForm.setType("problemOther");
        CrmCustomerUserPointsEntity infoByOpenid = this.crmCustomerUserPointsService.getInfoByOpenid(afterSalesQuestionCrForm.getOpenid());
        if (ObjectUtil.isNotNull((Object)infoByOpenid)) {
            afterSalesQuestionCrForm.setCustomerName(infoByOpenid.getCustomerName());
            afterSalesQuestionCrForm.setCustomerId(infoByOpenid.getCustomerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionCrForm.getOpenid()) && StrUtil.isEmpty((CharSequence)afterSalesQuestionCrForm.getContactsPhone()) && ObjectUtil.isNotNull((Object)infoByOpenid)) {
            afterSalesQuestionCrForm.setContactsPhone(infoByOpenid.getPhone());
        }
        if (!Objects.isNull(map = this.afterSalesQuestionService.saveQuestion(afterSalesQuestionCrForm)) && !Objects.isNull(map.get("error"))) {
            return ActionResult.fail((String)map.get("error").toString());
        }
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PostMapping(value={"getTelephoneQuestion"})
    public ActionResult getTelephoneQuestion(@RequestBody AfterSalesQuestionPagination afterSalesQuestionPagination) {
        List<AfterSalesTelephoneTaskDetailEntity> questionIdList = this.afterSalesTelephoneTaskDetailService.getQuestionIdList(afterSalesQuestionPagination);
        if (CollectionUtil.isNotEmpty(questionIdList)) {
            afterSalesQuestionPagination.setIds(questionIdList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getQuestionId())).map(AfterSalesTelephoneTaskDetailEntity::getQuestionId).collect(Collectors.toList()));
        }
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getTelephoneQuestionList(afterSalesQuestionPagination);
        PageListVO vo = new PageListVO();
        vo.setList(this.appendVo(list));
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"my"})
    @NotCheckLogin
    public ActionResult customerMy(@RequestBody AfterSalesQuestionPagination pagination) {
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.customerMy(pagination);
        PageListVO vo = new PageListVO();
        vo.setList(this.appendVo(list));
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesQuestionInfoVO> info(@PathVariable(value="id") String id) {
        List<String> productIdList;
        CrmCustomerEntity byId;
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        AfterSalesQuestionInfoVO vo = (AfterSalesQuestionInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesQuestionInfoVO.class);
        if (StringUtils.isNotEmpty((String)entity.getProductId())) {
            vo.setProductCategoryId(Arrays.asList(entity.getProductId().split(",")));
        }
        vo.setProcessedById(vo.getProcessedBy());
        vo.setProcessedBy(this.baseDataUtil.userSelectValueNoAccount(entity.getProcessedBy()));
        vo.setDealUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getDealUser()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List<AfterSalesAttachmentEntity> AfterSalesAttachmentList = this.afterSalesQuestionService.GetAfterSalesAttachmentList(id);
        for (AfterSalesAttachmentEntity afterSalesAttachmentEntity : AfterSalesAttachmentList) {
        }
        vo.setContactsName(entity.getContactsName());
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotNull((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))))) {
            vo.setCustomerName(byId.getName());
        }
        if (CollectionUtil.isNotEmpty(productIdList = Arrays.asList(vo.getProductId().split(",")))) {
            List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
            String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
        }
        vo.setAttachmentList(JsonUtil.getJsonToList(AfterSalesAttachmentList, AfterSalesAttachmentModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListByCustomerId/{customerId}"})
    public ActionResult getListByCustomerId(@PathVariable(value="customerId") String customerId) {
        List<AfterSalesQuestionEntity> listByCustomerId = this.afterSalesQuestionService.getListByCustomerId(customerId);
        List<AfterSalesQuestionListVO> list = this.appendVo(listByCustomerId);
        return ActionResult.success(list);
    }

    private List<AfterSalesQuestionListVO> appendVo(List<AfterSalesQuestionEntity> list) {
        Iterator<AfterSalesQuestionEntity> iterator = list.iterator();
        while (iterator.hasNext()) {
            AfterSalesQuestionEntity entity;
            String problemType = this.baseDataUtil.getDictName((entity = iterator.next()).getType(), "problemType");
            entity.setType(StringUtil.isNotEmpty((String)problemType) ? problemType : this.baseDataUtil.getDictName(entity.getType(), "400ProblemType"));
            entity.setDealUser(this.baseDataUtil.userSelectValueNoAccount(entity.getDealUser()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesQuestionListVO.class);
        for (AfterSalesQuestionListVO afterSalesQuestionVO : listVO) {
            OrganizeEntity byId1;
            String companyId;
            OrganizeEntity info1;
            UserEntity info2;
            UserEntity info;
            OrganizeEntity byId12;
            List<AfterSalesQuestionTrendsEntity> trendsEntity1;
            List<AfterSalesQuestionTrendsEntity> trendsEntity;
            afterSalesQuestionVO.setPriorityId(afterSalesQuestionVO.getPriority());
            afterSalesQuestionVO.setPriority(this.baseDataUtil.getDictName(afterSalesQuestionVO.getPriority(), "problemPriority"));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getQuestionApplyId())) {
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)afterSalesQuestionVO.getQuestionApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    afterSalesQuestionVO.setQuestionFlowState(flowTaskEntity.getStatus());
                } else {
                    afterSalesQuestionVO.setQuestionFlowState(null);
                }
            }
            if (CollectionUtil.isNotEmpty(trendsEntity = this.afterSalesQuestionTrendsService.getListByQuestionIdOrState(afterSalesQuestionVO.getId(), "assign"))) {
                afterSalesQuestionVO.setAssignDate(trendsEntity.get(0).getCreatorTime());
            }
            if (CollectionUtil.isNotEmpty(trendsEntity1 = this.afterSalesQuestionTrendsService.getListByQuestionIdOrState(afterSalesQuestionVO.getId(), "audit"))) {
                afterSalesQuestionVO.setAuditDate(trendsEntity1.get(0).getCreatorTime());
            }
            if (StringUtil.isNotEmpty((String)afterSalesQuestionVO.getProcessedCompanyId())) {
                afterSalesQuestionVO.setProcessedCompanyIdName(this.baseDataUtil.comSelectValues(afterSalesQuestionVO.getProcessedCompanyId()));
            }
            if (StringUtil.isNotEmpty((String)afterSalesQuestionVO.getProductCompanyId())) {
                afterSalesQuestionVO.setProductCompanyIdName(this.baseDataUtil.comSelectValues(afterSalesQuestionVO.getProductCompanyId()));
            }
            long count = this.afterSalesQuestionMessageCountService.getQuestionId(afterSalesQuestionVO.getId());
            afterSalesQuestionVO.setCount((int)count);
            afterSalesQuestionVO.setUserId(afterSalesQuestionVO.getCreatorUserId());
            if (afterSalesQuestionVO.getFeedbackSource() == 3) {
                afterSalesQuestionVO.setCreatorUserName(afterSalesQuestionVO.getContactsName());
            } else {
                afterSalesQuestionVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(afterSalesQuestionVO.getCreatorUserId()));
            }
            afterSalesQuestionVO.setProcessedById(afterSalesQuestionVO.getProcessedBy());
            afterSalesQuestionVO.setProcessedBy(this.baseDataUtil.userSelectValueNoAccount(afterSalesQuestionVO.getProcessedBy()));
            afterSalesQuestionVO.setRegionManager(this.baseDataUtil.userSelectValue(afterSalesQuestionVO.getRegionManager()));
            afterSalesQuestionVO.setCreatorUserName(this.baseDataUtil.userSelectValue(afterSalesQuestionVO.getCreatorUserId()));
            afterSalesQuestionVO.setCreatorTimel(afterSalesQuestionVO.getCreatorTime());
            afterSalesQuestionVO.setDevelopStateName(this.baseDataUtil.getDictName(afterSalesQuestionVO.getDevelopState(), "demandMark"));
            afterSalesQuestionVO.setEnabledMarkCode(afterSalesQuestionVO.getEnabledMark());
            afterSalesQuestionVO.setEnabledMark(this.baseDataUtil.getDictName(afterSalesQuestionVO.getEnabledMark(), "problemStatus"));
            afterSalesQuestionVO.setSupportTypeName(this.baseDataUtil.getDictName(afterSalesQuestionVO.getSupportType(), "questionSupportMethods"));
            afterSalesQuestionVO.setFourStateCode(afterSalesQuestionVO.getFourState());
            afterSalesQuestionVO.setFourState(this.baseDataUtil.getDictName(afterSalesQuestionVO.getFourState(), "problemStatus"));
            afterSalesQuestionVO.setFeedbackSourceDec(this.baseDataUtil.getDictName(afterSalesQuestionVO.getFeedbackSource() + "", "questionFeedbackSource"));
            String s = DateUtils.dateDiffStr(afterSalesQuestionVO.getCreatorTime(), new Date());
            afterSalesQuestionVO.setOverTimeStr(s);
            afterSalesQuestionVO.setOverTime(DateUtil.dateDiff((Date)afterSalesQuestionVO.getCreatorTime(), (Date)new Date()));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getProductId())) {
                List<String> productIdList = Arrays.asList(afterSalesQuestionVO.getProductId().split(","));
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
                String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                afterSalesQuestionVO.setProductName(collect);
            }
            if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getCustomerId())) {
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)afterSalesQuestionVO.getCustomerId()));
                afterSalesQuestionVO.setCustomerName(byId.getName());
            }
            if (StringUtil.isNotEmpty((String)afterSalesQuestionVO.getCompanyId()) && ObjectUtil.isNull((Object)(byId12 = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)afterSalesQuestionVO.getCompanyId()))))) {
                afterSalesQuestionVO.setCompanyName(byId12.getFullName());
            }
            if (StringUtils.isNotEmpty((String)afterSalesQuestionVO.getCreatorUserId()) && ObjectUtil.isNotEmpty((Object)(info = this.userService.getByRealName(afterSalesQuestionVO.getCreatorUserId()))) && ObjectUtil.isNotEmpty((Object)(info2 = this.userService.getInfo(info.getId()))) && ObjectUtil.isNotEmpty((Object)(info1 = this.organizeService.getInfo(info2.getOrganizeId())))) {
                afterSalesQuestionVO.setDepartmentName(info1.getFullName());
            }
            if (!StrUtil.isNotEmpty((CharSequence)(companyId = afterSalesQuestionVO.getCompanyId())) || ObjectUtil.isNull((Object)(byId1 = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)companyId))))) continue;
            afterSalesQuestionVO.setCompanyName(byId1.getFullName());
        }
        return listVO;
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesQuestionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmWorkitemEntity workitemEntity;
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        AfterSalesQuestionInfoVO vo = (AfterSalesQuestionInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesQuestionInfoVO.class);
        List<AfterSalesAttachmentEntity> afterSalesAttachmentList = this.afterSalesQuestionService.GetAfterSalesAttachmentList(id);
        List afterSalesAttachmentModelList = JsonUtil.getJsonToList(afterSalesAttachmentList, AfterSalesAttachmentModel.class);
        vo.setProcessedCompanyIdName(this.baseDataUtil.comSelectValues(vo.getProcessedCompanyId()));
        vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        vo.setProductCompanyName(this.baseDataUtil.comSelectValues(vo.getProductCompanyId()));
        vo.setAttachmentList(afterSalesAttachmentModelList);
        vo.setEnabledMarkCode(vo.getEnabledMark());
        vo.setFeedbackSourceDesc(this.baseDataUtil.getDictName(vo.getFeedbackSource() + "", "questionFeedbackSource"));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "problemStatus"));
        String typeName = this.baseDataUtil.getDictName(entity.getType(), "problemType");
        vo.setType(StringUtil.isNotEmpty((String)typeName) ? typeName : this.baseDataUtil.getDictName(entity.getType(), "400ProblemType"));
        vo.setPriorityId(vo.getPriority());
        vo.setPriority(this.baseDataUtil.getDictName(entity.getPriority(), "problemPriority"));
        vo.setSupportType(this.baseDataUtil.getDictName(entity.getSupportType(), "questionSupportMethods"));
        vo.setDealUserName(this.baseDataUtil.userSelectValueNoAccount(entity.getDealUser()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
        vo.setProcessedById(vo.getProcessedBy());
        vo.setProcessedBy(this.baseDataUtil.userSelectValueNoAccount(entity.getProcessedBy()));
        vo.setRegionManager(this.baseDataUtil.userSelectValueNoAccount(vo.getRegionManager()));
        vo.setCustomerAddress(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        List<String> productIdList = Arrays.asList(entity.getProductId().split(","));
        List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
        String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
        vo.setProductName(collect);
        CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            vo.setCustomerName(byId.getName());
        }
        if (entity.getApplyState().equals("1") && ObjectUtil.isNotEmpty((Object)(workitemEntity = this.crmWorkitemService.getAfterSalesQuestionId(entity.getId())))) {
            vo.setWorkitemId(workitemEntity.getId());
            vo.setWorkitemState(this.baseDataUtil.getDictName(workitemEntity.getEnabledMark(), "demandMark"));
            vo.setWorkitemName(workitemEntity.getName());
            vo.setPersonInCharge(this.baseDataUtil.userSelectValues(workitemEntity.getPersonInCharge()));
            vo.setWorkType(this.baseDataUtil.getDictName(workitemEntity.getType(), "demandType"));
            vo.setWorkPriority(this.baseDataUtil.getDictName(workitemEntity.getPriority(), "demandPriority"));
            vo.setStartDate(workitemEntity.getStartDate());
            vo.setEndDate(workitemEntity.getEndDate());
            vo.setActualStartDate(workitemEntity.getActualStartDate());
            vo.setActualEndDate(workitemEntity.getActualEndDate());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/oa/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult oaUpdate(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesQuestionUpForm afterSalesQuestionUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        String flowEngineId = "686207578077660357";
        if (entity != null) {
            CrmCustomerContactsEntity byId;
            AfterSalesQuestionEntity subentity;
            if (StrUtil.isNotBlank((CharSequence)afterSalesQuestionUpForm.getFlowId())) {
                flowEngineId = afterSalesQuestionUpForm.getFlowId();
            }
            if (StrUtil.isNotBlank((CharSequence)(subentity = (AfterSalesQuestionEntity)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionUpForm), AfterSalesQuestionEntity.class)).getContactsId()) && ObjectUtil.isNotNull((Object)(byId = (CrmCustomerContactsEntity)this.crmCustomerContactsService.getById((Serializable)((Object)subentity.getContactsId()))))) {
                subentity.setContactsName(byId.getName());
                subentity.setContactsPhone(byId.getPhone());
            }
            subentity.setQuestionApplyId(entity.getId());
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(afterSalesQuestionUpForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuestionId(entity.getId());
                entitys.setFileType(AfterSalesAttachmentTypeEnum.QUESTION_TYPE.getType());
                this.afterSalesAttachmentService.save(entitys);
            }
            this.afterSalesQuestionService.update(id, subentity);
            if (StrUtil.equals((CharSequence)entity.getApplyState(), (CharSequence)"0")) {
                FlowUtil.saveOrSubmit((String)afterSalesQuestionUpForm.getTaskId(), (String)flowEngineId, (String)afterSalesQuestionUpForm.getTemplateId(), (String)entity.getId(), (Object)((Object)afterSalesQuestionUpForm), (Integer)afterSalesQuestionUpForm.getStatus(), (String)entity.getProjectName());
            } else {
                FlowUtil.saveOrSubmit((String)afterSalesQuestionUpForm.getTaskId(), (String)flowEngineId, (String)afterSalesQuestionUpForm.getTemplateId(), (String)id, (Object)((Object)afterSalesQuestionUpForm), (Integer)afterSalesQuestionUpForm.getStatus(), (String)entity.getProjectName());
            }
            if (afterSalesQuestionUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"updateInfo/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult updateInfo(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesQuestionUpForm afterSalesQuestionUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        if (entity != null) {
            AfterSalesQuestionEntity subentity = (AfterSalesQuestionEntity)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionUpForm), AfterSalesQuestionEntity.class);
            subentity.setEnabledMark(entity.getEnabledMark());
            this.afterSalesQuestionService.update(id, subentity);
            List<AfterSalesAttachmentEntity> afterSalesAttachmentEntities = this.afterSalesAttachmentService.questionById(id);
            if (ObjectUtil.isNotEmpty(afterSalesAttachmentEntities)) {
                this.afterSalesAttachmentService.removeBatchByIds(afterSalesAttachmentEntities);
            }
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(afterSalesQuestionUpForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuestionId(entity.getId());
                this.afterSalesAttachmentService.save(entitys);
            }
            this.afterSalesQuestionTrendsService.createTrends(afterSalesQuestionUpForm.getId(), QuestionTrendsTypeEnum.UPDATE_TYPE.getType(), QuestionTrendsTypeEnum.UPDATE_TYPE.getDesc(), null, entity.getEstimatedCompletionTime());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesQuestionUpForm afterSalesQuestionUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        if (entity != null) {
            CrmCustomerContactsEntity byId;
            AfterSalesQuestionEntity subentity;
            if (!StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_DRAFT.getEnableMark()) && !StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_REJECTED.getEnableMark())) {
                if (StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getFeedbackSource(), (CharSequence)"1") || StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getFeedbackSource(), (CharSequence)"3")) {
                    afterSalesQuestionUpForm.setIsAudit(0);
                    afterSalesQuestionUpForm.setEnabledMark(QuestionEnableMarkEnum.ENABLE_AUDIT.getEnableMark());
                } else {
                    afterSalesQuestionUpForm.setIsAudit(1);
                    afterSalesQuestionUpForm.setEnabledMark(QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark());
                    if (ObjectUtil.equals((Object)afterSalesQuestionUpForm.getIsAssign(), (Object)0)) {
                        afterSalesQuestionUpForm.setProcessedBy(this.userProvider.get().getUserId());
                    }
                }
            }
            if (StrUtil.isNotBlank((CharSequence)(subentity = (AfterSalesQuestionEntity)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionUpForm), AfterSalesQuestionEntity.class)).getContactsId()) && ObjectUtil.isNotNull((Object)(byId = (CrmCustomerContactsEntity)this.crmCustomerContactsService.getById((Serializable)((Object)subentity.getContactsId()))))) {
                subentity.setContactsName(byId.getName());
                subentity.setContactsPhone(byId.getPhone());
            }
            if (afterSalesQuestionUpForm.getIsAssign() == 0 && StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark())) {
                subentity.setEnabledMark(QuestionEnableMarkEnum.ENABLE_RECEIVED_ORDER.getEnableMark());
                subentity.setProcessedBy(userInfo.getUserId());
                this.afterSalesQuestionTrendsService.createTrends(id, QuestionTrendsTypeEnum.RECEIVED_ORDER_TYPE.getType(), "\u81ea\u52a8\u63a5\u5355", subentity.getProcessedBy(), null);
            }
            this.afterSalesQuestionService.update(id, subentity);
            QueryWrapper AfterSalesAttachmentqueryWrapper = new QueryWrapper();
            AfterSalesAttachmentqueryWrapper.lambda().eq(AfterSalesAttachmentEntity::getQuestionId, (Object)entity.getId());
            this.afterSalesAttachmentService.remove((Wrapper)AfterSalesAttachmentqueryWrapper);
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(afterSalesQuestionUpForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuestionId(entity.getId());
                this.afterSalesAttachmentService.save(entitys);
            }
            if (StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_AUDIT.getEnableMark()) || StrUtil.equals((CharSequence)afterSalesQuestionUpForm.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
                if (StrUtil.equals((CharSequence)entity.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
                    this.afterSalesQuestionTrendsService.createTrends(afterSalesQuestionUpForm.getId(), QuestionTrendsTypeEnum.ENABLE_UPDATE_TYPE.getType(), QuestionTrendsTypeEnum.ENABLE_UPDATE_TYPE.getDesc(), null, entity.getEstimatedCompletionTime());
                } else {
                    this.afterSalesQuestionTrendsService.createTrends(afterSalesQuestionUpForm.getId(), QuestionTrendsTypeEnum.UPDATE_TYPE.getType(), QuestionTrendsTypeEnum.CREATE_TYPE.getDesc(), null, entity.getEstimatedCompletionTime());
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        if (entity != null) {
            entity.setDealTime(DateUtil.getNowDate());
            entity.setDealUser(userInfo.getUserId());
            entity.setDeleteFlag(1);
            this.afterSalesQuestionService.update(id, entity);
            QueryWrapper queryWrapperAfterSalesAttachment = new QueryWrapper();
            queryWrapperAfterSalesAttachment.lambda().eq(AfterSalesAttachmentEntity::getQuestionId, (Object)entity.getId());
            this.afterSalesAttachmentService.remove((Wrapper)queryWrapperAfterSalesAttachment);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"audit"})
    @RepeatSubmit
    public ActionResult audit(@RequestBody AfterSalesQuestionAuditCrForm auditCrForm) throws Exception {
        if (StrUtil.isEmpty((CharSequence)auditCrForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ba1\u6838\u7684\u95ee\u9898");
        }
        HashMap map = this.afterSalesQuestionService.auditQuestion(auditCrForm);
        if (ObjectUtil.isNull(map.get("error"))) {
            return ActionResult.success((String)(StrUtil.equals((CharSequence)auditCrForm.getEnabledMark(), (CharSequence)"accepted") ? "\u5ba1\u6838\u6210\u529f" : "\u62d2\u7edd\u6210\u529f"));
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @PostMapping(value={"assign"})
    @RepeatSubmit
    public ActionResult assign(@RequestBody AfterSalesQuestionAssignCrForm assignCrForm) {
        if (StrUtil.isEmpty((CharSequence)assignCrForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ba1\u6838\u7684\u95ee\u9898");
        }
        HashMap map = this.afterSalesQuestionService.assginQuestion(assignCrForm);
        if (ObjectUtil.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u5206\u6d3e\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @PostMapping(value={"deal"})
    @RepeatSubmit
    public ActionResult deal(@RequestBody AfterSalesQuestionDealCrForm dealCrForm) {
        if (StrUtil.isEmpty((CharSequence)dealCrForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u95ee\u9898");
        }
        HashMap map = this.afterSalesQuestionService.dealQuestion(dealCrForm);
        if (ObjectUtil.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u5904\u7406\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @GetMapping(value={"/notice/{id}"})
    @RepeatSubmit
    public ActionResult notice(@PathVariable(value="id") String id) throws Exception {
        AfterSalesQuestionEntity byId = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)byId) || ObjectUtil.equals((Object)byId.getDeleteFlag(), (Object)1)) {
            return ActionResult.fail((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        long count = this.afterSalesQuestionMessageCountService.getQuestionId(byId.getId());
        if (byId.getFeedbackSource() == 2) {
            String title;
            if (count == 3L) {
                return ActionResult.fail((String)"\u4eca\u65e5\u5df2\u63d0\u91923\u6b21\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u9192");
            }
            if (!StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark())) {
                return ActionResult.fail((String)"\u5de5\u5355\u72b6\u6001\u4e0d\u662f\u518d\u5f85\u63a5\u5355");
            }
            String content = title = "\u6709\u7ed9\u60a8\u5206\u6d3e\u7684400\u5de5\u5355\u9700\u8981\u5904\u7406\uff01";
            String name = "\u65e0\u5ba2\u6237\u540d\u79f0";
            if (StringUtils.isNotEmpty((String)byId.getCustomerId())) {
                name = ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName();
            }
            String createrName = this.baseDataUtil.userSelectValueNoAccount(byId.getCreatorUserId());
            String feedbackSourceName = this.baseDataUtil.getDictName(byId.getFeedbackSource() + "", "questionFeedbackSource");
            this.afterSalesQuestionService.pushToAssgin(title, content, byId.getProcessedBy(), "\u8bf7\u53ca\u65f6\u5904\u7406", id, name, createrName, feedbackSourceName);
            AfterSalesQuestionMessageCountCrForm countCrForm = new AfterSalesQuestionMessageCountCrForm();
            countCrForm.setQuestionId(byId.getId());
            countCrForm.setCount("1");
            this.afterSalesQuestionMessageCountService.create(countCrForm);
        } else {
            String title;
            if (count == 3L) {
                return ActionResult.fail((String)"\u4eca\u65e5\u5df2\u63d0\u91923\u6b21\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u9192");
            }
            if (!StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark())) {
                return ActionResult.fail((String)"\u5de5\u5355\u72b6\u6001\u4e0d\u662f\u518d\u5f85\u63a5\u5355");
            }
            String content = title = "\u6709\u7ed9\u60a8\u5206\u6d3e\u7684\u552e\u540e\u5de5\u5355\u9700\u8981\u5904\u7406\uff01";
            String name = ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName();
            String createrName = this.baseDataUtil.userSelectValueNoAccount(byId.getCreatorUserId());
            String feedbackSourceName = this.baseDataUtil.getDictName(byId.getFeedbackSource() + "", "questionFeedbackSource");
            this.afterSalesQuestionService.pushToAssgin(title, content, byId.getProcessedBy(), "\u8bf7\u53ca\u65f6\u5904\u7406", id, name, createrName, feedbackSourceName);
            AfterSalesQuestionMessageCountCrForm countCrForm = new AfterSalesQuestionMessageCountCrForm();
            countCrForm.setQuestionId(byId.getId());
            countCrForm.setCount("1");
            this.afterSalesQuestionMessageCountService.create(countCrForm);
        }
        return ActionResult.success((String)"\u518d\u6b21\u63d0\u9192\u6210\u529f");
    }

    @RepeatSubmit
    @DSTransactional
    @PostMapping(value={"/receivedOrder"})
    public ActionResult receivedOrder(@RequestBody AfterSalesQuestionDealCrForm dealCrForm) {
        AfterSalesQuestionEntity byId = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)dealCrForm.getId()));
        if (ObjectUtil.isNull((Object)byId) || ObjectUtil.equals((Object)byId.getDeleteFlag(), (Object)1)) {
            return ActionResult.fail((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        if (StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_RECEIVED_ORDER.getEnableMark())) {
            return ActionResult.fail((String)"\u5df2\u7ecf\u63a5\u5355\uff0c\u65e0\u9700\u518d\u6b21\u63a5\u5355");
        }
        byId.setEnabledMark(QuestionEnableMarkEnum.ENABLE_RECEIVED_ORDER.getEnableMark());
        byId.setReceivedDate(new Date());
        if (ObjectUtil.equals((Object)byId.getFeedbackSource(), (Object)2)) {
            byId.setFourState(QuestionEnableMarkEnum.ENABLE_RECEIVED_ORDER.getEnableMark());
        }
        byId.setEstimatedTime(dealCrForm.getEstimatedTime());
        byId.setReceivedReason(dealCrForm.getAuditRemark());
        if (ObjectUtil.isNotNull((Object)dealCrForm.getProductCompanyId())) {
            byId.setProductCompanyId(dealCrForm.getProductCompanyId());
        }
        this.afterSalesQuestionService.updateById(byId);
        this.afterSalesQuestionTrendsService.createTrends(dealCrForm.getId(), QuestionTrendsTypeEnum.RECEIVED_ORDER_TYPE.getType(), dealCrForm.getAuditRemark(), null, dealCrForm.getEstimatedTime());
        if (CollectionUtil.isNotEmpty(dealCrForm.getAttachmentList())) {
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(dealCrForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuestionId(byId.getId());
                entitys.setFileType("receivedOrder");
                this.afterSalesAttachmentService.save(entitys);
            }
        }
        return ActionResult.success((String)"\u63a5\u5355\u6210\u529f");
    }

    @RepeatSubmit
    @DSTransactional
    @PostMapping(value={"close"})
    public ActionResult close(@RequestBody @Valid AfterSalesQuestionBackCrForm backCrForm) {
        AfterSalesQuestionEntity byId = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)backCrForm.getId()));
        if (ObjectUtil.isNull((Object)byId) || ObjectUtil.equals((Object)byId.getDeleteFlag(), (Object)1)) {
            return ActionResult.fail((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        if (StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_CLOSE.getEnableMark())) {
            return ActionResult.fail((String)"\u5de5\u5355\u5df2\u7ecf\u5173\u95ed");
        }
        byId.setEnabledMark(QuestionEnableMarkEnum.ENABLE_CLOSE.getEnableMark());
        byId.setCloseType(1);
        byId.setReceivedDate(new Date());
        byId.setCloseTime(new Date());
        byId.setCloseReason(backCrForm.getAuditRemark());
        if (CollectionUtil.isNotEmpty(backCrForm.getAttachmentList())) {
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(backCrForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuestionId(byId.getId());
                entitys.setFileType("close");
                this.afterSalesAttachmentService.save(entitys);
            }
        }
        this.afterSalesQuestionService.updateById(byId);
        this.afterSalesQuestionTrendsService.createTrends(backCrForm.getId(), QuestionTrendsTypeEnum.CLOSE_ORDER_TYPE.getType(), backCrForm.getAuditRemark(), null, null);
        return ActionResult.success((String)"\u5173\u95ed\u6210\u529f");
    }

    @RepeatSubmit
    @DSTransactional
    @PostMapping(value={"back"})
    public ActionResult back(@RequestBody @Valid AfterSalesQuestionBackCrForm backCrForm) {
        String id = backCrForm.getId();
        AfterSalesQuestionEntity byId = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)byId) || ObjectUtil.equals((Object)byId.getDeleteFlag(), (Object)1)) {
            return ActionResult.fail((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        if (!StrUtil.equals((CharSequence)byId.getEnabledMark(), (CharSequence)QuestionEnableMarkEnum.ENABLE_RESOLVED.getEnableMark())) {
            return ActionResult.fail((String)"\u5de5\u5355\u4e0d\u662f\u5df2\u89e3\u51b3\u72b6\u6001");
        }
        this.afterSalesQuestionService.back(backCrForm);
        return ActionResult.success((String)"\u9000\u56de\u6210\u529f");
    }

    @GetMapping(value={"trends/{questionId}"})
    public ActionResult trends(@PathVariable(value="questionId") String questionId) {
        return ActionResult.success((Object)this.dealTrends(questionId));
    }

    private List dealTrends(String questionId) {
        AfterSalesQuestionEntity byId = (AfterSalesQuestionEntity)this.afterSalesQuestionService.getById((Serializable)((Object)questionId));
        if (ObjectUtil.isNotNull((Object)byId)) {
            List<AfterSalesQuestionTrendsEntity> list = this.afterSalesQuestionTrendsService.getListByQuestionId(questionId);
            list.stream().forEach(entity -> {
                entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
                if (byId.getFeedbackSource() == 3 && StrUtil.isBlank((CharSequence)entity.getCreatorUserId())) {
                    entity.setCreatorUserId(byId.getContactsName());
                }
                entity.setNextProcessedUser(this.baseDataUtil.userSelectValueNoAccount(entity.getNextProcessedUser()));
                entity.setTypeCode(entity.getType());
                entity.setType(this.baseDataUtil.getDictName(entity.getType(), "problemTrendsType"));
            });
            return list;
        }
        return CollectionUtil.list((boolean)false);
    }

    @NotCheckLogin
    @GetMapping(value={"trends/customer/{questionId}"})
    public ActionResult trendsCustomer(@PathVariable(value="questionId") String questionId) {
        return ActionResult.success((Object)this.dealTrends(questionId));
    }

    @GetMapping(value={"/attachmentById/{id}"})
    public ActionResult attachmentById(@PathVariable(value="id") String id) {
        List<AfterSalesAttachmentEntity> list = this.afterSalesAttachmentService.questionById(id);
        return ActionResult.success(list);
    }

    @NotCheckLogin
    @GetMapping(value={"/customer/{id}"})
    public ActionResult<AfterSalesQuestionInfoVO> customerInfo(@PathVariable(value="id") String id) {
        List<String> productIdList;
        CrmCustomerEntity byId;
        AfterSalesQuestionEntity entity = this.afterSalesQuestionService.getInfo(id);
        entity.setProcessedBy(this.baseDataUtil.userSelectValueNoAccount(entity.getProcessedBy()));
        entity.setDealUser(this.baseDataUtil.userSelectValueNoAccount(entity.getDealUser()));
        AfterSalesQuestionInfoVO vo = (AfterSalesQuestionInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesQuestionInfoVO.class);
        List<AfterSalesAttachmentEntity> AfterSalesAttachmentList = this.afterSalesQuestionService.GetAfterSalesAttachmentList(id);
        for (AfterSalesAttachmentEntity afterSalesAttachmentEntity : AfterSalesAttachmentList) {
        }
        vo.setContactsName(entity.getContactsName());
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotNull((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))))) {
            vo.setCustomerName(byId.getName());
        }
        if (CollectionUtil.isNotEmpty(productIdList = Arrays.asList(vo.getProductId().split(",")))) {
            List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
            String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
        }
        vo.setAttachmentList(JsonUtil.getJsonToList(AfterSalesAttachmentList, AfterSalesAttachmentModel.class));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(AfterSalesQuestionPaginationExportModel afterSalesQuestionPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)afterSalesQuestionPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        AfterSalesQuestionPagination afterSalesQuestionPagination = (AfterSalesQuestionPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuestionPaginationExportModel), AfterSalesQuestionPagination.class));
        UserInfo userInfo = this.userProvider.get();
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getTypeList(afterSalesQuestionPagination, afterSalesQuestionPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, AfterSalesQuestionListVO.class);
        if (ObjectUtil.isNotEmpty((Object)listVO)) {
            List organizeList = this.organizeService.list();
            List custList = this.crmCustomerService.list();
            List dictTypeList = this.dictionaryTypeService.list();
            List dictDataList = this.dictionaryDataService.list();
            List userList = this.userService.list();
            for (AfterSalesQuestionListVO afterSalesQuestionVO : listVO) {
                afterSalesQuestionVO.setProductCompanyIdName(this.baseDataUtil.comSelectValues(afterSalesQuestionVO.getProductCompanyId()));
                List<AfterSalesQuestionTrendsEntity> trendsEntity = this.afterSalesQuestionTrendsService.getListByQuestionIdOrState(afterSalesQuestionVO.getId(), "assign");
                if (CollectionUtil.isNotEmpty(trendsEntity)) {
                    afterSalesQuestionVO.setAssignDate(trendsEntity.get(0).getCreatorTime());
                }
                afterSalesQuestionVO.setAfterSalesType(afterSalesQuestionPaginationExportModel.getAfterSalesType());
                afterSalesQuestionVO = this.getDictionaryName(afterSalesQuestionVO, userList, dictTypeList, dictDataList);
                if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getProductId())) {
                    List<String> productIdList = Arrays.asList(afterSalesQuestionVO.getProductId().split(","));
                    List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
                    String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                    afterSalesQuestionVO.setProductName(collect);
                }
                if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getCustomerId())) {
                    for (CrmCustomerEntity cust : custList) {
                        if (!cust.getId().equals(afterSalesQuestionVO.getCustomerId())) continue;
                        afterSalesQuestionVO.setCustomerName(cust.getName());
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getCompanyId())) {
                    for (OrganizeEntity byId1 : organizeList) {
                        if (ObjectUtil.isNull((Object)byId1) || !byId1.getId().equals(afterSalesQuestionVO.getCompanyId())) continue;
                        afterSalesQuestionVO.setCompanyName(byId1.getFullName());
                    }
                }
                if (!StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getProcessedCompanyId())) continue;
                for (OrganizeEntity byId1 : organizeList) {
                    if (ObjectUtil.isNull((Object)byId1) || !byId1.getId().equals(afterSalesQuestionVO.getProcessedCompanyId())) continue;
                    afterSalesQuestionVO.setProcessedCompanyIdName(byId1.getFullName());
                }
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)afterSalesQuestionPaginationExportModel.getSelectKey()) ? afterSalesQuestionPaginationExportModel.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, "\u95ee\u9898\u5217\u8868");
        return ActionResult.success((Object)vo);
    }

    AfterSalesQuestionListVO getDictionaryName(AfterSalesQuestionListVO entity, List<UserEntity> userList, List<DictionaryTypeEntity> dictTypeList, List<DictionaryDataEntity> dictDataList) {
        entity.setProcessedById(entity.getProcessedBy());
        entity.setEnabledMarkCode(entity.getEnabledMark());
        if (ObjectUtil.isNotEmpty(userList)) {
            for (UserEntity user : userList) {
                if (user.getId().equals(entity.getDealUser())) {
                    entity.setDealUser(user.getRealName());
                }
                if (user.getId().equals(entity.getCreatorUserId())) {
                    entity.setCreatorUserId(user.getRealName());
                }
                if (user.getId().equals(entity.getProcessedBy())) {
                    entity.setProcessedBy(user.getRealName());
                }
                if (!user.getId().equals(entity.getRegionManager())) continue;
                entity.setRegionManager(user.getRealName());
            }
        }
        if (ObjectUtil.isNotEmpty(dictDataList)) {
            for (DictionaryTypeEntity type : dictTypeList) {
                for (DictionaryDataEntity data : dictDataList) {
                    if (entity.getAfterSalesType() == 0) {
                        if ("problemType".equals(type.getEnCode()) && (data.getEnCode().equals(entity.getType()) || data.getId().equals(entity.getType())) && data.getDictionaryTypeId().equals(type.getId())) {
                            entity.setType(data.getFullName());
                            continue;
                        }
                    } else if ("400ProblemType".equals(type.getEnCode()) && (data.getEnCode().equals(entity.getType()) || data.getId().equals(entity.getType())) && data.getDictionaryTypeId().equals(type.getId())) {
                        entity.setType(data.getFullName());
                        continue;
                    }
                    if ("problemPriority".equals(type.getEnCode()) && (data.getEnCode().equals(entity.getPriority()) || data.getId().equals(entity.getPriority())) && data.getDictionaryTypeId().equals(type.getId())) {
                        entity.setPriority(data.getFullName());
                        continue;
                    }
                    if (!"problemStatus".equals(type.getEnCode()) || !data.getEnCode().equals(entity.getEnabledMark()) && !data.getId().equals(entity.getEnabledMark()) || !data.getDictionaryTypeId().equals(type.getId())) continue;
                    entity.setEnabledMark(data.getFullName());
                }
            }
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String appendStr) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block88: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u7c7b\u578b", (Object)"type"));
                        continue block88;
                    }
                    case "questionNumber": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u7f16\u53f7", (Object)"questionNumber"));
                        continue block88;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block88;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee", (Object)"projectName"));
                        continue block88;
                    }
                    case "regionManager": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df\u8d1f\u8d23\u4eba", (Object)"regionManager"));
                        continue block88;
                    }
                    case "productCompanyIdName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"productCompanyIdName"));
                        continue block88;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block88;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startTime"));
                        continue block88;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block88;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productName"));
                        continue block88;
                    }
                    case "contactsName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contactsName"));
                        continue block88;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block88;
                    }
                    case "priority": {
                        entitys.add(new ExcelExportEntity("\u4e25\u91cd\u7a0b\u5ea6", (Object)"priority"));
                        continue block88;
                    }
                    case "processedBy": {
                        entitys.add(new ExcelExportEntity("\u53d7\u7406\u4eba", (Object)"processedBy"));
                        continue block88;
                    }
                    case "dealUser": {
                        entitys.add(new ExcelExportEntity("\u89e3\u51b3\u4eba", (Object)"dealUser"));
                        continue block88;
                    }
                    case "dealTime": {
                        entitys.add(new ExcelExportEntity("\u89e3\u51b3\u65f6\u95f4", (Object)"dealTime"));
                        continue block88;
                    }
                    case "solution": {
                        entitys.add(new ExcelExportEntity("\u89e3\u51b3\u65b9\u6848", (Object)"solution"));
                        continue block88;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u4eba", (Object)"creatorUserId"));
                        continue block88;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block88;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u63cf\u8ff0", (Object)"description"));
                        continue block88;
                    }
                    case "auditRemark": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6838\u610f\u89c1", (Object)"auditRemark"));
                        continue block88;
                    }
                    case "auditTime": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6838\u65f6\u95f4", (Object)"auditTime"));
                        continue block88;
                    }
                    case "backReason": {
                        entitys.add(new ExcelExportEntity("\u9000\u56de\u539f\u56e0", (Object)"backReason"));
                        continue block88;
                    }
                    case "pendingReason": {
                        entitys.add(new ExcelExportEntity("\u6302\u8d77\u539f\u56e0", (Object)"pendingReason"));
                        continue block88;
                    }
                    case "receivedReason": {
                        entitys.add(new ExcelExportEntity("\u63a5\u5355\u8bf4\u660e", (Object)"receivedReason"));
                        continue block88;
                    }
                    case "receivedDate": {
                        entitys.add(new ExcelExportEntity("\u63a5\u5355\u65e5\u671f", (Object)"receivedDate"));
                        continue block88;
                    }
                    case "assignReason": {
                        entitys.add(new ExcelExportEntity("\u5206\u6d3e\u539f\u56e0", (Object)"assignReason"));
                        continue block88;
                    }
                    case "assignDate": {
                        entitys.add(new ExcelExportEntity("\u5206\u6d3e\u65e5\u671f", (Object)"assignDate"));
                        continue block88;
                    }
                    case "closeReason": {
                        entitys.add(new ExcelExportEntity("\u5173\u95ed\u539f\u56e0", (Object)"closeReason"));
                        continue block88;
                    }
                    case "questionNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u95ee\u9898\u603b\u6570", (Object)"questionNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "draftNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u8349\u7a3f", (Object)"draftNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "auditNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5f85\u5ba1\u6838", (Object)"auditNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "pendingOrdersNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5f85\u63a5\u5355", (Object)"pendingOrdersNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "receivedOrderNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u63a5\u5355", (Object)"receivedOrderNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "pendingNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u6302\u8d77", (Object)"pendingNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "resolvedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u89e3\u51b3", (Object)"resolvedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "rejectedNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u62d2\u7edd", (Object)"rejectedNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                    case "closeNum": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5df2\u5173\u95ed", (Object)"closeNum");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block88;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = appendStr + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @PostMapping(value={"/statistics/summary"})
    public ActionResult statisticsSummary(@RequestBody AfterSalesQuesitonStatisticsSummaryQuery afterSalesQuesitonStatisticsSummaryQuery) {
        if (CollectionUtil.isNotEmpty(afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList())) {
            afterSalesQuesitonStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(0)));
            afterSalesQuesitonStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(1)));
        }
        List<QuestionSstatisticsSummaryVO> list = this.afterSalesQuestionService.statisticsSummary(afterSalesQuesitonStatisticsSummaryQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuesitonStatisticsSummaryQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/statistics/type/summary"})
    public ActionResult statisticsTypeSummary(@RequestBody AfterSalesQuesitonStatisticsSummaryQuery afterSalesQuesitonStatisticsSummaryQuery) {
        if (CollectionUtil.isNotEmpty(afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList())) {
            afterSalesQuesitonStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(0)));
            afterSalesQuesitonStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(1)));
        }
        List<QuestionSstatisticsSummaryVO> list = this.afterSalesQuestionService.statisticsTypeSummary(afterSalesQuesitonStatisticsSummaryQuery);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesQuesitonStatisticsSummaryQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/statistics/summary/Export"})
    public ActionResult exportStatisticsSummary(AfterSalesQuesitonStatisticsSummaryExportModel exportModel) {
        AfterSalesQuesitonStatisticsSummaryQuery afterSalesQuesitonStatisticsSummaryQuery = new AfterSalesQuesitonStatisticsSummaryQuery();
        if (StringUtils.isNotEmpty(exportModel.getFeedBackDateList())) {
            ArrayList<Date> creatorTime = new ArrayList<Date>();
            creatorTime.add(new Date(exportModel.getFeedBackDateList().get(0)));
            creatorTime.add(new Date(exportModel.getFeedBackDateList().get(1)));
            afterSalesQuesitonStatisticsSummaryQuery.setFeedBackDateList(creatorTime);
        }
        String str = "\u95ee\u9898\u6c47\u603b";
        if (CollectionUtil.isNotEmpty(exportModel.getFeedBackDateList())) {
            afterSalesQuesitonStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(0)));
            afterSalesQuesitonStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(1)));
            str = str + afterSalesQuesitonStatisticsSummaryQuery.getStartTime() + "-" + afterSalesQuesitonStatisticsSummaryQuery.getEndTime();
        }
        afterSalesQuesitonStatisticsSummaryQuery.setDataType(exportModel.getDataType());
        afterSalesQuesitonStatisticsSummaryQuery.setExport(true);
        List<QuestionSstatisticsSummaryVO> list = this.afterSalesQuestionService.statisticsSummary(afterSalesQuesitonStatisticsSummaryQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/statistics/type/summary/Export"})
    public ActionResult exportStatisticsTypeSummary(AfterSalesQuesitonStatisticsSummaryExportModel exportModel) {
        AfterSalesQuesitonStatisticsSummaryQuery afterSalesQuesitonStatisticsSummaryQuery = new AfterSalesQuesitonStatisticsSummaryQuery();
        if (StringUtils.isNotEmpty(exportModel.getFeedBackDateList())) {
            ArrayList<Date> creatorTime = new ArrayList<Date>();
            creatorTime.add(new Date(exportModel.getFeedBackDateList().get(0)));
            creatorTime.add(new Date(exportModel.getFeedBackDateList().get(1)));
            afterSalesQuesitonStatisticsSummaryQuery.setFeedBackDateList(creatorTime);
        }
        String str = "\u95ee\u9898\u7c7b\u578b\u6c47\u603b";
        if (CollectionUtil.isNotEmpty(exportModel.getFeedBackDateList())) {
            afterSalesQuesitonStatisticsSummaryQuery.setStartTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(0)));
            afterSalesQuesitonStatisticsSummaryQuery.setEndTime(DateUtil.daFormat((Date)afterSalesQuesitonStatisticsSummaryQuery.getFeedBackDateList().get(1)));
            str = str + afterSalesQuesitonStatisticsSummaryQuery.getStartTime() + "-" + afterSalesQuesitonStatisticsSummaryQuery.getEndTime();
        }
        afterSalesQuesitonStatisticsSummaryQuery.setDataType(exportModel.getDataType());
        afterSalesQuesitonStatisticsSummaryQuery.setExport(true);
        List<QuestionSstatisticsSummaryVO> list = this.afterSalesQuestionService.statisticsTypeSummary(afterSalesQuesitonStatisticsSummaryQuery);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, str);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @GetMapping(value={"/productList/{id}"})
    public ActionResult<List<CrmProductInfoVO>> productInfo(@PathVariable(value="id") String id) {
        List<CrmProductInfoVO> entity = this.afterSalesQuestionService.getProductInfo(id);
        List<CrmProductRelationEntity> listByCustomerId = this.crmProductRelationService.getListByCustomerId(id);
        if (CollectionUtil.isNotEmpty(listByCustomerId)) {
            List<String> collect = listByCustomerId.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
            List<CrmProductEntity> list = this.crmProductService.getListByProductIds(collect);
        }
        return ActionResult.success(entity);
    }

    @NotCheckLogin
    @GetMapping(value={"/ios/video/range"})
    public void iosVideoRange(@RequestParam(value="url") String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int lastIndex = url.lastIndexOf("/annex/");
        String result = "";
        if (lastIndex != -1) {
            result = url.substring(lastIndex);
        }
        result = result.replace("/annex/", "/");
        String filePath = FilePathUtil.getFilePath((String)"annex".toLowerCase());
        File file = new File(filePath + result);
        this.afterSalesQuestionService.rangeVideo(request, response, file);
    }
}

