/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesRepairDetailEntity;
import com.bringspring.visit.entity.AfterSalesRepairEntity;
import com.bringspring.visit.mapper.AfterSalesRepairDetailMapper;
import com.bringspring.visit.model.AfterSalesRepairPaginationExportModel;
import com.bringspring.visit.model.after_sales_repair.AfterSalesRepairCrForm;
import com.bringspring.visit.model.after_sales_repair.AfterSalesRepairInfoVO;
import com.bringspring.visit.model.after_sales_repair.AfterSalesRepairListVO;
import com.bringspring.visit.model.after_sales_repair.AfterSalesRepairPagination;
import com.bringspring.visit.model.after_sales_repair.AfterSalesRepairUpForm;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairDetailListVO;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairapprove;
import com.bringspring.visit.service.AfterSalesRepairDetailService;
import com.bringspring.visit.service.AfterSalesRepairFlowService;
import com.bringspring.visit.service.AfterSalesRepairService;
import com.bringspring.visit.utils.ProjectReportingEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"after_sales_repair"}, value="system")
@RequestMapping(value={"/api/visit/AfterSalesRepair"})
public class AfterSalesRepairController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesRepairController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private AfterSalesRepairService afterSalesRepairService;
    @Autowired
    private AfterSalesRepairDetailService afterSalesRepairDetailService;
    @Autowired
    private AfterSalesRepairDetailMapper afterSalesRepairDetailMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private AfterSalesRepairFlowService afterSalesRepairFlowService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesRepairPagination afterSalesRepairPagination) throws IOException {
        List<AfterSalesRepairEntity> list = this.afterSalesRepairService.getList(afterSalesRepairPagination);
        List listVO = JsonUtil.getJsonToList(list, AfterSalesRepairListVO.class);
        for (AfterSalesRepairListVO afterSalesRepairVO : listVO) {
            afterSalesRepairVO.setPriorityName(this.baseDataUtil.getDictName(afterSalesRepairVO.getPriority(), "priority"));
            afterSalesRepairVO.setCreatorUserName(this.baseDataUtil.userSelectValue(afterSalesRepairVO.getCreatorUserId()));
            afterSalesRepairVO.setStateName(this.baseDataUtil.getDictName(afterSalesRepairVO.getState(), "maintainoverallstate"));
            afterSalesRepairVO.setCompanyName(this.baseDataUtil.comSelectValue(afterSalesRepairVO.getCompanyId(), ""));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesRepairPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListProjectId"})
    public ActionResult getListProjectId(@RequestBody AfterSalesRepairPagination afterSalesRepairPagination) throws IOException {
        List<AfterSalesRepairEntity> list = this.afterSalesRepairService.getListProjectId(afterSalesRepairPagination);
        List listVO = JsonUtil.getJsonToList(list, AfterSalesRepairListVO.class);
        for (AfterSalesRepairListVO afterSalesRepairVO : listVO) {
            afterSalesRepairVO.setPriorityName(this.baseDataUtil.getDictName(afterSalesRepairVO.getPriority(), "priority"));
            afterSalesRepairVO.setCreatorUserName(this.baseDataUtil.userSelectValue(afterSalesRepairVO.getCreatorUserId()));
            afterSalesRepairVO.setStateName(this.baseDataUtil.getDictName(afterSalesRepairVO.getState(), "maintainoverallstate"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesRepairPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AfterSalesRepairCrForm afterSalesRepairCrForm) throws DataException {
        this.afterSalesRepairService.create(afterSalesRepairCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesRepairInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesRepairEntity entity = this.afterSalesRepairService.getInfo(id);
        AfterSalesRepairInfoVO vo = (AfterSalesRepairInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesRepairInfoVO.class);
        List<AfterSalesRepairDetailEntity> AfterSalesRepairDetailList = this.afterSalesRepairDetailService.getAfterSalesRepairDetailList(id);
        for (AfterSalesRepairDetailEntity afterSalesRepairDetailEntity : AfterSalesRepairDetailList) {
        }
        vo.setAfterSalesRepairDetailList(JsonUtil.getJsonToList(AfterSalesRepairDetailList, AfterSalesRepairDetailListVO.class));
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/approve"})
    public ActionResult approve(@RequestBody AfterSalesRepairapprove ve) {
        List<AfterSalesRepairDetailEntity> list;
        List collect;
        List<AfterSalesRepairDetailEntity> listAll;
        AfterSalesRepairEntity entity = this.afterSalesRepairService.getInfo(ve.getId());
        if (ObjectUtil.isNull((Object)entity) && StringUtils.isNull((Object)ve.getSublevelId())) {
            return ActionResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (ve.getType().equals("consent")) {
            entity.setSchedule("1");
            entity.setState("plantorder");
            this.afterSalesRepairService.updateInfo(entity);
            this.afterSalesRepairService.getSendMessage(entity, "remind", null);
            this.afterSalesRepairFlowService.create(entity.getId(), ProjectReportingEnum.PASS_NODE.getType());
            return ActionResult.success((String)"\u5ba1\u6838\u901a\u8fc7");
        }
        if (ve.getType().equals("reject")) {
            entity.setSchedule("3");
            entity.setState("reject");
            this.afterSalesRepairService.updateInfo(entity);
            this.afterSalesRepairFlowService.create(entity.getId(), ProjectReportingEnum.NOPASS_NODE.getType());
            return ActionResult.success((String)"\u9a73\u56de\u6210\u529f");
        }
        if (ve.getType().equals("planreject")) {
            entity.setSchedule("3");
            entity.setState("planreject");
            if (StringUtils.isNotEmpty((String)ve.getExplains())) {
                entity.setDescribes(ve.getExplains());
            }
            this.afterSalesRepairService.updateInfo(entity);
            List<AfterSalesRepairDetailEntity> afterSalesRepairDetailList = this.afterSalesRepairDetailService.getAfterSalesRepairDetailList(ve.getId());
            if (CollectionUtil.isNotEmpty(afterSalesRepairDetailList)) {
                for (AfterSalesRepairDetailEntity detailEntity : afterSalesRepairDetailList) {
                    detailEntity.setState("reject");
                    detailEntity.setExplains(ve.getExplains());
                    this.afterSalesRepairDetailMapper.updateById(detailEntity);
                }
            }
            this.afterSalesRepairFlowService.create(entity.getId(), ProjectReportingEnum.PLANREJECT_COMPLETION.getType());
            return ActionResult.success((String)"\u9a73\u56de\u6210\u529f");
        }
        if (ve.getType().equals("planttakeOrders")) {
            if (CollectionUtil.isNotEmpty(ve.getIds())) {
                listAll = this.afterSalesRepairDetailService.getAfterSalesRepairDetailListAll(ve.getIds());
                collect = listAll.stream().map(AfterSalesRepairDetailEntity::getState).collect(Collectors.toList());
                if (collect.contains("ReceivedOrder")) {
                    return ActionResult.fail((String)"\u5df2\u6709\u63a5\u5355\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                for (AfterSalesRepairDetailEntity entity1 : listAll) {
                    entity1.setState("ReceivedOrder");
                    entity1.setPredictTime(ve.getPredictTime());
                    entity1.setReceiverUserId(this.userProvider.get().getUserId());
                    entity1.setReceiverTime(DateUtil.getNowDate());
                    entity1.setEditInstructions(ve.getEditInstructions());
                    this.afterSalesRepairDetailMapper.updateById(entity1);
                }
            }
            if (CollectionUtil.isNotEmpty(list = this.afterSalesRepairDetailService.getAfterSalesRepairDetailList(ve.getId()))) {
                boolean allSame;
                collect = list.stream().map(AfterSalesRepairDetailEntity::getState).collect(Collectors.toList());
                boolean bl = allSame = collect.stream().distinct().count() == 1L;
                if (allSame) {
                    entity.setState("planttakeOrders");
                    this.afterSalesRepairService.updateInfo(entity);
                    this.afterSalesRepairFlowService.create(entity.getId(), ProjectReportingEnum.PLANTTAKE_ORDERS.getType(), ve.getEditInstructions());
                }
                return ActionResult.success((String)"\u63a5\u5355\u6210\u529f");
            }
        }
        if (ve.getType().equals("completion")) {
            boolean allSame;
            if (CollectionUtil.isNotEmpty(ve.getIds())) {
                listAll = this.afterSalesRepairDetailService.getAfterSalesRepairDetailListAll(ve.getIds());
                collect = listAll.stream().map(AfterSalesRepairDetailEntity::getState).collect(Collectors.toList());
                if (collect.contains("completion")) {
                    return ActionResult.fail((String)"\u5df2\u6709\u5b8c\u6210\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                for (AfterSalesRepairDetailEntity entity1 : listAll) {
                    entity1.setState("completion");
                    if (StringUtils.isNotEmpty((String)ve.getExplains())) {
                        entity1.setExplains(ve.getExplains());
                    }
                    entity1.setAccomplishTime(DateUtil.getNowDate());
                    if (StringUtils.isNotEmpty((String)ve.getTrackingNumber())) {
                        entity1.setTrackingNumber(ve.getTrackingNumber());
                    }
                    this.afterSalesRepairDetailMapper.updateById(entity1);
                }
            }
            boolean bl = allSame = (collect = (list = this.afterSalesRepairDetailService.getAfterSalesRepairDetailList(ve.getId())).stream().map(AfterSalesRepairDetailEntity::getState).collect(Collectors.toList())).stream().distinct().count() == 1L;
            if (allSame) {
                entity.setState("factoryCompletion");
                entity.setSchedule("4");
                this.afterSalesRepairFlowService.create(entity.getId(), ProjectReportingEnum.FACTORY_COMPLETION.getType(), ve.getExplains());
            }
            this.afterSalesRepairService.updateInfo(entity);
            return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
        }
        AfterSalesRepairDetailEntity info = this.afterSalesRepairDetailService.getInfo(ve.getId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            if (ve.getType().equals("revamp")) {
                if (ObjectUtil.isNotEmpty((Object)ve.getPredictTime())) {
                    info.setPredictTime(ve.getPredictTime());
                }
                info.setEditInstructions(ve.getEditInstructions());
                this.afterSalesRepairDetailMapper.updateById(info);
            }
            if (ve.getType().equals("scrap")) {
                if (StringUtils.isNotEmpty((String)ve.getExplains())) {
                    info.setExplains(ve.getExplains());
                }
                info.setState("scrap");
                this.afterSalesRepairDetailMapper.updateById(info);
            }
            if (ve.getType().equals("OutsideMaintenance")) {
                if (StringUtils.isNotEmpty((String)ve.getExplains())) {
                    info.setExplains(ve.getExplains());
                }
                info.setPredictTime(ve.getPredictTime());
                info.setState("OutsideMaintenance");
                this.afterSalesRepairDetailMapper.updateById(info);
            }
            if (ve.getType().equals("BeTransferred")) {
                if (StringUtils.isNotEmpty((String)ve.getExplains())) {
                    info.setExplains(ve.getExplains());
                }
                info.setPredictTime(ve.getPredictTime());
                info.setState("BeTransferred");
                this.afterSalesRepairDetailMapper.updateById(info);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            this.afterSalesRepairService.updateInfo(entity);
        }
        return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesRepairInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesRepairEntity entity = this.afterSalesRepairService.getInfo(id);
        AfterSalesRepairInfoVO vo = (AfterSalesRepairInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesRepairInfoVO.class);
        List<AfterSalesRepairDetailEntity> afterSalesRepairDetailList = this.afterSalesRepairDetailService.getAfterSalesRepairDetailList(id);
        if (CollectionUtil.isNotEmpty(afterSalesRepairDetailList)) {
            List afterSalesRepairDetailModelList = JsonUtil.getJsonToList(afterSalesRepairDetailList, AfterSalesRepairDetailListVO.class);
            for (AfterSalesRepairDetailListVO listVO : afterSalesRepairDetailModelList) {
                listVO.setState(this.baseDataUtil.getDictName(listVO.getState(), "maintenanceGangState"));
                listVO.setType(this.baseDataUtil.getDictName(listVO.getType(), "maintainType"));
                listVO.setReceiverUserId(this.baseDataUtil.userSelectValue(listVO.getReceiverUserId()));
            }
            vo.setAfterSalesRepairDetailList(afterSalesRepairDetailModelList);
        }
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setPriority(this.baseDataUtil.getDictName(vo.getPriority(), "priority"));
        vo.setAccessory(this.baseDataUtil.getFileNameInJson(vo.getAccessory()));
        vo.setStateName(this.baseDataUtil.getDictName(vo.getState(), "maintainoverallstate"));
        vo.setExplainUserId(this.baseDataUtil.userSelectValue(vo.getExplainUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesRepairUpForm afterSalesRepairUpForm) throws DataException {
        this.afterSalesRepairService.update(id, afterSalesRepairUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesRepairEntity entity = this.afterSalesRepairService.getInfo(id);
        if (entity != null) {
            this.afterSalesRepairService.delete(entity);
            QueryWrapper queryWrapperAfterSalesRepairDetail = new QueryWrapper();
            queryWrapperAfterSalesRepairDetail.lambda().eq(AfterSalesRepairDetailEntity::getRepairId, (Object)entity.getId());
            this.afterSalesRepairDetailService.remove((QueryWrapper<AfterSalesRepairDetailEntity>)queryWrapperAfterSalesRepairDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getRoleUserName"})
    public ActionResult getRoleUserName() throws IOException {
        List shMaintain = this.roleService.getListByEnCode("ShMaintain");
        List role = this.userRelationService.getListByObjectId(((RoleEntity)shMaintain.get(0)).getId(), "Role");
        List userIds = role.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        List userByIds = this.userService.getUserByIds(userIds);
        return ActionResult.success((Object)userByIds);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(AfterSalesRepairPaginationExportModel afterSalesRepairPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)afterSalesRepairPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        AfterSalesRepairPagination afterSalesRepairPagination = (AfterSalesRepairPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)afterSalesRepairPaginationExportModel), AfterSalesRepairPagination.class));
        List<AfterSalesRepairEntity> list = this.afterSalesRepairService.getTypeList(afterSalesRepairPagination, afterSalesRepairPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, AfterSalesRepairListVO.class);
        for (AfterSalesRepairListVO afterSalesRepairVO : listVO) {
            afterSalesRepairVO.setPriorityName(this.baseDataUtil.getDictName(afterSalesRepairVO.getPriority(), "priority"));
            afterSalesRepairVO.setCreatorUserName(this.baseDataUtil.userSelectValue(afterSalesRepairVO.getCreatorUserId()));
            afterSalesRepairVO.setStateName(this.baseDataUtil.getDictName(afterSalesRepairVO.getState(), "maintainoverallstate"));
            afterSalesRepairVO.setCompanyName(this.baseDataUtil.comSelectValue(afterSalesRepairVO.getCompanyId(), ""));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)afterSalesRepairPaginationExportModel.getSelectKey()) ? afterSalesRepairPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "id": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u53f7", (Object)"id"));
                        continue block26;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block26;
                    }
                    case "priorityName": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priorityName"));
                        continue block26;
                    }
                    case "stateName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"stateName"));
                        continue block26;
                    }
                    case "describes": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"describes"));
                        continue block26;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserName"));
                        continue block26;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65f6\u95f4", (Object)"creatorTime"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

