/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesRepairDetailEntity;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairDetailInfoVO;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairDetailListVO;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairDetailPagination;
import com.bringspring.visit.model.after_sales_repair_detail.AfterSalesRepairDetailUpForm;
import com.bringspring.visit.service.AfterSalesRepairDetailService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"after_sales_repair_detail"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesRepairDetail"})
public class AfterSalesRepairDetailController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesRepairDetailController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesRepairDetailService afterSalesRepairDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesRepairDetailPagination afterSalesRepairDetailPagination) throws IOException {
        List<AfterSalesRepairDetailEntity> list = this.afterSalesRepairDetailService.getList(afterSalesRepairDetailPagination);
        List listVO = JsonUtil.getJsonToList(list, AfterSalesRepairDetailListVO.class);
        for (AfterSalesRepairDetailListVO vo : listVO) {
            vo.setState(this.baseDataUtil.getDictName(vo.getState(), "maintenanceGangState"));
            vo.setType(this.baseDataUtil.getDictName(vo.getType(), "maintainType"));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesRepairDetailPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesRepairDetailInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesRepairDetailEntity entity = this.afterSalesRepairDetailService.getInfo(id);
        AfterSalesRepairDetailInfoVO vo = (AfterSalesRepairDetailInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesRepairDetailInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesRepairDetailInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesRepairDetailEntity entity = this.afterSalesRepairDetailService.getInfo(id);
        AfterSalesRepairDetailInfoVO vo = (AfterSalesRepairDetailInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesRepairDetailInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesRepairDetailUpForm afterSalesRepairDetailUpForm) throws DataException {
        this.afterSalesRepairDetailService.update(id, afterSalesRepairDetailUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesRepairDetailEntity entity = this.afterSalesRepairDetailService.getInfo(id);
        if (entity != null) {
            this.afterSalesRepairDetailService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

