/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesRepairFlowEntity;
import com.bringspring.visit.model.after_sales_repair.AftersalesrepairflowCrForm;
import com.bringspring.visit.model.after_sales_repair.AftersalesrepairflowVo;
import com.bringspring.visit.service.AfterSalesRepairFlowService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"after_sales_repair_flow"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesRepairFlow"})
public class AfterSalesRepairFlowController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesRepairFlowController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private AfterSalesRepairFlowService afterSalesRepairFlowService;

    @GetMapping(value={"/{id}"})
    public ActionResult<List<AftersalesrepairflowVo>> info(@PathVariable(value="id") String id) {
        List<AfterSalesRepairFlowEntity> entity = this.afterSalesRepairFlowService.getByRepairList(id);
        List vo = JsonUtil.getJsonToList(entity, AftersalesrepairflowVo.class);
        for (AftersalesrepairflowVo flowVo : vo) {
            flowVo.setFlowTypeName(this.baseDataUtil.getDictName(flowVo.getFlowType(), "flowState"));
            flowVo.setCreatorUserName(this.baseDataUtil.userSelectValue(flowVo.getCreatorUserId()));
        }
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AftersalesrepairflowCrForm afterSalesRepairFlowCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        AfterSalesRepairFlowEntity entity = (AfterSalesRepairFlowEntity)JsonUtil.getJsonToBean((Object)afterSalesRepairFlowCrForm, AfterSalesRepairFlowEntity.class);
        entity.setId(mainId);
        this.afterSalesRepairFlowService.save(entity);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

