/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskDetailEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskTopicEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskTopicOptionEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTopicEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTopicOptionEntity;
import com.bringspring.visit.model.after_sales_telephone_task.AfterSalesTelephoneTaskDetailModel;
import com.bringspring.visit.model.after_sales_telephone_template.AfterSalesTelephoneTopicOptionModel;
import com.bringspring.visit.model.aftersalestelephonetask.AfterSalesTelephoneTaskCrForm;
import com.bringspring.visit.model.aftersalestelephonetask.AfterSalesTelephoneTaskInfoVO;
import com.bringspring.visit.model.aftersalestelephonetask.AfterSalesTelephoneTaskListVO;
import com.bringspring.visit.model.aftersalestelephonetask.AfterSalesTelephoneTaskPagination;
import com.bringspring.visit.model.aftersalestelephonetask.AfterSalesTelephoneTaskUpForm;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskDetailService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskTopicOptionService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskTopicService;
import com.bringspring.visit.service.AfterSalesTelephoneTopicOptionService;
import com.bringspring.visit.service.AfterSalesTelephoneTopicService;
import com.bringspring.visit.utils.TelephoneFollowTaskDetailEnableMarkEnum;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7535\u8bdd\u968f\u8bbf\u4efb\u52a1"}, value="visit")
@RequestMapping(value={"/api/visit/AfterSalesTelephoneTask"})
public class AfterSalesTelephoneTaskController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesTelephoneTaskController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesTelephoneTaskService afterSalesTelephoneTaskService;
    @Autowired
    private AfterSalesTelephoneTaskDetailService afterSalesTelephoneTaskDetailService;
    @Autowired
    private AfterSalesTelephoneTaskTopicService afterSalesTelephoneTaskTopicService;
    @Autowired
    private AfterSalesTelephoneTaskTopicOptionService afterSalesTelephoneTaskTopicOptionService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private AfterSalesTelephoneTopicService afterSalesTelephoneTopicService;
    @Autowired
    private AfterSalesTelephoneTopicOptionService afterSalesTelephoneTopicOptionService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody AfterSalesTelephoneTaskPagination afterSalesTelephoneTaskPagination) throws IOException {
        List<AfterSalesTelephoneTaskEntity> list = this.afterSalesTelephoneTaskService.getList(afterSalesTelephoneTaskPagination);
        for (AfterSalesTelephoneTaskEntity entity : list) {
            entity.setType(this.baseDataUtil.getDictName(entity.getType(), "TelephonefollowUpType"));
            entity.setIsAuto(this.baseDataUtil.getDictName(entity.getIsAuto(), "TelephonefollowUpType"));
            entity.setTemplateType(this.baseDataUtil.getDictName(entity.getTemplateType(), "telephoneTemplateType"));
            entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesTelephoneTaskListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesTelephoneTaskPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"listByNotEnd"})
    public ActionResult listByNotEnd() {
        return ActionResult.success(this.afterSalesTelephoneTaskService.listByNotEnd());
    }

    @GetMapping(value={"taskDetail/{taskId}"})
    public ActionResult taskDetail(@PathVariable(value="taskId") String taskId) {
        return ActionResult.success(this.afterSalesTelephoneTaskDetailService.listByEnableMark(taskId, TelephoneFollowTaskDetailEnableMarkEnum.NOT_START.getEnableMark()));
    }

    @GetMapping(value={"taskDetailInfo/{detailId}"})
    public ActionResult taskDetailInfo(@PathVariable(value="detailId") String detailId) {
        List<AfterSalesTelephoneTaskTopicEntity> topicList = this.afterSalesTelephoneTaskTopicService.listByTaskDetail(detailId);
        for (AfterSalesTelephoneTaskTopicEntity topicEntity : topicList) {
            List<AfterSalesTelephoneTaskTopicOptionEntity> optionEntityList = this.afterSalesTelephoneTaskTopicOptionService.listByTaskDeailIdAndTopicId(detailId, topicEntity.getId());
            topicEntity.setOptionList(optionEntityList);
            if (!CollectionUtil.isNotEmpty(topicEntity.getOptionList())) continue;
            for (AfterSalesTelephoneTaskTopicOptionEntity optionEntity : topicEntity.getOptionList()) {
                if (!StrUtil.equals((CharSequence)optionEntity.getOptionName(), (CharSequence)topicEntity.getOptionName())) continue;
                topicEntity.setOptionId(optionEntity.getId());
            }
        }
        return ActionResult.success(topicList);
    }

    @GetMapping(value={"templateIdInfo/{templateId}"})
    public ActionResult listByTemplateId(@PathVariable(value="templateId") String templateId) {
        List<AfterSalesTelephoneTopicEntity> afterSalesTelephoneTopicEntities = this.afterSalesTelephoneTopicService.listByTemplateId(templateId);
        for (AfterSalesTelephoneTopicEntity topicEntity : afterSalesTelephoneTopicEntities) {
            List<AfterSalesTelephoneTopicOptionEntity> optionEntityList = this.afterSalesTelephoneTopicOptionService.listByTopicId(topicEntity.getId());
            topicEntity.setOptionList(JsonUtil.getJsonToList(optionEntityList, AfterSalesTelephoneTopicOptionModel.class));
        }
        return ActionResult.success(afterSalesTelephoneTopicEntities);
    }

    @GetMapping(value={"templateIdInfoMap/{templateId}"})
    public ActionResult templateIdInfoMap(@PathVariable(value="templateId") String templateId) {
        List<AfterSalesTelephoneTopicEntity> afterSalesTelephoneTopicEntities = this.afterSalesTelephoneTopicService.listByTemplateId(templateId);
        LinkedHashMap<String, List<AfterSalesTelephoneTopicEntity>> stringListHashMap = this.afterSalesTelephoneTopicService.inspectionTopicConvert(afterSalesTelephoneTopicEntities);
        return ActionResult.success(stringListHashMap);
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid AfterSalesTelephoneTaskCrForm afterSalesTelephoneTaskCrForm) throws DataException {
        this.afterSalesTelephoneTaskService.saveTask(afterSalesTelephoneTaskCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesTelephoneTaskInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesTelephoneTaskEntity entity = this.afterSalesTelephoneTaskService.getInfo(id);
        AfterSalesTelephoneTaskInfoVO vo = (AfterSalesTelephoneTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesTelephoneTaskInfoVO.class);
        List<AfterSalesTelephoneTaskDetailEntity> AfterSalesTelephoneTaskDetailList = this.afterSalesTelephoneTaskService.GetAfterSalesTelephoneTaskDetailList(id);
        for (AfterSalesTelephoneTaskDetailEntity afterSalesTelephoneTaskDetailEntity : AfterSalesTelephoneTaskDetailList) {
        }
        vo.setAfterSalesTelephoneTaskDetailList(JsonUtil.getJsonToList(AfterSalesTelephoneTaskDetailList, AfterSalesTelephoneTaskDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesTelephoneTaskInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AfterSalesTelephoneTaskEntity entity = this.afterSalesTelephoneTaskService.getInfo(id);
        AfterSalesTelephoneTaskInfoVO vo = (AfterSalesTelephoneTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesTelephoneTaskInfoVO.class);
        List<AfterSalesTelephoneTaskDetailEntity> detailList = this.afterSalesTelephoneTaskService.GetAfterSalesTelephoneTaskDetailList(id);
        List detailModelList = JsonUtil.getJsonToList(detailList, AfterSalesTelephoneTaskDetailModel.class);
        for (AfterSalesTelephoneTaskDetailModel model : detailModelList) {
            model.setFollowUser(this.baseDataUtil.userSelectValueNoAccount(model.getFollowUser()));
        }
        vo.setAfterSalesTelephoneTaskDetailList(detailModelList);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "TelephonefollowUpType"));
        vo.setTemplateTypeCode(vo.getTemplateType());
        vo.setTemplateType(this.baseDataUtil.getDictName(vo.getTemplateType(), "telephoneTemplateType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesTelephoneTaskUpForm afterSalesTelephoneTaskUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesTelephoneTaskEntity entity = this.afterSalesTelephoneTaskService.getInfo(id);
        if (entity != null) {
            AfterSalesTelephoneTaskEntity subentity = (AfterSalesTelephoneTaskEntity)JsonUtil.getJsonToBean((Object)afterSalesTelephoneTaskUpForm, AfterSalesTelephoneTaskEntity.class);
            this.afterSalesTelephoneTaskService.update(id, subentity);
            QueryWrapper AfterSalesTelephoneTaskDetailqueryWrapper = new QueryWrapper();
            AfterSalesTelephoneTaskDetailqueryWrapper.lambda().eq(AfterSalesTelephoneTaskDetailEntity::getTaskId, (Object)entity.getId());
            this.afterSalesTelephoneTaskDetailService.remove((Wrapper)AfterSalesTelephoneTaskDetailqueryWrapper);
            List AfterSalesTelephoneTaskDetailList = JsonUtil.getJsonToList(afterSalesTelephoneTaskUpForm.getAftersalestelephonetaskdetailList(), AfterSalesTelephoneTaskDetailEntity.class);
            for (AfterSalesTelephoneTaskDetailEntity entitys : AfterSalesTelephoneTaskDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setTaskId(entity.getId());
                this.afterSalesTelephoneTaskDetailService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesTelephoneTaskEntity entity = this.afterSalesTelephoneTaskService.getInfo(id);
        if (entity != null) {
            this.afterSalesTelephoneTaskService.delete(entity);
            QueryWrapper queryWrapperAfterSalesTelephoneTaskDetail = new QueryWrapper();
            queryWrapperAfterSalesTelephoneTaskDetail.lambda().eq(AfterSalesTelephoneTaskDetailEntity::getTaskId, (Object)entity.getId());
            this.afterSalesTelephoneTaskDetailService.remove((Wrapper)queryWrapperAfterSalesTelephoneTaskDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DSTransactional
    @GetMapping(value={"/cancel/{id}"})
    public ActionResult toCancel(@PathVariable(value="id") String id) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesTelephoneTaskDetailEntity entity = this.afterSalesTelephoneTaskDetailService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.fail((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(9);
        entity.setLastModifyUserId(userInfo.getUserId());
        entity.setLastModifyTime(new Date());
        this.afterSalesTelephoneTaskDetailService.update(id, entity);
        if (StrUtil.isNotEmpty((CharSequence)entity.getTelephoneQuestionId())) {
            AfterSalesQuestionEntity questionEntity = new AfterSalesQuestionEntity();
            questionEntity.setId(entity.getTelephoneQuestionId());
            questionEntity.setIsTelephone(0);
            this.afterSalesQuestionService.updateById(questionEntity);
        }
        return ActionResult.success((String)"\u53d6\u6d88\u6210\u529f");
    }
}

