/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleBidBusinessEntity;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidInfoVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidListVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidPagination;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidPaginationVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidUpForm;
import com.bringspring.visit.service.BeforeSaleBidBusinessService;
import com.bringspring.visit.service.BeforeSaleBidService;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62db\u6295\u6807\u7ba1\u7406\u4e1a\u52a1\u6570\u636e"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleBidBusiness"})
public class BeforeSaleBidBusinessController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleBidBusinessController.class);
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleBidService beforeSaleBidService;
    @Autowired
    private BeforeSaleBidBusinessService beforeSaleBidBusinessService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleBidPagination beforeSaleBidPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (roleIds.contains("497777648534223557")) {
            beforeSaleBidPagination.setShowScope("all");
        }
        List<BeforeSaleBidBusinessEntity> list = this.beforeSaleBidBusinessService.getList(beforeSaleBidPagination);
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleBidListVO.class);
        for (BeforeSaleBidListVO entity : listVO) {
            if (StrUtil.isNotEmpty((CharSequence)entity.getCompanyId())) {
                OrganizeEntity info = this.organizeService.getInfo(entity.getCompanyId());
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                entity.setCompanyName(jsonToBean.getShortName());
            }
            if (StrUtil.isNotEmpty((CharSequence)entity.getCreatorCompanyId())) {
                OrganizeEntity info1 = this.organizeService.getInfo(entity.getCreatorCompanyId());
                OrganizeCrModel jsonToBean1 = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info1.getPropertyJson(), OrganizeCrModel.class);
                entity.setSalerCompanyName(jsonToBean1.getShortName());
            }
            entity.setApplicationType(this.baseDataUtil.getDictName(entity.getApplicationType(), "applicationType"));
            entity.setBidCatagory(this.baseDataUtil.getDictName(entity.getBidCatagory(), "bidCatagory"));
            entity.setBidType(this.baseDataUtil.getDictName(entity.getBidType(), "bidType"));
            entity.setBidDelivery(this.baseDataUtil.getDictName(entity.getBidDelivery(), "bidDelivery"));
            entity.setApplyUserid(this.baseDataUtil.userSelectValues(entity.getApplyUserid()));
            entity.setApplyUserDepartment(this.baseDataUtil.comSelectValues(entity.getApplyUserDepartment()));
            entity.setSupportUserid(this.baseDataUtil.userSelectValues(entity.getSupportUserid()));
            entity.setCollaborativePerson(this.baseDataUtil.userSelectValues(entity.getCollaborativePerson()));
            entity.setEnabledMarkName(this.baseDataUtil.getDictName(String.valueOf(entity.getEnabledMark()), "bidEnabledMark"));
            entity.setAssociationProductName(this.crmProductService.getInfoByListId(entity.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            if (ObjectUtil.isNotEmpty((Object)this.crmCustomerService.getInfo(entity.getCustomerName()))) {
                entity.setCustomerTitle(this.crmCustomerService.getInfo(entity.getCustomerName()).getName());
            }
            entity.setApplyUserid(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyUserid()));
            entity.setApplyUserDepartment(this.baseDataUtil.comSelectValues(entity.getApplyUserDepartment()));
            entity.setEnabledBusinessName(this.baseDataUtil.getDictName(entity.getEnabledBusiness(), "projectQuestionState"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        BeforeSaleBidPaginationVO page = (BeforeSaleBidPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidPagination), BeforeSaleBidPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleBidInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerEntity cust;
        BeforeSaleBidBusinessEntity entity = this.beforeSaleBidBusinessService.getInfo(id);
        BeforeSaleBidInfoVO vo = (BeforeSaleBidInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBidInfoVO.class);
        vo.setEnabledMarkName(this.baseDataUtil.getDictName(String.valueOf(vo.getEnabledMark()), "bidEnabledMark"));
        vo.setAssociationProductName(this.crmProductService.getInfoByListId(vo.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerName()) && ObjectUtil.isNotEmpty((Object)(cust = this.crmCustomerService.getInfo(vo.getCustomerName())))) {
            vo.setCustomerTitle(cust.getName());
        }
        vo.setApplyUseridName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyUserid()));
        vo.setApplyUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        if (entity.getAssociationSaleChance().length() > 0) {
            vo.setAssociationSaleChanceName(this.crmCustomerOpportunityService.getInfo(entity.getAssociationSaleChance()).getDescription());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleBidInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleBidBusinessEntity entity = this.beforeSaleBidBusinessService.getInfo(id);
        BeforeSaleBidInfoVO vo = (BeforeSaleBidInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBidInfoVO.class);
        vo.setApplicationType(this.baseDataUtil.getDictName(vo.getApplicationType(), "applicationType"));
        vo.setBidCatagory(this.baseDataUtil.getDictName(vo.getBidCatagory(), "bidCatagory"));
        vo.setBidType(this.baseDataUtil.getDictName(vo.getBidType(), "bidType"));
        vo.setBidDelivery(this.baseDataUtil.getDictName(vo.getBidDelivery(), "bidDelivery"));
        vo.setApplyUserid(this.baseDataUtil.userSelectValues(vo.getApplyUserid()));
        vo.setApplyUserDepartment(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        vo.setSupportUserid(this.baseDataUtil.userSelectValues(vo.getSupportUserid()));
        vo.setCollaborativePerson(this.baseDataUtil.userSelectValues(vo.getCollaborativePerson()));
        vo.setEnabledMarkName(this.baseDataUtil.getDictName(vo.getEnabledMark(), "bidEnabledMark"));
        vo.setAssociationProductName(this.crmProductService.getInfoByListId(vo.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        vo.setCustomerTitle(this.crmCustomerService.getInfo(vo.getCustomerName()).getName());
        vo.setApplyUseridName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyUserid()));
        vo.setApplyUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws DataException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleBidBusinessEntity entity = this.beforeSaleBidBusinessService.getInfo(id);
        String flowEngineId = "514065616181921861";
        if (entity != null) {
            BeforeSaleBidBusinessEntity subentity = (BeforeSaleBidBusinessEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidUpForm), BeforeSaleBidBusinessEntity.class);
            this.beforeSaleBidBusinessService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)beforeSaleBidUpForm.getTaskId(), (String)flowEngineId, (String)beforeSaleBidUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)beforeSaleBidUpForm.getStatus(), (String)beforeSaleBidUpForm.getTenderName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleBidBusinessEntity entity = this.beforeSaleBidBusinessService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (ObjectUtil.isNotEmpty((Object)taskEntity)) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.beforeSaleBidBusinessService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

