/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.ProjectQuestionStateEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleBidBusinessEntity;
import com.bringspring.visit.entity.BeforeSaleBidEntity;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidCrForm;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidInfoVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidListVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidPagination;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidPaginationExportModel;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidPaginationVO;
import com.bringspring.visit.model.beforesalebid.BeforeSaleBidUpForm;
import com.bringspring.visit.service.BeforeSaleBidBusinessService;
import com.bringspring.visit.service.BeforeSaleBidReviewService;
import com.bringspring.visit.service.BeforeSaleBidService;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.visit.utils.BeforeSupportEnableEnableEnum;
import com.bringspring.visit.utils.Constants;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62db\u6295\u6807\u7ba1\u7406"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleBid"})
public class BeforeSaleBidController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleBidController.class);
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleBidService beforeSaleBidService;
    @Autowired
    private BeforeSaleBidBusinessService beforeSaleBidBusinessService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private BeforeSaleBidReviewService beforeSaleBidReviewService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleBidPagination beforeSaleBidPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (roleIds.contains("497777648534223557")) {
            beforeSaleBidPagination.setShowScope("all");
        }
        List<BeforeSaleBidEntity> list = this.beforeSaleBidService.getList(beforeSaleBidPagination);
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleBidListVO.class);
        for (BeforeSaleBidListVO entity : listVO) {
            if (StrUtil.isNotEmpty((CharSequence)entity.getCompanyId())) {
                entity.setCompanyName(this.organizeService.getInfo(entity.getCompanyId()).getShortName());
            }
            entity.setApplicationType(this.baseDataUtil.getDictName(entity.getApplicationType(), "applicationType"));
            entity.setBidCatagory(this.baseDataUtil.getDictName(entity.getBidCatagory(), "bidCatagory"));
            entity.setBidType(this.baseDataUtil.getDictName(entity.getBidType(), "bidType"));
            entity.setBidDelivery(this.baseDataUtil.getDictName(entity.getBidDelivery(), "bidDelivery"));
            entity.setApplyUserid(this.baseDataUtil.userSelectValues(entity.getApplyUserid()));
            entity.setApplyUserDepartment(this.baseDataUtil.comSelectValues(entity.getApplyUserDepartment()));
            if (StrUtil.isNotEmpty((CharSequence)entity.getSupportUserid())) {
                entity.setSupportUserid(entity.getSupportUserid().replaceAll("\"", "").replace("[", "").replace("]", ""));
            }
            entity.setSupportUserid(this.baseDataUtil.userSelectValues(entity.getSupportUserid()));
            entity.setCollaborativePerson(this.baseDataUtil.userSelectValues(entity.getCollaborativePerson()));
            entity.setEnabledMarkName(this.baseDataUtil.getDictName(String.valueOf(entity.getEnabledMark()), "bidEnabledMark"));
            entity.setAssociationProductName(this.crmProductService.getInfoByListId(entity.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            if (ObjectUtil.isNotEmpty((Object)this.crmCustomerService.getInfo(entity.getCustomerName()))) {
                entity.setCustomerTitle(this.crmCustomerService.getInfo(entity.getCustomerName()).getName());
            }
            entity.setApplyUserid(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyUserid()));
            entity.setApplyUserDepartment(this.baseDataUtil.comSelectValues(entity.getApplyUserDepartment()));
            entity.setSalerCompanyName(this.afterSalesRoleUtils.getCompanyShortName(entity.getApplyUserid()));
        }
        for (BeforeSaleBidListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        BeforeSaleBidPaginationVO page = (BeforeSaleBidPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidPagination), BeforeSaleBidPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid BeforeSaleBidCrForm beforeSaleBidCrForm) throws Exception {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleBidEntity entity = (BeforeSaleBidEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidCrForm), BeforeSaleBidEntity.class);
        entity.setCreatorCompanyId(userInfo.getOrganizeId());
        entity.setId(mainId);
        entity.setEnabledMark(Constants.BEFORE_SALE_ENABLEDMARK_VERIFY);
        entity.setApplyUserid(userInfo.getUserId());
        entity.setApplyUserDepartment(userInfo.getDepartmentId());
        entity.setWinBid("1");
        List<UserEntity> listByRoleId = this.userRelationUtil.getListByRoleIds("497777648534223557");
        if (!listByRoleId.isEmpty()) {
            String title = "\u60a8\u6709\u552e\u524d\u652f\u6301\u7533\u8bf7\u5f85\u5ba1\u6838!";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u5ba2\u6237\u540d\u79f0\uff1a" + beforeSaleBidCrForm.getCustomerTitle());
            stringBuffer.append("\n\u7533\u8bf7\u4eba\uff1a" + userInfo.getRealName());
            stringBuffer.append("\n\u7533\u8bf7\u90e8\u95e8\uff1a" + this.baseDataUtil.comSelectValues(userInfo.getDepartmentId()));
            String content = stringBuffer.toString();
            String url = "";
            this.beforeSaleBidService.sendMessage(listByRoleId.stream().map(UserEntity::getId).collect(Collectors.toList()), title, content, url, mainId);
        }
        String flowEngineId = "514065616181921861";
        entity.setEnabledBusiness(BeforeSupportEnableEnableEnum.TO_ASSIGEND.getType());
        this.beforeSaleBidService.save(entity);
        beforeSaleBidCrForm.setCreatorCompanyId(userInfo.getOrganizeId());
        if (beforeSaleBidCrForm.getStatus() == 0) {
            this.insertIntoServiceTable(mainId, beforeSaleBidCrForm, ProjectQuestionStateEnum.STATE_DRAFT.getState(), beforeSaleBidCrForm.getStatus());
        } else {
            this.insertIntoServiceTable(mainId, beforeSaleBidCrForm, ProjectQuestionStateEnum.STATE_APPROVAL.getState(), beforeSaleBidCrForm.getStatus());
        }
        FlowUtil.saveOrSubmit((String)beforeSaleBidCrForm.getTaskId(), (String)flowEngineId, (String)beforeSaleBidCrForm.getTemplateId(), (String)mainId, (Object)entity, (Integer)beforeSaleBidCrForm.getStatus(), (String)beforeSaleBidCrForm.getTenderName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    void insertIntoServiceTable(String mainId, BeforeSaleBidCrForm entity, String state, Integer flowState) {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleBidBusinessEntity jsonToBean = (BeforeSaleBidBusinessEntity)JsonUtil.getJsonToBean((Object)((Object)entity), BeforeSaleBidBusinessEntity.class);
        jsonToBean.setId(mainId);
        jsonToBean.setEnabledBusiness(state);
        jsonToBean.setFlowState(flowState);
        this.beforeSaleBidBusinessService.save(jsonToBean);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleBidInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerEntity cust;
        BeforeSaleBidEntity entity = this.beforeSaleBidService.getInfo(id);
        BeforeSaleBidInfoVO vo = (BeforeSaleBidInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBidInfoVO.class);
        vo.setEnabledMarkName(this.baseDataUtil.getDictName(String.valueOf(vo.getEnabledMark()), "bidEnabledMark"));
        vo.setAssociationProductName(this.crmProductService.getInfoByListId(vo.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerName()) && ObjectUtil.isNotEmpty((Object)(cust = this.crmCustomerService.getInfo(vo.getCustomerName())))) {
            vo.setCustomerTitle(cust.getName());
        }
        vo.setApplyUseridName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyUserid()));
        vo.setApplyUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        if (entity.getAssociationSaleChance().length() > 0) {
            vo.setAssociationSaleChanceName(this.crmCustomerOpportunityService.getInfo(entity.getAssociationSaleChance()).getDescription());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleBidInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleBidEntity entity = this.beforeSaleBidService.getInfo(id);
        BeforeSaleBidInfoVO vo = (BeforeSaleBidInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBidInfoVO.class);
        vo.setApplicationType(this.baseDataUtil.getDictName(vo.getApplicationType(), "applicationType"));
        vo.setBidCatagory(this.baseDataUtil.getDictName(vo.getBidCatagory(), "bidCatagory"));
        vo.setBidType(this.baseDataUtil.getDictName(vo.getBidType(), "bidType"));
        vo.setBidDelivery(this.baseDataUtil.getDictName(vo.getBidDelivery(), "bidDelivery"));
        vo.setApplyUserid(this.baseDataUtil.userSelectValues(vo.getApplyUserid()));
        vo.setApplyUserDepartment(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        vo.setSupportUserid(this.baseDataUtil.userSelectValues(vo.getSupportUserid()));
        vo.setCollaborativePerson(this.baseDataUtil.userSelectValues(vo.getCollaborativePerson()));
        vo.setEnabledMarkName(this.baseDataUtil.getDictName(vo.getEnabledMark(), "bidEnabledMark"));
        vo.setAssociationProductName(this.crmProductService.getInfoByListId(vo.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerName())) {
            vo.setCustomerTitle(this.crmCustomerService.getInfo(vo.getCustomerName()).getName());
        }
        vo.setApplyUseridName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyUserid()));
        vo.setApplyUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyUserDepartment()));
        JSONArray jsonArray = this.beforeSaleBidReviewService.getByBeforeBidId(id);
        if (ObjectUtil.isNotEmpty((Object)jsonArray)) {
            vo.setReviewList(JsonUtil.getJsonToList((JSONArray)jsonArray));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws DataException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleBidEntity entity = this.beforeSaleBidService.getInfo(id);
        String flowEngineId = "514065616181921861";
        if (entity != null) {
            BeforeSaleBidEntity subentity = (BeforeSaleBidEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidUpForm), BeforeSaleBidEntity.class);
            subentity.setCreatorCompanyId(userInfo.getOrganizeId());
            this.beforeSaleBidService.update(id, subentity);
            BeforeSaleBidBusinessEntity bidBusinessEntity = (BeforeSaleBidBusinessEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidUpForm), BeforeSaleBidBusinessEntity.class);
            if (beforeSaleBidUpForm.getStatus() == 0) {
                bidBusinessEntity.setEnabledBusiness(ProjectQuestionStateEnum.STATE_DRAFT.getState());
                bidBusinessEntity.setFlowState(beforeSaleBidUpForm.getStatus());
            } else {
                bidBusinessEntity.setFlowState(beforeSaleBidUpForm.getStatus());
                bidBusinessEntity.setEnabledBusiness(ProjectQuestionStateEnum.STATE_APPROVAL.getState());
            }
            this.beforeSaleBidBusinessService.update(id, bidBusinessEntity);
            beforeSaleBidUpForm.setCreatorCompanyId(subentity.getCreatorCompanyId());
            FlowUtil.saveOrSubmit((String)beforeSaleBidUpForm.getTaskId(), (String)flowEngineId, (String)beforeSaleBidUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)beforeSaleBidUpForm.getStatus(), (String)beforeSaleBidUpForm.getTenderName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleBidEntity entity = this.beforeSaleBidService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.beforeSaleBidService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/verify/{id}"})
    @DSTransactional
    public ActionResult agreeAndReject(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws Exception {
        boolean b;
        UserInfo userInfo = this.userProvider.get();
        if (beforeSaleBidUpForm != null && (b = this.beforeSaleBidService.agreeAndReject(beforeSaleBidUpForm))) {
            return ActionResult.success((String)"\u5ba1\u6838\u6210\u529f");
        }
        return ActionResult.success((String)"\u5df2\u9a73\u56de");
    }

    @PutMapping(value={"/winBid/{id}"})
    @DSTransactional
    public ActionResult winBid(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws DataException, WorkFlowException {
        boolean b;
        UserInfo userInfo = this.userProvider.get();
        if (beforeSaleBidUpForm != null && (b = this.beforeSaleBidService.winBid(beforeSaleBidUpForm))) {
            return ActionResult.success((String)"\u767b\u8bb0\u6210\u529f");
        }
        return ActionResult.success((String)"\u5931\u8d25");
    }

    @PutMapping(value={"/loseBid/{id}"})
    @DSTransactional
    public ActionResult loseBid(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws DataException, WorkFlowException {
        boolean b;
        if (beforeSaleBidUpForm != null && (b = this.beforeSaleBidService.loseBid(beforeSaleBidUpForm))) {
            return ActionResult.success((String)"\u767b\u8bb0\u6210\u529f");
        }
        return ActionResult.success((String)"\u5931\u8d25");
    }

    @PutMapping(value={"/reviewBid/{id}"})
    @DSTransactional
    public ActionResult reviewBid(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBidUpForm beforeSaleBidUpForm) throws DataException {
        boolean b;
        if (beforeSaleBidUpForm != null && (b = this.beforeSaleBidService.reviewBid(beforeSaleBidUpForm))) {
            return ActionResult.success((String)"\u767b\u8bb0\u6210\u529f");
        }
        return ActionResult.success((String)"\u5931\u8d25");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(BeforeSaleBidPaginationExportModel beforeSaleBidPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)beforeSaleBidPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        BeforeSaleBidPagination beforeSaleBidPagination = (BeforeSaleBidPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBidPaginationExportModel), BeforeSaleBidPagination.class));
        List<BeforeSaleBidEntity> list = this.beforeSaleBidService.getTypeList(beforeSaleBidPagination, beforeSaleBidPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleBidListVO.class);
        for (BeforeSaleBidListVO entity : listVO) {
            entity.setApplicationType(this.baseDataUtil.getDictName(entity.getApplicationType(), "applicationType"));
            entity.setBidCatagory(this.baseDataUtil.getDictName(entity.getBidCatagory(), "bidCatagory"));
            entity.setBidType(this.baseDataUtil.getDictName(entity.getBidType(), "bidType"));
            entity.setBidDelivery(this.baseDataUtil.getDictName(entity.getBidDelivery(), "bidDelivery"));
            entity.setApplyUserid(this.baseDataUtil.userSelectValues(entity.getApplyUserid()));
            entity.setSupportUserid(this.baseDataUtil.userSelectValues(entity.getSupportUserid()));
            entity.setCollaborativePerson(this.baseDataUtil.userSelectValues(entity.getCollaborativePerson()));
            entity.setEnabledMarkName(this.baseDataUtil.getDictName(String.valueOf(entity.getEnabledMark()), "bidEnabledMark"));
            entity.setAssociationProductName(this.crmProductService.getInfoByListId(entity.getAssociationProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            if (ObjectUtil.isNotEmpty((Object)this.crmCustomerService.getInfo(entity.getCustomerName()))) {
                entity.setCustomerTitle(this.crmCustomerService.getInfo(entity.getCustomerName()).getName());
            }
            entity.setApplyUserid(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyUserid()));
            HashMap<String, String> statusMap = new HashMap<String, String>();
            statusMap.put("1", "\u7b49\u5f85\u5ba1\u6838");
            statusMap.put("2", "\u5ba1\u6838\u901a\u8fc7");
            statusMap.put("3", "\u5ba1\u6838\u9a73\u56de");
            statusMap.put("4", "\u6d41\u7a0b\u64a4\u56de");
            statusMap.put("5", "\u5ba1\u6838\u7ec8\u6b62");
            if (ObjectUtil.isNotEmpty((Object)entity.getEnabledMark())) {
                String status = statusMap.getOrDefault(entity.getEnabledMark(), "\u7b49\u5f85\u63d0\u4ea4");
                entity.setEnabledMark(status);
            }
            entity.setWinBid(this.baseDataUtil.getDictName(entity.getWinBid(), "beforeSaleBidStatus"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)beforeSaleBidPaginationExportModel.getSelectKey()) ? beforeSaleBidPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerTitle": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerTitle"));
                        continue block44;
                    }
                    case "associationProductName": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u4ea7\u54c1", (Object)"associationProductName"));
                        continue block44;
                    }
                    case "tenderName": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u9879\u76ee\u540d\u79f0", (Object)"tenderName"));
                        continue block44;
                    }
                    case "bidType": {
                        entitys.add(new ExcelExportEntity("\u6295\u6807\u7c7b\u578b", (Object)"bidType"));
                        continue block44;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u5f00\u59cb\u65e5\u671f", (Object)"startTime"));
                        continue block44;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u6807\u4e66\u8d2d\u4e70\u622a\u6b62\u65e5\u671f", (Object)"endTime"));
                        continue block44;
                    }
                    case "applyUserid": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"applyUserid"));
                        continue block44;
                    }
                    case "supportUserid": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u4eba\u5458", (Object)"supportUserid"));
                        continue block44;
                    }
                    case "tenderFee": {
                        entitys.add(new ExcelExportEntity("\u6807\u4e66\u8d39\u7528(\u5143)", (Object)"tenderFee"));
                        continue block44;
                    }
                    case "projectBudget": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9884\u7b97(\u5143)", (Object)"projectBudget"));
                        continue block44;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block44;
                    }
                    case "winBid": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u6807\u72b6\u6001", (Object)"winBid"));
                        continue block44;
                    }
                    case "winningBidAmount": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u6807\u91d1\u989d(\u5143)", (Object)"winningBidAmount"));
                        continue block44;
                    }
                    case "successfulBidderTime": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u6807\u65f6\u95f4", (Object)"successfulBidderTime"));
                        continue block44;
                    }
                    case "lostDescription": {
                        entitys.add(new ExcelExportEntity("\u4e22\u5355\u8bf4\u660e", (Object)"lostDescription"));
                        continue block44;
                    }
                    case "reviewDescription": {
                        entitys.add(new ExcelExportEntity("\u590d\u76d8\u8bf4\u660e", (Object)"reviewDescription"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u62db\u6295\u6807\u652f\u6301\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

