/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleBiddingSuppliersEntity;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersCrForm;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersInfoVO;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersListVO;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersPagination;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersPaginationExportModel;
import com.bringspring.visit.model.beforesalebiddingsuppliers.BeforeSaleBiddingSuppliersUpForm;
import com.bringspring.visit.service.BeforeSaleBiddingSuppliersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6536\u6b3e\u5355\u4f4d\u7ba1\u7406"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleBiddingSuppliers"})
public class BeforeSaleBiddingSuppliersController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleBiddingSuppliersController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleBiddingSuppliersService beforeSaleBiddingSuppliersService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleBiddingSuppliersPagination beforeSaleBiddingSuppliersPagination) throws IOException {
        List<BeforeSaleBiddingSuppliersEntity> list = this.beforeSaleBiddingSuppliersService.getList(beforeSaleBiddingSuppliersPagination);
        for (BeforeSaleBiddingSuppliersEntity beforeSaleBiddingSuppliersEntity : list) {
            beforeSaleBiddingSuppliersEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(beforeSaleBiddingSuppliersEntity.getCreatorUserId()));
            beforeSaleBiddingSuppliersEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(beforeSaleBiddingSuppliersEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleBiddingSuppliersListVO.class);
        for (BeforeSaleBiddingSuppliersListVO beforeSaleBiddingSuppliersListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBiddingSuppliersPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid BeforeSaleBiddingSuppliersCrForm beforeSaleBiddingSuppliersCrForm) throws DataException {
        this.beforeSaleBiddingSuppliersService.create(beforeSaleBiddingSuppliersCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(BeforeSaleBiddingSuppliersPaginationExportModel beforeSaleBiddingSuppliersPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)beforeSaleBiddingSuppliersPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        BeforeSaleBiddingSuppliersPagination beforeSaleBiddingSuppliersPagination = (BeforeSaleBiddingSuppliersPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleBiddingSuppliersPaginationExportModel), BeforeSaleBiddingSuppliersPagination.class));
        List<BeforeSaleBiddingSuppliersEntity> list = this.beforeSaleBiddingSuppliersService.getTypeList(beforeSaleBiddingSuppliersPagination, beforeSaleBiddingSuppliersPaginationExportModel.getDataType());
        for (BeforeSaleBiddingSuppliersEntity beforeSaleBiddingSuppliersEntity : list) {
            beforeSaleBiddingSuppliersEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(beforeSaleBiddingSuppliersEntity.getCreatorUserId()));
            beforeSaleBiddingSuppliersEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(beforeSaleBiddingSuppliersEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleBiddingSuppliersListVO.class);
        for (BeforeSaleBiddingSuppliersListVO beforeSaleBiddingSuppliersListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)beforeSaleBiddingSuppliersPaginationExportModel.getSelectKey()) ? beforeSaleBiddingSuppliersPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "id": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u952e", (Object)"id"));
                        continue block28;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"supplierName"));
                        continue block28;
                    }
                    case "ncCode": {
                        entitys.add(new ExcelExportEntity("NC\u7f16\u7801", (Object)"ncCode"));
                        continue block28;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block28;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block28;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block28;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block28;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        boolean i = this.beforeSaleBiddingSuppliersService.removeBatchByIds(allIdList);
        if (!i) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleBiddingSuppliersInfoVO> info(@PathVariable(value="id") String id) {
        BeforeSaleBiddingSuppliersEntity entity = this.beforeSaleBiddingSuppliersService.getInfo(id);
        BeforeSaleBiddingSuppliersInfoVO vo = (BeforeSaleBiddingSuppliersInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBiddingSuppliersInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleBiddingSuppliersInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleBiddingSuppliersEntity entity = this.beforeSaleBiddingSuppliersService.getInfo(id);
        BeforeSaleBiddingSuppliersInfoVO vo = (BeforeSaleBiddingSuppliersInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleBiddingSuppliersInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleBiddingSuppliersUpForm beforeSaleBiddingSuppliersUpForm) throws DataException {
        this.beforeSaleBiddingSuppliersService.update(id, beforeSaleBiddingSuppliersUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleBiddingSuppliersEntity entity = this.beforeSaleBiddingSuppliersService.getInfo(id);
        if (entity != null) {
            this.beforeSaleBiddingSuppliersService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

