/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleFileEntity;
import com.bringspring.visit.model.beforesalefile.BeforeSaleFileCrForm;
import com.bringspring.visit.model.beforesalefile.BeforeSaleFileInfoVO;
import com.bringspring.visit.model.beforesalefile.BeforeSaleFileListVO;
import com.bringspring.visit.model.beforesalefile.BeforeSaleFilePagination;
import com.bringspring.visit.model.beforesalefile.BeforeSaleFileUpForm;
import com.bringspring.visit.service.BeforeSaleFileService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u524d\u6587\u6863"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleFile"})
public class BeforeSaleFileController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleFileController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleFileService beforeSaleFileService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductService crmProductService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleFilePagination beforeSaleFilePagination) throws IOException {
        List<BeforeSaleFileEntity> list = this.beforeSaleFileService.getList(beforeSaleFilePagination);
        UserInfo userInfo = this.userProvider.get();
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleFileListVO.class);
        List organizeList = this.organizeService.getOrgRedisList();
        for (BeforeSaleFileListVO entity : listVO) {
            entity.setFileType(this.baseDataUtil.getDictName(entity.getFileType(), "fileType"));
            entity.setFilePath(this.baseDataUtil.getFileNameInJson(entity.getFilePath()));
            entity.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            List<String> companyList = this.beforeSaleFileService.strToList(entity.getCompanyName());
            if (entity.getLastModifyTime() == null) {
                entity.setLastModifyTime(entity.getCreatorTime());
            }
            if (entity.getCreatorUserId().equals(userInfo.getUserId())) {
                entity.setUpdateFlag(true);
            }
            if (companyList.isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            block1: for (String s : companyList) {
                if (organizeList == null) continue;
                for (OrganizeEntity organize : organizeList) {
                    if (!s.equals(organize.getId())) continue;
                    stringBuilder.append(organize.getFullName() + ",");
                    continue block1;
                }
            }
            if (stringBuilder == null) continue;
            entity.setCompanyName(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)beforeSaleFilePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid BeforeSaleFileCrForm beforeSaleFileCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        beforeSaleFileCrForm.setCreatorUserId(userInfo.getUserId());
        beforeSaleFileCrForm.setCreatorTime(DateUtil.getNow());
        BeforeSaleFileEntity entity = (BeforeSaleFileEntity)JsonUtil.getJsonToBean((Object)beforeSaleFileCrForm, BeforeSaleFileEntity.class);
        entity.setId(mainId);
        this.beforeSaleFileService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleFileInfoVO> info(@PathVariable(value="id") String id) {
        BeforeSaleFileEntity entity = this.beforeSaleFileService.getInfo(id);
        BeforeSaleFileInfoVO vo = (BeforeSaleFileInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleFileInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setAssociationProductName(this.crmProductService.getInfo(vo.getAssociationProduct()).getProductName());
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleFileInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleFileEntity entity = this.beforeSaleFileService.getInfo(id);
        BeforeSaleFileInfoVO vo = (BeforeSaleFileInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleFileInfoVO.class);
        vo.setAssociationProductName(this.crmProductService.getInfo(vo.getAssociationProduct()).getProductName());
        vo.setFileType(this.baseDataUtil.getDictName(vo.getFileType(), "fileType"));
        vo.setFilePath(this.baseDataUtil.getFileNameInJson(vo.getFilePath()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setAssociationProduct(this.crmProductService.getInfo(vo.getAssociationProduct()).getProductName());
        List<String> companyList = this.beforeSaleFileService.strToList(entity.getCompanyName());
        if (vo.getLastModifyTime() == null) {
            vo.setLastModifyTime(vo.getCreatorTime());
        }
        if (!companyList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : companyList) {
                OrganizeEntity info = this.organizeService.getInfo(s);
                if (info == null) continue;
                stringBuilder.append(info.getFullName() + ",");
            }
            vo.setCompanyName(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleFileUpForm beforeSaleFileUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleFileEntity entity = this.beforeSaleFileService.getInfo(id);
        if (entity != null) {
            BeforeSaleFileEntity subentity = (BeforeSaleFileEntity)JsonUtil.getJsonToBean((Object)beforeSaleFileUpForm, BeforeSaleFileEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.beforeSaleFileService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleFileEntity entity = this.beforeSaleFileService.getInfo(id);
        if (entity != null) {
            this.beforeSaleFileService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/downLoad/{id}"})
    @DSTransactional
    public ActionResult downLoad(@PathVariable(value="id") String id) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleFileEntity entity = this.beforeSaleFileService.getInfo(id);
        return null;
    }
}

