/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleBidEntity;
import com.bringspring.visit.entity.BeforeSaleMarginEntity;
import com.bringspring.visit.model.beforesalemargin.BeforeSaleMarginCrForm;
import com.bringspring.visit.model.beforesalemargin.BeforeSaleMarginInfoVO;
import com.bringspring.visit.model.beforesalemargin.BeforeSaleMarginListVO;
import com.bringspring.visit.model.beforesalemargin.BeforeSaleMarginPagination;
import com.bringspring.visit.model.beforesalemargin.BeforeSaleMarginUpForm;
import com.bringspring.visit.service.BeforeSaleBidService;
import com.bringspring.visit.service.BeforeSaleMarginService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6295\u6807\u4fdd\u8bc1\u91d1"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleMargin"})
public class BeforeSaleMarginController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleMarginController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleMarginService beforeSaleMarginService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private BeforeSaleBidService beforeSaleBidService;
    @Autowired
    private CrmCustomerService crmCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleMarginPagination beforeSaleMarginPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<BeforeSaleMarginEntity> list = this.beforeSaleMarginService.getList(beforeSaleMarginPagination);
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleMarginListVO.class);
        for (BeforeSaleMarginListVO entity : listVO) {
            entity.setBidHead(this.baseDataUtil.userSelectValues(entity.getBidHead()));
            entity.setReturnPaymentType(this.baseDataUtil.getDictName(entity.getReturnPaymentType(), "returnPaymentType"));
            entity.setAssociationBidName(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()).getTenderName());
            entity.setCustomerName(this.crmCustomerService.getInfo(entity.getCustomerId()).getName());
            entity.setBidEntity(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()));
            if (!userInfo.getUserId().equals(entity.getCreatorUserId())) continue;
            entity.setButtonFlag(true);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)beforeSaleMarginPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid BeforeSaleMarginCrForm beforeSaleMarginCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleMarginEntity entity = (BeforeSaleMarginEntity)JsonUtil.getJsonToBean((Object)beforeSaleMarginCrForm, BeforeSaleMarginEntity.class);
        entity.setId(mainId);
        entity.setRecoverMargin(1);
        this.beforeSaleMarginService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleMarginInfoVO> info(@PathVariable(value="id") String id) {
        BeforeSaleMarginEntity entity = this.beforeSaleMarginService.getInfo(id);
        BeforeSaleMarginInfoVO vo = (BeforeSaleMarginInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleMarginInfoVO.class);
        vo.setAssociationBidName(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()).getTenderName());
        vo.setCustomerName(this.crmCustomerService.getInfo(entity.getCustomerId()).getName());
        vo.setBidEntity(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleMarginInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleMarginEntity entity = this.beforeSaleMarginService.getInfo(id);
        BeforeSaleMarginInfoVO vo = (BeforeSaleMarginInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleMarginInfoVO.class);
        vo.setAssociationBidName(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()).getTenderName());
        vo.setCustomerName(this.crmCustomerService.getInfo(entity.getCustomerId()).getName());
        vo.setBidEntity(this.beforeSaleBidService.getInfo(entity.getAssociationBidId()));
        vo.setBidHead(this.baseDataUtil.userSelectValues(vo.getBidHead()));
        vo.setReturnPaymentType(this.baseDataUtil.getDictName(vo.getReturnPaymentType(), "returnPaymentType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleMarginUpForm beforeSaleMarginUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BeforeSaleMarginEntity entity = this.beforeSaleMarginService.getInfo(id);
        BeforeSaleBidEntity info = this.beforeSaleBidService.getInfo(beforeSaleMarginUpForm.getAssociationBidId());
        if (entity != null) {
            BeforeSaleMarginEntity subentity = (BeforeSaleMarginEntity)JsonUtil.getJsonToBean((Object)beforeSaleMarginUpForm, BeforeSaleMarginEntity.class);
            if (beforeSaleMarginUpForm.getReturnPaymentActuallyTime() != null) {
                String twoDay = DateUtil.getTwoDay((String)DateUtil.daFormat((Date)subentity.getReturnPaymentActuallyTime()), (String)DateUtil.daFormat((Date)info.getCreatorTime()));
                subentity.setHoldingTime(Integer.valueOf(twoDay));
                subentity.setRecoverMargin(0);
            }
            this.beforeSaleMarginService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleMarginEntity entity = this.beforeSaleMarginService.getInfo(id);
        if (entity != null) {
            this.beforeSaleMarginService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

