/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.model.before_sale_support_list.BeforeSaleSupportListCrForm;
import com.bringspring.visit.model.before_sale_support_list.BeforeSaleSupportListListVO;
import com.bringspring.visit.model.before_sale_support_list.BeforeSaleSupportListPagination;
import com.bringspring.visit.model.before_sale_support_list.BeforeSaleSupportListPaginationExportModel;
import com.bringspring.visit.service.BeforeSaleSupportListService;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u524d\u652f\u6301\u7533\u5217\u8868"}, value="beforeSaleSupportList")
@RequestMapping(value={"/api/visit/Beforesalesupportlist"})
public class BeforeSaleSupportListController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleSupportListController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BeforeSaleSupportListService beforesalesupportlistService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleSupportListPagination beforesalesupportlistPagination) throws IOException {
        List<BeforeSaleSupportListListVO> listVO = this.beforesalesupportlistService.getBeforeSaleSupportList(beforesalesupportlistPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)beforesalesupportlistPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleSupportListListVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleSupportListListVO vo = this.beforesalesupportlistService.getBeforeSaleSupportListInfoVO(id);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"assign"})
    @Transactional
    public ActionResult assign(@RequestBody BeforeSaleSupportListCrForm beforeSaleSupportListCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap assign = this.beforesalesupportlistService.assign(beforeSaleSupportListCrForm);
            if (Objects.isNull(assign.get("error"))) {
                return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
            }
            return ActionResult.fail((String)assign.get("error").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"execute"})
    @Transactional
    public ActionResult execute(@RequestBody BeforeSaleSupportListCrForm beforeSaleSupportListCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap assign = this.beforesalesupportlistService.execute(beforeSaleSupportListCrForm);
            if (Objects.isNull(assign.get("error"))) {
                return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
            }
            return ActionResult.fail((String)assign.get("error").toString());
        }
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(BeforeSaleSupportListPaginationExportModel beforeSaleSupportListPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)beforeSaleSupportListPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        BeforeSaleSupportListPagination beforeSaleSupportListPagination = (BeforeSaleSupportListPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportListPaginationExportModel), BeforeSaleSupportListPagination.class));
        List<BeforeSaleSupportListListVO> listVO = this.beforesalesupportlistService.getBeforeSaleSupportListExport(beforeSaleSupportListPagination, beforeSaleSupportListPaginationExportModel.getDataType());
        for (BeforeSaleSupportListListVO vo : listVO) {
            if (ObjectUtil.isNotEmpty((Object)vo.getBeforeSaleManager()) && vo.getBeforeSaleManager().contains("[")) {
                vo.setBeforeSaleManager(vo.getBeforeSaleManager().replace("[", "").replace("]", "").replace("\"", "").replace("\\", ""));
            }
            vo.setBeforeSaleManagerName(this.baseDataUtil.userSelectValues(vo.getBeforeSaleManager()));
            if (ObjectUtil.isNotEmpty((Object)vo.getStartTime())) {
                vo.setStartTimeString(DateUtil.format((Date)vo.getStartTime(), (String)"yyyy-MM-dd"));
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getEndTime())) {
                vo.setEndTimeString(DateUtil.format((Date)vo.getEndTime(), (String)"yyyy-MM-dd"));
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getEstimatedBiddingStartdate())) {
                vo.setBiddingStartString(DateUtil.format((Date)vo.getEstimatedBiddingStartdate(), (String)"yyyy-MM-dd"));
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getEstimatedBiddingEnddate())) {
                vo.setBiddingEndString(DateUtil.format((Date)vo.getEstimatedBiddingEnddate(), (String)"yyyy-MM-dd"));
            }
            if ("0".equals(vo.getWetherKnow())) {
                vo.setWetherKnow("\u4e0d\u77e5\u6653");
            } else {
                vo.setWetherKnow("\u5df2\u77e5\u6653");
            }
            if ("0".equals(vo.getWetherAccompany())) {
                vo.setWetherAccompany("\u662f");
                continue;
            }
            vo.setWetherAccompany("\u4e0d\u966a\u540c");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)beforeSaleSupportListPaginationExportModel.getSelectKey()) ? beforeSaleSupportListPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block76: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerId"));
                        continue block76;
                    }
                    case "customerCatagory": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546/\u96c6\u6210\u5546", (Object)"customerCatagory"));
                        continue block76;
                    }
                    case "customerType": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7c7b\u578b", (Object)"customerType"));
                        continue block76;
                    }
                    case "wetherKnow": {
                        entitys.add(new ExcelExportEntity("\u9886\u5bfc\u662f\u5426\u77e5\u6653", (Object)"wetherKnow"));
                        continue block76;
                    }
                    case "wetherAccompany": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u662f\u5426\u966a\u540c", (Object)"wetherAccompany"));
                        continue block76;
                    }
                    case "supportProductId": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u4ea7\u54c1", (Object)"supportProductId"));
                        continue block76;
                    }
                    case "supportContent": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u7c7b\u578b", (Object)"supportContent"));
                        continue block76;
                    }
                    case "supportprojectStage": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u9879\u76ee\u9636\u6bb5", (Object)"supportprojectStage"));
                        continue block76;
                    }
                    case "supportType": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u65b9\u5f0f", (Object)"supportType"));
                        continue block76;
                    }
                    case "demonstrationTime": {
                        entitys.add(new ExcelExportEntity("\u8bba\u8bc1\u4f1a\u65f6\u95f4", (Object)"demonstrationTime"));
                        continue block76;
                    }
                    case "participant": {
                        entitys.add(new ExcelExportEntity("\u53c2\u4e0e\u4eba", (Object)"participant"));
                        continue block76;
                    }
                    case "competeCompetitors": {
                        entitys.add(new ExcelExportEntity("\u53c2\u4e0e\u7ade\u4e89\u5bf9\u624b", (Object)"competeCompetitors"));
                        continue block76;
                    }
                    case "customerFocusProduct": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5173\u6ce8\u70b9", (Object)"customerFocusProduct"));
                        continue block76;
                    }
                    case "explainPoints": {
                        entitys.add(new ExcelExportEntity("\u8bb2\u89e3\u6f14\u793a\u4fa7\u91cd\u70b9", (Object)"explainPoints"));
                        continue block76;
                    }
                    case "bidOpeningTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u6807\u65f6\u95f4", (Object)"bidOpeningTime"));
                        continue block76;
                    }
                    case "surroundingManufacturer": {
                        entitys.add(new ExcelExportEntity("\u56f4\u6807\u5382\u5bb6", (Object)"surroundingManufacturer"));
                        continue block76;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u5f00\u59cb\u65f6\u95f4", (Object)"startTimeString"));
                        continue block76;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u7ed3\u675f\u65f6\u95f4", (Object)"endTimeString"));
                        continue block76;
                    }
                    case "supportUserid": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u4eba\u5458", (Object)"supportUserid"));
                        continue block76;
                    }
                    case "beforeSaleManagerName": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u652f\u6301\u4eba\u5458", (Object)"beforeSaleManagerName"));
                        continue block76;
                    }
                    case "actualProductName": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u652f\u6301\u4ea7\u54c1", (Object)"actualProductName"));
                        continue block76;
                    }
                    case "actualStartTime": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u652f\u6301\u5f00\u59cb\u65f6\u95f4", (Object)"actualStartTime"));
                        continue block76;
                    }
                    case "actualEndTime": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u652f\u6301\u7ed3\u675f\u65f6\u95f4", (Object)"actualEndTime"));
                        continue block76;
                    }
                    case "applyPerson": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"applyPerson"));
                        continue block76;
                    }
                    case "applyPersonDepartment": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba\u90e8\u95e8", (Object)"applyPersonDepartment"));
                        continue block76;
                    }
                    case "budgetLimit": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u989d\u5ea6", (Object)"budgetLimit"));
                        continue block76;
                    }
                    case "budgetDescription": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u63cf\u8ff0", (Object)"budgetDescription"));
                        continue block76;
                    }
                    case "contentToConstructed": {
                        entitys.add(new ExcelExportEntity("\u62df\u5efa\u8bbe\u5185\u5bb9", (Object)"contentToConstructed"));
                        continue block76;
                    }
                    case "estimatedBiddingStartdate": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u5f00\u59cb\u65f6\u95f4", (Object)"biddingStartString"));
                        continue block76;
                    }
                    case "estimatedBiddingEnddate": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u7ed3\u675f\u65f6\u95f4", (Object)"biddingEndString"));
                        continue block76;
                    }
                    case "technicalRequirement": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"technicalRequirement"));
                        continue block76;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block76;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u552e\u524d\u7533\u8bf7\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u552e\u524d\u7533\u8bf7\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u552e\u524d\u7533\u8bf7\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

