/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.constant.MarketLogStateEnum;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkReturnPlanFollowEntity;
import com.bringspring.contract.mapper.RkContractProjectMapper;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkReturnPlanFollowService;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmClueTrendsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.mapper.CrmProductMapper;
import com.bringspring.crm.mapper.CrmProductRelationMapper;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoInfoVO;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmClueTrendsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkMarketLogEntity;
import com.bringspring.visit.entity.RkMrketLogDetailEntity;
import com.bringspring.visit.entity.RkMrketLogRelevanceEntity;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.entity.VisitFollowUpEntity;
import com.bringspring.visit.mapper.VisitFollowUpMapper;
import com.bringspring.visit.model.RkMrketLogRelevanceListInfo;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCopyTo;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCopytoCrForm;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCrForm;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogInfoVO;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogListVO;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogPagination;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogUpForm;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogRelevanceListVO;
import com.bringspring.visit.model.rkMarketLog.VisitFollowUpForm;
import com.bringspring.visit.service.RkMarketLogCopytoService;
import com.bringspring.visit.service.RkMarketLogProjectDataService;
import com.bringspring.visit.service.RkMarketLogService;
import com.bringspring.visit.service.RkMrketLogDetailService;
import com.bringspring.visit.service.RkMrketLogRelevanceService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkProjectReportingStageTrendsService;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workitem.service.CrmWorkitemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u548c\u4ea4\u4ed8\u65e5\u5fd7"}, value="contract")
@RequestMapping(value={"/api/visit/RkMarketLog"})
public class RkMarketLogController {
    private static final Logger log = LoggerFactory.getLogger(RkMarketLogController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkMarketLogService rkMarketLogService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private RkMarketLogCopytoService rkMarketLogCopytoService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private VisitFollowUpMapper visitFollowUpMapper;
    @Autowired
    private RkContractProjectMapper rkContractProjectMapper;
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductMapper crmProductMapper;
    @Autowired
    private CrmProductRelationMapper crmProductRelationMapper;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private CrmClueTrendsService crmClueTrendsService;
    @Autowired
    private RkProjectReportingStageTrendsService rkProjectReportingStageTrendsService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private RkMrketLogRelevanceService rkMrketLogRelevanceService;
    @Autowired
    private RkMrketLogDetailService rkMrketLogDetailService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkMarketLogProjectDataService rkMarketLogProjectDataService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkReturnPlanFollowService rkReturnPlanFollowService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkMarketLogPagination rkMarketLogPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<RkMarketLogEntity> list = this.rkMarketLogService.getList(rkMarketLogPagination);
        for (RkMarketLogEntity rkMarketLogEntity : list) {
            rkMarketLogEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(rkMarketLogEntity.getLastModifyUserId()));
            rkMarketLogEntity.setImages(this.baseDataUtil.getFileNameInJson(rkMarketLogEntity.getImages()));
            if (rkMarketLogEntity.getMarketType().equals("sale")) {
                rkMarketLogEntity.setLogType(this.baseDataUtil.getDictName(rkMarketLogEntity.getLogType(), "marketLogType"));
                continue;
            }
            rkMarketLogEntity.setLogType(this.baseDataUtil.getDictName(rkMarketLogEntity.getLogType(), "deliveryLogType"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkMarketLogListVO.class);
        for (RkMarketLogListVO vo : listVO) {
            Object rkContractProjectEntity;
            OrganizeEntity byId;
            if (StrUtil.isNotEmpty((CharSequence)vo.getOrganizeId()) && ObjectUtil.isNotNull((Object)(byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getOrganizeId()))))) {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                vo.setOrganizeName(jsonToBean.getShortName());
                vo.setCompanyName(jsonToBean.getShortName());
            }
            UserEntity userEntity = this.serviceAllUtil.getUserInfo(vo.getCreatorUserId());
            OrganizeEntity organizeInfo = this.serviceAllUtil.getOrganizeInfo(userEntity.getOrganizeId());
            if (ObjectUtil.isNotEmpty((Object)vo.getDepartmentId())) {
                if (StrUtil.equals((CharSequence)vo.getOrganizeId(), (CharSequence)CompanyIdEnum.HNZY.getId())) {
                    vo.setDepartmentName(organizeInfo.getFullName());
                } else {
                    vo.setDepartmentName(this.baseDataUtil.comSelectValues(vo.getDepartmentId()));
                }
            }
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            ArrayList<String> ids = new ArrayList<String>();
            vo.setVisitFollowUpIdList(this.strToList(vo.getVisitFollowUpId()));
            for (String id : vo.getVisitFollowUpIdList()) {
                VisitFollowUpEntity visitFollowUpEntity = (VisitFollowUpEntity)this.visitFollowUpMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(VisitFollowUpEntity::getId, (Object)id));
                if (!Objects.nonNull(visitFollowUpEntity)) continue;
                ids.add(visitFollowUpEntity.getCustomerName());
            }
            vo.setVisitFollowUpName(ids);
            if (StringUtils.isNotEmpty((String)vo.getNewProductId()) && Objects.nonNull(rkContractProjectEntity = (CrmProductRelationEntity)this.crmProductRelationMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(CrmProductRelationEntity::getId, (Object)vo.getNewProductId())))) {
                vo.setNewProductName(((CrmProductEntity)this.crmProductMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(CrmProductEntity::getId, (Object)((CrmProductRelationEntity)rkContractProjectEntity).getProductId()))).getProductName());
            }
            if (!vo.getMarketType().equals("afterSale") && !vo.getMarketType().equals("newAfterSale")) continue;
            if (StringUtils.isNotEmpty((String)vo.getRkContractProjectId())) {
                if (vo.getMarketType().equals("afterSale") && vo.getRkContractProjectId().equals("\u8363\u79d1\u79d1\u6280\u5185\u90e8\u9879\u76ee") || vo.getRkContractProjectId().equals("\u5185\u90e8\u9879\u76ee")) {
                    vo.setRkContractProjectName("\u5185\u90e8\u9879\u76ee");
                } else if (vo.getRkContractProjectId().contains(",")) {
                    ArrayList<String> projectName = new ArrayList<String>();
                    ArrayList<String> projectCodeList = new ArrayList<String>();
                    String[] split = vo.getRkContractProjectId().split(",");
                    vo.setRkContractProjectIdList(Arrays.asList(split));
                    String[] stringArray = split;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String projectId = stringArray[i];
                        RkContractProjectEntity rkContractProjectEntity2 = (RkContractProjectEntity)this.rkContractProjectMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RkContractProjectEntity::getId, (Object)projectId));
                        if (!Objects.nonNull(rkContractProjectEntity2)) continue;
                        projectName.add(rkContractProjectEntity2.getProjectName() + ",");
                        projectCodeList.add(rkContractProjectEntity2.getProjectCode());
                    }
                    vo.setRkContractProjectNameList(projectName);
                    vo.setProjectState("0");
                    vo.setProjectCode(projectCodeList.stream().map(Object::toString).collect(Collectors.joining(", ")));
                } else {
                    rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RkContractProjectEntity::getId, (Object)vo.getRkContractProjectId()));
                    if (Objects.nonNull(rkContractProjectEntity)) {
                        vo.setRkContractProjectName(((RkContractProjectEntity)rkContractProjectEntity).getProjectName());
                    }
                    vo.setProjectState("1");
                    vo.setProjectCode(((RkContractProjectEntity)rkContractProjectEntity).getProjectCode());
                }
            }
            if (!StringUtils.isNotEmpty((String)vo.getCustomerId())) continue;
            if (vo.getCustomerId().contains(",")) {
                String[] customerIds;
                ArrayList<String> customerNames = new ArrayList<String>();
                for (String customerId : customerIds = vo.getCustomerId().split(",")) {
                    CrmCustomerEntity info = this.crmCustomerService.getInfo(customerId);
                    if (!ObjectUtil.isNotEmpty((Object)info)) continue;
                    customerNames.add(info.getName());
                }
                vo.setCustomerName(customerNames.stream().map(Object::toString).collect(Collectors.joining(", ")));
                continue;
            }
            CrmCustomerEntity info = this.crmCustomerService.getInfo(vo.getCustomerId());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            vo.setCustomerName(info.getName());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkMarketLogPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    public List<String> strToList(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            str = str.replaceAll("\"", "").replace("[", "").replace("]", "");
            String[] split = str.split(",");
            return JsonUtil.getJsonToList((Object)split, String.class);
        }
        return new ArrayList<String>();
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkMarketLogPagination rkMarketLogPagination) throws IOException {
        if (StringUtils.isEmpty((String)rkMarketLogPagination.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        List<RkMarketLogEntity> list = this.rkMarketLogService.getTypeList(rkMarketLogPagination, rkMarketLogPagination.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkMarketLogListVO.class);
        for (RkMarketLogListVO vo : listVO) {
            if (StrUtil.isNotEmpty((CharSequence)vo.getOrganizeId())) {
                vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getOrganizeId()));
            }
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setState(StringUtils.equals((CharSequence)vo.getState(), (CharSequence)"0") ? "\u8349\u7a3f" : "\u5df2\u63d0\u4ea4");
            vo.setLogType(this.baseDataUtil.getDictName(vo.getLogType(), "marketLogType"));
            if (!vo.getMarketType().equals("afterSale") && !vo.getMarketType().equals("newAfterSale")) continue;
            if (StringUtils.isNotEmpty((String)vo.getRkContractProjectId())) {
                if (vo.getMarketType().equals("afterSale") && vo.getRkContractProjectId().equals("\u8363\u79d1\u79d1\u6280\u5185\u90e8\u9879\u76ee") || vo.getRkContractProjectId().equals("\u5185\u90e8\u9879\u76ee")) {
                    vo.setRkContractProjectName("\u5185\u90e8\u9879\u76ee");
                } else if (vo.getRkContractProjectId().contains(",")) {
                    ArrayList<String> projectName = new ArrayList<String>();
                    ArrayList<String> projectCodeList = new ArrayList<String>();
                    String[] split = vo.getRkContractProjectId().split(",");
                    vo.setRkContractProjectIdList(Arrays.asList(split));
                    String[] stringArray = split;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String projectId = stringArray[i];
                        RkContractProjectEntity rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RkContractProjectEntity::getId, (Object)projectId));
                        if (!Objects.nonNull(rkContractProjectEntity)) continue;
                        projectName.add(rkContractProjectEntity.getProjectName() + ",");
                        projectCodeList.add(rkContractProjectEntity.getProjectCode());
                    }
                    vo.setRkContractProjectNameList(projectName);
                    vo.setProjectState("0");
                    vo.setProjectCode(projectCodeList.stream().map(Object::toString).collect(Collectors.joining(", ")));
                } else {
                    RkContractProjectEntity rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RkContractProjectEntity::getId, (Object)vo.getRkContractProjectId()));
                    if (Objects.nonNull(rkContractProjectEntity)) {
                        vo.setRkContractProjectName(rkContractProjectEntity.getProjectName());
                    }
                    vo.setProjectState("1");
                    vo.setProjectCode(rkContractProjectEntity.getProjectCode());
                }
            }
            if (!StringUtils.isNotEmpty((String)vo.getCustomerId())) continue;
            if (vo.getCustomerId().contains(",")) {
                String[] customerIds;
                ArrayList<String> customerNames = new ArrayList<String>();
                for (String customerId : customerIds = vo.getCustomerId().split(",")) {
                    CrmCustomerEntity info = this.crmCustomerService.getInfo(customerId);
                    if (!ObjectUtil.isNotEmpty((Object)info)) continue;
                    customerNames.add(info.getName());
                }
                vo.setCustomerName(customerNames.stream().map(Object::toString).collect(Collectors.joining(", ")));
                continue;
            }
            CrmCustomerEntity info = this.crmCustomerService.getInfo(vo.getCustomerId());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            vo.setCustomerName(info.getName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkMarketLogPagination.getSelectKey()) ? rkMarketLogPagination.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block36;
                    }
                    case "optionDate": {
                        entitys.add(new ExcelExportEntity("\u65e5\u62a5\u65e5\u671f", (Object)"optionDate"));
                        continue block36;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba", (Object)"creatorUserName"));
                        continue block36;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block36;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u5185\u5bb9", (Object)"content"));
                        continue block36;
                    }
                    case "manHour": {
                        entitys.add(new ExcelExportEntity("\u5de5\u65f6", (Object)"manHour"));
                        continue block36;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u5ba2\u6237", (Object)"customerName"));
                        continue block36;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block36;
                    }
                    case "rkContractProjectName": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u9879\u76ee", (Object)"rkContractProjectName"));
                        continue block36;
                    }
                    case "state": {
                        entitys.add(new ExcelExportEntity("\u65e5\u5fd7\u72b6\u6001", (Object)"state"));
                        continue block36;
                    }
                    case "logType": {
                        entitys.add(new ExcelExportEntity("\u65e5\u5fd7\u7c7b\u578b", (Object)"logType"));
                        continue block36;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u65e5\u5fd7\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkMarketLogCrForm rkMarketLogCrForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"9") && StrUtil.equals((CharSequence)rkMarketLogCrForm.getMarketType(), (CharSequence)"afterSale") && this.rkMarketLogService.everydayTotal(rkMarketLogCrForm.getOptionDate())) {
            return ActionResult.fail((String)"\u5f53\u524d\u65e5\u671f\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3") && StrUtil.equals((CharSequence)rkMarketLogCrForm.getMarketType(), (CharSequence)"afterSale") && this.rkMarketLogService.getExceedManHour(rkMarketLogCrForm)) {
            return ActionResult.fail((String)"\u5de5\u65f6\u4e0d\u80fd\u8d85\u8fc714\u4e2a\u5c0f\u65f6");
        }
        Boolean is = this.rkMarketLogService.insert(rkMarketLogCrForm);
        if (is.booleanValue()) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.success((String)"\u521b\u5efa\u5931\u8d25");
    }

    @GetMapping(value={"marketDataAll/{id}"})
    public ActionResult<RkMarketLogInfoVO> marketDataAll(@PathVariable(value="id") String id) {
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        RkMarketLogInfoVO vo = (RkMarketLogInfoVO)JsonUtil.getJsonToBean((Object)entity, RkMarketLogInfoVO.class);
        List<RkMrketLogDetailEntity> list = this.rkMrketLogDetailService.getMarketById(vo.getId());
        vo.setMrketLogDetailList(list);
        vo.setRelevanceListInfo(this.getRelevanceListInfo(vo.getId()));
        return ActionResult.success((Object)vo);
    }

    private RkMrketLogRelevanceListInfo getRelevanceListInfo(String id) {
        RkMrketLogRelevanceListInfo info = new RkMrketLogRelevanceListInfo();
        List<RkMrketLogRelevanceEntity> marketId = this.rkMrketLogRelevanceService.getMarketId(id);
        info.setVisitFollowList(JsonUtil.getJsonToList(marketId.stream().filter(s -> s.getMainType().equals("forVisit")).collect(Collectors.toList()), RkMrketLogRelevanceListVO.class));
        info.setCrmClueList(JsonUtil.getJsonToList(marketId.stream().filter(s -> s.getMainType().equals("FollowLeads")).collect(Collectors.toList()), RkMrketLogRelevanceListVO.class));
        info.setTrendsList(JsonUtil.getJsonToList(marketId.stream().filter(s -> s.getMainType().equals("business")).collect(Collectors.toList()), RkMrketLogRelevanceListVO.class));
        info.setReturnPlanList(JsonUtil.getJsonToList(marketId.stream().filter(s -> s.getMainType().equals("returnPlan")).collect(Collectors.toList()), RkMrketLogRelevanceListVO.class));
        if (CollectionUtil.isNotEmpty(info.getVisitFollowList())) {
            info.setClientCount(info.getVisitFollowList().stream().filter(s -> s.getNextType().equals("client")).count());
            info.setEverydayCount(info.getVisitFollowList().stream().filter(s -> s.getNextType().equals("everyday")).count());
        }
        if (CollectionUtil.isNotEmpty(info.getCrmClueList())) {
            info.setAddFollowLeadsCount(info.getCrmClueList().stream().filter(s -> s.getNextType().equals("addFollowLeads")).count());
            info.setCiFollowLeadsCount(info.getCrmClueList().stream().filter(s -> s.getNextType().equals("ciFollowLeads")).count());
        }
        if (CollectionUtil.isNotEmpty(info.getTrendsList())) {
            info.setFollowBusinessCount(info.getTrendsList().stream().filter(s -> s.getNextType().equals("followBusiness")).count());
            info.setAddBusinessCount(info.getTrendsList().stream().filter(s -> s.getNextType().equals("addBusiness")).count());
        }
        if (CollectionUtil.isNotEmpty(info.getReturnPlanList())) {
            info.setFollowReturnPlanCount(info.getReturnPlanList().stream().filter(s -> s.getNextType().equals("followReturnPlan")).count());
        }
        return info;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkMarketLogInfoVO> info(@PathVariable(value="id") String id) {
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        RkMarketLogInfoVO vo = (RkMarketLogInfoVO)JsonUtil.getJsonToBean((Object)entity, RkMarketLogInfoVO.class);
        String zhi = "";
        if (StringUtils.isNotEmpty((String)vo.getVisitFollowUpId())) {
            vo.setVisitFollowUpIdList(this.strToList(vo.getVisitFollowUpId()));
        }
        for (String val : vo.getVisitFollowUpIdList()) {
            VisitFollowUpEntity visitFollowUp = (VisitFollowUpEntity)this.visitFollowUpMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(VisitFollowUpEntity::getId, (Object)val));
            if (!Objects.nonNull(visitFollowUp)) continue;
            vo.setVisitFollowUpId(visitFollowUp.getCustomerName());
            zhi = zhi + vo.getVisitFollowUpId() + "\uff0c";
        }
        if (!ObjectUtil.isEmpty((Object)zhi)) {
            String substring = zhi.substring(0, zhi.length() - 1);
            vo.setVisitFollowUpName(substring);
        }
        if (entity.getMarketType().equals("afterSale") && !vo.getCustomerId().isEmpty() && Objects.nonNull(vo.getCustomerId())) {
            vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        }
        if (vo.getMarketType().equals("sale")) {
            List<RkMrketLogDetailEntity> list = this.rkMrketLogDetailService.getMarketById(vo.getId());
            vo.setMrketLogDetailList(list);
            vo.setRelevanceListInfo(this.getRelevanceListInfo(vo.getId()));
            ArrayList<Long> allTime = new ArrayList<Long>();
            if (ObjectUtil.isNotEmpty((Object)entity.getStartTime())) {
                allTime.add(entity.getStartTime().getTime());
            }
            if (ObjectUtil.isNotEmpty((Object)entity.getEndTime())) {
                allTime.add(entity.getEndTime().getTime());
            }
            vo.setStartAllTime(allTime);
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkMarketLogListVO> detailInfo(@PathVariable(value="id") String id) {
        Object rkContractProjectEntity;
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        RkMarketLogListVO vo = this.rkMarketLogService.detailInfo(entity);
        vo.setUserIdCopyAll(entity.getUserIdCopy());
        if (vo.getMarketType().equals("sale")) {
            vo.setLogTypeYuan(this.baseDataUtil.getDictName(vo.getLogType(), "marketLogType"));
        } else {
            vo.setLogTypeYuan(this.baseDataUtil.getDictName(vo.getLogType(), "deliveryLogType"));
        }
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
        VisitFollowUpEntity visitFollowUpEntity = (VisitFollowUpEntity)this.visitFollowUpMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(VisitFollowUpEntity::getId, (Object)vo.getVisitFollowUpId()));
        String zhi = "";
        vo.setVisitFollowUpIdList(this.strToList(vo.getVisitFollowUpId()));
        for (String val : vo.getVisitFollowUpIdList()) {
            VisitFollowUpEntity visitFollowUp = (VisitFollowUpEntity)this.visitFollowUpMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(VisitFollowUpEntity::getId, (Object)val));
            if (!Objects.nonNull(visitFollowUp)) continue;
            vo.setVisitFollowUpId(visitFollowUp.getCustomerName());
            zhi = zhi + vo.getVisitFollowUpId() + "\uff0c";
        }
        if (!ObjectUtil.isEmpty((Object)zhi)) {
            String substring = zhi.substring(0, zhi.length() - 1);
            vo.setVisitFollowUpId(substring);
        } else {
            vo.setVisitFollowUpId("");
        }
        if (StringUtils.isNotEmpty((String)vo.getRkContractProjectId())) {
            if (vo.getMarketType().equals("afterSale") && vo.getRkContractProjectId().equals("\u8363\u79d1\u79d1\u6280\u5185\u90e8\u9879\u76ee") || vo.getRkContractProjectId().equals("\u5185\u90e8\u9879\u76ee")) {
                vo.setRkContractProjectName("\u5185\u90e8\u9879\u76ee");
            } else {
                rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RkContractProjectEntity::getId, (Object)vo.getRkContractProjectId()));
                if (Objects.nonNull(rkContractProjectEntity)) {
                    vo.setRkContractProjectName(((RkContractProjectEntity)rkContractProjectEntity).getProjectName());
                }
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getNewProductId()) && Objects.nonNull(rkContractProjectEntity = (CrmProductRelationEntity)this.crmProductRelationMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(CrmProductRelationEntity::getId, (Object)vo.getNewProductId())))) {
            vo.setNewProductName(((CrmProductEntity)this.crmProductMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(CrmProductEntity::getId, (Object)((CrmProductRelationEntity)rkContractProjectEntity).getProductId()))).getProductName());
        }
        vo.setImages(this.baseDataUtil.getFileNameInJson(vo.getImages()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getClueId())) {
            CrmClueInfoEntity byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)vo.getClueId()));
            vo.setCrmClueInfoInfoVO((CrmClueInfoInfoVO)JsonUtil.getJsonToBean((Object)byId, CrmClueInfoInfoVO.class));
        }
        if (vo.getMarketType().equals("sale") || vo.getMarketType().equals("mjWorkerLog")) {
            List<RkMrketLogDetailEntity> list = this.rkMrketLogDetailService.getMarketById(vo.getId());
            vo.setMrketLogDetailList(list);
            vo.setRelevanceListInfo(this.getRelevanceListInfo(vo.getId()));
            ArrayList<Long> allTime = new ArrayList<Long>();
            if (ObjectUtil.isNotEmpty((Object)entity.getStartTime())) {
                allTime.add(entity.getStartTime().getTime());
            }
            if (ObjectUtil.isNotEmpty((Object)entity.getEndTime())) {
                allTime.add(entity.getEndTime().getTime());
            }
            vo.setStartAllTime(allTime);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkMarketLogUpForm rkMarketLogUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"9") && StrUtil.equals((CharSequence)rkMarketLogUpForm.getMarketType(), (CharSequence)"afterSale") && this.rkMarketLogService.everydayTotal(rkMarketLogUpForm.getOptionDate())) {
            return ActionResult.fail((String)"\u5f53\u524d\u65e5\u671f\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"3") && StrUtil.equals((CharSequence)rkMarketLogUpForm.getMarketType(), (CharSequence)"afterSale") && this.rkMarketLogService.getExceedManHour((RkMarketLogCrForm)JsonUtil.getJsonToBean((Object)rkMarketLogUpForm, RkMarketLogCrForm.class))) {
            return ActionResult.fail((String)"\u5de5\u65f6\u4e0d\u80fd\u8d85\u8fc714\u4e2a\u5c0f\u65f6");
        }
        Boolean is = this.rkMarketLogService.updateMarket(id, rkMarketLogUpForm);
        if (is.booleanValue()) {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.success((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        if (MarketLogStateEnum.CONFIRM.getEnableMark().equals(entity.getState()) || MarketLogStateEnum.SUBMIT.getEnableMark().equals(entity.getState())) {
            return ActionResult.fail((String)"\u5df2\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u5220\u9664");
        }
        if (entity != null) {
            this.rkMarketLogService.delete(entity);
            this.rkMrketLogDetailService.deleteBatchIds(id);
            this.rkMrketLogRelevanceService.deleteBatchIds(id);
            this.rkMarketLogProjectDataService.deleteBatchIds(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/visit"})
    public ActionResult visitInfo(@RequestBody @Valid VisitFollowUpForm visitFollowUpForm) {
        List<VisitFollowUpEntity> entity = this.rkMarketLogService.getVisitInfo(visitFollowUpForm);
        for (VisitFollowUpEntity en : entity) {
            en.setGoal(this.baseDataUtil.getDictName(en.getGoal(), "visitgoal"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(entity);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitFollowUpForm), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/dateAll"})
    public ActionResult dateAll(@RequestBody @Valid VisitFollowUpForm visitFollowUpForm) {
        List<VisitFollowUpEntity> entity = this.rkMarketLogService.getVisitDateInfo(visitFollowUpForm);
        List<CrmClueTrendsEntity> crmClue = this.crmClueTrendsService.getUserIdDate(visitFollowUpForm);
        List<RkProjectReportingStageTrendsEntity> stageTrendsList = this.rkProjectReportingStageTrendsService.getUserIdDate(visitFollowUpForm);
        List<RkReturnPlanFollowEntity> returnPlanList = this.rkReturnPlanFollowService.getUserIdDate(visitFollowUpForm);
        RkMrketLogRelevanceListInfo visitFollowVo = this.rkMarketLogService.getRelevanceData(entity, crmClue, stageTrendsList, returnPlanList);
        return ActionResult.success((Object)visitFollowVo);
    }

    @GetMapping(value={"/project/{id}"})
    public ActionResult<List<RkContractProjectEntity>> projectInfo(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        List<RkContractProjectEntity> list = this.rkContractProjectService.getListByCustomerIdAndCompanyId(id, userInfo.getOrganizeId());
        return ActionResult.success(list);
    }

    @PostMapping(value={"/copyToUserIdLog"})
    public ActionResult copyToUserIdLog(@RequestBody @Valid RkMarketLogCopyTo rkMarketLogCopyTo) {
        String url;
        String pcUrl;
        RkMarketLogEntity info = this.rkMarketLogService.getInfo(rkMarketLogCopyTo.getId());
        if (ObjectUtil.isNull((Object)info)) {
            return ActionResult.fail((String)"\u6284\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String title = info.getTitle() + "\u7684\u5de5\u4f5c\u65e5\u5fd7\uff0c\u8bf7\u67e5\u770b\uff01";
        String content = "\u6807\u9898\uff1a" + info.getTitle() + "\n\u521b\u5efa\u65f6\u95f4\uff1a" + com.bringspring.visit.utils.DateUtil.dateFormat(new Date());
        String string = info.getMarketType().equals("sale") ? "/#/visit/marketLog" : (info.getMarketType().equals("mjWorkerLog") ? "/#/visit/professionalLog" : (pcUrl = info.getMarketType().equals("newAfterSale") ? "/#/visit/afterSalesLog" : "/#/visit/projectLog"));
        String string2 = info.getMarketType().equals("sale") ? "/#/pages/market/sales-log/index" : (url = info.getMarketType().equals("mjWorkerLog") ? "/#/pages/market/workLog/index" : "/#/pages/market/delivery-log");
        if (StrUtil.equals((CharSequence)info.getMarketType(), (CharSequence)"newAfterSale")) {
            url = CrmConstants.APP_DEMAND_DETAIL;
        }
        String type = TermTypeEnum.TERM_APP_PC.getCode();
        List<Object> oldUserIds = new ArrayList();
        if (StringUtils.isNotEmpty((String)info.getUserIdCopy())) {
            oldUserIds = Arrays.asList(info.getUserIdCopy().split(","));
        }
        List<String> userIds = Arrays.asList(rkMarketLogCopyTo.getUserIdCopyAll().split(","));
        List<Object> finalOldUserIds = oldUserIds;
        List<String> userIdAll = userIds.stream().filter(s -> !finalOldUserIds.contains(s)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(userIdAll)) {
            this.crmWorkitemService.newSendMessage("\u65e5\u62a5\u529f\u80fd", "dailyCredit", title, content, url, pcUrl, userIdAll, type, "");
            RkMarketLogCopytoCrForm build = RkMarketLogCopytoCrForm.builder().marketLogId(info.getId()).logType(info.getMarketType()).userIdCopys(userIdAll.toString()).build();
            this.rkMarketLogCopytoService.create(build);
            info.setUserIdCopy(rkMarketLogCopyTo.getUserIdCopyAll());
            this.rkMarketLogService.update(info.getId(), info);
            return ActionResult.success((String)"\u6284\u9001\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0d\u53ef\u91cd\u590d\u6284\u9001!");
    }

    @GetMapping(value={"/dateSum"})
    public ActionResult<Integer> getDateCount() throws ParseException {
        int dateCount = this.rkMarketLogService.getDateCount();
        return ActionResult.success((Object)dateCount);
    }

    @PutMapping(value={"/confirm/{id}"})
    @DSTransactional
    public ActionResult confirm(@PathVariable(value="id") String id) throws DataException {
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u65e5\u5fd7\u4e0d\u5b58\u5728");
        }
        entity.setState(MarketLogStateEnum.CONFIRM.getEnableMark());
        this.rkMarketLogService.updateById(entity);
        return ActionResult.success((String)"\u786e\u8ba4\u6210\u529f");
    }

    @PutMapping(value={"/reject/{id}"})
    @DSTransactional
    public ActionResult reject(@PathVariable(value="id") String id) throws DataException {
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u65e5\u5fd7\u4e0d\u5b58\u5728");
        }
        entity.setState(MarketLogStateEnum.REJECT.getEnableMark());
        this.rkMarketLogService.updateById(entity);
        return ActionResult.success((String)"\u9a73\u56de\u6210\u529f");
    }
}

