/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.MarketLogStateEnum;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.mapper.RkContractProjectMapper;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkMarketLogProjectDataEntity;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogPagination;
import com.bringspring.visit.model.rkmarketlogprojectdata.RkMarketLogProjectDataInfoVO;
import com.bringspring.visit.model.rkmarketlogprojectdata.RkMarketLogProjectDataPaginationExportModel;
import com.bringspring.visit.service.RkMarketLogProjectDataService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea4\u4ed8\u65e5\u5fd7\uff0c\u5408\u540c\u548c\u9879\u76ee\u57fa\u672c\u4fe1\u606f"}, value="contract")
@RequestMapping(value={"/api/visit/RkMarketLogProjectData"})
public class RkMarketLogProjectDataController {
    private static final Logger log = LoggerFactory.getLogger(RkMarketLogProjectDataController.class);
    @Autowired
    private RkMarketLogProjectDataService rkMarketLogProjectDataService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractProjectMapper rkContractProjectMapper;

    @PostMapping(value={"/getList"})
    public ActionResult byManHourList(@RequestBody RkMarketLogPagination rkMarketLogPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        ArrayList<String> stateList = new ArrayList<String>();
        stateList.add(MarketLogStateEnum.SUBMIT.getEnableMark());
        stateList.add(MarketLogStateEnum.CONFIRM.getEnableMark());
        rkMarketLogPagination.setStateList(stateList);
        List<RkMarketLogProjectDataEntity> list = this.rkMarketLogProjectDataService.getList(rkMarketLogPagination);
        List<RkMarketLogProjectDataInfoVO> listVO = JsonUtil.getJsonToList(list, RkMarketLogProjectDataInfoVO.class);
        listVO = this.getListVo(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkMarketLogPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<RkMarketLogProjectDataInfoVO> getListVo(List<RkMarketLogProjectDataInfoVO> listVO) {
        for (RkMarketLogProjectDataInfoVO vo : listVO) {
            UserEntity info = this.userService.getInfo(vo.getCreatorUserId());
            if (StringUtils.isNotEmpty((String)this.baseDataUtil.getDictName(vo.getType(), "projectState"))) {
                vo.setTypeName(this.baseDataUtil.getDictName(vo.getType(), "projectState"));
            } else {
                vo.setTypeName(this.baseDataUtil.getDictName(vo.getType(), "afterSalesProjectWarrantyState"));
            }
            if (ObjectUtil.isNotEmpty((Object)info) && StringUtil.isNotEmpty((String)info.getOrganizeId())) {
                vo.setDepartmentName(this.baseDataUtil.comSelectValue(info.getOrganizeId(), ""));
                OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)info.getOrganizeId()));
                if (ObjectUtil.isNotNull((Object)byId)) {
                    vo.setOrganizeName(this.baseDataUtil.comSelectValue(byId.getOrganizeId(), ""));
                }
            }
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            if (StringUtils.isNotEmpty((String)vo.getProjectCode())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(RkContractProjectEntity::getProjectCode, (Object)vo.getProjectCode());
                List rkContractProjectEntities = this.rkContractProjectMapper.selectList((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)rkContractProjectEntities)) {
                    RkContractProjectEntity projectEntity = (RkContractProjectEntity)rkContractProjectEntities.get(0);
                    if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                        vo.setProjectNameAll(projectEntity.getProjectName());
                        vo.setProjectCode(projectEntity.getProjectCode());
                        continue;
                    }
                    vo.setProjectNameAll("\u5185\u90e8\u9879\u76ee");
                    continue;
                }
                vo.setProjectNameAll("\u5185\u90e8\u9879\u76ee");
                continue;
            }
            vo.setProjectNameAll("\u5185\u90e8\u9879\u76ee");
        }
        return listVO;
    }

    @PostMapping
    @RepeatSubmit
    @DSTransactional
    @NotCheckLogin
    public ActionResult create() throws Exception {
        this.rkMarketLogProjectDataService.createAll();
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkMarketLogProjectDataPaginationExportModel rkMarketLogPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkMarketLogPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkMarketLogPagination rkMarketLogPagination = (RkMarketLogPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkMarketLogPaginationExportModel), RkMarketLogPagination.class));
        ArrayList<String> stateList = new ArrayList<String>();
        stateList.add(MarketLogStateEnum.SUBMIT.getEnableMark());
        stateList.add(MarketLogStateEnum.CONFIRM.getEnableMark());
        rkMarketLogPagination.setStateList(stateList);
        List<RkMarketLogProjectDataEntity> list = this.rkMarketLogProjectDataService.getTypeList(rkMarketLogPagination, rkMarketLogPaginationExportModel.getDataType());
        List<RkMarketLogProjectDataInfoVO> listVO = JsonUtil.getJsonToList(list, RkMarketLogProjectDataInfoVO.class);
        listVO = this.getListVo(listVO);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkMarketLogPaginationExportModel.getSelectKey()) ? rkMarketLogPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCode"));
                        continue block26;
                    }
                    case "projectNameAll": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectNameAll"));
                        continue block26;
                    }
                    case "typeName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7c7b\u578b", (Object)"typeName"));
                        continue block26;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"creatorUserName"));
                        continue block26;
                    }
                    case "organizeName": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"organizeName"));
                        continue block26;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"departmentName"));
                        continue block26;
                    }
                    case "manHour": {
                        entitys.add(new ExcelExportEntity("\u5de5\u65f6\uff08\u5c0f\u65f6\uff09", (Object)"manHour"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

