/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogPagination;
import com.bringspring.visit.model.rkMarketLog.RkProjectHourStatisticsInfoVO;
import com.bringspring.visit.service.RkMarketLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u7ba1\u7406\u4ea4\u4ed8\u65e5\u5fd7\u5de5\u65f6\u7edf\u8ba1"}, value="contract")
@RequestMapping(value={"/api/visit/ProjectHourStatistics"})
public class RkProjectHourStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectHourStatisticsController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkMarketLogService rkMarketLogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkMarketLogPagination rkMarketLogPagination) throws IOException {
        List<RkProjectHourStatisticsInfoVO> listVO = this.rkMarketLogService.selectProjectHourStatisticsList(rkMarketLogPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkMarketLogPagination), PaginationVO.class);
        page.setTotal(Integer.valueOf(listVO.size()));
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u552e\u540e\u5de5\u65f6\u660e\u7ec6\u5bfc\u51faExcel")
    @GetMapping(value={"/Export"})
    public ActionResult exportContractAssets(RkMarketLogPagination rkMarketLogPagination) throws IOException {
        DownloadVO vo = this.rkMarketLogService.exportProjectHourStatistics(rkMarketLogPagination);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u552e\u540e\u5de5\u65f6\u660e\u7ec6\u5bfc\u51faExcel")
    @GetMapping(value={"/exportDetail"})
    public ActionResult exportDetail(RkMarketLogPagination rkMarketLogPagination) throws IOException {
        DownloadVO vo = this.rkMarketLogService.exportProjectHourStatisticsDetail(rkMarketLogPagination);
        return ActionResult.success((Object)vo);
    }
}

