/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentInfoVO;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCompetitorEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductPriceEntity;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoInfoVO;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCompetitorService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductPriceService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.constant.LastFollowStatusEnum;
import com.bringspring.visit.entity.AfterSalesAttachmentEntity;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.entity.RkReportingProductPriceEntity;
import com.bringspring.visit.model.aftersalesattachment.AfterSalesAttachmentModel;
import com.bringspring.visit.model.attendanceCalendar.AttendanceCalendarModel;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingAuditForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingCancleForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingCrForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingInfoVO;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingListVO;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingPagination;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingPaginationExportModel;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingReconsiderForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingStopForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingTransformModel;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingUpForm;
import com.bringspring.visit.model.rkprojectreporting.RkReportingTransformPagination;
import com.bringspring.visit.model.rkprojectreporting.RkReportingTransformPaginationExportModel;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsPagination;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsTransferForm;
import com.bringspring.visit.service.AfterSalesAttachmentService;
import com.bringspring.visit.service.AttendanceCalendarService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkProjectReportingStageTrendsService;
import com.bringspring.visit.service.RkReportingProductPriceService;
import com.bringspring.visit.utils.ProjectReportStageTrendsTypeEnum;
import com.bringspring.visit.utils.ProjectReportingEnum;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u62a5\u5907"}, value="visit")
@RequestMapping(value={"/api/visit/RkProjectReporting"})
public class RkProjectReportingController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectReportingController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private AfterSalesAttachmentService afterSalesAttachmentService;
    @Autowired
    private RkProjectReportingStageTrendsService rkProjectReportingStageTrendsService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmProductPriceService crmProductPriceService;
    @Autowired
    private CrmCompetitorService crmCompetitorService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private RkReportingProductPriceService rkReportingProductPriceService;
    @Autowired
    private AttendanceCalendarService attendanceCalendarService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectReportingPagination rkProjectReportingPagination) throws IOException {
        if (rkProjectReportingPagination.getSearchType() != null && rkProjectReportingPagination.getSearchType() == 1) {
            UserInfo userInfo = this.userProvider.get();
            HashMap iCanWho = this.salesRoleUtils.getICanWho(userInfo);
            List userIdList = CollectionUtil.list((boolean)false);
            boolean isAll = (Boolean)iCanWho.get("isAll");
            if (!isAll) {
                List list = (List)iCanWho.get("idList");
                List authAddress = (List)iCanWho.get("authAddress");
                List collect = list.stream().filter(s -> !StrUtil.equals((CharSequence)s, (CharSequence)userInfo.getUserId())).collect(Collectors.toList());
                userIdList.addAll(collect);
                rkProjectReportingPagination.setAuthAddress(authAddress);
                rkProjectReportingPagination.setCanSeeUserIdList(userIdList);
            }
        }
        List<RkProjectReportingEntity> list = this.rkProjectReportingService.getList(rkProjectReportingPagination);
        List<RkProjectReportingListVO> listVO = this.appendListVo(list, false, rkProjectReportingPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportingPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<RkProjectReportingListVO> appendListVo(List<RkProjectReportingEntity> list, boolean isExport, RkProjectReportingPagination pagination) {
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportingListVO.class);
        Object organize = null;
        CrmCompetitorEntity competitor = null;
        for (RkProjectReportingListVO rkProjectReportingVO : listVO) {
            List<String> productCompanyList;
            List organizeEntityList;
            rkProjectReportingVO.setAddress(this.baseDataUtil.provinceData(rkProjectReportingVO.getAddress()));
            rkProjectReportingVO.setGardeName(this.baseDataUtil.getDictName(rkProjectReportingVO.getGarde(), "CustomerGrade"));
            if (StringUtils.isNotEmpty((String)rkProjectReportingVO.getCompanyId())) {
                rkProjectReportingVO.setCompanyCode(rkProjectReportingVO.getCompanyId());
                rkProjectReportingVO.setCompanyId(this.organizeService.getInfo(rkProjectReportingVO.getCompanyId()).getShortName());
            }
            UserEntity userEntity = (UserEntity)this.userService.getById((Serializable)((Object)rkProjectReportingVO.getCreatorUserId()));
            OrganizeEntity organizeInfo = this.serviceAllUtil.getOrganizeInfo(userEntity.getOrganizeId());
            if (StrUtil.equals((CharSequence)rkProjectReportingVO.getCompanyCode(), (CharSequence)CompanyIdEnum.HNZY.getId())) {
                rkProjectReportingVO.setDepartmentName(organizeInfo.getFullName());
                if (StrUtil.isNotEmpty((CharSequence)rkProjectReportingVO.getCityName())) {
                    rkProjectReportingVO.setDepartmentName(organizeInfo.getFullName() + "-" + rkProjectReportingVO.getCityName().replace("\u5e02", ""));
                }
            }
            rkProjectReportingVO.setCreatorUser(rkProjectReportingVO.getCreatorUserId());
            rkProjectReportingVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkProjectReportingVO.getCreatorUserId()));
            rkProjectReportingVO.setOldCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(rkProjectReportingVO.getOldCreatorUser()));
            rkProjectReportingVO.setEnabledMarkCode(rkProjectReportingVO.getEnabledMark());
            rkProjectReportingVO.setEnabledMark(this.baseDataUtil.getDictName(rkProjectReportingVO.getEnabledMark(), "projectReportingEnabledMark"));
            rkProjectReportingVO.setSaleStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getSaleStage(), "ReportingSaleStage"));
            rkProjectReportingVO.setInitSaleStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getInitSaleStage(), "ReportingSaleStage"));
            rkProjectReportingVO.setProjectStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getProjectStage(), "ReportingProjectStage"));
            rkProjectReportingVO.setSalesType(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getSalesType()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getSalesType(), (CharSequence)"directSales") ? "\u76f4\u9500" : "\u5206\u9500"));
            rkProjectReportingVO.setIsSecondarySales(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsSecondarySales()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsSecondarySales(), (CharSequence)"1") ? "\u662f" : "\u5426"));
            rkProjectReportingVO.setIsNeedInternalApplication(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication(), (CharSequence)"1") ? "\u9700\u8981" : "\u4e0d\u9700\u8981"));
            HashSet<String> productCompanySet = new HashSet<String>();
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getProductCompany()) && CollectionUtil.isNotEmpty((Collection)(organizeEntityList = this.organizeService.listByIds(productCompanyList = Arrays.asList(rkProjectReportingVO.getProductCompany().split(",")))))) {
                for (OrganizeEntity byId : organizeEntityList) {
                    OrganizeCrModel crModel = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                    productCompanySet.add(crModel.getShortName());
                }
            }
            if (CollectionUtil.isNotEmpty(productCompanySet)) {
                rkProjectReportingVO.setProductCompany(StrUtil.join((CharSequence)",", productCompanySet));
            }
            this.rkProjectReportingService.appendBrokerInfo(rkProjectReportingVO);
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getCompetitorId())) {
                competitor = (CrmCompetitorEntity)this.crmCompetitorService.getById((Serializable)((Object)rkProjectReportingVO.getCompetitorId()));
                rkProjectReportingVO.setCompetitorId(ObjectUtil.isNull((Object)competitor) ? "" : competitor.getCompetitorName());
            } else {
                rkProjectReportingVO.setCompetitorId("");
            }
            if ("2".equals(rkProjectReportingVO.getOpportunityType())) {
                rkProjectReportingVO.setOpportunityTypeName("\u76f4\u7b7e\u5546\u673a");
            } else if ("1".equals(rkProjectReportingVO.getOpportunityType())) {
                rkProjectReportingVO.setOpportunityTypeName("\u6e20\u9053\u5546\u673a");
            }
            if (isExport) {
                rkProjectReportingVO.setReportingType(StrUtil.equals((CharSequence)rkProjectReportingVO.getReportingType(), (CharSequence)"1") ? "\u957f\u671f\u62a5\u5907" : "\u51c6\u5ba2\u6237\u62a5\u5907");
                if (pagination.getSelectKey().contains("productType") && StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getProductType())) {
                    rkProjectReportingVO.setProductTypeName(this.crmProductCategoryService.getNameByIds(rkProjectReportingVO.getProductType()));
                }
                if (pagination.getSelectKey().contains("projectProgress")) {
                    RkProjectReportingStageTrendsPagination trendsPagination = new RkProjectReportingStageTrendsPagination();
                    trendsPagination.setReportingId(rkProjectReportingVO.getId());
                    List<RkProjectReportingStageTrendsEntity> listByReporting = this.rkProjectReportingStageTrendsService.getListByReporting(trendsPagination);
                    rkProjectReportingVO.setReportingList(listByReporting);
                }
                if (ObjectUtil.isNotNull((Object)rkProjectReportingVO.getExpectedBidOpenMonth())) {
                    String s = DateUtil.format((Date)rkProjectReportingVO.getExpectedBidOpenMonth(), (DateTimeFormatter)DatePattern.NORM_MONTH_FORMATTER);
                    rkProjectReportingVO.setExpectedBidOpenMonthStr(s);
                }
            } else {
                QueryWrapper priceQueryWrapper = new QueryWrapper();
                priceQueryWrapper.lambda().eq(RkReportingProductPriceEntity::getReportingId, (Object)rkProjectReportingVO.getId());
                if (this.rkReportingProductPriceService.count((Wrapper)priceQueryWrapper) > 0L) {
                    rkProjectReportingVO.setIsHavePriceRecord(1);
                } else {
                    rkProjectReportingVO.setIsHavePriceRecord(0);
                }
                if (ObjectUtil.equal((Object)rkProjectReportingVO.getWinOrLose(), (Object)-1)) {
                    Date nowDate;
                    Date lastFollowTime = rkProjectReportingVO.getLastFollowTime();
                    List<AttendanceCalendarModel> listByWdate = this.attendanceCalendarService.getListByWdate(lastFollowTime, DateUtil.getNowDate());
                    long count = listByWdate.stream().filter(x -> x.getWorktime() < 8).count();
                    if (null != lastFollowTime && !lastFollowTime.after(nowDate = DateUtil.getNowDate())) {
                        long between = DateUtil.between((Date)lastFollowTime, (Date)nowDate, (DateUnit)DateUnit.HOUR);
                        if (between > (7L + count) * 24L) {
                            rkProjectReportingVO.setLastFollowStatus(LastFollowStatusEnum.ERROR.getEnCode());
                        } else if (between <= 24L) {
                            rkProjectReportingVO.setLastFollowStatus(LastFollowStatusEnum.WARNING.getEnCode());
                        }
                    }
                }
            }
            if (!"departConnect".equals(pagination.getResourceType())) continue;
            rkProjectReportingVO.setIsHaveQuotation(0);
            rkProjectReportingVO.setIsHaveProfit(0);
            QueryWrapper quotationQueryWrapper = new QueryWrapper();
            quotationQueryWrapper.lambda().eq(SaleQuotationEntity::getOpportunityId, (Object)rkProjectReportingVO.getId());
            List quotationList = this.saleQuotationService.list((Wrapper)quotationQueryWrapper);
            if (!CollectionUtil.isNotEmpty((Collection)quotationList)) continue;
            rkProjectReportingVO.setIsHaveQuotation(1);
            List quotationIds = quotationList.stream().map(SaleQuotationEntity::getId).collect(Collectors.toList());
            QueryWrapper profitQueryWrapper = new QueryWrapper();
            profitQueryWrapper.lambda().in(SaleQuotationProfitEntity::getQuotationId, quotationIds);
            if (this.saleQuotationProfitService.count((Wrapper)profitQueryWrapper) <= 0L) continue;
            rkProjectReportingVO.setIsHaveProfit(1);
        }
        return listVO;
    }

    @PostMapping(value={"/getListSelf"})
    public ActionResult getListSelf(@RequestBody RkProjectReportingPagination rkProjectReportingPagination) throws IOException {
        rkProjectReportingPagination.setCreatorUserId(this.userProvider.get().getUserId());
        List<RkProjectReportingEntity> list = this.rkProjectReportingService.getListSelf(rkProjectReportingPagination);
        for (RkProjectReportingEntity rkProjectReportingEntity : list) {
            rkProjectReportingEntity.setAddress(this.baseDataUtil.provinceData(rkProjectReportingEntity.getAddress()));
            rkProjectReportingEntity.setGarde(this.baseDataUtil.getDictName(rkProjectReportingEntity.getGarde(), "CustomerGrade"));
            OrganizeEntity info = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)rkProjectReportingEntity.getCompanyId()));
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
            rkProjectReportingEntity.setCompanyId(jsonToBean.getShortName());
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportingListVO.class);
        for (RkProjectReportingListVO rkProjectReportingVO : listVO) {
            rkProjectReportingVO.setCreatorUser(rkProjectReportingVO.getCreatorUserId());
            rkProjectReportingVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkProjectReportingVO.getCreatorUserId()));
            rkProjectReportingVO.setEnabledMarkCode(rkProjectReportingVO.getEnabledMark());
            rkProjectReportingVO.setEnabledMark(this.baseDataUtil.getDictName(rkProjectReportingVO.getEnabledMark(), "projectReportingEnabledMark"));
            rkProjectReportingVO.setSaleStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getSaleStage(), "ReportingSaleStage"));
            rkProjectReportingVO.setProjectStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getProjectStage(), "ReportingProjectStage"));
            if (!StrUtil.isNotEmpty((CharSequence)rkProjectReportingVO.getCompetitorId())) continue;
            List<String> idList = Arrays.asList(rkProjectReportingVO.getCompetitorId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCompetitorEntity::getId, idList);
            List competitorList = this.crmCompetitorService.list((Wrapper)queryWrapper);
            if (!CollectionUtil.isNotEmpty((Collection)competitorList)) continue;
            String competitorName = competitorList.stream().map(CrmCompetitorEntity::getCompetitorName).collect(Collectors.joining(","));
            rkProjectReportingVO.setCompetitorName(competitorName);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportingPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"getListBySealer"})
    public ActionResult getListBySealer(@RequestBody @Valid RkReportingTransformPagination pagination) throws IOException {
        List reportingTransform = this.rkProjectReportingService.getReportingTransform(pagination);
        for (RkProjectReportingTransformModel vo : reportingTransform) {
            if (ObjectUtil.isNotEmpty((Object)vo.getCompanyId())) {
                OrganizeEntity info = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()));
                vo.setCompanyName(info.getShortName());
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getConversionRate())) {
                vo.setConversionRate(vo.getConversionRate().multiply(new BigDecimal(100)).setScale(2, 4));
            }
            if (!ObjectUtil.isNotEmpty((Object)vo.getWinRate())) continue;
            vo.setWinRate(vo.getWinRate().multiply(new BigDecimal(100)).setScale(2, 4));
        }
        PageListVO vo = new PageListVO();
        vo.setList(reportingTransform);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"ReportingTransform/export"})
    public ActionResult exportReportingTransform(@RequestBody @Valid RkReportingTransformPaginationExportModel exportModel) {
        RkReportingTransformPagination pagination = (RkReportingTransformPagination)((Object)JsonUtil.getJsonToBean((Object)exportModel, RkReportingTransformPagination.class));
        List reportingTransform = this.rkProjectReportingService.getReportingTransform(pagination);
        for (RkProjectReportingTransformModel vo : reportingTransform) {
            if (ObjectUtil.isNotEmpty((Object)vo.getCompanyId())) {
                OrganizeEntity info = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()));
                vo.setCompanyName(info.getShortName());
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getConversionRate())) {
                vo.setConversionRate(vo.getConversionRate().multiply(new BigDecimal(100)).setScale(2, 4));
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getWinRate())) {
                vo.setWinRate(vo.getWinRate().multiply(new BigDecimal(100)).setScale(2, 4));
            }
            if (!ObjectUtil.isEmpty((Object)vo.getCurrentQuarterEstimatedSigningAmount())) continue;
            vo.setCurrentQuarterEstimatedSigningAmount(BigDecimal.ZERO.setScale(6));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)reportingTransform, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StrUtil.isEmpty((CharSequence)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatTransformModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatTransformModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block34;
                    }
                    case "reallyName": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"reallyName"));
                        continue block34;
                    }
                    case "orgName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"orgName"));
                        continue block34;
                    }
                    case "estimatedSigningAmount": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"estimatedSigningAmount"));
                        continue block34;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u7b7e\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"contractAmount"));
                        continue block34;
                    }
                    case "conversionRate": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u8f6c\u5316\u7387(%)", (Object)"conversionRate"));
                        continue block34;
                    }
                    case "stockReportingAmount": {
                        entitys.add(new ExcelExportEntity("\u5b58\u91cf\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"stockReportingAmount"));
                        continue block34;
                    }
                    case "winRate": {
                        entitys.add(new ExcelExportEntity("\u8d62\u5355\u7387\uff08%\uff09", (Object)"winRate"));
                        continue block34;
                    }
                    case "expectedOrderAmount": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u6210\u5355\u91d1\u989d\uff08\u5143\uff09", (Object)"expectedOrderAmount"));
                        continue block34;
                    }
                    case "currentYearEstimatedSigningAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u9884\u8ba1\u6210\u5355\u91d1\u989d\uff08\u5143\uff09", (Object)"currentYearEstimatedSigningAmount"));
                        continue block34;
                    }
                    case "currentQuarterEstimatedSigningAmount": {
                        entitys.add(new ExcelExportEntity("\u5b63\u5ea6\u9884\u8ba1\u6210\u5355\u91d1\u989d\uff08\u5143\uff09", (Object)"currentQuarterEstimatedSigningAmount"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u5546\u673a\u8f6c\u5316\u7edf\u8ba1");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u5546\u673a\u8f6c\u5316\u7edf\u8ba1" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @PostMapping(value={"/countReporting"})
    public ActionResult countReporting(@RequestBody RkProjectReportingPagination rkProjectReportingPagination) {
        long reportingNum = this.rkProjectReportingService.countReporting(rkProjectReportingPagination);
        BigDecimal reportingAmount = this.rkProjectReportingService.countReportingAmount(rkProjectReportingPagination);
        Map<String, Object> mapState = this.rkProjectReportingService.countBySaleStageAmount(rkProjectReportingPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("reportingNum", reportingNum);
        map.put("reportingAmount", reportingAmount);
        map.putAll(mapState);
        return ActionResult.success((Object)map);
    }

    @ApiOperation(value="\u83b7\u53d6\u7c73\u5065\u5546\u673a\u62a5\u5907\u5355\u636e\u6d41\u6c34\u53f7,\u53ea\u5c55\u793a\uff0c\u4e0d\u66f4\u65b0\u6d41\u6c34\u53f7")
    @GetMapping(value={"/BillNumber/{enCode}"})
    public ActionResult getBillNumber(@PathVariable(value="enCode") String enCode) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String data = this.rkProjectReportingService.getBillNumber(enCode, false);
        return ActionResult.success((String)"\u83b7\u53d6\u6210\u529f", (Object)data);
    }

    @PostMapping(value={"countByEnabledMark"})
    public ActionResult countByEnabledMark(@RequestBody RkProjectReportingPagination rkProjectReportingPagination) {
        if (rkProjectReportingPagination.getSearchType() != null && rkProjectReportingPagination.getSearchType() == 1) {
            UserInfo userInfo = this.userProvider.get();
            HashMap iCanWho = this.salesRoleUtils.getICanWho(userInfo);
            List userIdList = CollectionUtil.list((boolean)false);
            boolean isAll = (Boolean)iCanWho.get("isAll");
            if (!isAll) {
                List list = (List)iCanWho.get("idList");
                List authAddress = (List)iCanWho.get("authAddress");
                List collect = list.stream().filter(s -> !StrUtil.equals((CharSequence)s, (CharSequence)userInfo.getUserId())).collect(Collectors.toList());
                userIdList.addAll(collect);
                rkProjectReportingPagination.setAuthAddress(authAddress);
                rkProjectReportingPagination.setCanSeeUserIdList(userIdList);
            }
        }
        List<Map<String, Object>> maps = this.rkProjectReportingService.countByEnabledMark(rkProjectReportingPagination);
        return ActionResult.success(maps);
    }

    @PostMapping(value={"countBySaleStage"})
    public ActionResult countBySaleStage(@RequestBody RkProjectReportingPagination rkProjectReportingPagination) {
        if (rkProjectReportingPagination.getSearchType() != null && rkProjectReportingPagination.getSearchType() == 1) {
            UserInfo userInfo = this.userProvider.get();
            HashMap iCanWho = this.salesRoleUtils.getICanWho(userInfo);
            List userIdList = CollectionUtil.list((boolean)false);
            boolean isAll = (Boolean)iCanWho.get("isAll");
            if (!isAll) {
                List list = (List)iCanWho.get("idList");
                List authAddress = (List)iCanWho.get("authAddress");
                List collect = list.stream().filter(s -> !StrUtil.equals((CharSequence)s, (CharSequence)userInfo.getUserId())).collect(Collectors.toList());
                userIdList.addAll(collect);
                rkProjectReportingPagination.setAuthAddress(authAddress);
                rkProjectReportingPagination.setCanSeeUserIdList(userIdList);
            }
        }
        List<Map<String, Object>> maps = this.rkProjectReportingService.countBySaleStage(rkProjectReportingPagination);
        return ActionResult.success(maps);
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException {
        RkProjectReportingCrForm rkProjectReportingCrForm = (RkProjectReportingCrForm)JsonUtil.getJsonToBean(crData, RkProjectReportingCrForm.class);
        String visualId = "503829668818848773";
        String mainId = RandomUtil.uuId();
        rkProjectReportingCrForm.setMainId(mainId);
        UserInfo userInfo = this.userProvider.get();
        this.rkProjectReportingService.saveProjectReporting(rkProjectReportingCrForm);
        if (FlowTaskStatusEnum.Handle.getCode().equals(rkProjectReportingCrForm.getStatus())) {
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody RkProjectReportingPaginationExportModel rkProjectReportingPaginationExportModel) throws IOException {
        if (StrUtil.isEmpty((CharSequence)rkProjectReportingPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProjectReportingPagination rkProjectReportingPagination = (RkProjectReportingPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportingPaginationExportModel), RkProjectReportingPagination.class));
        List<RkProjectReportingEntity> list = this.rkProjectReportingService.getTypeList(rkProjectReportingPagination, rkProjectReportingPaginationExportModel.getDataType());
        List<RkProjectReportingListVO> listVO = this.appendListVo(list, true, rkProjectReportingPaginationExportModel);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        HashSet set = CollectionUtil.set((boolean)false, (Object[])new String[0]);
        HashMap keyMap = MapUtil.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                List ll;
                Object o = m.get("reportingList");
                if (ObjectUtil.isNotNull(m.get("expectedSigningDate"))) {
                    DateTime expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("expectedSigningDate").toString()));
                    String s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("expectedSigningDate", s);
                }
                if (ObjectUtil.isNotNull(o) && CollectionUtil.isNotEmpty((Collection)(ll = JsonUtil.getJsonToList(o, RkProjectReportingStageTrendsEntity.class)))) {
                    ll.stream().forEach(trend -> {
                        String key = "follow" + cn.hutool.core.date.DateUtil.formatDate((Date)trend.getFollowTime());
                        m.put(key, StrUtil.isNotBlank((CharSequence)trend.getFollowMethod()) ? this.baseDataUtil.getDictName(trend.getFollowMethod(), "followMethod") + "-" + trend.getDescription() : trend.getDescription());
                        set.add(key);
                        keyMap.put(key, "\u9879\u76ee\u8fdb\u5ea6(" + cn.hutool.core.date.DateUtil.formatDate((Date)trend.getFollowTime()) + ")");
                    });
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                for (Object key : keyMap.keySet()) {
                    Set strings = m.keySet();
                    if (strings.contains(key)) continue;
                    m.put(key.toString(), "");
                }
            });
        }
        List collect = set.stream().collect(Collectors.toList());
        Collections.sort(collect, Collections.reverseOrder());
        rkProjectReportingPaginationExportModel.setSelectKey(rkProjectReportingPaginationExportModel.getSelectKey() + "," + CollectionUtil.join(collect, (CharSequence)","));
        String[] keys = StrUtil.isNotBlank((CharSequence)rkProjectReportingPaginationExportModel.getSelectKey()) ? rkProjectReportingPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, keyMap);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, HashMap keyMap) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            block210: for (String key : keys) {
                if (ObjectUtil.isNotNull((Object)keyMap) && ObjectUtil.isNotNull(keyMap.get(key)) && StrUtil.isNotBlank((CharSequence)keyMap.get(key).toString())) {
                    entitys.add(new ExcelExportEntity(keyMap.get(key).toString(), (Object)key));
                    continue;
                }
                switch (key) {
                    case "id": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u7f16\u53f7", (Object)"id"));
                        continue block210;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block210;
                    }
                    case "productCompany": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u6240\u5c5e\u516c\u53f8", (Object)"productCompany"));
                        continue block210;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u90e8\u95e8", (Object)"departmentName"));
                        continue block210;
                    }
                    case "reportingType": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u7c7b\u578b", (Object)"reportingType"));
                        continue block210;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237", (Object)"customerName"));
                        continue block210;
                    }
                    case "saleStageName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u9636\u6bb5", (Object)"saleStageName"));
                        continue block210;
                    }
                    case "projectStageName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9636\u6bb5", (Object)"projectStageName"));
                        continue block210;
                    }
                    case "reportingProject": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u540d\u79f0", (Object)"reportingProject"));
                        continue block210;
                    }
                    case "garde": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7b49\u7ea7", (Object)"gardeName"));
                        continue block210;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u5740", (Object)"address"));
                        continue block210;
                    }
                    case "addressDetail": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u5730\u5740", (Object)"addressDetail"));
                        continue block210;
                    }
                    case "contactName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8054\u7cfb\u4eba", (Object)"contactName"));
                        continue block210;
                    }
                    case "contactPost": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u804c\u52a1", (Object)"contactPost"));
                        continue block210;
                    }
                    case "contactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"contactPhone"));
                        continue block210;
                    }
                    case "projectScale": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u60c5\u51b5\u4ecb\u7ecd", (Object)"projectScale"));
                        continue block210;
                    }
                    case "hisManufacturer": {
                        entitys.add(new ExcelExportEntity("HIS\u5382\u5bb6", (Object)"hisManufacturer"));
                        continue block210;
                    }
                    case "projectScore": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5f97\u5206", (Object)"projectScore"));
                        continue block210;
                    }
                    case "integratorName": {
                        entitys.add(new ExcelExportEntity("\u96c6\u6210\u5546\u540d\u79f0", (Object)"integratorName"));
                        continue block210;
                    }
                    case "integratorProjectManager": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"integratorProjectManager"));
                        continue block210;
                    }
                    case "integratorContactPhone": {
                        entitys.add(new ExcelExportEntity("\u96c6\u6210\u5546\u8054\u7cfb\u65b9\u5f0f", (Object)"integratorContactPhone"));
                        continue block210;
                    }
                    case "customerContactName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u59d3\u540d", (Object)"customerContactName"));
                        continue block210;
                    }
                    case "customerEepartment": {
                        entitys.add(new ExcelExportEntity("\u79d1\u5ba4", (Object)"customerEepartment"));
                        continue block210;
                    }
                    case "customerPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"customerPhone"));
                        continue block210;
                    }
                    case "productClearness": {
                        entitys.add(new ExcelExportEntity("\u5df2\u660e\u786e\u9700\u6c42", (Object)"productClearness"));
                        continue block210;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"productTypeName"));
                        continue block210;
                    }
                    case "isSolution": {
                        entitys.add(new ExcelExportEntity("\u5df2\u63d0\u4f9b\u65b9\u6848", (Object)"isSolution"));
                        continue block210;
                    }
                    case "solutionType": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u7c7b\u578b", (Object)"solutionType"));
                        continue block210;
                    }
                    case "isQuotation": {
                        entitys.add(new ExcelExportEntity("\u5df2\u63d0\u4f9b\u6b63\u5f0f\u62a5\u4ef7\u5355", (Object)"isQuotation"));
                        continue block210;
                    }
                    case "productScore": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u9700\u6c42\u5f97\u5206", (Object)"productScore"));
                        continue block210;
                    }
                    case "competitiveName": {
                        entitys.add(new ExcelExportEntity("\u7ade\u54c1", (Object)"competitiveName"));
                        continue block210;
                    }
                    case "internalLines": {
                        entitys.add(new ExcelExportEntity("\u5185\u7ebf\u8bbe\u7acb", (Object)"internalLines"));
                        continue block210;
                    }
                    case "competitiveScore": {
                        entitys.add(new ExcelExportEntity("\u7ade\u53bf/\u5185\u7ebf\u5f97\u5206", (Object)"competitiveScore"));
                        continue block210;
                    }
                    case "isDemonstration": {
                        entitys.add(new ExcelExportEntity("\u8fdb\u884c\u4ea7\u54c1\u6f14\u793a", (Object)"isDemonstration"));
                        continue block210;
                    }
                    case "demonstrationDesc": {
                        entitys.add(new ExcelExportEntity("\u6f14\u793a\u8bf4\u660e", (Object)"demonstrationDesc"));
                        continue block210;
                    }
                    case "isVisitingExamples": {
                        entitys.add(new ExcelExportEntity("\u5df2\u53c2\u89c2\u793a\u4f8b", (Object)"isVisitingExamples"));
                        continue block210;
                    }
                    case "visitingDesc": {
                        entitys.add(new ExcelExportEntity("\u53c2\u89c2\u8bf4\u660e", (Object)"visitingDesc"));
                        continue block210;
                    }
                    case "isDemonstrate": {
                        entitys.add(new ExcelExportEntity("\u9662\u5185\u8bba\u8bc1\u4f1a", (Object)"isDemonstrate"));
                        continue block210;
                    }
                    case "demonstrateDesc": {
                        entitys.add(new ExcelExportEntity("\u8bba\u8bc1\u8bf4\u660e", (Object)"demonstrateDesc"));
                        continue block210;
                    }
                    case "demonstrateScore": {
                        entitys.add(new ExcelExportEntity("\u8bba\u8bc1\u5f97\u5206", (Object)"demonstrateScore"));
                        continue block210;
                    }
                    case "isBiddingTime": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u62db\u6807\u65f6\u95f4", (Object)"isBiddingTime"));
                        continue block210;
                    }
                    case "biddingDesc": {
                        entitys.add(new ExcelExportEntity("\u62db\u6295\u6807\u8bf4\u660e", (Object)"biddingDesc"));
                        continue block210;
                    }
                    case "isProjectApproval": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u7acb\u9879\u901a\u8fc7", (Object)"isProjectApproval"));
                        continue block210;
                    }
                    case "projectApprovalDesc": {
                        entitys.add(new ExcelExportEntity("\u7acb\u9879\u8bf4\u660e", (Object)"projectApprovalDesc"));
                        continue block210;
                    }
                    case "isClearBudget": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u9884\u7b97", (Object)"isClearBudget"));
                        continue block210;
                    }
                    case "budgetDesc": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u9884\u7b97\u8bf4\u660e", (Object)"budgetDesc"));
                        continue block210;
                    }
                    case "projectApprovalScore": {
                        entitys.add(new ExcelExportEntity("\u7acb\u9879\u5f97\u5206", (Object)"projectApprovalScore"));
                        continue block210;
                    }
                    case "isBrandRecommendation": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c\u63a8\u8350", (Object)"isBrandRecommendation"));
                        continue block210;
                    }
                    case "brandRecommendationDesc": {
                        entitys.add(new ExcelExportEntity("\u63a8\u8350\u8bf4\u660e", (Object)"brandRecommendationDesc"));
                        continue block210;
                    }
                    case "isTenderRequirements": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u8981\u6c42\u64b0\u5199", (Object)"isTenderRequirements"));
                        continue block210;
                    }
                    case "tenderRequirementsDesc": {
                        entitys.add(new ExcelExportEntity("\u6280\u672f\u8981\u6c42\u64b0\u5199\u8bf4\u660e", (Object)"tenderRequirementsDesc"));
                        continue block210;
                    }
                    case "isScoringMethod": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u5206\u529e\u6cd5\u64b0\u5199 ", (Object)"isScoringMethod"));
                        continue block210;
                    }
                    case "scoringMethodDesc": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u5206\u529e\u6cd5\u64b0\u5199\u8bf4\u660e", (Object)"scoringMethodDesc"));
                        continue block210;
                    }
                    case "biddingScore": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u8bbe\u8ba1\u5f97\u5206", (Object)"biddingScore"));
                        continue block210;
                    }
                    case "cooperativeCompaniesName": {
                        entitys.add(new ExcelExportEntity("\u5408\u4f5c\u516c\u53f8", (Object)"cooperativeCompaniesName"));
                        continue block210;
                    }
                    case "companyProjectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"companyProjectManager"));
                        continue block210;
                    }
                    case "companyContactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"companyContactPhone"));
                        continue block210;
                    }
                    case "cooperativeCompaniesScore": {
                        entitys.add(new ExcelExportEntity("\u5408\u4f5c\u516c\u53f8\u5f97\u5206", (Object)"cooperativeCompaniesScore"));
                        continue block210;
                    }
                    case "competentDepartmentManager": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u7ba1\u90e8\u95e8\u8d1f\u8d23\u4eba", (Object)"competentDepartmentManager"));
                        continue block210;
                    }
                    case "competentDepartmentPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"competentDepartmentPost"));
                        continue block210;
                    }
                    case "competentDepartmentPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"competentDepartmentPhone"));
                        continue block210;
                    }
                    case "competentDepartmentScore": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u7ba1\u90e8\u95e8\u5f97\u5206", (Object)"competentDepartmentScore"));
                        continue block210;
                    }
                    case "useDepartmentManager": {
                        entitys.add(new ExcelExportEntity("\u4f7f\u7528\u90e8\u95e8\u8d1f\u8d23\u4eba", (Object)"useDepartmentManager"));
                        continue block210;
                    }
                    case "useDepartmentPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"useDepartmentPost"));
                        continue block210;
                    }
                    case "useDepartmentPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"useDepartmentPhone"));
                        continue block210;
                    }
                    case "useDepartmentScore": {
                        entitys.add(new ExcelExportEntity("\u4f7f\u7528\u90e8\u95e8\u5f97\u5206", (Object)"useDepartmentScore"));
                        continue block210;
                    }
                    case "instituteLeader": {
                        entitys.add(new ExcelExportEntity("\u9662\u9886\u5bfc", (Object)"instituteLeader"));
                        continue block210;
                    }
                    case "instituteLeaderPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"instituteLeaderPost"));
                        continue block210;
                    }
                    case "instituteLeaderPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"instituteLeaderPhone"));
                        continue block210;
                    }
                    case "instituteLeaderScore": {
                        entitys.add(new ExcelExportEntity("\u9662\u9886\u5bfc\u5f97\u5206", (Object)"instituteLeaderScore"));
                        continue block210;
                    }
                    case "isProductPromotion": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u5ba2\u6237\u4ea7\u54c1\u5ba3\u8bb2", (Object)"isProductPromotion"));
                        continue block210;
                    }
                    case "productPromotionDesc": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5ba3\u8bb2\u8bf4\u660e", (Object)"productPromotionDesc"));
                        continue block210;
                    }
                    case "productPromotionScore": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5ba3\u8bb2\u5f97\u5206", (Object)"productPromotionScore"));
                        continue block210;
                    }
                    case "isTargetedSolutions": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u63d0\u4f9b\u9488\u5bf9\u6027\u65b9\u6848 ", (Object)"isTargetedSolutions"));
                        continue block210;
                    }
                    case "targetedSolutionsDesc": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u8bf4\u660e", (Object)"targetedSolutionsDesc"));
                        continue block210;
                    }
                    case "targetedSolutionsScore": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u5f97\u5206", (Object)"targetedSolutionsScore"));
                        continue block210;
                    }
                    case "isLongQuotation": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62a5\u4ef7", (Object)"isLongQuotation"));
                        continue block210;
                    }
                    case "quotationDesc": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u8bf4\u660e", (Object)"quotationDesc"));
                        continue block210;
                    }
                    case "quotationScore": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u5f97\u5206", (Object)"quotationScore"));
                        continue block210;
                    }
                    case "totalScore": {
                        entitys.add(new ExcelExportEntity("\u603b\u5206", (Object)"totalScore"));
                        continue block210;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block210;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u4eba", (Object)"creatorUserId"));
                        continue block210;
                    }
                    case "lastFollowTime": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u8ddf\u8fdb\u65e5\u671f", (Object)"lastFollowTime"));
                        continue block210;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u65f6\u95f4", (Object)"creatorTime"));
                        continue block210;
                    }
                    case "expectedSigningDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u7b7e\u5355\u65e5\u671f", (Object)"expectedSigningDate"));
                        continue block210;
                    }
                    case "estimatedSigningAmount": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u9884\u8ba1\u9500\u552e\u91d1\u989d(\u5143)", (Object)"estimatedSigningAmount");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block210;
                    }
                    case "estimatedGrossProfit": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u672a\u7a0e\u9884\u4f30\u6bdb\u5229\u6da6(\u5143)", (Object)"estimatedGrossProfit");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block210;
                    }
                    case "expectedBidOpenMonthStr": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5f00\u6807\u6708\u4efd", (Object)"expectedBidOpenMonthStr"));
                        continue block210;
                    }
                    case "salesType": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u65b9\u5f0f", (Object)"salesType"));
                        continue block210;
                    }
                    case "opportunityTypeName": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u7c7b\u578b", (Object)"opportunityTypeName"));
                        continue block210;
                    }
                    case "brokerId": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546", (Object)"brokerName"));
                        continue block210;
                    }
                    case "brokerContactName": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u4eba", (Object)"brokerContactName"));
                        continue block210;
                    }
                    case "brokerPhone": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u65b9\u5f0f", (Object)"brokerPhone"));
                        continue block210;
                    }
                    case "competitorId": {
                        entitys.add(new ExcelExportEntity("\u7ade\u4e89\u5bf9\u624b", (Object)"competitorId"));
                        continue block210;
                    }
                    case "winRate": {
                        entitys.add(new ExcelExportEntity("\u8d62\u5355\u7387(%)", (Object)"winRate"));
                        continue block210;
                    }
                    case "hospitalBudget": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u533b\u9662\u9884\u7b97(\u5143)", (Object)"hospitalBudget");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block210;
                    }
                    case "isSecondarySales": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e8c\u6b21\u9500\u552e", (Object)"isSecondarySales"));
                        continue block210;
                    }
                    case "isNeedInternalApplication": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9700\u8981\u6295\u6807\u7533\u8bf7", (Object)"isNeedInternalApplication"));
                        continue block210;
                    }
                    case "bidDescription": {
                        entitys.add(new ExcelExportEntity("\u65e0\u9700\u6295\u6807\u60c5\u51b5\u8bf4\u660e", (Object)"bidDescription"));
                        continue block210;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u62a5\u5907\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectReportingInfoVO> info(@PathVariable(value="id") String id) {
        RkAgentEntity agentEntity;
        QueryWrapper queryWrapper;
        List<String> idList;
        List<String> list;
        List categoryEntityList;
        RkProjectReportingEntity entity = this.rkProjectReportingService.getInfo(id);
        RkProjectReportingInfoVO vo = (RkProjectReportingInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingInfoVO.class);
        vo.setGardeName(this.baseDataUtil.getDictName(vo.getGarde(), "CustomerGrade"));
        vo.setCreatorUser(vo.getCreatorUserId());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<AfterSalesAttachmentEntity> afterSalesAttachmentList = this.afterSalesAttachmentService.listByBussinessObjId(id);
        List afterSalesAttachmentModelList = JsonUtil.getJsonToList(afterSalesAttachmentList, AfterSalesAttachmentModel.class);
        vo.setSaleStageName(this.baseDataUtil.getDictName(vo.getSaleStage(), "ReportingSaleStage"));
        vo.setProjectStageName(this.baseDataUtil.getDictName(vo.getProjectStage(), "ReportingProjectStage"));
        vo.setSolutionTypeName(this.baseDataUtil.getDictName(vo.getSolutionType(), "504261540023859397"));
        vo.setProductTypeName(vo.getProductType());
        if (StrUtil.isNotBlank((CharSequence)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(list = Arrays.asList(vo.getProductType().split(",")))))) {
            String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductTypeName(join);
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAssociationProduct())) {
            if (vo.getAssociationProduct().contains(",")) {
                StringBuffer stringBuffer = new StringBuffer();
                List<String> asList = Arrays.asList(vo.getAssociationProduct().split(","));
                for (String s : asList) {
                    CrmProductEntity productEntity;
                    CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(s);
                    if (!ObjectUtil.isNotEmpty((Object)priceEntity) || !ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) continue;
                    stringBuffer.append(productEntity.getProductName() + ",");
                }
                String productStr = stringBuffer.length() > 0 ? stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString() : "";
                vo.setAssociationProductName(productStr);
            } else {
                CrmProductEntity productEntity;
                CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(vo.getAssociationProduct());
                if (ObjectUtil.isNotEmpty((Object)priceEntity) && ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) {
                    vo.setAssociationProductName(productEntity.getProductName());
                }
            }
        }
        vo.setAttachmentList(afterSalesAttachmentModelList);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompetitorId())) {
            idList = Arrays.asList(vo.getCompetitorId().split(","));
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCompetitorEntity::getId, idList);
            List competitorList = this.crmCompetitorService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)competitorList)) {
                String competitorName = competitorList.stream().map(CrmCompetitorEntity::getCompetitorName).collect(Collectors.joining(","));
                vo.setCompetitorName(competitorName);
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getBrokerId()) && null != (agentEntity = this.rkAgentService.getInfo(vo.getBrokerId()))) {
            vo.setBrokerName(agentEntity.getName());
        }
        vo.setHasOtherCategory(false);
        if (StringUtils.isNotEmpty((String)vo.getOtherProduct())) {
            vo.setHasOtherCategory(true);
        } else if (StringUtils.isNotEmpty((String)vo.getProductType())) {
            idList = Arrays.asList(vo.getProductType().split(","));
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmProductCategoryEntity::getId, idList);
            queryWrapper.lambda().eq(CrmProductCategoryEntity::getName, (Object)"\u5176\u4ed6");
            if (null != this.crmProductCategoryService.getOne((Wrapper)queryWrapper)) {
                vo.setHasOtherCategory(true);
            }
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectReportingInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkAgentEntity agentEntity;
        UserEntity info;
        List categoryEntityList;
        List<String> list;
        List ll;
        RkProjectReportingEntity entity = this.rkProjectReportingService.getInfo(id);
        RkProjectReportingInfoVO vo = (RkProjectReportingInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingInfoVO.class);
        vo.setCreatorUser(vo.getCreatorUserId());
        vo.setGarde(this.baseDataUtil.getDictName(vo.getGarde(), "CustomerGrade"));
        if (StrUtil.isNotEmpty((CharSequence)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(ll = this.crmProductCategoryService.listByIds(list = CollectionUtil.list((boolean)false, Arrays.asList(vo.getProductType().split(","))))))) {
            String collect = ll.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductType(collect);
        }
        vo.setSaleStageName(this.baseDataUtil.getDictName(vo.getSaleStage(), "ReportingSaleStage"));
        vo.setProjectStageName(this.baseDataUtil.getDictName(vo.getProjectStage(), "ReportingProjectStage"));
        vo.setAddress(this.baseDataUtil.provinceData(vo.getAddress()));
        vo.setEnabledMarkCode(vo.getEnabledMark());
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "projectReportingEnabledMark"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setSolutionTypeName(this.baseDataUtil.getDictName(vo.getSolutionType(), "solutionType"));
        vo.setProductTypeName(vo.getProductType());
        vo.setCollaboratorUser(this.baseDataUtil.userSelectValueNoAccount(vo.getCollaboratorUser()));
        vo.setBidOpenDateStatusName(this.baseDataUtil.getDictName(vo.getBidOpenDateStatus(), "bidOpenDateStatus"));
        vo.setSalesTypeName(this.baseDataUtil.getDictName(vo.getSalesType(), "salesType"));
        if (StrUtil.isNotBlank((CharSequence)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(list = Arrays.asList(vo.getProductType().split(",")))))) {
            String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductTypeName(join);
        }
        List<AfterSalesAttachmentEntity> afterSalesAttachmentList = this.afterSalesAttachmentService.listByBussinessObjId(id);
        List afterSalesAttachmentModelList = JsonUtil.getJsonToList(afterSalesAttachmentList, AfterSalesAttachmentModel.class);
        vo.setAttachmentList(afterSalesAttachmentModelList);
        if (StrUtil.isNotEmpty((CharSequence)vo.getClueId())) {
            CrmClueInfoEntity byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)vo.getClueId()));
            vo.setCrmClueInfoInfoVO((CrmClueInfoInfoVO)JsonUtil.getJsonToBean((Object)byId, CrmClueInfoInfoVO.class));
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAssociationProduct())) {
            if (vo.getAssociationProduct().contains(",")) {
                StringBuffer stringBuffer = new StringBuffer();
                List<String> asList = Arrays.asList(vo.getAssociationProduct().split(","));
                for (String s : asList) {
                    CrmProductEntity productEntity;
                    CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(s);
                    if (!ObjectUtil.isNotEmpty((Object)priceEntity) || !ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) continue;
                    stringBuffer.append(productEntity.getProductName() + ",");
                }
                if (stringBuffer.length() > 0) {
                    String productStr = stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString();
                    vo.setAssociationProductName(productStr);
                }
            } else {
                CrmProductEntity productEntity;
                CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(vo.getAssociationProduct());
                if (ObjectUtil.isNotEmpty((Object)priceEntity) && ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) {
                    vo.setAssociationProductName(productEntity.getProductName());
                }
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getChannelId())) {
            RkAgentEntity rkAgentEntity = this.rkAgentService.getInfo(vo.getChannelId());
            vo.setChannelId(ObjectUtil.isNotEmpty((Object)rkAgentEntity) ? rkAgentEntity.getName() : "");
        }
        vo.setManagerId(ObjectUtil.isNotEmpty((Object)(info = this.userService.getInfo(entity.getCreatorUserId()))) ? info.getManagerId() : "");
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompetitorId())) {
            List<String> idList = Arrays.asList(vo.getCompetitorId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCompetitorEntity::getId, idList);
            List competitorList = this.crmCompetitorService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)competitorList)) {
                String competitorName = competitorList.stream().map(CrmCompetitorEntity::getCompetitorName).collect(Collectors.joining(","));
                vo.setCompetitorName(competitorName);
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getBrokerId()) && null != (agentEntity = this.rkAgentService.getInfo(vo.getBrokerId()))) {
            vo.setBrokerName(agentEntity.getName());
        }
        vo.setReportingSaleTypeName(this.baseDataUtil.getDictName(vo.getReportingSaleType(), "reportingSalesType"));
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        RkProjectReportingUpForm rkProjectReportingUpForm = (RkProjectReportingUpForm)JsonUtil.getJsonToBean(upData, RkProjectReportingUpForm.class);
        String visualId = "503829668818848773";
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingEntity entity = this.rkProjectReportingService.getInfo(id);
        if (entity != null) {
            rkProjectReportingUpForm.setId(id);
            if (FlowTaskStatusEnum.Handle.getCode().equals(rkProjectReportingUpForm.getStatus())) {
                rkProjectReportingUpForm.setEnabledMark(ProjectReportingEnum.RECONSIDER_NODE.getType());
            }
            this.rkProjectReportingService.updateProjectReporting(rkProjectReportingUpForm);
            RkProjectReportingEntity subentity = this.rkProjectReportingService.getInfo(id);
            subentity.setEnabledMark(entity.getEnabledMark());
            if (FlowTaskStatusEnum.Handle.getCode().equals(rkProjectReportingUpForm.getStatus())) {
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/stopOrStart"})
    public ActionResult stopOrStart(@RequestBody @Valid RkProjectReportingStopForm stopForm) {
        this.rkProjectReportingService.stopOrStart(stopForm);
        String msg = ObjectUtil.equals((Object)stopForm.getType(), (Object)1) ? "\u6682\u505c\u6210\u529f" : "\u53d6\u6d88\u6682\u505c\u6210\u529f";
        return ActionResult.success((String)msg);
    }

    @RepeatSubmit
    @PutMapping(value={"audit/{id}"})
    public ActionResult audit(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingAuditForm rkProjectReportingAuditForm) {
        rkProjectReportingAuditForm.setId(id);
        this.rkProjectReportingService.auditProjectReporting(rkProjectReportingAuditForm);
        return ActionResult.success((String)"\u5ba1\u6279\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"reconsider/{id}"})
    public ActionResult reconsider(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingUpForm rkProjectReportingUpForm) {
        rkProjectReportingUpForm.setId(id);
        this.rkProjectReportingService.updateFyProjectReporting(rkProjectReportingUpForm);
        return ActionResult.success((String)"\u63d0\u4ea4\u590d\u8bae\u6210\u529f");
    }

    @RepeatSubmit
    @PostMapping(value={"inputReconsider/{id}"})
    public ActionResult inputReconsider(@PathVariable(value="id") String id, @RequestBody RkProjectReportingReconsiderForm reconsiderForm) {
        reconsiderForm.setId(id);
        this.rkProjectReportingService.saveProjectReconsiderInfo(reconsiderForm);
        return ActionResult.success((String)"\u586b\u5199\u590d\u8bae\u610f\u89c1\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"toJudgment/{id}"})
    public ActionResult toJudgment(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingUpForm rkProjectReportingUpForm) {
        rkProjectReportingUpForm.setId(id);
        this.rkProjectReportingService.saveToJudgment(rkProjectReportingUpForm);
        return ActionResult.success((String)"\u63d0\u4ea4\u88c1\u51b3\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"judgment/{id}"})
    public ActionResult judgment(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingUpForm rkProjectReportingUpForm) {
        rkProjectReportingUpForm.setId(id);
        this.rkProjectReportingService.savejudgment(rkProjectReportingUpForm);
        return ActionResult.success((String)"\u88c1\u51b3\u6210\u529f");
    }

    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.rkProjectReportingService.removeInfo(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"/cancle"})
    @Transactional
    public ActionResult cancle(@RequestBody RkProjectReportingCancleForm cancleForm) {
        RkProjectReportingEntity entity = this.rkProjectReportingService.getInfo(cancleForm.getId());
        if (entity != null) {
            entity.setEnabledMark(ProjectReportingEnum.CANCEL_NODE.getType());
            this.rkProjectReportingService.update(cancleForm.getId(), entity);
            RkProjectReportingStageTrendsEntity trendsEntity = new RkProjectReportingStageTrendsEntity();
            trendsEntity.setId(RandomUtil.uuId());
            trendsEntity.setReportingId(cancleForm.getId());
            trendsEntity.setDescription(cancleForm.getDescription());
            trendsEntity.setTrendsType(ProjectReportStageTrendsTypeEnum.CANCLE.getType());
            trendsEntity.setOppId(entity.getOppId());
            trendsEntity.setStageChangeDesc("\u53d6\u6d88\u5907\u6848");
            trendsEntity.setFollowTime(DateUtil.getNowDate());
            this.rkProjectReportingStageTrendsService.save(trendsEntity);
        }
        return ActionResult.success((String)"\u53d6\u6d88\u5907\u6848\u6210\u529f");
    }

    @RepeatSubmit
    @ApiOperation(value="\u8f6c\u79fb\u5546\u673a")
    @PostMapping(value={"transfer"})
    public ActionResult transfer(@RequestBody @Valid RkProjectReportingTrendsTransferForm trendsTransferForm) {
        HashMap transfer = this.rkProjectReportingService.transfer(trendsTransferForm);
        if (ObjectUtil.isNull(transfer.get("error"))) {
            return ActionResult.success((String)"\u8f6c\u79fb\u6210\u529f");
        }
        return ActionResult.fail((String)transfer.get("error").toString());
    }

    @GetMapping(value={"fileList/{reportingId}"})
    public ActionResult fileList(@PathVariable(value="reportingId") String reportingId) {
        RkProjectReportingStageTrendsPagination trendsPagination = new RkProjectReportingStageTrendsPagination();
        trendsPagination.setReportingId(reportingId);
        List idList = CollectionUtil.list((boolean)false, (Object[])new String[]{reportingId});
        List<RkProjectReportingStageTrendsEntity> listByReporting = this.rkProjectReportingStageTrendsService.getListByReporting(trendsPagination);
        if (CollectionUtil.isNotEmpty(listByReporting)) {
            List collect = listByReporting.stream().map(RkProjectReportingStageTrendsEntity::getId).collect(Collectors.toList());
            idList.addAll(collect);
        }
        List<AfterSalesAttachmentEntity> attachmentEntities = this.afterSalesAttachmentService.listByBussinessObjIdList(idList);
        attachmentEntities.stream().forEach(entity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        return ActionResult.success(attachmentEntities);
    }

    @GetMapping(value={"/getReportingForContract/{reportingId}"})
    public ActionResult getReportingForContract(@PathVariable(value="reportingId") String reportingId) {
        RkProjectReportingInfoVO vo = this.rkProjectReportingService.getReportingForContract(reportingId);
        return ActionResult.success((Object)vo);
    }
}

