/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsCrForm;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsInfoVO;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsListVO;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsPagination;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsUpForm;
import com.bringspring.visit.service.RkProjectReportingStageTrendsService;
import com.bringspring.visit.utils.ProjectReportStageTrendsTypeEnum;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5546\u673a\u62a5\u5907\u9500\u552e\u3001\u9879\u76ee\u9636\u6bb5\u52a8\u6001"}, value="visit")
@RequestMapping(value={"/api/visit/RkProjectReportingStageTrends"})
public class RkProjectReportingStageTrendsController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectReportingStageTrendsController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectReportingStageTrendsService rkProjectReportingStageTrendsService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectReportingStageTrendsPagination rkProjectReportingStageTrendsPagination) throws IOException {
        List<RkProjectReportingStageTrendsEntity> list = this.rkProjectReportingStageTrendsService.getList(rkProjectReportingStageTrendsPagination);
        for (RkProjectReportingStageTrendsEntity rkProjectReportingStageTrendsEntity : list) {
            Object typeId = "";
            if (rkProjectReportingStageTrendsEntity.getTrendsType() == ProjectReportStageTrendsTypeEnum.SALE_STAGE.getType()) {
                typeId = "ReportingSaleStage";
            }
            if (rkProjectReportingStageTrendsEntity.getTrendsType() == ProjectReportStageTrendsTypeEnum.PROJECT_STAGE.getType()) {
                typeId = "ReportingProjectStage";
            }
            if (StrUtil.isNotEmpty((CharSequence)typeId)) {
                rkProjectReportingStageTrendsEntity.setStageName(this.baseDataUtil.getDictName(rkProjectReportingStageTrendsEntity.getStageCode(), (String)typeId));
                rkProjectReportingStageTrendsEntity.setLastStageName(this.baseDataUtil.getDictName(rkProjectReportingStageTrendsEntity.getLastStage(), (String)typeId));
            }
            rkProjectReportingStageTrendsEntity.setFollowMethod(this.baseDataUtil.getDictName(rkProjectReportingStageTrendsEntity.getFollowMethod(), "followMethod"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportingStageTrendsListVO.class);
        for (Object typeId : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportingStageTrendsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectReportingStageTrendsCrForm rkProjectReportingStageTrendsCrForm) throws DataException {
        HashMap map = this.rkProjectReportingStageTrendsService.saveTrends(rkProjectReportingStageTrendsCrForm);
        if (ObjectUtil.isNotNull(map.get("error"))) {
            ActionResult.fail((String)map.get("error").toString());
        }
        return ActionResult.success((String)"\u8ddf\u8fdb\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectReportingStageTrendsInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectReportingStageTrendsEntity entity = this.rkProjectReportingStageTrendsService.getInfo(id);
        RkProjectReportingStageTrendsInfoVO vo = (RkProjectReportingStageTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingStageTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectReportingStageTrendsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectReportingStageTrendsEntity entity = this.rkProjectReportingStageTrendsService.getInfo(id);
        RkProjectReportingStageTrendsInfoVO vo = (RkProjectReportingStageTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingStageTrendsInfoVO.class);
        vo.setStageCode(this.baseDataUtil.getDictName(vo.getStageCode(), "ReportingSaleStage"));
        vo.setLastStage(this.baseDataUtil.getDictName(vo.getLastStage(), "ReportingSaleStage"));
        vo.setFollowMethod(this.baseDataUtil.getDictName(vo.getFollowMethod(), "followMethod"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingStageTrendsUpForm rkProjectReportingStageTrendsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingStageTrendsEntity entity = this.rkProjectReportingStageTrendsService.getInfo(id);
        if (entity != null) {
            RkProjectReportingStageTrendsEntity subentity = (RkProjectReportingStageTrendsEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingStageTrendsUpForm, RkProjectReportingStageTrendsEntity.class);
            this.rkProjectReportingStageTrendsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectReportingStageTrendsEntity entity = this.rkProjectReportingStageTrendsService.getInfo(id);
        if (entity != null) {
            this.rkProjectReportingStageTrendsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getListByReporting"})
    public ActionResult getListByReporting(@RequestBody @Valid RkProjectReportingStageTrendsPagination trendsPagination) {
        List<RkProjectReportingStageTrendsEntity> list = this.rkProjectReportingStageTrendsService.getListByReporting(trendsPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportingStageTrendsInfoVO.class);
        listVO.stream().forEach(entity -> {
            UserEntity userEntity;
            String dicName;
            String typeId = "";
            if (entity.getTrendsType() == ProjectReportStageTrendsTypeEnum.SALE_STAGE.getType()) {
                typeId = "ReportingSaleStage";
            }
            if (entity.getTrendsType() == ProjectReportStageTrendsTypeEnum.PROJECT_STAGE.getType()) {
                typeId = "ReportingProjectStage";
            }
            if (StrUtil.isNotEmpty((CharSequence)typeId)) {
                entity.setStageName(this.baseDataUtil.getDictName(entity.getStageCode(), typeId));
            }
            if (StrUtil.isNotEmpty((CharSequence)entity.getOppId())) {
                CrmCustomerOpportunityEntity byId = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)entity.getOppId()));
                entity.setOppId(byId.getDescription());
            }
            if (StrUtil.isNotEmpty((CharSequence)(dicName = this.baseDataUtil.getDictName(entity.getFollowMethod(), "followMethod")))) {
                entity.setFollowMethodName(dicName);
            }
            if (null != (userEntity = this.userService.getInfo(entity.getCreatorUserId()))) {
                entity.setCreatorUserId(userEntity.getRealName());
                entity.setAvatar(userEntity.getHeadIcon());
            }
        });
        return ActionResult.success((Object)listVO);
    }
}

