/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingTrendsEntity;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsCrForm;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsInfoVO;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsListVO;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsPagination;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsUpForm;
import com.bringspring.visit.service.RkProjectReportingTrendsService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62a5\u5907\u5ba1\u6279\u8bb0\u5f55"}, value="visit")
@RequestMapping(value={"/api/visit/RkProjectReportingTrends"})
public class RkProjectReportingTrendsController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectReportingTrendsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectReportingTrendsService rkProjectReportingTrendsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectReportingTrendsPagination rkProjectReportingTrendsPagination) throws IOException {
        List<RkProjectReportingTrendsEntity> list = this.rkProjectReportingTrendsService.getList(rkProjectReportingTrendsPagination);
        for (RkProjectReportingTrendsEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportingTrendsListVO.class);
        for (RkProjectReportingTrendsListVO rkProjectReportingTrendsListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportingTrendsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectReportingTrendsCrForm rkProjectReportingTrendsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingTrendsEntity entity = (RkProjectReportingTrendsEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingTrendsCrForm, RkProjectReportingTrendsEntity.class);
        entity.setId(mainId);
        this.rkProjectReportingTrendsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/listByReportingId/{type}/{reportingId}"})
    public ActionResult listByReportingId(@PathVariable(value="type") String type, @PathVariable(value="reportingId") String reportingId) {
        List<String> typeList = CollectionUtil.list((boolean)false);
        if (StringUtils.isNotEmpty((String)type) && !StringUtils.equals((CharSequence)type, (CharSequence)"-1")) {
            typeList = Arrays.asList(type.split(","));
        }
        List<RkProjectReportingTrendsEntity> list = this.rkProjectReportingTrendsService.listByReportingId(typeList, reportingId);
        List jsonToList = JsonUtil.getJsonToList(list, RkProjectReportingTrendsListVO.class);
        for (RkProjectReportingTrendsListVO trendsListVO : jsonToList) {
            trendsListVO.setNodeTypeCode(trendsListVO.getNodeType());
            trendsListVO.setNodeType(this.baseDataUtil.getDictName(trendsListVO.getNodeType(), "projectReportingTrendsEnabledMark"));
            trendsListVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(trendsListVO.getCreatorUserId()));
        }
        return ActionResult.success((Object)jsonToList);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectReportingTrendsInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectReportingTrendsEntity entity = this.rkProjectReportingTrendsService.getInfo(id);
        RkProjectReportingTrendsInfoVO vo = (RkProjectReportingTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectReportingTrendsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectReportingTrendsEntity entity = this.rkProjectReportingTrendsService.getInfo(id);
        RkProjectReportingTrendsInfoVO vo = (RkProjectReportingTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportingTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportingTrendsUpForm rkProjectReportingTrendsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingTrendsEntity entity = this.rkProjectReportingTrendsService.getInfo(id);
        if (entity != null) {
            RkProjectReportingTrendsEntity subentity = (RkProjectReportingTrendsEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingTrendsUpForm, RkProjectReportingTrendsEntity.class);
            this.rkProjectReportingTrendsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectReportingTrendsEntity entity = this.rkProjectReportingTrendsService.getInfo(id);
        if (entity != null) {
            this.rkProjectReportingTrendsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

