/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkReportingProductPriceEntity;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceCrForm;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceInfoVO;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceListVO;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPricePagination;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceUpForm;
import com.bringspring.visit.service.RkReportingProductPriceItemService;
import com.bringspring.visit.service.RkReportingProductPriceService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5546\u673a\u4ef7\u683c\u5907\u6848"}, value="visit")
@RequestMapping(value={"/api/visit/RkReportingProductPrice"})
public class RkReportingProductPriceController {
    private static final Logger log = LoggerFactory.getLogger(RkReportingProductPriceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkReportingProductPriceService rkReportingProductPriceService;
    @Autowired
    private RkReportingProductPriceItemService rkReportingProductPriceItemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkReportingProductPricePagination rkReportingProductPricePagination) throws IOException {
        List<RkReportingProductPriceEntity> list = this.rkReportingProductPriceService.getList(rkReportingProductPricePagination);
        List listVO = JsonUtil.getJsonToList(list, RkReportingProductPriceListVO.class);
        for (RkReportingProductPriceListVO rkReportingProductPriceVO : listVO) {
            rkReportingProductPriceVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(rkReportingProductPriceVO.getCreatorUserId()));
            rkReportingProductPriceVO.setProductPriceItemList(this.rkReportingProductPriceItemService.queryByPriceId(rkReportingProductPriceVO.getId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkReportingProductPricePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkReportingProductPriceCrForm rkReportingProductPriceCrForm) throws DataException {
        this.rkReportingProductPriceService.insertInfo(rkReportingProductPriceCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkReportingProductPriceInfoVO> info(@PathVariable(value="id") String id) {
        RkReportingProductPriceInfoVO vo = this.rkReportingProductPriceService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkReportingProductPriceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkReportingProductPriceEntity entity = this.rkReportingProductPriceService.getInfo(id);
        RkReportingProductPriceInfoVO vo = (RkReportingProductPriceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReportingProductPriceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detailByReporting/{reportingId}"})
    public ActionResult<RkReportingProductPriceInfoVO> detailByReporting(@PathVariable(value="reportingId") String reportingId) {
        RkReportingProductPriceInfoVO vo = this.rkReportingProductPriceService.detailByReporting(reportingId);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkReportingProductPriceUpForm rkReportingProductPriceUpForm) throws DataException {
        this.rkReportingProductPriceService.editInfo(id, rkReportingProductPriceUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkReportingProductPriceEntity entity = this.rkReportingProductPriceService.getInfo(id);
        if (entity != null) {
            this.rkReportingProductPriceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/init/{reportingId}"})
    public ActionResult<RkReportingProductPriceInfoVO> init(@PathVariable(value="reportingId") String reportingId) throws DataException {
        RkReportingProductPriceInfoVO vo = this.rkReportingProductPriceService.initInfo(reportingId);
        return ActionResult.success((Object)vo);
    }
}

