/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.UserRelationObjectTypeEnum;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.base.util.UserAuthAreaUtils;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7528\u6237"}, value="visit")
@RequestMapping(value={"/api/visit/user"})
public class UserApprovedController {
    private static final Logger log = LoggerFactory.getLogger(UserApprovedController.class);
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private CrmCustomerService customerService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;

    @GetMapping(value={"/getApproved"})
    public ActionResult getApproved(String userType, String roleType, String createUserId) {
        if (StrUtil.isEmpty((CharSequence)createUserId)) {
            createUserId = this.userProvider.get().getUserId();
        }
        HashMap map = MapUtil.newHashMap();
        List userList = CollectionUtil.list((boolean)false);
        if (StrUtil.equals((CharSequence)roleType, (CharSequence)"sales")) {
            if (StrUtil.equals((CharSequence)userType, (CharSequence)"commissioner")) {
                userList = this.salesRoleUtils.getManager(createUserId);
            }
            if (StrUtil.equals((CharSequence)userType, (CharSequence)"regionalHead")) {
                userList = this.salesRoleUtils.getRegionalManager(createUserId);
            }
        }
        String users = "";
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            users = CollectionUtil.join((Iterable)userList, (CharSequence)",");
        }
        map.put("handleId", users);
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"/getApprovedByCode"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult getApprovedByCode(String roleCode, String searchType, String saleId, String customerId, String createUserId, String taskId) {
        HashMap map = MapUtil.newHashMap();
        map.put("handleId", "");
        if (StrUtil.isBlank((CharSequence)roleCode)) {
            return ActionResult.success((Object)map);
        }
        String userId = "";
        if (StrUtil.equals((CharSequence)searchType, (CharSequence)"createUserId")) {
            if (StrUtil.isEmpty((CharSequence)createUserId)) {
                createUserId = this.userProvider.get().getUserId();
            }
            userId = createUserId;
        } else {
            FlowTaskEntity flowTaskSubmited = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowFormContentJson});
            String flowFormContentJson = flowTaskSubmited.getFlowFormContentJson();
            Map map1 = JsonUtil.stringToMap((String)flowFormContentJson);
            Object saleId1 = map1.get("salerId");
            if (ObjectUtil.isNotNull(saleId1)) {
                userId = saleId1.toString();
            }
            if (StrUtil.isBlank((CharSequence)userId)) {
                RkContractEntity byId1;
                Object projectId = map1.get("projectId");
                if (ObjectUtil.isNotNull(projectId)) {
                    RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectId.toString()));
                    if (ObjectUtil.isNotNull((Object)byId)) {
                        userId = byId.getSalerId();
                    }
                    if (StrUtil.isBlank((CharSequence)userId) && ObjectUtil.isNotNull((Object)(byId1 = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)byId.getContractId()))))) {
                        userId = byId1.getSalerId();
                    }
                } else {
                    Object contractId = map1.get("contractId");
                    byId1 = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)contractId.toString()));
                    if (ObjectUtil.isNotNull((Object)byId1)) {
                        userId = byId1.getSalerId();
                    }
                }
            }
        }
        if (StrUtil.isBlank((CharSequence)userId)) {
            return ActionResult.success((Object)map);
        }
        List haveSameAuthAreaWithMe = UserAuthAreaUtils.getHaveSameAuthAreaWithMe((String)userId, (List)CollectionUtil.list((boolean)false), (Integer)2, (String)UserRelationObjectTypeEnum.SALE_AREA.getObjectType());
        if (CollectionUtil.isEmpty((Collection)haveSameAuthAreaWithMe)) {
            return ActionResult.success((Object)map);
        }
        List list = this.roleService.getList();
        List collect = list.stream().filter(s -> s.getEnCode().contains(roleCode)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            return ActionResult.success((Object)map);
        }
        List roleUserList = CollectionUtil.list((boolean)false);
        for (RoleEntity roleEntity : collect) {
            List<UserRelationEntity> listByRoleCode = this.userRelationUtil.getListByRoleCode(roleEntity.getEnCode());
            if (!CollectionUtil.isNotEmpty(listByRoleCode)) continue;
            roleUserList.addAll(listByRoleCode.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isEmpty((Collection)roleUserList)) {
            return ActionResult.success((Object)map);
        }
        Set returnUserList = haveSameAuthAreaWithMe.stream().filter(s -> roleUserList.contains(s)).collect(Collectors.toSet());
        String users = "";
        if (CollectionUtil.isNotEmpty(returnUserList)) {
            users = CollectionUtil.join(returnUserList, (CharSequence)",");
        }
        map.put("handleId", users);
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"/getApprovedForLeader"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult getApprovedForLeader(String searchType, String taskId, String level, String filedName) {
        HashMap map = MapUtil.newHashMap();
        String users = "";
        String userId = "";
        FlowTaskEntity flowTaskSubmited = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowFormContentJson});
        String flowFormContentJson = flowTaskSubmited.getFlowFormContentJson();
        Map map1 = JsonUtil.stringToMap((String)flowFormContentJson);
        Object projectManager = map1.get("projectManager");
        if (ObjectUtil.isNotEmpty((Object)filedName)) {
            Object temp = map1.get(filedName);
            if (ObjectUtil.isNotEmpty(temp)) {
                userId = temp;
            }
        } else if (ObjectUtil.isNotNull(projectManager)) {
            userId = projectManager;
        } else {
            RkContractEntity contract;
            Object contractId;
            RkContractProjectEntity project;
            Object projectId = map1.get("projectId");
            if (ObjectUtil.isNotNull(projectId) && ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(projectId.toString())))) {
                userId = project.getProjectHeader();
            }
            if (ObjectUtil.isNotNull(contractId = map1.get("contractId")) && ObjectUtil.isNotEmpty((Object)(contract = this.rkContractService.getInfo(contractId.toString())))) {
                userId = contract.getSalerId();
            }
        }
        if (ObjectUtil.isNotNull((Object)userId)) {
            if (StrUtil.equals((CharSequence)searchType, (CharSequence)"organize")) {
                users = this.getDeptHeader(userId);
            } else {
                int levelInt = Integer.parseInt(ObjectUtil.isNull((Object)level) ? "1" : level.toString());
                levelInt = Math.min(levelInt, 5);
                users = userId.toString();
                for (int i = 0; i < levelInt; ++i) {
                    users = this.getHeader(users);
                }
            }
        }
        System.out.println("=======================================================================>" + users);
        map.put("handleId", users);
        return ActionResult.success((Object)map);
    }

    private String getHeader(Object userId) {
        String header = "";
        UserEntity u = this.userService.getInfo(userId.toString());
        header = u.getManagerId();
        return header;
    }

    @GetMapping(value={"/getCustomerAreaRegional"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult getCustomerAreaRegional(String taskId, String filedName, String searchType) throws WorkFlowException {
        CrmCustomerEntity crmCustomer;
        Object customerId;
        HashMap map = MapUtil.newHashMap();
        String users = "";
        String userId = "";
        FlowTaskEntity flowTaskSubmited = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowFormContentJson});
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(taskId);
        FlowEngineTemplateEntity flowEngineTemplateEntity = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)flowTask.getTemplateId()));
        String flowFormContentJson = flowTaskSubmited.getFlowFormContentJson();
        Map map1 = JsonUtil.stringToMap((String)flowFormContentJson);
        String address = "";
        if (StrUtil.equals((CharSequence)"customerAddress", (CharSequence)searchType)) {
            address = map1.get(filedName);
        }
        if (ObjectUtil.isEmpty((Object)address) && ObjectUtil.isNotEmpty(customerId = map1.get(filedName)) && ObjectUtil.isNotEmpty((Object)(crmCustomer = this.customerService.getInfo(customerId.toString())))) {
            address = crmCustomer.getAddress();
        }
        String companyId = flowEngineTemplateEntity.getCompanyId();
        if (ObjectUtil.isNotEmpty((Object)address) && ObjectUtil.isNotEmpty((Object)companyId)) {
            users = this.getAreaReaRegional(address.toString(), companyId.toString());
        }
        map.put("handleId", users);
        return ActionResult.success((Object)map);
    }

    private String getAreaReaRegional(String address, String company) {
        if (StringUtil.isNotEmpty((String)address)) {
            List addressList = JsonUtil.getJsonToList((String)address, String.class);
            if (CollectionUtil.isNotEmpty((Collection)addressList)) {
                List userList = this.userService.getListByOraganizetionId(company);
                List userRelationList = this.userRelationService.getListByObjectId(address, "Area");
                if (CollectionUtil.isNotEmpty(userRelationList = userRelationList.stream().filter(a -> userList.stream().map(UserEntity::getId).collect(Collectors.toList()).contains(a.getUserId())).collect(Collectors.toList()))) {
                    List userAllList = this.userRelationService.getListByUserIdAll(userRelationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
                    if (CollectionUtil.isEmpty(userAllList = userAllList.stream().filter(a -> a.getObjectType().equals("AreaManager")).collect(Collectors.toList()))) {
                        addressList.remove(addressList.size() - 1);
                        return this.getAreaReaRegional(JsonUtil.getObjectToString((Object)addressList), company);
                    }
                    return ((UserRelationEntity)userAllList.get(0)).getUserId();
                }
                addressList.remove(addressList.size() - 1);
                return this.getAreaReaRegional(JsonUtil.getObjectToString((Object)addressList), company);
            }
            return null;
        }
        return null;
    }

    private String getDeptHeader(Object userId) {
        OrganizeEntity organizeEntity;
        String header = "";
        UserEntity u = this.userService.getInfo(userId.toString());
        if (ObjectUtil.isNotEmpty((Object)u) && ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.getInfo(u.getOrganizeId())))) {
            header = organizeEntity.getManagerId();
        }
        return header;
    }

    @GetMapping(value={"/getProductCompany"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult getProductCompany(String taskId, String filedName, String filedType, String dictionaryDataEnCode) {
        DictionaryTypeEntity base;
        RkContractEntity rkContractEntity;
        RkContractProjectEntity rkContractProjectEntity;
        HashMap map = MapUtil.newHashMap();
        List users = CollectionUtil.list((boolean)false);
        FlowTaskEntity flowTaskSubmited = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowFormContentJson});
        String flowFormContentJson = flowTaskSubmited.getFlowFormContentJson();
        Map map1 = JsonUtil.stringToMap((String)flowFormContentJson);
        Object incomeType = map1.get("incomeType");
        Object productType = map1.get("productType");
        Object productName = map1.get("productId");
        Object filedValue = map1.get(filedName);
        if (StrUtil.equals((CharSequence)"contractId", (CharSequence)filedName)) {
            RkContractEntity rkContractEntity2 = this.rkContractService.getInfo(filedValue.toString());
            if (ObjectUtil.isNotEmpty((Object)rkContractEntity2)) {
                filedValue = rkContractEntity2.getIncomeType();
            }
        } else if (StrUtil.equals((CharSequence)"projectId", (CharSequence)filedName) && ObjectUtil.isNotEmpty((Object)(rkContractProjectEntity = this.rkContractProjectService.getInfo(filedValue.toString()))) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.rkContractService.getInfo(rkContractProjectEntity.getContractId())))) {
            filedValue = rkContractEntity.getIncomeType();
        }
        List<Object> companyList = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)filedType) && ObjectUtil.isNotEmpty(filedValue)) {
            List matchList;
            List<String> filedValueStr = Arrays.asList(filedValue.toString().replace("[", "").replace("]", "").split(","));
            if (StrUtil.equals((CharSequence)filedType, (CharSequence)"1")) {
                List categoryEntityList = this.crmProductCategoryService.list();
                for (String v : filedValueStr) {
                    if (!StrUtil.isNotEmpty((CharSequence)v)) continue;
                    matchList = categoryEntityList.stream().filter(a -> a.getId().equals(v)).collect(Collectors.toList());
                    companyList.addAll(matchList.stream().map(CrmProductCategoryEntity::getParentId).collect(Collectors.toList()));
                }
            } else {
                List productList = this.crmProductService.list();
                for (String v : filedValueStr) {
                    if (!StrUtil.isNotEmpty((CharSequence)v)) continue;
                    matchList = productList.stream().filter(a -> a.getId().equals(v)).collect(Collectors.toList());
                    companyList.addAll(matchList.stream().map(CrmProductEntity::getCompanyId).collect(Collectors.toList()));
                }
            }
        }
        companyList = companyList.stream().distinct().collect(Collectors.toList());
        if (StrUtil.isNotEmpty((CharSequence)dictionaryDataEnCode) && ObjectUtil.isNotEmpty((Object)(base = this.dictionaryTypeService.getInfoByEnCode(dictionaryDataEnCode)))) {
            for (String string : companyList) {
                List dictionaryDataEntities = this.dictionaryDataService.getList(base.getId(), Boolean.valueOf(true), string);
                if (!CollectionUtil.isNotEmpty((Collection)dictionaryDataEntities)) continue;
                users.addAll(dictionaryDataEntities.stream().map(DictionaryDataEntity::getDescription).collect(Collectors.toList()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)users)) {
            map.put("handleId", users.stream().distinct().collect(Collectors.joining(",")));
        } else {
            map.put("handleId", "");
        }
        return ActionResult.success((Object)map);
    }
}

