/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.VisitContactEntity;
import com.bringspring.visit.model.visitcontact.VisitContactInfoVO;
import com.bringspring.visit.model.visitcontact.VisitContactListVO;
import com.bringspring.visit.model.visitcontact.VisitContactPagination;
import com.bringspring.visit.model.visitcontact.VisitContactUpForm;
import com.bringspring.visit.model.visitcontact.VisitCustomerContactCrForm;
import com.bringspring.visit.service.VisitContactService;
import com.bringspring.visit.utils.ContactEnableMarkEnum;
import com.bringspring.visit.utils.DeleteMarkEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62dc\u8bbf\u529f\u80fd\u7684\u8054\u7cfb\u4eba\u8868"}, value="visit")
@RequestMapping(value={"/api/visit/VisitContact"})
public class VisitContactController {
    private static final Logger log = LoggerFactory.getLogger(VisitContactController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitContactService visitContactService;

    @ApiOperation(value="\u67e5\u8be2\u8054\u7cfb\u4eba")
    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody VisitContactPagination visitContactPagination) throws IOException {
        List<VisitContactEntity> list = this.visitContactService.getList(visitContactPagination);
        for (VisitContactEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, VisitContactListVO.class);
        for (VisitContactListVO visitContactListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitContactPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8054\u7cfb\u4eba")
    @PostMapping(value={"/selectAll"})
    public ActionResult selectAll(@RequestBody VisitContactPagination visitContactPagination) {
        UserInfo userInfo = this.userProvider.get();
        visitContactPagination.setEnabledMark(ContactEnableMarkEnum.ENABLE_IMPROVED.getEnableMark());
        visitContactPagination.setCreatorUserId(userInfo.getUserId());
        if (StrUtil.isNotEmpty((CharSequence)visitContactPagination.getKeyword())) {
            visitContactPagination.setKeyword(visitContactPagination.getKeyword().toUpperCase());
        }
        List<VisitContactEntity> list = this.visitContactService.getList(visitContactPagination);
        List listVO = JsonUtil.getJsonToList(list, VisitContactListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitContactPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @ApiOperation(value="\u65b0\u589e\u8054\u7cfb\u4eba")
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid VisitCustomerContactCrForm customerContactCrForm) throws DataException {
        HashMap map = this.visitContactService.saveContactList(customerContactCrForm);
        if (Objects.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<VisitContactInfoVO> info(@PathVariable(value="id") String id) {
        VisitContactEntity entity = this.visitContactService.getInfo(id);
        VisitContactInfoVO vo = (VisitContactInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitContactInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitContactInfoVO> detailInfo(@PathVariable(value="id") String id) {
        VisitContactEntity entity = this.visitContactService.getInfo(id);
        VisitContactInfoVO vo = (VisitContactInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitContactInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitContactUpForm visitContactUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        VisitContactEntity entity = this.visitContactService.getInfo(id);
        if (entity != null) {
            VisitContactEntity subentity = (VisitContactEntity)JsonUtil.getJsonToBean((Object)visitContactUpForm, VisitContactEntity.class);
            this.visitContactService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @RepeatSubmit
    @ApiOperation(value="\u5220\u9664\u8054\u7cfb\u4eba")
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        VisitContactEntity entity = this.visitContactService.getInfo(id);
        if (entity != null) {
            entity.setDeleteMark(DeleteMarkEnum.DELETE.getDeleteMark());
            entity.setDeleteUserId(userInfo.getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

