/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.VisitContactEntity;
import com.bringspring.visit.entity.VisitCustomerEntity;
import com.bringspring.visit.model.visitcontact.VisitContactModel;
import com.bringspring.visit.model.visitcustomer.CustomerSearchDTO;
import com.bringspring.visit.model.visitcustomer.CustomerSearchPagination;
import com.bringspring.visit.model.visitcustomer.VisitCustomerCrForm;
import com.bringspring.visit.model.visitcustomer.VisitCustomerInfoVO;
import com.bringspring.visit.model.visitcustomer.VisitCustomerListVO;
import com.bringspring.visit.model.visitcustomer.VisitCustomerPagination;
import com.bringspring.visit.model.visitcustomer.VisitCustomerUpForm;
import com.bringspring.visit.service.VisitContactService;
import com.bringspring.visit.service.VisitCustomerService;
import com.bringspring.visit.utils.CustomerEnableMarkEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62dc\u8bbf\u529f\u80fd\u7684\u5ba2\u6237\u8868"}, value="visit")
@RequestMapping(value={"/api/visit/VisitCustomer"})
public class VisitCustomerController {
    private static final Logger log = LoggerFactory.getLogger(VisitCustomerController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitCustomerService visitCustomerService;
    @Autowired
    private VisitContactService visitContactService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private ProvinceService provinceService;

    @ApiOperation(value="\u5ba2\u6237\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody VisitCustomerPagination visitCustomerPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        PageListVO pageListVO = new PageListVO();
        Map<String, CustomerEnableMarkEnum> allToMap = CustomerEnableMarkEnum.getAllToMap();
        if (ObjectUtil.isNotEmpty((Object)visitCustomerPagination.getDataRange()) && visitCustomerPagination.getDataRange() == 1) {
            CustomerSearchPagination customerSearchPagination = new CustomerSearchPagination();
            customerSearchPagination.setPageSize(visitCustomerPagination.getPageSize());
            customerSearchPagination.setCurrentPage(visitCustomerPagination.getCurrentPage());
            customerSearchPagination.setKeyword(visitCustomerPagination.getKeyword());
            customerSearchPagination.setCompanyId(userInfo.getOrganizeId());
            customerSearchPagination.setUserId(userInfo.getUserId());
            customerSearchPagination.setOrderByVisit("0");
            List<CustomerSearchDTO> list = this.visitCustomerService.selectAll(customerSearchPagination);
            list.stream().forEach(d -> {
                CrmCustomerEntity byId;
                d.setEnabledMarkDesc(ObjectUtil.isNull(allToMap.get(d.getEnabledMark())) ? "" : ((CustomerEnableMarkEnum)((Object)((Object)((Object)allToMap.get(d.getEnabledMark()))))).getDesc());
                if (StrUtil.equals((CharSequence)d.getCustomerSource(), (CharSequence)"crm") && !Objects.isNull(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)d.getId())))) {
                    d.setAddressName(this.baseDataUtil.provinceData(byId.getAddress()));
                    d.setConduct(this.baseDataUtil.getDictName(byId.getConduct(), "EnterpriseNature"));
                    d.setGrade(this.baseDataUtil.getDictName(byId.getGrade(), "CustomerGrade"));
                    d.setCrmType(this.baseDataUtil.getDictName(byId.getType(), ""));
                }
            });
            System.out.println("ddd");
            pageListVO.setList(list);
            PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitCustomerPagination), PaginationVO.class);
            pageListVO.setPagination(page);
        } else {
            List<String> userIdList = this.searchUserId(visitCustomerPagination);
            visitCustomerPagination.setUserIdList(userIdList);
            List<VisitCustomerEntity> list = this.visitCustomerService.getList(visitCustomerPagination);
            for (VisitCustomerEntity visitCustomerEntity : list) {
                visitCustomerEntity.setType(this.baseDataUtil.getDictName(visitCustomerEntity.getType(), ""));
            }
            List listVO = JsonUtil.getJsonToList(list, VisitCustomerListVO.class);
            for (VisitCustomerListVO vo : listVO) {
                vo.setCustomerSource("visit");
                vo.setEnabledMarkDesc(ObjectUtil.isNull((Object)((Object)allToMap.get(vo.getEnabledMark()))) ? "" : allToMap.get(vo.getEnabledMark()).getDesc());
            }
            pageListVO.setList(listVO);
            PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitCustomerPagination), PaginationVO.class);
            pageListVO.setPagination(paginationVO);
        }
        return ActionResult.success((Object)pageListVO);
    }

    private List<String> searchUserId(VisitCustomerPagination visitCustomerPagination) {
        List userIdList = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        if (!ObjectUtil.isEmpty((Object)visitCustomerPagination.getDataRange()) && visitCustomerPagination.getDataRange() == 2) {
            List listByManagerId = this.userService.getListByManagerId(userInfo.getUserId(), "");
            if (CollectionUtil.isEmpty((Collection)listByManagerId)) {
                userIdList.add(userInfo.getUserId());
            } else {
                userIdList = listByManagerId.stream().map(UserBaseVO::getId).collect(Collectors.toList());
            }
        }
        if (ObjectUtil.isNull((Object)visitCustomerPagination.getDataRange()) || !ObjectUtil.isEmpty((Object)visitCustomerPagination.getDataRange()) && visitCustomerPagination.getDataRange() == 3) {
            userIdList.add(userInfo.getUserId());
        }
        return userIdList;
    }

    @RepeatSubmit
    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237")
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid VisitCustomerCrForm visitCustomerCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "491521850468364869";
        String mainId = RandomUtil.uuId();
        visitCustomerCrForm.setMainId(mainId);
        CrmCustomerEntity entity = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)((Object)visitCustomerCrForm), CrmCustomerEntity.class);
        HashMap map = this.visitCustomerService.saveCustomer(visitCustomerCrForm);
        if (ObjectUtil.isNull(map.get("error"))) {
            FlowUtil.saveOrSubmit((String)visitCustomerCrForm.getTaskId(), (String)flowEngineId, (String)visitCustomerCrForm.getTemplateId(), (String)mainId, (Object)entity, (Integer)visitCustomerCrForm.getStatus());
            if (visitCustomerCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<VisitCustomerInfoVO> info(@PathVariable(value="id") String id) {
        VisitCustomerEntity entity = this.visitCustomerService.getInfo(id);
        VisitCustomerInfoVO vo = (VisitCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitCustomerInfoVO.class);
        List<VisitContactEntity> VisitContactList = this.visitCustomerService.GetVisitContactList(id);
        for (VisitContactEntity visitContactEntity : VisitContactList) {
        }
        vo.setVisitContactList(JsonUtil.getJsonToList(VisitContactList, VisitContactModel.class));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitCustomerInfoVO> detailInfo(@PathVariable(value="id") String id) {
        VisitCustomerEntity entity = this.visitCustomerService.getInfo(id);
        VisitCustomerInfoVO vo = (VisitCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitCustomerInfoVO.class);
        List<VisitContactEntity> visitContactList = this.visitCustomerService.GetVisitContactList(id);
        List visitContactModelList = JsonUtil.getJsonToList(visitContactList, VisitContactModel.class);
        for (VisitContactModel visitContactModel : visitContactModelList) {
        }
        vo.setVisitContactList(visitContactModelList);
        vo.setTypeDesc(this.baseDataUtil.getDictName(vo.getType(), ""));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/detail/{id}/{customerSource}"})
    public ActionResult<VisitCustomerInfoVO> detailInfoAndSource(@PathVariable(value="id") String id, @PathVariable(value="customerSource") String customerSource) {
        Object entity;
        VisitCustomerInfoVO vo = new VisitCustomerInfoVO();
        if (StrUtil.equals((CharSequence)customerSource, (CharSequence)"visit")) {
            entity = this.visitCustomerService.getInfo(id);
            vo = (VisitCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitCustomerInfoVO.class);
        }
        if (StrUtil.equals((CharSequence)customerSource, (CharSequence)"agent")) {
            entity = (RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)id));
            vo = (VisitCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitCustomerInfoVO.class);
            vo.setTag("");
            vo.setAlias("");
            vo.setProvName(this.baseDataUtil.provinceData(((RkAgentEntity)entity).getRegion()));
            vo.setDetail(((RkAgentEntity)entity).getAddress());
        }
        if (StrUtil.equals((CharSequence)customerSource, (CharSequence)"crm")) {
            entity = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)id));
            vo = (VisitCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitCustomerInfoVO.class);
            vo.setTag(StrUtil.isNotEmpty((CharSequence)((CrmCustomerEntity)entity).getAliasQuery()) ? ((CrmCustomerEntity)entity).getAliasQuery() : "");
            String s = this.baseDataUtil.provinceData(((CrmCustomerEntity)entity).getAddress());
            vo.setDetail(((CrmCustomerEntity)entity).getDetailAddress());
            vo.setProvName(s);
        }
        List<VisitContactEntity> visitContactList = this.visitCustomerService.GetVisitContactList(id);
        List visitContactModelList = JsonUtil.getJsonToList(visitContactList, VisitContactModel.class);
        for (VisitContactModel visitContactModel : visitContactModelList) {
        }
        vo.setVisitContactList(visitContactModelList);
        vo.setTypeDesc(this.baseDataUtil.getDictName(vo.getType(), ""));
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @ApiOperation(value="\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitCustomerUpForm visitCustomerUpForm) throws DataException {
        HashMap map = this.visitCustomerService.updateCustomer(id, visitCustomerUpForm);
        if (ObjectUtil.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        VisitCustomerEntity entity = this.visitCustomerService.getInfo(id);
        if (entity != null) {
            this.visitCustomerService.delete(entity);
            QueryWrapper queryWrapperVisitContact = new QueryWrapper();
            queryWrapperVisitContact.lambda().eq(VisitContactEntity::getCustomerId, (Object)entity.getId());
            this.visitContactService.remove((Wrapper)queryWrapperVisitContact);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u9009\u62e9\u5ba2\u6237")
    @PostMapping(value={"/selectAll"})
    public ActionResult getAll(@RequestBody CustomerSearchPagination customerSearchPagination) {
        UserInfo userInfo = this.userProvider.get();
        customerSearchPagination.setEnabledMark(CustomerEnableMarkEnum.ENABLE_IMPROVED.getEnableMark());
        customerSearchPagination.setCompanyId(userInfo.getOrganizeId());
        customerSearchPagination.setUserId(userInfo.getUserId());
        if (StrUtil.isNotEmpty((CharSequence)customerSearchPagination.getKeyword())) {
            customerSearchPagination.setKeyword(customerSearchPagination.getKeyword().toUpperCase());
        }
        List arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        List orderArea = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty((Collection)arealist)) {
            List authAreaIdList = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            System.out.println("ddd");
            if (CollectionUtil.isNotEmpty(authAreaIdList)) {
                authAreaIdList.stream().forEach(s -> {
                    String h = s.split(",")[0];
                    h = h.replace("[", "");
                    h = h.replace("]", "").replaceAll("\"", "");
                    orderArea.add(h);
                });
            }
            String join = CollectionUtil.join((Iterable)orderArea, (CharSequence)",");
            customerSearchPagination.setAuthArea(join);
        }
        customerSearchPagination.setOrderByVisit("1");
        List<CustomerSearchDTO> customerSearchDTOS = CollectionUtil.list((boolean)false);
        customerSearchDTOS = StrUtil.isNotEmpty((CharSequence)customerSearchPagination.getSource()) && StrUtil.equals((CharSequence)customerSearchPagination.getSource(), (CharSequence)"crm") ? this.visitCustomerService.selectCrmCustomer(customerSearchPagination) : this.visitCustomerService.selectAll(customerSearchPagination);
        List addressList = null;
        for (CustomerSearchDTO dto : customerSearchDTOS) {
            CrmCustomerEntity byId;
            dto.setAddressCode(dto.getAddress());
            if (StrUtil.equals((CharSequence)dto.getCustomerSource(), (CharSequence)"crm") && !Objects.isNull(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)dto.getId())))) {
                dto.setAddressCode(byId.getAddress());
                dto.setAddressName(this.baseDataUtil.provinceData(byId.getAddress()));
                dto.setConduct(this.baseDataUtil.getDictName(byId.getConduct(), "EnterpriseNature"));
                dto.setGrade(this.baseDataUtil.getDictName(byId.getGrade(), "CustomerGrade"));
                dto.setCrmType(this.baseDataUtil.getDictName(byId.getType(), "CustomerType"));
                if (StringUtils.isNotEmpty((String)byId.getAddress()) && (addressList = JSON.parseArray((String)byId.getAddress(), String.class)).size() >= 1) {
                    dto.setProvSimpleName(this.provinceService.getInfo((String)addressList.get(1)).getProvSimpleName());
                }
            }
            if (Objects.isNull(dto.getClassificationCode()) || StrUtil.equals((CharSequence)dto.getClassificationCode(), (CharSequence)"medicalUser")) {
                dto.setType("\u533b\u7597");
            } else {
                String dicName = this.baseDataUtil.getDictName(dto.getType(), "CustomerType");
                dto.setType(dicName);
            }
            String s2 = this.baseDataUtil.provinceData(dto.getAddress());
            dto.setAddress(s2);
        }
        PageListVO vo = new PageListVO();
        vo.setList(customerSearchDTOS);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)customerSearchPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

